/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.Properties;
import sun.io.CharacterEncoding;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class Converters {
    private static Object lock = class$sun$io$Converters == null ? (class$sun$io$Converters = Converters.class$("sun.io.Converters")) : class$sun$io$Converters;
    private static String converterPackageName = null;
    private static String defaultEncoding = null;
    public static final int BYTE_TO_CHAR = 0;
    public static final int CHAR_TO_BYTE = 1;
    private static final String[] converterPrefix = new String[]{"ByteToChar", "CharToByte"};
    private static final int CACHE_SIZE = 3;
    private static final Object DEFAULT_NAME = new Object();
    private static SoftReference[][] classCache = new SoftReference[][]{new SoftReference[3], new SoftReference[3]};
    static final String systemDefaultEncoding;
    static /* synthetic */ Class class$sun$io$Converters;

    private Converters() {
    }

    private static void moveToFront(Object[] objectArray, int n) {
        Object object = objectArray[n];
        int n2 = n;
        while (n2 > 0) {
            objectArray[n2] = objectArray[n2 - 1];
            --n2;
        }
        objectArray[0] = object;
    }

    private static Class cache(int n, Object object) {
        Object[] objectArray = classCache[n];
        int n2 = 0;
        while (n2 < 3) {
            SoftReference softReference = objectArray[n2];
            if (softReference != null) {
                Object[] objectArray2 = (Object[])softReference.get();
                if (objectArray2 == null) {
                    objectArray[n2] = null;
                } else if (objectArray2[1].equals(object)) {
                    Converters.moveToFront(objectArray, n2);
                    return (Class)objectArray2[0];
                }
            }
            ++n2;
        }
        return null;
    }

    private static Class cache(int n, Object object, Class clazz) {
        Object[] objectArray = classCache[n];
        objectArray[2] = new SoftReference(new Object[]{clazz, object});
        Converters.moveToFront(objectArray, 2);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCached(int n, String string) {
        Object object = lock;
        synchronized (object) {
            SoftReference[] softReferenceArray = classCache[n];
            int n2 = 0;
            while (n2 < 3) {
                SoftReference softReference = softReferenceArray[n2];
                if (softReference != null) {
                    Object[] objectArray = (Object[])softReference.get();
                    if (objectArray == null) {
                        softReferenceArray[n2] = null;
                    } else if (objectArray[1].equals(string)) {
                        return true;
                    }
                }
                ++n2;
            }
            return false;
        }
    }

    private static String getConverterPackageName() {
        String string = converterPackageName;
        if (string != null) {
            return string;
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("file.encoding.pkg");
        string = (String)AccessController.doPrivileged(getPropertyAction);
        if (string != null) {
            converterPackageName = string;
        } else {
            string = "sun.io";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultEncodingName() {
        Object object = lock;
        synchronized (object) {
            if (defaultEncoding == null) {
                GetPropertyAction getPropertyAction = new GetPropertyAction("file.encoding");
                defaultEncoding = (String)AccessController.doPrivileged(getPropertyAction);
            }
        }
        return defaultEncoding;
    }

    public static String getFallbackEncoding(String string) {
        if (string == "ISO-8859-1") {
            return null;
        }
        if (systemDefaultEncoding != null && !systemDefaultEncoding.equals(string)) {
            return systemDefaultEncoding;
        }
        return "ISO-8859-1";
    }

    public static void resetDefaultEncodingName() {
        if (VM.isBooted()) {
            return;
        }
        Converters.setDefaultEncodingName("ISO-8859-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultEncodingName(String string) {
        Object object = lock;
        synchronized (object) {
            defaultEncoding = null;
            Properties properties = System.getProperties();
            properties.setProperty("file.encoding", string);
            System.setProperties(properties);
            defaultEncoding = string;
        }
    }

    private static Class getConverterClass(int n, String string) throws UnsupportedEncodingException {
        String string2 = null;
        if (!string.equals("ISO8859_1")) {
            string2 = string.equals("8859_1") ? "ISO8859_1" : (string.equals("ISO-8859-1") ? "ISO8859_1" : (string.equals("ISO8859-1") ? "ISO8859_1" : (string.equals("646") ? "ASCII" : CharacterEncoding.aliasName(string))));
        }
        if (string2 == null) {
            string2 = string;
        }
        try {
            return Class.forName(Converters.getConverterPackageName() + "." + converterPrefix[n] + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedEncodingException(string2);
        }
    }

    private static Object newConverter(String string, Class clazz) throws UnsupportedEncodingException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedEncodingException(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedEncodingException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object newConverter(int n, String string) throws UnsupportedEncodingException {
        Class clazz;
        Object object = lock;
        synchronized (object) {
            clazz = Converters.cache(n, string);
            if (clazz == null) {
                clazz = Converters.getConverterClass(n, string);
                Converters.cache(n, string, clazz);
            }
        }
        return Converters.newConverter(string, clazz);
    }

    private static Class getDefaultConverterClass(int n) {
        boolean bl = false;
        Class clazz = Converters.cache(n, DEFAULT_NAME);
        if (clazz != null) {
            return clazz;
        }
        String string = Converters.getDefaultEncodingName();
        if (string != null) {
            bl = true;
        } else {
            string = "ISO8859_1";
        }
        try {
            clazz = Converters.getConverterClass(n, string);
            if (bl) {
                Converters.cache(n, DEFAULT_NAME, clazz);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                clazz = Converters.getConverterClass(n, "ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                throw new InternalError("Cannot find default " + converterPrefix[n] + " converter class");
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object newDefaultConverter(int n) {
        Class clazz;
        Object object = lock;
        synchronized (object) {
            clazz = Converters.getDefaultConverterClass(n);
        }
        try {
            return Converters.newConverter("", clazz);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Cannot instantiate default converter class " + clazz.getName());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        GetPropertyAction getPropertyAction = new GetPropertyAction("ibm.system.encoding");
        systemDefaultEncoding = (String)AccessController.doPrivileged(getPropertyAction);
    }
}

