/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.ibm.jvm.ExtendedSystem;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import sun.reflect.FieldAccessor;
import sun.reflect.Reflection;

public final class Field
extends AccessibleObject
implements Member {
    private Class clazz;
    private long slot;
    private String name;
    private Class type;
    private int modifiers;
    private volatile FieldAccessor fieldAccessor;
    private Field root;
    private volatile Class securityCheckTargetClassCache;

    Field(Class clazz, String string, Class clazz2, int n, long l) {
        this.clazz = clazz;
        this.name = string;
        this.type = clazz2;
        this.modifiers = n;
        this.slot = l;
    }

    Field copy() {
        Field field = new Field(this.clazz, this.name, this.type, this.modifiers, this.slot);
        if (!ExtendedSystem.isResettableJVM()) {
            field.root = this;
            field.fieldAccessor = this.fieldAccessor;
        }
        return field;
    }

    public Class getDeclaringClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Class getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Field) {
            Field field = (Field)object;
            return this.getDeclaringClass() == field.getDeclaringClass() && this.getName().equals(field.getName()) && this.getType() == field.getType();
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        int n = this.getModifiers();
        return (n == 0 ? "" : Modifier.toString(n) + " ") + Field.getTypeName(this.getType()) + " " + Field.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    public Object get(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.get0(object);
        }
        return this.getFieldAccessor(object).get(object);
    }

    private native Object get0(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public boolean getBoolean(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getBoolean0(object);
        }
        return this.getFieldAccessor(object).getBoolean(object);
    }

    private native boolean getBoolean0(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public byte getByte(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getByte0(object);
        }
        return this.getFieldAccessor(object).getByte(object);
    }

    private native byte getByte0(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public char getChar(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getChar0(object);
        }
        return this.getFieldAccessor(object).getChar(object);
    }

    private native char getChar0(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public short getShort(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getShort0(object);
        }
        return this.getFieldAccessor(object).getShort(object);
    }

    private native short getShort0(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public int getInt(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getInt0(object);
        }
        return this.getFieldAccessor(object).getInt(object);
    }

    private native int getInt0(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public long getLong(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getLong0(object);
        }
        return this.getFieldAccessor(object).getLong(object);
    }

    private native long getLong0(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public float getFloat(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getFloat0(object);
        }
        return this.getFieldAccessor(object).getFloat(object);
    }

    private native float getFloat0(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public double getDouble(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getDouble0(object);
        }
        return this.getFieldAccessor(object).getDouble(object);
    }

    private native double getDouble0(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public void set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            this.set0(object, object2);
        } else {
            this.getFieldAccessor(object).set(object, object2);
        }
    }

    private native void set0(Object var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    public void setBoolean(Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            this.setBoolean0(object, bl);
        } else {
            this.getFieldAccessor(object).setBoolean(object, bl);
        }
    }

    private native void setBoolean0(Object var1, boolean var2) throws IllegalArgumentException, IllegalAccessException;

    public void setByte(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            this.setByte0(object, by);
        } else {
            this.getFieldAccessor(object).setByte(object, by);
        }
    }

    private native void setByte0(Object var1, byte var2) throws IllegalArgumentException, IllegalAccessException;

    public void setChar(Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            this.setChar0(object, c);
        } else {
            this.getFieldAccessor(object).setChar(object, c);
        }
    }

    private native void setChar0(Object var1, char var2) throws IllegalArgumentException, IllegalAccessException;

    public void setShort(Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            this.setShort0(object, s);
        } else {
            this.getFieldAccessor(object).setShort(object, s);
        }
    }

    private native void setShort0(Object var1, short var2) throws IllegalArgumentException, IllegalAccessException;

    public void setInt(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            this.setInt0(object, n);
        } else {
            this.getFieldAccessor(object).setInt(object, n);
        }
    }

    private native void setInt0(Object var1, int var2) throws IllegalArgumentException, IllegalAccessException;

    public void setLong(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            this.setLong0(object, l);
        } else {
            this.getFieldAccessor(object).setLong(object, l);
        }
    }

    private native void setLong0(Object var1, long var2) throws IllegalArgumentException, IllegalAccessException;

    public void setFloat(Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            this.setFloat0(object, f);
        } else {
            this.getFieldAccessor(object).setFloat(object, f);
        }
    }

    private native void setFloat0(Object var1, float var2) throws IllegalArgumentException, IllegalAccessException;

    public void setDouble(Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        if (ExtendedSystem.isOldReflectionMode()) {
            this.setDouble0(object, d);
        } else {
            this.getFieldAccessor(object).setDouble(object, d);
        }
    }

    private native void setDouble0(Object var1, double var2) throws IllegalArgumentException, IllegalAccessException;

    private FieldAccessor getFieldAccessor(Object object) throws IllegalAccessException {
        this.doSecurityCheck(object);
        if (this.fieldAccessor == null) {
            this.acquireFieldAccessor();
        }
        return this.fieldAccessor;
    }

    private void acquireFieldAccessor() {
        FieldAccessor fieldAccessor = null;
        if (this.root != null) {
            fieldAccessor = this.root.getFieldAccessor();
        }
        if (fieldAccessor != null) {
            this.fieldAccessor = fieldAccessor;
            return;
        }
        fieldAccessor = AccessibleObject.reflectionFactory.newFieldAccessor(this);
        this.setFieldAccessor(fieldAccessor);
    }

    private FieldAccessor getFieldAccessor() {
        return this.fieldAccessor;
    }

    private void setFieldAccessor(FieldAccessor fieldAccessor) {
        this.fieldAccessor = fieldAccessor;
        if (this.root != null) {
            this.root.setFieldAccessor(fieldAccessor);
        }
    }

    private void doSecurityCheck(Object object) throws IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class clazz;
            Class clazz2 = Reflection.getCallerClass(4);
            Class clazz3 = clazz = object == null || !Modifier.isProtected(this.modifiers) ? this.clazz : object.getClass();
            if (this.securityCheckCache != clazz2 || clazz != this.securityCheckTargetClassCache) {
                Reflection.ensureMemberAccess(clazz2, this.clazz, object, this.modifiers);
                this.securityCheckCache = clazz2;
                this.securityCheckTargetClassCache = clazz;
            }
        }
    }

    static String getTypeName(Class clazz) {
        if (clazz.isArray()) {
            try {
                Class clazz2 = clazz;
                int n = 0;
                while (clazz2.isArray()) {
                    ++n;
                    clazz2 = clazz2.getComponentType();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(clazz2.getName());
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append("[]");
                    ++n2;
                }
                return stringBuffer.toString();
            }
            catch (Throwable throwable) {
            }
        }
        return clazz.getName();
    }
}

