/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.Converter;
import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;

class EUCJP_Decoder
extends IBMCharsetDecoder {
    private final short[] index;
    private final String data;
    private final char[] singleMap;
    private final int shift;
    private final int mask1;
    private final int mask2;

    protected EUCJP_Decoder(Charset charset, char[] cArray, int n, short[] sArray, String string, byte[] byArray) {
        super(charset, 1.0f, 1.0f);
        this.data = string;
        this.index = sArray;
        this.shift = n;
        this.mask1 = Converter.mask1[n];
        this.mask2 = Converter.mask2[n];
        this.singleMap = cArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        int n5 = 1;
        CoderResult coderResult = CoderResult.UNDERFLOW;
        while (n < n2) {
            char c;
            int n6;
            block12: {
                block10: {
                    int n7;
                    block13: {
                        block11: {
                            n6 = byArray[n] & 0xFF;
                            c = this.singleMap[n6];
                            if (c >= '\ufffe') break block11;
                            n5 = 1;
                            break block12;
                        }
                        if (c != '\uffff') break block13;
                        if (n6 == 142) {
                            if (n + 2 > n2) break;
                            n7 = byArray[n + 1] & 0xFF;
                            if (n7 < 161 || n7 > 254) {
                                coderResult = CoderResult.malformedForLength(2);
                                break;
                            }
                            n6 = n7 + 128;
                            n5 = 2;
                            break block10;
                        } else if (n6 == 143) {
                            if (n + 3 > n2) break;
                            n6 = byArray[n + 1] & 0xFF;
                            n7 = byArray[n + 2] & 0xFF;
                            if (this.singleMap[n6] != '\ufffe' || this.singleMap[n6] != '\ufffe') {
                                coderResult = CoderResult.malformedForLength(3);
                                break;
                            }
                            n5 = 3;
                            n6 = (n6 << 8 | n7) & 0xFF7F;
                            break block10;
                        } else {
                            coderResult = CoderResult.unmappableForLength(1);
                            break;
                        }
                    }
                    if (n + 1 >= n2) break;
                    n7 = byArray[n + 1] & 0xFF;
                    if (this.singleMap[n7] != '\ufffe') {
                        coderResult = CoderResult.malformedForLength(1);
                        break;
                    }
                    n6 = n6 << 8 | n7;
                    n5 = 2;
                }
                c = this.data.charAt(this.index[n6 >> this.shift] + (n6 & this.mask2));
            }
            if (c < '\u0002' && c != (char)n6) {
                coderResult = CoderResult.unmappableForLength(n5);
                break;
            }
            if (n4 - n3 < 1) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            cArray[n3++] = c;
            n += n5;
        }
        byteBuffer.position(n - byteBuffer.arrayOffset());
        charBuffer.position(n3 - charBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        block16: {
            CoderResult coderResult2;
            block15: {
                CoderResult coderResult3;
                block14: {
                    CoderResult coderResult4;
                    block13: {
                        CoderResult coderResult5;
                        block12: {
                            CoderResult coderResult6;
                            block11: {
                                CoderResult coderResult7;
                                block10: {
                                    n = byteBuffer.position();
                                    int n2 = 0;
                                    int n3 = 1;
                                    try {
                                        while (byteBuffer.hasRemaining()) {
                                            char c;
                                            int n4;
                                            block18: {
                                                block21: {
                                                    block19: {
                                                        block20: {
                                                            block17: {
                                                                n4 = byteBuffer.get() & 0xFF;
                                                                c = this.singleMap[n4];
                                                                if (c >= '\ufffe') break block17;
                                                                n3 = 1;
                                                                break block18;
                                                            }
                                                            if (c != '\uffff') break block19;
                                                            if (n4 != 142) break block20;
                                                            if (!byteBuffer.hasRemaining()) break;
                                                            n2 = byteBuffer.get() & 0xFF;
                                                            if (n2 < 161 || n2 > 254) {
                                                                coderResult7 = CoderResult.malformedForLength(2);
                                                                Object var12_14 = null;
                                                                break block10;
                                                            }
                                                            n4 = n2 + 128;
                                                            n3 = 2;
                                                            break block21;
                                                        }
                                                        if (n4 == 143) {
                                                            if (byteBuffer.remaining() < 2) break;
                                                            n4 = byteBuffer.get() & 0xFF;
                                                            n2 = byteBuffer.get() & 0xFF;
                                                            if (this.singleMap[n4] != '\ufffe' || this.singleMap[n4] != '\ufffe') {
                                                                coderResult6 = CoderResult.malformedForLength(3);
                                                                break block11;
                                                            }
                                                            n4 = (n4 << 8 | n2) & 0xFF7F;
                                                            n3 = 3;
                                                            break block21;
                                                        } else {
                                                            coderResult5 = CoderResult.unmappableForLength(1);
                                                            break block12;
                                                        }
                                                    }
                                                    if (!byteBuffer.hasRemaining()) break;
                                                    n2 = byteBuffer.get() & 0xFF;
                                                    if (this.singleMap[n2] != '\ufffe') {
                                                        coderResult4 = CoderResult.malformedForLength(n3);
                                                        break block13;
                                                    }
                                                    n4 = n4 << 8 | n2;
                                                    n3 = 2;
                                                }
                                                c = this.data.charAt(this.index[n4 >> this.shift] + (n4 & this.mask2));
                                            }
                                            if (c < '\u0002' && c != (char)n4) {
                                                coderResult3 = CoderResult.unmappableForLength(1);
                                                break block14;
                                            }
                                            if (!charBuffer.hasRemaining()) {
                                                coderResult2 = CoderResult.OVERFLOW;
                                                break block15;
                                            }
                                            n += n3;
                                            charBuffer.put(c);
                                        }
                                        coderResult = CoderResult.UNDERFLOW;
                                        break block16;
                                    }
                                    catch (Throwable throwable) {
                                        Object var12_21 = null;
                                        byteBuffer.position(n);
                                        throw throwable;
                                    }
                                }
                                byteBuffer.position(n);
                                return coderResult7;
                            }
                            Object var12_15 = null;
                            byteBuffer.position(n);
                            return coderResult6;
                        }
                        Object var12_16 = null;
                        byteBuffer.position(n);
                        return coderResult5;
                    }
                    Object var12_17 = null;
                    byteBuffer.position(n);
                    return coderResult4;
                }
                Object var12_18 = null;
                byteBuffer.position(n);
                return coderResult3;
            }
            Object var12_19 = null;
            byteBuffer.position(n);
            return coderResult2;
        }
        Object var12_20 = null;
        byteBuffer.position(n);
        return coderResult;
    }

    protected final CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray() && !IBMCharsetDecoder.UseBuffer) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

