/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class DirectEncoder
extends IBMCharsetEncoder {
    private int maxCode;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected DirectEncoder(Charset charset, int n, byte[] byArray) {
        super(charset, 1.0f, 1.0f);
        this.maxCode = n;
        if (byArray != null) {
            this.replaceWith(byArray);
        }
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (this.maxCode == 0) {
            return true;
        }
        return (char)(byArray[0] & 0xFF) <= this.maxCode;
    }

    public boolean canEncode(char c) {
        return c <= this.maxCode;
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        while (n < n2) {
            char c = cArray[n];
            if (c <= this.maxCode) {
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
            } else {
                if (this.sgp.parse(c, cArray, n, n2) < 0) {
                    coderResult = this.sgp.error();
                    break;
                }
                coderResult = this.sgp.unmappableResult();
                break;
            }
            byArray[n3++] = (byte)c;
            ++n;
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        block6: {
            CoderResult coderResult2;
            block9: {
                CoderResult coderResult3;
                block8: {
                    CoderResult coderResult4;
                    block7: {
                        n = charBuffer.position();
                        try {
                            char c;
                            while (true) {
                                if (!charBuffer.hasRemaining()) {
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block6;
                                }
                                c = charBuffer.get();
                                if (c > this.maxCode) break;
                                if (!byteBuffer.hasRemaining()) {
                                    coderResult4 = CoderResult.OVERFLOW;
                                    Object var7_9 = null;
                                    break block7;
                                }
                                byteBuffer.put((byte)c);
                                ++n;
                            }
                            if (Surrogate.is(c) && this.sgp.parse(c, charBuffer) < 0) {
                                coderResult3 = this.sgp.error();
                                break block8;
                            }
                            coderResult2 = this.sgp.unmappableResult();
                            break block9;
                        }
                        catch (Throwable throwable) {
                            Object var7_13 = null;
                            charBuffer.position(n);
                            throw throwable;
                        }
                    }
                    charBuffer.position(n);
                    return coderResult4;
                }
                Object var7_10 = null;
                charBuffer.position(n);
                return coderResult3;
            }
            Object var7_11 = null;
            charBuffer.position(n);
            return coderResult2;
        }
        Object var7_12 = null;
        charBuffer.position(n);
        return coderResult;
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !IBMCharsetEncoder.UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

