/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hursley.devtools;

import com.ibm.hursley.devtools.MessageCatalogue;
import com.ibm.hursley.devtools.Trace;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.BreakIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;

public class NLSServices {
    private static final String sccsid = "%Z% %W%  %E% %U%";
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1998     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Locale loc = Locale.getDefault();
    private static MessageFormat msgFormatter = new MessageFormat("");
    private static final String cls = "NLSServices";
    public static PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
    public static PrintWriter err = new PrintWriter((Writer)new OutputStreamWriter(System.err), true);
    public static InputStreamReader in = new InputStreamReader(System.in);

    public static void localiseStandardIO() throws UnsupportedEncodingException {
        Trace.entry(cls, "localiseStandardIO");
        String string = loc.getLanguage().toLowerCase(loc);
        String string2 = "437";
        if (string.equals("en")) {
            string2 = "437";
        } else if (string.equals("fr")) {
            string2 = "437";
        } else if (string.equals("de")) {
            string2 = "437";
        } else if (string.equals("es")) {
            string2 = "437";
        } else if (string.equals("ko")) {
            string2 = "437";
        } else if (string.equals("ja")) {
            string2 = "437";
        } else if (string.equals("pt")) {
            string2 = "437";
        } else if (string.equals("ch")) {
            string2 = "437";
        }
        Trace.trace(2, cls, "Localising to encoding: " + string2);
        try {
            out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, string2), true);
            err = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, string2), true);
            in = new InputStreamReader(System.in, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.trace(cls, String.valueOf(string2) + " not supported by JVM.");
            Trace.exit(cls, "localiseStandardIO");
            throw unsupportedEncodingException;
        }
        Trace.exit(cls, "localiseStandardIO");
    }

    public static void setLocale(Locale locale) {
        Trace.entry(cls, "setLocale");
        loc = locale != null ? locale : Locale.getDefault();
        msgFormatter.setLocale(loc);
        Trace.exit(cls, "setLocale");
    }

    public static MessageCatalogue getMessageCatalogue(String string) throws MissingResourceException {
        Trace.entry(cls, "getMessageCatalogue");
        Trace.trace(2, cls, "Loading catalogue " + string);
        Trace.trace(2, cls, "Locale = " + loc.getCountry() + "_" + loc.getVariant());
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string, loc);
        }
        catch (MissingResourceException missingResourceException) {
            Trace.trace(cls, "Unable to load catalogue: " + missingResourceException.getClassName());
            Trace.exit(cls, "getMessageCatalogue");
            throw missingResourceException;
        }
        Trace.exit(cls, "getMessageCatalogue");
        return new MessageCatalogue(resourceBundle, msgFormatter);
    }

    public static String formatNumber(long l) {
        Trace.entry(cls, "formatNumber");
        NumberFormat numberFormat = NumberFormat.getInstance(loc);
        Trace.exit(cls, "formatNumber");
        return numberFormat.format(l);
    }

    public static String formatNumber(double d) {
        Trace.entry(cls, "formatNumber");
        NumberFormat numberFormat = NumberFormat.getInstance(loc);
        Trace.exit(cls, "formatNumber");
        return numberFormat.format(d);
    }

    public static String formatNumber(MessageCatalogue messageCatalogue, String string, long l) throws MissingResourceException {
        Trace.entry(cls, "formatNumber");
        String string2 = null;
        try {
            String string3 = messageCatalogue.getMessage(string);
            DecimalFormat decimalFormat = new DecimalFormat(string3);
            string2 = decimalFormat.format(l);
        }
        catch (MissingResourceException missingResourceException) {
            Trace.trace(cls, String.valueOf(string) + " not found in catalogue " + missingResourceException.getClassName());
            Trace.exit(cls, "formatNumber");
            throw missingResourceException;
        }
        Trace.exit(cls, "formatNumber");
        return string2;
    }

    public static String formatNumber(MessageCatalogue messageCatalogue, String string, double d) throws MissingResourceException {
        Trace.entry(cls, "formatNumber");
        String string2 = null;
        try {
            String string3 = messageCatalogue.getMessage(string);
            DecimalFormat decimalFormat = new DecimalFormat(string3);
            string2 = decimalFormat.format(d);
        }
        catch (MissingResourceException missingResourceException) {
            Trace.trace(cls, String.valueOf(string) + " not found in catalogue " + missingResourceException.getClassName());
            Trace.exit(cls, "formatNumber");
            throw missingResourceException;
        }
        Trace.exit(cls, "formatNumber");
        return string2;
    }

    public static String formatCurrency(long l) {
        Trace.entry(cls, "formatCurrency");
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(loc);
        Trace.exit(cls, "formatCurrency");
        return numberFormat.format(l);
    }

    public static String formatCurrency(double d) {
        Trace.entry(cls, "formatCurrency");
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(loc);
        Trace.exit(cls, "formatCurrency");
        return numberFormat.format(d);
    }

    public static String formatPercentage(long l) {
        Trace.entry(cls, "formatPercentage");
        NumberFormat numberFormat = NumberFormat.getPercentInstance(loc);
        Trace.exit(cls, "formatPercentage");
        return numberFormat.format(l);
    }

    public static String formatPercentage(double d) {
        Trace.entry(cls, "formatPercentage");
        NumberFormat numberFormat = NumberFormat.getPercentInstance(loc);
        Trace.exit(cls, "formatPercentage");
        return numberFormat.format(d);
    }

    public static Number parseNumber(String string) throws ParseException {
        Trace.entry(cls, "parseNumber");
        Number number = null;
        NumberFormat numberFormat = NumberFormat.getInstance(loc);
        try {
            number = numberFormat.parse(string);
        }
        catch (ParseException parseException) {
            Trace.trace(cls, "Exception parsing text: " + string + " : " + parseException.toString());
            Trace.exit(cls, "parseNumber");
            throw parseException;
        }
        Trace.exit(cls, "parseNumber");
        return number;
    }

    public static String formatDate() {
        Trace.entry(cls, "formatDate");
        DateFormat dateFormat = DateFormat.getDateInstance(2, loc);
        Trace.exit(cls, "formatDate");
        return dateFormat.format(new Date());
    }

    public static String formatDate(Date date) {
        Trace.entry(cls, "formatDate");
        DateFormat dateFormat = DateFormat.getDateInstance(2, loc);
        Trace.exit(cls, "formatDate");
        return dateFormat.format(date);
    }

    public static String formatDate(Date date, int n) {
        Trace.entry(cls, "formatDate");
        DateFormat dateFormat = DateFormat.getDateInstance(n, loc);
        Trace.exit(cls, "formatDate");
        return dateFormat.format(date);
    }

    public static String formatTime() {
        Trace.entry(cls, "formatTime");
        DateFormat dateFormat = DateFormat.getTimeInstance(2, loc);
        Trace.exit(cls, "formatTime");
        return dateFormat.format(new Date());
    }

    public static String formatTime(Date date) {
        Trace.entry(cls, "formatTime");
        DateFormat dateFormat = DateFormat.getTimeInstance(2, loc);
        Trace.exit(cls, "formatTime");
        return dateFormat.format(date);
    }

    public static String formatTime(Date date, int n) {
        Trace.entry(cls, "formatTime");
        DateFormat dateFormat = DateFormat.getTimeInstance(n, loc);
        Trace.exit(cls, "formatTime");
        return dateFormat.format(date);
    }

    public static String formatDateTime() {
        Trace.entry(cls, "formatDateTime");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, loc);
        Trace.exit(cls, "formatDateTime");
        return dateFormat.format(new Date());
    }

    public static String formatDateTime(Date date) {
        Trace.entry(cls, "formatDateTime");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, loc);
        Trace.exit(cls, "formatDateTime");
        return dateFormat.format(date);
    }

    public static String formatDateTime(Date date, int n, int n2) {
        Trace.entry(cls, "formatDateTime");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(n, n2, loc);
        Trace.exit(cls, "formatDateTime");
        return dateFormat.format(date);
    }

    public static boolean equals(String string, String string2) {
        Trace.entry(cls, "equals");
        Collator collator = Collator.getInstance(loc);
        Trace.exit(cls, "equals");
        return collator.equals(string, string2);
    }

    public static int compare(String string, String string2) {
        Trace.entry(cls, "compare");
        Collator collator = Collator.getInstance(loc);
        Trace.exit(cls, "compare");
        return collator.compare(string, string2);
    }

    public static String toLowerCase(String string) {
        Trace.entry(cls, "toLowerCase");
        String string2 = string.toLowerCase(loc);
        Trace.exit(cls, "toLowerCase");
        return string2;
    }

    public static String toUpperCase(String string) {
        Trace.entry(cls, "toUpperCase");
        String string2 = string.toUpperCase(loc);
        Trace.exit(cls, "toUpperCase");
        return string2;
    }

    public static String[] sort(String[] stringArray) {
        Trace.entry(cls, "sort");
        Collator collator = Collator.getInstance(loc);
        int n = stringArray.length;
        CollationKey[] collationKeyArray = new CollationKey[n];
        int n2 = 0;
        while (n2 < n - 1) {
            collationKeyArray[n2] = collator.getCollationKey(stringArray[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 1;
            while (n4 < n) {
                if (collationKeyArray[n4 - 1].compareTo(collationKeyArray[n4]) > 0) {
                    CollationKey collationKey = collationKeyArray[n4 - 1];
                    collationKeyArray[n4 - 1] = collationKeyArray[n4];
                    collationKeyArray[n4] = collationKey;
                }
                ++n4;
            }
            ++n3;
        }
        String[] stringArray2 = new String[n];
        int n5 = 0;
        while (n5 < n) {
            stringArray2[n5] = collationKeyArray[n5].getSourceString();
            Trace.trace(2, cls, String.valueOf(n5) + "\t-> " + stringArray2[n5]);
            ++n5;
        }
        Trace.exit(cls, "sort");
        return stringArray2;
    }

    public static WordEnumeration iterateOverWords(String string) {
        return new WordEnumeration(string, loc);
    }

    public static SentenceEnumeration iterateOverSentences(String string) {
        return new SentenceEnumeration(string, loc);
    }

    public static LineEnumeration iterateOverLines(String string) {
        return new LineEnumeration(string, loc);
    }

    protected static abstract class StringEnumeration
    implements Enumeration {
        private static final String sccsid = "%Z% %W%  %E% %U%";
        private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1998     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected BreakIterator iterator;
        private String sourceText;
        private int startPos;
        private int endPos;
        private boolean done = false;

        protected StringEnumeration(String string, Locale locale) {
            Trace.entry(this, "StringEnumeration");
            Trace.trace(2, this, "%Z% %W%  %E% %U%");
            this.iterator = this.createIterator(locale);
            this.sourceText = string;
            this.iterator.setText(this.sourceText);
            this.startPos = this.iterator.first();
            this.done = this.startPos == -1;
            Trace.exit(this, "StringEnumeration");
        }

        protected abstract BreakIterator createIterator(Locale var1);

        public boolean hasMoreElements() {
            return !this.done;
        }

        public Object nextElement() throws NoSuchElementException {
            Trace.entry(this, "nextElement");
            if (!this.hasMoreElements()) {
                Trace.trace(this, "No more elements available.");
                Trace.exit(this, "nextElement");
                throw new NoSuchElementException();
            }
            this.endPos = this.iterator.next();
            if (this.endPos == -1) {
                this.endPos = this.sourceText.length();
                this.done = true;
            }
            String string = this.sourceText.substring(this.startPos, this.endPos);
            this.startPos = this.endPos;
            Trace.exit(this, "nextElement");
            return string;
        }
    }

    public static class WordEnumeration
    extends StringEnumeration {
        private static final String sccsid = "%Z% %W%  %E% %U%";
        private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1998     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected WordEnumeration(String string, Locale locale) {
            super(string, locale);
        }

        protected BreakIterator createIterator(Locale locale) {
            return BreakIterator.getWordInstance(locale);
        }

        public String nextWord() throws NoSuchElementException {
            return (String)this.nextElement();
        }
    }

    public static class SentenceEnumeration
    extends StringEnumeration {
        private static final String sccsid = "%Z% %W%  %E% %U%";
        private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1998     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected SentenceEnumeration(String string, Locale locale) {
            super(string, locale);
        }

        protected BreakIterator createIterator(Locale locale) {
            return BreakIterator.getSentenceInstance(locale);
        }

        public String nextSentence() throws NoSuchElementException {
            return (String)this.nextElement();
        }
    }

    public static class LineEnumeration
    extends StringEnumeration {
        private static final String sccsid = "%Z% %W%  %E% %U%";
        private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1998     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected LineEnumeration(String string, Locale locale) {
            super(string, locale);
        }

        protected BreakIterator createIterator(Locale locale) {
            return BreakIterator.getLineInstance(locale);
        }

        public String nextLine() throws NoSuchElementException {
            return (String)this.nextElement();
        }
    }
}

