/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.SunClipboard;

public class ClipboardTransferable
implements Transferable {
    private final HashMap flavorsToData = new HashMap();
    private DataFlavor[] flavors = new DataFlavor[0];
    private static final boolean RETRY_ON_FAILURE = true;
    private static final boolean BAIL_ON_FAILURE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClipboardTransferable(SunClipboard sunClipboard) {
        sunClipboard.openClipboard(null);
        try {
            long[] lArray = this.getClipboardFormats(sunClipboard.getID());
            if (lArray != null) {
                HashMap hashMap = new HashMap(lArray.length, 1.0f);
                Map map = DataTransferer.getInstance().getFlavorsForFormats(lArray, SunClipboard.flavorMap);
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    DataFlavor dataFlavor = (DataFlavor)iterator.next();
                    Long l = (Long)map.get(dataFlavor);
                    this.fetchOneFlavor(sunClipboard, dataFlavor, l, hashMap, true);
                }
                DataTransferer.getInstance();
                this.flavors = DataTransferer.setToSortedDataFlavorArray(this.flavorsToData.keySet(), map);
            }
            Object var9_8 = null;
            sunClipboard.closeClipboard();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            sunClipboard.closeClipboard();
            throw throwable;
        }
    }

    private boolean fetchOneFlavor(SunClipboard sunClipboard, DataFlavor dataFlavor, Long l, HashMap hashMap, boolean bl) {
        if (!this.flavorsToData.containsKey(dataFlavor)) {
            long l2 = l;
            Object object = null;
            if (!hashMap.containsKey(l)) {
                try {
                    object = this.getClipboardData(sunClipboard.getID(), l2);
                }
                catch (IOException iOException) {
                    object = iOException;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                hashMap.put(l, object);
            } else {
                object = hashMap.get(l);
            }
            if (object == null || object instanceof IOException) {
                if (!bl) {
                    return false;
                }
                long[] lArray = DataTransferer.getInstance().getFormatsForFlavorAsArray(dataFlavor, SunClipboard.flavorMap);
                int n = 0;
                while (n < lArray.length) {
                    if (lArray[n] != l2 && this.fetchOneFlavor(sunClipboard, dataFlavor, new Long(lArray[n]), hashMap, false)) {
                        return true;
                    }
                    ++n;
                }
            }
            if (object instanceof IOException) {
                this.flavorsToData.put(dataFlavor, object);
                return false;
            }
            if (object != null) {
                this.flavorsToData.put(dataFlavor, new DataFactory(l2, (byte[])object));
                return true;
            }
        }
        return false;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.flavorsToData.containsKey(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        Object object = this.flavorsToData.get(dataFlavor);
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof DataFactory) {
            DataFactory dataFactory = (DataFactory)object;
            object = dataFactory.getTransferData(dataFlavor);
        }
        return object;
    }

    private native long[] getClipboardFormats(long var1);

    private native byte[] getClipboardData(long var1, long var3) throws IOException;

    private final class DataFactory {
        final long format;
        final byte[] data;

        DataFactory(long l, byte[] byArray) {
            this.format = l;
            this.data = byArray;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws IOException {
            return DataTransferer.getInstance().translateBytes(this.data, dataFlavor, this.format, ClipboardTransferable.this);
        }
    }
}

