/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import sun.awt.NativeLibLoader;
import sun.io.CharToByteConverter;
import sun.io.CharToByteUnicode;

public class FontDescriptor
implements Cloneable {
    String nativeName;
    public CharToByteConverter fontCharset;
    int[] exclusionRanges;
    public CharToByteConverter unicodeCharset;
    boolean useUnicode;

    public FontDescriptor(String string, CharToByteConverter charToByteConverter, int[] nArray) {
        this.nativeName = string;
        this.fontCharset = charToByteConverter;
        this.exclusionRanges = nArray;
        this.useUnicode = false;
    }

    public boolean isExcluded(char c) {
        int n = 0;
        while (n < this.exclusionRanges.length) {
            int n2 = this.exclusionRanges[n] >> 16 & 0xFFFF;
            int n3 = this.exclusionRanges[n] & 0xFFFF;
            if (c >= n2 && c <= n3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        return super.toString() + " [" + this.nativeName + "|" + this.fontCharset + "]";
    }

    private static native void initIDs();

    public boolean useUnicode() {
        if (this.useUnicode && this.unicodeCharset == null) {
            this.unicodeCharset = new CharToByteUnicode(false);
        }
        return this.useUnicode;
    }

    static {
        NativeLibLoader.loadLibraries();
        FontDescriptor.initIDs();
    }
}

