/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.ImageView;

class AccessibleHTML
implements Accessible {
    private JEditorPane editor;
    private Document model;
    private DocumentListener docListener;
    private PropertyChangeListener propChangeListener;
    private ElementInfo rootElementInfo;
    private RootHTMLAccessibleContext rootHTMLAccessibleContext;

    public AccessibleHTML(JEditorPane jEditorPane) {
        this.editor = jEditorPane;
        this.propChangeListener = new PropertyChangeHandler();
        this.setDocument(this.editor.getDocument());
        this.docListener = new DocumentHandler();
    }

    private void setDocument(Document document) {
        if (this.model != null) {
            this.model.removeDocumentListener(this.docListener);
        }
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.propChangeListener);
        }
        this.model = document;
        if (this.model != null) {
            if (this.rootElementInfo != null) {
                this.rootElementInfo.invalidate(false);
            }
            this.buildInfo();
            this.model.addDocumentListener(this.docListener);
        } else {
            this.rootElementInfo = null;
        }
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(this.propChangeListener);
        }
    }

    private Document getDocument() {
        return this.model;
    }

    private JEditorPane getTextComponent() {
        return this.editor;
    }

    private ElementInfo getRootInfo() {
        return this.rootElementInfo;
    }

    private View getRootView() {
        return this.getTextComponent().getUI().getRootView(this.getTextComponent());
    }

    private Rectangle getRootEditorRect() {
        Rectangle rectangle = this.getTextComponent().getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            rectangle.y = 0;
            rectangle.x = 0;
            Insets insets = this.editor.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            return rectangle;
        }
        return null;
    }

    private Object lock() {
        Document document = this.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
            return document;
        }
        return null;
    }

    private void unlock(Object object) {
        if (object != null) {
            ((AbstractDocument)object).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildInfo() {
        Object object = this.lock();
        try {
            Document document = this.getDocument();
            Element element = document.getDefaultRootElement();
            this.rootElementInfo = new ElementInfo(element);
            this.rootElementInfo.validate();
            Object var5_4 = null;
            this.unlock(object);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unlock(object);
            throw throwable;
        }
    }

    ElementInfo createElementInfo(Element element, ElementInfo elementInfo) {
        AttributeSet attributeSet = element.getAttributes();
        if (attributeSet != null) {
            Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (object == HTML.Tag.IMG) {
                return new IconElementInfo(element, elementInfo);
            }
            if (object == HTML.Tag.CONTENT || object == HTML.Tag.CAPTION) {
                return new TextElementInfo(element, elementInfo);
            }
            if (object == HTML.Tag.TABLE) {
                return new TableElementInfo(element, elementInfo);
            }
        }
        return null;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.rootHTMLAccessibleContext == null) {
            this.rootHTMLAccessibleContext = new RootHTMLAccessibleContext(this.rootElementInfo);
        }
        return this.rootHTMLAccessibleContext;
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("document")) {
                AccessibleHTML.this.setDocument(AccessibleHTML.this.editor.getDocument());
            }
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AccessibleHTML.this.getRootInfo().update(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AccessibleHTML.this.getRootInfo().update(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AccessibleHTML.this.getRootInfo().update(documentEvent);
        }
    }

    private class ElementInfo {
        private ArrayList children;
        private Element element;
        private ElementInfo parent;
        private boolean isValid;
        private boolean canBeValid;

        ElementInfo(Element element) {
            this(element, null);
        }

        ElementInfo(Element element, ElementInfo elementInfo) {
            this.element = element;
            this.parent = elementInfo;
            this.isValid = false;
            this.canBeValid = true;
        }

        protected void validate() {
            this.isValid = true;
            this.loadChildren(this.getElement());
        }

        protected void loadChildren(Element element) {
            if (!element.isLeaf()) {
                int n = 0;
                int n2 = element.getElementCount();
                while (n < n2) {
                    Element element2 = element.getElement(n);
                    ElementInfo elementInfo = AccessibleHTML.this.createElementInfo(element2, this);
                    if (elementInfo != null) {
                        this.addChild(elementInfo);
                    } else {
                        this.loadChildren(element2);
                    }
                    ++n;
                }
            }
        }

        public int getIndexInParent() {
            if (this.parent == null || !this.parent.isValid()) {
                return -1;
            }
            return this.parent.indexOf(this);
        }

        public Element getElement() {
            return this.element;
        }

        public ElementInfo getParent() {
            return this.parent;
        }

        public int indexOf(ElementInfo elementInfo) {
            ArrayList arrayList = this.children;
            if (arrayList != null) {
                return arrayList.indexOf(elementInfo);
            }
            return -1;
        }

        public ElementInfo getChild(int n) {
            ArrayList arrayList;
            if (this.validateIfNecessary() && (arrayList = this.children) != null && n >= 0 && n < arrayList.size()) {
                return (ElementInfo)arrayList.get(n);
            }
            return null;
        }

        public int getChildCount() {
            this.validateIfNecessary();
            return this.children == null ? 0 : this.children.size();
        }

        protected void addChild(ElementInfo elementInfo) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(elementInfo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected View getView() {
            Object object;
            block4: {
                View view;
                if (!this.validateIfNecessary()) {
                    return null;
                }
                object = AccessibleHTML.this.lock();
                try {
                    View view2 = AccessibleHTML.this.getRootView();
                    Element element = this.getElement();
                    int n = element.getStartOffset();
                    if (view2 == null) break block4;
                    view = this.getView(view2, element, n);
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    AccessibleHTML.this.unlock(object);
                    throw throwable;
                }
                AccessibleHTML.this.unlock(object);
                return view;
            }
            View view = null;
            Object var7_8 = null;
            AccessibleHTML.this.unlock(object);
            return view;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Rectangle getBounds() {
            Object object;
            block6: {
                Rectangle rectangle;
                if (!this.validateIfNecessary()) {
                    return null;
                }
                object = AccessibleHTML.this.lock();
                try {
                    Rectangle rectangle2 = AccessibleHTML.this.getRootEditorRect();
                    View view = AccessibleHTML.this.getRootView();
                    Element element = this.getElement();
                    if (rectangle2 == null || view == null) break block6;
                    try {
                        rectangle = view.modelToView(element.getStartOffset(), Position.Bias.Forward, element.getEndOffset(), Position.Bias.Backward, rectangle2).getBounds();
                    }
                    catch (BadLocationException badLocationException) {
                        break block6;
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    AccessibleHTML.this.unlock(object);
                    throw throwable;
                }
                AccessibleHTML.this.unlock(object);
                return rectangle;
            }
            Object var7_8 = null;
            AccessibleHTML.this.unlock(object);
            return null;
        }

        protected boolean isValid() {
            return this.isValid;
        }

        protected AttributeSet getAttributes() {
            if (this.validateIfNecessary()) {
                return this.getElement().getAttributes();
            }
            return null;
        }

        protected AttributeSet getViewAttributes() {
            if (this.validateIfNecessary()) {
                View view = this.getView();
                if (view != null) {
                    return view.getElement().getAttributes();
                }
                return this.getElement().getAttributes();
            }
            return null;
        }

        protected int getIntAttr(AttributeSet attributeSet, Object object, int n) {
            if (attributeSet != null && attributeSet.isDefined(object)) {
                int n2;
                String string = (String)attributeSet.getAttribute(object);
                if (string == null) {
                    n2 = n;
                } else {
                    try {
                        n2 = Math.max(0, Integer.parseInt(string));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = n;
                    }
                }
                return n2;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean validateIfNecessary() {
            if (!this.isValid() && this.canBeValid) {
                this.children = null;
                Object object = AccessibleHTML.this.lock();
                try {
                    this.validate();
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    AccessibleHTML.this.unlock(object);
                    throw throwable;
                }
                AccessibleHTML.this.unlock(object);
                {
                }
            }
            return this.isValid();
        }

        protected void invalidate(boolean bl) {
            if (!this.isValid()) {
                if (this.canBeValid && !bl) {
                    this.canBeValid = false;
                }
                return;
            }
            this.isValid = false;
            this.canBeValid = bl;
            if (this.children != null) {
                int n = 0;
                while (n < this.children.size()) {
                    ((ElementInfo)this.children.get(n)).invalidate(false);
                    ++n;
                }
                this.children = null;
            }
        }

        private View getView(View view, Element element, int n) {
            if (view.getElement() == element) {
                return view;
            }
            int n2 = view.getViewIndex(n, Position.Bias.Forward);
            if (n2 != -1 && n2 < view.getViewCount()) {
                return this.getView(view.getView(n2), element, n);
            }
            return null;
        }

        private int getClosestInfoIndex(int n) {
            int n2 = 0;
            while (n2 < this.getChildCount()) {
                ElementInfo elementInfo = this.getChild(n2);
                if (n < elementInfo.getElement().getEndOffset() || n == elementInfo.getElement().getStartOffset()) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        private void update(DocumentEvent documentEvent) {
            Object object;
            if (!this.isValid()) {
                return;
            }
            ElementInfo elementInfo = this.getParent();
            Element element = this.getElement();
            do {
                if ((object = documentEvent.getChange(element)) != null) {
                    if (element == this.getElement()) {
                        this.invalidate(true);
                    } else if (elementInfo != null) {
                        elementInfo.invalidate(elementInfo == AccessibleHTML.this.getRootInfo());
                    }
                    return;
                }
                element = element.getParentElement();
            } while (elementInfo != null && element != null && element != elementInfo.getElement());
            if (this.getChildCount() > 0) {
                int n;
                ElementInfo elementInfo2;
                object = this.getElement();
                int n2 = documentEvent.getOffset();
                int n3 = this.getClosestInfoIndex(n2);
                if (n3 == -1 && documentEvent.getType() == DocumentEvent.EventType.REMOVE && n2 >= object.getEndOffset()) {
                    n3 = this.getChildCount() - 1;
                }
                ElementInfo elementInfo3 = elementInfo2 = n3 >= 0 ? this.getChild(n3) : null;
                if (elementInfo2 != null && elementInfo2.getElement().getStartOffset() == n2 && n2 > 0) {
                    n3 = Math.max(n3 - 1, 0);
                }
                if (documentEvent.getType() != DocumentEvent.EventType.REMOVE) {
                    n = this.getClosestInfoIndex(n2 + documentEvent.getLength());
                    if (n < 0) {
                        n = this.getChildCount() - 1;
                    }
                } else {
                    n = n3;
                    while (n + 1 < this.getChildCount() && this.getChild(n + 1).getElement().getEndOffset() == this.getChild(n + 1).getElement().getStartOffset()) {
                        ++n;
                    }
                }
                int n4 = n3 = Math.max(n3, 0);
                while (n4 <= n && this.isValid()) {
                    this.getChild(n4).update(documentEvent);
                    ++n4;
                }
            }
        }
    }

    private class TableElementInfo
    extends ElementInfo
    implements Accessible {
        protected ElementInfo caption;
        private TableCellElementInfo[][] grid;
        private AccessibleContext accessibleContext;

        TableElementInfo(Element element, ElementInfo elementInfo) {
            super(element, elementInfo);
        }

        public ElementInfo getCaptionInfo() {
            return this.caption;
        }

        protected void validate() {
            super.validate();
            this.updateGrid();
        }

        protected void loadChildren(Element element) {
            int n = 0;
            while (n < element.getElementCount()) {
                Element element2 = element.getElement(n);
                AttributeSet attributeSet = element2.getAttributes();
                if (attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.TR) {
                    this.addChild(new TableRowElementInfo(element2, this, n));
                } else if (attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CAPTION) {
                    this.caption = AccessibleHTML.this.createElementInfo(element2, this);
                }
                ++n;
            }
        }

        private void updateGrid() {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.getChildCount()) {
                TableRowElementInfo tableRowElementInfo = this.getRow(n5);
                n = 0;
                int n6 = 0;
                while (n6 < n2) {
                    n = Math.max(n, this.getRow(n5 - n6 - 1).getColumnCount(n6 + 2));
                    ++n6;
                }
                n2 = Math.max(tableRowElementInfo.getRowCount(), n2);
                --n2;
                n3 = Math.max(n3, tableRowElementInfo.getColumnCount() + n);
                ++n5;
            }
            n4 = this.getChildCount() + n2;
            this.grid = new TableCellElementInfo[n4][];
            int n7 = 0;
            while (n7 < n4) {
                this.grid[n7] = new TableCellElementInfo[n3];
                ++n7;
            }
            n = 0;
            while (n < n4) {
                this.getRow(n).updateGrid(n);
                ++n;
            }
        }

        public TableRowElementInfo getRow(int n) {
            return (TableRowElementInfo)this.getChild(n);
        }

        public TableCellElementInfo getCell(int n, int n2) {
            if (this.validateIfNecessary() && n < this.grid.length && n2 < this.grid[0].length) {
                return this.grid[n][n2];
            }
            return null;
        }

        public int getRowExtentAt(int n, int n2) {
            TableCellElementInfo tableCellElementInfo = this.getCell(n, n2);
            if (tableCellElementInfo != null) {
                int n3 = tableCellElementInfo.getRowCount();
                int n4 = 1;
                while (n - n4 >= 0 && this.grid[n - n4][n2] == tableCellElementInfo) {
                    ++n4;
                }
                return n3 - n4 + 1;
            }
            return 0;
        }

        public int getColumnExtentAt(int n, int n2) {
            TableCellElementInfo tableCellElementInfo = this.getCell(n, n2);
            if (tableCellElementInfo != null) {
                int n3 = tableCellElementInfo.getColumnCount();
                int n4 = 1;
                while (n2 - n4 >= 0 && this.grid[n][n2 - n4] == tableCellElementInfo) {
                    ++n4;
                }
                return n3 - n4 + 1;
            }
            return 0;
        }

        public int getRowCount() {
            if (this.validateIfNecessary()) {
                return this.grid.length;
            }
            return 0;
        }

        public int getColumnCount() {
            if (this.validateIfNecessary() && this.grid.length > 0) {
                return this.grid[0].length;
            }
            return 0;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new TableAccessibleContext((ElementInfo)this);
            }
            return this.accessibleContext;
        }

        private class TableCellElementInfo
        extends ElementInfo {
            private Accessible accessible;
            private boolean isHeaderCell;

            TableCellElementInfo(Element element, ElementInfo elementInfo) {
                super(element, elementInfo);
                this.isHeaderCell = false;
            }

            TableCellElementInfo(Element element, ElementInfo elementInfo, boolean bl) {
                super(element, elementInfo);
                this.isHeaderCell = bl;
            }

            public boolean isHeaderCell() {
                return this.isHeaderCell;
            }

            public Accessible getAccessible() {
                this.accessible = null;
                this.getAccessible(this);
                return this.accessible;
            }

            private void getAccessible(ElementInfo elementInfo) {
                if (elementInfo instanceof Accessible) {
                    this.accessible = (Accessible)((Object)elementInfo);
                    return;
                }
                int n = 0;
                while (n < elementInfo.getChildCount()) {
                    this.getAccessible(elementInfo.getChild(n));
                    ++n;
                }
            }

            public int getRowCount() {
                if (this.validateIfNecessary()) {
                    return Math.max(1, this.getIntAttr(this.getAttributes(), HTML.Attribute.ROWSPAN, 1));
                }
                return 0;
            }

            public int getColumnCount() {
                if (this.validateIfNecessary()) {
                    return Math.max(1, this.getIntAttr(this.getAttributes(), HTML.Attribute.COLSPAN, 1));
                }
                return 0;
            }

            protected void invalidate(boolean bl) {
                super.invalidate(bl);
                this.getParent().invalidate(true);
            }
        }

        private class TableRowElementInfo
        extends ElementInfo {
            private TableElementInfo parent;
            private int rowNumber;

            TableRowElementInfo(Element element, TableElementInfo tableElementInfo2, int n) {
                super(element, tableElementInfo2);
                this.parent = tableElementInfo2;
                this.rowNumber = n;
            }

            protected void loadChildren(Element element) {
                int n = 0;
                while (n < element.getElementCount()) {
                    AttributeSet attributeSet = element.getElement(n).getAttributes();
                    if (attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.TH) {
                        TableCellElementInfo tableCellElementInfo = new TableCellElementInfo(element.getElement(n), this, true);
                        this.addChild(tableCellElementInfo);
                        AccessibleTable accessibleTable = this.parent.getAccessibleContext().getAccessibleTable();
                        TableAccessibleContext tableAccessibleContext = (TableAccessibleContext)accessibleTable;
                        tableAccessibleContext.addRowHeader(tableCellElementInfo, this.rowNumber);
                    } else if (attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.TD) {
                        this.addChild(new TableCellElementInfo(element.getElement(n), this, false));
                    }
                    ++n;
                }
            }

            public int getRowCount() {
                int n = 1;
                if (this.validateIfNecessary()) {
                    int n2 = 0;
                    while (n2 < this.getChildCount()) {
                        TableCellElementInfo tableCellElementInfo = (TableCellElementInfo)this.getChild(n2);
                        if (tableCellElementInfo.validateIfNecessary()) {
                            n = Math.max(n, tableCellElementInfo.getRowCount());
                        }
                        ++n2;
                    }
                }
                return n;
            }

            public int getColumnCount() {
                int n = 0;
                if (this.validateIfNecessary()) {
                    int n2 = 0;
                    while (n2 < this.getChildCount()) {
                        TableCellElementInfo tableCellElementInfo = (TableCellElementInfo)this.getChild(n2);
                        if (tableCellElementInfo.validateIfNecessary()) {
                            n += tableCellElementInfo.getColumnCount();
                        }
                        ++n2;
                    }
                }
                return n;
            }

            protected void invalidate(boolean bl) {
                super.invalidate(bl);
                this.getParent().invalidate(true);
            }

            private void updateGrid(int n) {
                if (this.validateIfNecessary()) {
                    int n2;
                    boolean bl = false;
                    while (!bl) {
                        n2 = 0;
                        while (n2 < TableElementInfo.this.grid[n].length) {
                            if (TableElementInfo.this.grid[n][n2] == null) {
                                bl = true;
                                break;
                            }
                            ++n2;
                        }
                        if (bl) continue;
                        ++n;
                    }
                    n2 = 0;
                    int n3 = 0;
                    while (n3 < this.getChildCount()) {
                        TableCellElementInfo tableCellElementInfo = (TableCellElementInfo)this.getChild(n3);
                        while (TableElementInfo.this.grid[n][n2] != null) {
                            ++n2;
                        }
                        int n4 = tableCellElementInfo.getRowCount() - 1;
                        while (n4 >= 0) {
                            int n5 = tableCellElementInfo.getColumnCount() - 1;
                            while (n5 >= 0) {
                                ((TableElementInfo)TableElementInfo.this).grid[n + n4][n2 + n5] = tableCellElementInfo;
                                --n5;
                            }
                            --n4;
                        }
                        n2 += tableCellElementInfo.getColumnCount();
                        ++n3;
                    }
                }
            }

            private int getColumnCount(int n) {
                if (this.validateIfNecessary()) {
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < this.getChildCount()) {
                        TableCellElementInfo tableCellElementInfo = (TableCellElementInfo)this.getChild(n3);
                        if (tableCellElementInfo.getRowCount() >= n) {
                            n2 += tableCellElementInfo.getColumnCount();
                        }
                        ++n3;
                    }
                    return n2;
                }
                return 0;
            }
        }

        public class TableAccessibleContext
        extends HTMLAccessibleContext
        implements AccessibleTable {
            private AccessibleHeadersTable rowHeadersTable;

            public TableAccessibleContext(ElementInfo elementInfo) {
                super(elementInfo);
            }

            public String getAccessibleName() {
                return this.getAccessibleRole().toString();
            }

            public String getAccessibleDescription() {
                return AccessibleHTML.this.editor.getContentType();
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.TABLE;
            }

            public int getAccessibleIndexInParent() {
                return this.elementInfo.getIndexInParent();
            }

            public int getAccessibleChildrenCount() {
                return ((TableElementInfo)this.elementInfo).getRowCount() * ((TableElementInfo)this.elementInfo).getColumnCount();
            }

            public Accessible getAccessibleChild(int n) {
                int n2 = ((TableElementInfo)this.elementInfo).getRowCount();
                int n3 = ((TableElementInfo)this.elementInfo).getColumnCount();
                int n4 = n / n2;
                int n5 = n % n3;
                if (n4 < 0 || n4 >= n2 || n5 < 0 || n5 >= n3) {
                    return null;
                }
                return this.getAccessibleAt(n4, n5);
            }

            public AccessibleTable getAccessibleTable() {
                return this;
            }

            public Accessible getAccessibleCaption() {
                ElementInfo elementInfo = TableElementInfo.this.getCaptionInfo();
                if (elementInfo instanceof Accessible) {
                    return (Accessible)((Object)TableElementInfo.this.caption);
                }
                return null;
            }

            public void setAccessibleCaption(Accessible accessible) {
            }

            public Accessible getAccessibleSummary() {
                return null;
            }

            public void setAccessibleSummary(Accessible accessible) {
            }

            public int getAccessibleRowCount() {
                return ((TableElementInfo)this.elementInfo).getRowCount();
            }

            public int getAccessibleColumnCount() {
                return ((TableElementInfo)this.elementInfo).getColumnCount();
            }

            public Accessible getAccessibleAt(int n, int n2) {
                TableCellElementInfo tableCellElementInfo = TableElementInfo.this.getCell(n, n2);
                if (tableCellElementInfo != null) {
                    return tableCellElementInfo.getAccessible();
                }
                return null;
            }

            public int getAccessibleRowExtentAt(int n, int n2) {
                return ((TableElementInfo)this.elementInfo).getRowExtentAt(n, n2);
            }

            public int getAccessibleColumnExtentAt(int n, int n2) {
                return ((TableElementInfo)this.elementInfo).getColumnExtentAt(n, n2);
            }

            public AccessibleTable getAccessibleRowHeader() {
                return this.rowHeadersTable;
            }

            public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
            }

            public AccessibleTable getAccessibleColumnHeader() {
                return null;
            }

            public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
            }

            public Accessible getAccessibleRowDescription(int n) {
                return null;
            }

            public void setAccessibleRowDescription(int n, Accessible accessible) {
            }

            public Accessible getAccessibleColumnDescription(int n) {
                return null;
            }

            public void setAccessibleColumnDescription(int n, Accessible accessible) {
            }

            public boolean isAccessibleSelected(int n, int n2) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    if (n < 0 || n >= this.getAccessibleRowCount() || n2 < 0 || n2 >= this.getAccessibleColumnCount()) {
                        return false;
                    }
                    TableCellElementInfo tableCellElementInfo = TableElementInfo.this.getCell(n, n2);
                    if (tableCellElementInfo != null) {
                        Element element = tableCellElementInfo.getElement();
                        int n3 = element.getStartOffset();
                        int n4 = element.getEndOffset();
                        return n3 >= AccessibleHTML.this.editor.getSelectionStart() && n4 <= AccessibleHTML.this.editor.getSelectionEnd();
                    }
                }
                return false;
            }

            public boolean isAccessibleRowSelected(int n) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    if (n < 0 || n >= this.getAccessibleRowCount()) {
                        return false;
                    }
                    int n2 = this.getAccessibleColumnCount();
                    TableCellElementInfo tableCellElementInfo = TableElementInfo.this.getCell(n, 0);
                    if (tableCellElementInfo == null) {
                        return false;
                    }
                    int n3 = tableCellElementInfo.getElement().getStartOffset();
                    TableCellElementInfo tableCellElementInfo2 = TableElementInfo.this.getCell(n, n2 - 1);
                    if (tableCellElementInfo2 == null) {
                        return false;
                    }
                    int n4 = tableCellElementInfo2.getElement().getEndOffset();
                    return n3 >= AccessibleHTML.this.editor.getSelectionStart() && n4 <= AccessibleHTML.this.editor.getSelectionEnd();
                }
                return false;
            }

            public boolean isAccessibleColumnSelected(int n) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    if (n < 0 || n >= this.getAccessibleColumnCount()) {
                        return false;
                    }
                    int n2 = this.getAccessibleRowCount();
                    TableCellElementInfo tableCellElementInfo = TableElementInfo.this.getCell(0, n);
                    if (tableCellElementInfo == null) {
                        return false;
                    }
                    int n3 = tableCellElementInfo.getElement().getStartOffset();
                    TableCellElementInfo tableCellElementInfo2 = TableElementInfo.this.getCell(n2 - 1, n);
                    if (tableCellElementInfo2 == null) {
                        return false;
                    }
                    int n4 = tableCellElementInfo2.getElement().getEndOffset();
                    return n3 >= AccessibleHTML.this.editor.getSelectionStart() && n4 <= AccessibleHTML.this.editor.getSelectionEnd();
                }
                return false;
            }

            public int[] getSelectedAccessibleRows() {
                if (TableElementInfo.this.validateIfNecessary()) {
                    int n = this.getAccessibleRowCount();
                    Vector<Integer> vector = new Vector<Integer>();
                    int n2 = 0;
                    while (n2 < n) {
                        if (this.isAccessibleRowSelected(n2)) {
                            vector.addElement(new Integer(n2));
                        }
                        ++n2;
                    }
                    int[] nArray = new int[vector.size()];
                    int n3 = 0;
                    while (n3 < nArray.length) {
                        nArray[n3] = (Integer)vector.elementAt(n3);
                        ++n3;
                    }
                    return nArray;
                }
                return new int[0];
            }

            public int[] getSelectedAccessibleColumns() {
                if (TableElementInfo.this.validateIfNecessary()) {
                    int n = this.getAccessibleRowCount();
                    Vector<Integer> vector = new Vector<Integer>();
                    int n2 = 0;
                    while (n2 < n) {
                        if (this.isAccessibleColumnSelected(n2)) {
                            vector.addElement(new Integer(n2));
                        }
                        ++n2;
                    }
                    int[] nArray = new int[vector.size()];
                    int n3 = 0;
                    while (n3 < nArray.length) {
                        nArray[n3] = (Integer)vector.elementAt(n3);
                        ++n3;
                    }
                    return nArray;
                }
                return new int[0];
            }

            public int getAccessibleRow(int n) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    int n2 = this.getAccessibleColumnCount() * this.getAccessibleRowCount();
                    if (n >= n2) {
                        return -1;
                    }
                    return n / this.getAccessibleColumnCount();
                }
                return -1;
            }

            public int getAccessibleColumn(int n) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    int n2 = this.getAccessibleColumnCount() * this.getAccessibleRowCount();
                    if (n >= n2) {
                        return -1;
                    }
                    return n % this.getAccessibleColumnCount();
                }
                return -1;
            }

            public int getAccessibleIndex(int n, int n2) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    if (n >= this.getAccessibleRowCount() || n2 >= this.getAccessibleColumnCount()) {
                        return -1;
                    }
                    return n * this.getAccessibleColumnCount() + n2;
                }
                return -1;
            }

            public String getAccessibleRowHeader(int n) {
                View view;
                TableCellElementInfo tableCellElementInfo;
                if (TableElementInfo.this.validateIfNecessary() && (tableCellElementInfo = TableElementInfo.this.getCell(n, 0)).isHeaderCell() && (view = tableCellElementInfo.getView()) != null && AccessibleHTML.this.model != null) {
                    try {
                        return AccessibleHTML.this.model.getText(view.getStartOffset(), view.getEndOffset() - view.getStartOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                return null;
            }

            public String getAccessibleColumnHeader(int n) {
                View view;
                TableCellElementInfo tableCellElementInfo;
                if (TableElementInfo.this.validateIfNecessary() && (tableCellElementInfo = TableElementInfo.this.getCell(0, n)).isHeaderCell() && (view = tableCellElementInfo.getView()) != null && AccessibleHTML.this.model != null) {
                    try {
                        return AccessibleHTML.this.model.getText(view.getStartOffset(), view.getEndOffset() - view.getStartOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                return null;
            }

            public void addRowHeader(TableCellElementInfo tableCellElementInfo, int n) {
                if (this.rowHeadersTable == null) {
                    this.rowHeadersTable = new AccessibleHeadersTable();
                }
                this.rowHeadersTable.addHeader(tableCellElementInfo, n);
            }

            protected class AccessibleHeadersTable
            implements AccessibleTable {
                private Hashtable headers = new Hashtable();
                private int rowCount = 0;
                private int columnCount = 0;

                protected AccessibleHeadersTable() {
                }

                public void addHeader(TableCellElementInfo tableCellElementInfo, int n) {
                    Integer n2 = new Integer(n);
                    ArrayList<TableCellElementInfo> arrayList = (ArrayList<TableCellElementInfo>)this.headers.get(n2);
                    if (arrayList == null) {
                        arrayList = new ArrayList<TableCellElementInfo>();
                        this.headers.put(n2, arrayList);
                    }
                    arrayList.add(tableCellElementInfo);
                }

                public Accessible getAccessibleCaption() {
                    return null;
                }

                public void setAccessibleCaption(Accessible accessible) {
                }

                public Accessible getAccessibleSummary() {
                    return null;
                }

                public void setAccessibleSummary(Accessible accessible) {
                }

                public int getAccessibleRowCount() {
                    return this.rowCount;
                }

                public int getAccessibleColumnCount() {
                    return this.columnCount;
                }

                private TableCellElementInfo getElementInfoAt(int n, int n2) {
                    ArrayList arrayList = (ArrayList)this.headers.get(new Integer(n));
                    if (arrayList != null) {
                        return (TableCellElementInfo)arrayList.get(n2);
                    }
                    return null;
                }

                public Accessible getAccessibleAt(int n, int n2) {
                    TableCellElementInfo tableCellElementInfo = this.getElementInfoAt(n, n2);
                    if (tableCellElementInfo instanceof Accessible) {
                        return (Accessible)((Object)tableCellElementInfo);
                    }
                    return null;
                }

                public int getAccessibleRowExtentAt(int n, int n2) {
                    TableCellElementInfo tableCellElementInfo = this.getElementInfoAt(n, n2);
                    if (tableCellElementInfo != null) {
                        return tableCellElementInfo.getRowCount();
                    }
                    return 0;
                }

                public int getAccessibleColumnExtentAt(int n, int n2) {
                    TableCellElementInfo tableCellElementInfo = this.getElementInfoAt(n, n2);
                    if (tableCellElementInfo != null) {
                        return tableCellElementInfo.getRowCount();
                    }
                    return 0;
                }

                public AccessibleTable getAccessibleRowHeader() {
                    return null;
                }

                public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
                }

                public AccessibleTable getAccessibleColumnHeader() {
                    return null;
                }

                public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
                }

                public Accessible getAccessibleRowDescription(int n) {
                    return null;
                }

                public void setAccessibleRowDescription(int n, Accessible accessible) {
                }

                public Accessible getAccessibleColumnDescription(int n) {
                    return null;
                }

                public void setAccessibleColumnDescription(int n, Accessible accessible) {
                }

                public boolean isAccessibleSelected(int n, int n2) {
                    return false;
                }

                public boolean isAccessibleRowSelected(int n) {
                    return false;
                }

                public boolean isAccessibleColumnSelected(int n) {
                    return false;
                }

                public int[] getSelectedAccessibleRows() {
                    return new int[0];
                }

                public int[] getSelectedAccessibleColumns() {
                    return new int[0];
                }
            }
        }
    }

    private class IconElementInfo
    extends ElementInfo
    implements Accessible {
        private int width;
        private int height;
        private AccessibleContext accessibleContext;

        IconElementInfo(Element element, ElementInfo elementInfo) {
            super(element, elementInfo);
            this.width = -1;
            this.height = -1;
        }

        protected void invalidate(boolean bl) {
            super.invalidate(bl);
            this.height = -1;
            this.width = -1;
        }

        private int getImageSize(Object object) {
            if (this.validateIfNecessary()) {
                int n = this.getIntAttr(this.getAttributes(), object, -1);
                if (n == -1) {
                    Image image;
                    View view = this.getView();
                    n = 0;
                    if (view instanceof ImageView && (image = ((ImageView)view).getImage()) != null) {
                        n = object == HTML.Attribute.WIDTH ? image.getWidth(null) : image.getHeight(null);
                    }
                }
                return n;
            }
            return 0;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new IconAccessibleContext((ElementInfo)this);
            }
            return this.accessibleContext;
        }

        protected class IconAccessibleContext
        extends HTMLAccessibleContext
        implements AccessibleIcon {
            public IconAccessibleContext(ElementInfo elementInfo) {
                super(elementInfo);
            }

            public String getAccessibleName() {
                if (AccessibleHTML.this.model != null) {
                    return (String)AccessibleHTML.this.model.getProperty("title");
                }
                return null;
            }

            public String getAccessibleDescription() {
                return AccessibleHTML.this.editor.getContentType();
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.ICON;
            }

            public AccessibleIcon[] getAccessibleIcon() {
                AccessibleIcon[] accessibleIconArray = new AccessibleIcon[]{this};
                return accessibleIconArray;
            }

            public String getAccessibleIconDescription() {
                return ((ImageView)IconElementInfo.this.getView()).getAltText();
            }

            public void setAccessibleIconDescription(String string) {
            }

            public int getAccessibleIconWidth() {
                if (IconElementInfo.this.width == -1) {
                    IconElementInfo.this.width = IconElementInfo.this.getImageSize(HTML.Attribute.WIDTH);
                }
                return IconElementInfo.this.width;
            }

            public int getAccessibleIconHeight() {
                if (IconElementInfo.this.height == -1) {
                    IconElementInfo.this.height = IconElementInfo.this.getImageSize(HTML.Attribute.HEIGHT);
                }
                return IconElementInfo.this.height;
            }
        }
    }

    class TextElementInfo
    extends ElementInfo
    implements Accessible {
        private AccessibleContext accessibleContext;

        TextElementInfo(Element element, ElementInfo elementInfo) {
            super(element, elementInfo);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new TextAccessibleContext((ElementInfo)this);
            }
            return this.accessibleContext;
        }

        public class TextAccessibleContext
        extends HTMLAccessibleContext
        implements AccessibleText {
            public TextAccessibleContext(ElementInfo elementInfo) {
                super(elementInfo);
            }

            public AccessibleText getAccessibleText() {
                return this;
            }

            public String getAccessibleName() {
                if (AccessibleHTML.this.model != null) {
                    return (String)AccessibleHTML.this.model.getProperty("title");
                }
                return null;
            }

            public String getAccessibleDescription() {
                return AccessibleHTML.this.editor.getContentType();
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.TEXT;
            }

            public int getIndexAtPoint(Point point) {
                View view = TextElementInfo.this.getView();
                if (view != null) {
                    return view.viewToModel(point.x, point.y, this.getBounds());
                }
                return -1;
            }

            public Rectangle getCharacterBounds(int n) {
                try {
                    return AccessibleHTML.this.editor.getUI().modelToView(AccessibleHTML.this.editor, n);
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }

            public int getCharCount() {
                if (TextElementInfo.this.validateIfNecessary()) {
                    Element element = this.elementInfo.getElement();
                    return element.getEndOffset() - element.getStartOffset();
                }
                return 0;
            }

            public int getCaretPosition() {
                View view = TextElementInfo.this.getView();
                if (view == null) {
                    return -1;
                }
                Container container = view.getContainer();
                if (container == null) {
                    return -1;
                }
                if (container instanceof JTextComponent) {
                    return ((JTextComponent)container).getCaretPosition();
                }
                return -1;
            }

            public String getAtIndex(int n, int n2) {
                return this.getAtIndex(n, n2, 0);
            }

            public String getAfterIndex(int n, int n2) {
                return this.getAtIndex(n, n2, 1);
            }

            public String getBeforeIndex(int n, int n2) {
                return this.getAtIndex(n, n2, -1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private String getAtIndex(int n, int n2, int n3) {
                if (AccessibleHTML.this.model instanceof AbstractDocument) {
                    ((AbstractDocument)AccessibleHTML.this.model).readLock();
                }
                try {
                    if (n2 < 0 || n2 >= AccessibleHTML.this.model.getLength()) {
                        String string = null;
                        return string;
                    }
                    switch (n) {
                        case 1: {
                            if (n2 + n3 >= AccessibleHTML.this.model.getLength()) return null;
                            if (n2 + n3 < 0) return null;
                            String string = AccessibleHTML.this.model.getText(n2 + n3, 1);
                            return string;
                        }
                        case 2: 
                        case 3: {
                            IndexedSegment indexedSegment = this.getSegmentAt(n, n2);
                            if (indexedSegment == null) return null;
                            if (n3 != 0) {
                                int n4 = n3 < 0 ? indexedSegment.modelOffset - 1 : indexedSegment.modelOffset + n3 * indexedSegment.count;
                                indexedSegment = n4 >= 0 && n4 <= AccessibleHTML.this.model.getLength() ? this.getSegmentAt(n, n4) : null;
                            }
                            if (indexedSegment == null) return null;
                            String string = new String(indexedSegment.array, indexedSegment.offset, indexedSegment.count);
                            return string;
                        }
                    }
                    return null;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                finally {
                    if (AccessibleHTML.this.model instanceof AbstractDocument) {
                        ((AbstractDocument)AccessibleHTML.this.model).readUnlock();
                    }
                }
            }

            private Element getParagraphElement(int n) {
                if (AccessibleHTML.this.model instanceof PlainDocument) {
                    PlainDocument plainDocument = (PlainDocument)AccessibleHTML.this.model;
                    return plainDocument.getParagraphElement(n);
                }
                if (AccessibleHTML.this.model instanceof StyledDocument) {
                    StyledDocument styledDocument = (StyledDocument)AccessibleHTML.this.model;
                    return styledDocument.getParagraphElement(n);
                }
                Element element = null;
                element = AccessibleHTML.this.model.getDefaultRootElement();
                while (!element.isLeaf()) {
                    int n2 = element.getElementIndex(n);
                    element = element.getElement(n2);
                }
                if (element == null) {
                    return null;
                }
                return element.getParentElement();
            }

            private IndexedSegment getParagraphElementText(int n) throws BadLocationException {
                Element element = this.getParagraphElement(n);
                if (element != null) {
                    IndexedSegment indexedSegment = new IndexedSegment();
                    try {
                        int n2 = element.getEndOffset() - element.getStartOffset();
                        AccessibleHTML.this.model.getText(element.getStartOffset(), n2, indexedSegment);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                    indexedSegment.modelOffset = element.getStartOffset();
                    return indexedSegment;
                }
                return null;
            }

            private IndexedSegment getSegmentAt(int n, int n2) throws BadLocationException {
                BreakIterator breakIterator;
                IndexedSegment indexedSegment = this.getParagraphElementText(n2);
                if (indexedSegment == null) {
                    return null;
                }
                switch (n) {
                    case 2: {
                        breakIterator = BreakIterator.getWordInstance(this.getLocale());
                        break;
                    }
                    case 3: {
                        breakIterator = BreakIterator.getSentenceInstance(this.getLocale());
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                indexedSegment.first();
                breakIterator.setText(indexedSegment);
                int n3 = breakIterator.following(n2 - indexedSegment.modelOffset + indexedSegment.offset);
                if (n3 == -1) {
                    return null;
                }
                if (n3 > indexedSegment.offset + indexedSegment.count) {
                    return null;
                }
                int n4 = breakIterator.previous();
                if (n4 == -1 || n4 >= indexedSegment.offset + indexedSegment.count) {
                    return null;
                }
                indexedSegment.modelOffset = indexedSegment.modelOffset + n4 - indexedSegment.offset;
                indexedSegment.offset = n4;
                indexedSegment.count = n3 - n4;
                return indexedSegment;
            }

            public AttributeSet getCharacterAttribute(int n) {
                StyledDocument styledDocument;
                Element element;
                if (AccessibleHTML.this.model instanceof StyledDocument && (element = (styledDocument = (StyledDocument)AccessibleHTML.this.model).getCharacterElement(n)) != null) {
                    return element.getAttributes();
                }
                return null;
            }

            public int getSelectionStart() {
                return AccessibleHTML.this.editor.getSelectionStart();
            }

            public int getSelectionEnd() {
                return AccessibleHTML.this.editor.getSelectionEnd();
            }

            public String getSelectedText() {
                return AccessibleHTML.this.editor.getSelectedText();
            }

            private String getText(int n, int n2) throws BadLocationException {
                if (AccessibleHTML.this.model != null && AccessibleHTML.this.model instanceof StyledDocument) {
                    StyledDocument styledDocument = (StyledDocument)AccessibleHTML.this.model;
                    return AccessibleHTML.this.model.getText(n, n2);
                }
                return null;
            }

            private class IndexedSegment
            extends Segment {
                public int modelOffset;

                private IndexedSegment() {
                }
            }
        }
    }

    protected abstract class HTMLAccessibleContext
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent {
        protected ElementInfo elementInfo;

        public HTMLAccessibleContext(ElementInfo elementInfo) {
            this.elementInfo = elementInfo;
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            Object object = this.elementInfo.getParent();
            if (object != null && object.equals(AccessibleHTML.this.rootElementInfo)) {
                object = AccessibleHTML.this.editor;
            } else if (object instanceof TableElementInfo.TableCellElementInfo) {
                object = ((TableElementInfo.TableCellElementInfo)object).getParent().getParent();
            }
            if (object instanceof Accessible) {
                return (Accessible)object;
            }
            return null;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            JEditorPane jEditorPane = AccessibleHTML.this.getTextComponent();
            if (jEditorPane != null && jEditorPane.isEnabled()) {
                accessibleStateSet.add(AccessibleState.ENABLED);
            }
            if (jEditorPane != null && jEditorPane.isFocusTraversable()) {
                accessibleStateSet.add(AccessibleState.FOCUSABLE);
            }
            if (jEditorPane != null && jEditorPane.isVisible()) {
                accessibleStateSet.add(AccessibleState.VISIBLE);
            }
            if (jEditorPane != null && jEditorPane.isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            }
            return accessibleStateSet;
        }

        public int getAccessibleIndexInParent() {
            return this.elementInfo.getIndexInParent();
        }

        public int getAccessibleChildrenCount() {
            return this.elementInfo.getChildCount();
        }

        public Accessible getAccessibleChild(int n) {
            ElementInfo elementInfo = this.elementInfo.getChild(n);
            if (elementInfo != null && elementInfo instanceof Accessible) {
                return (Accessible)((Object)elementInfo);
            }
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return AccessibleHTML.this.editor.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return AccessibleHTML.this.getTextComponent().getBackground();
        }

        public void setBackground(Color color) {
            AccessibleHTML.this.getTextComponent().setBackground(color);
        }

        public Color getForeground() {
            return AccessibleHTML.this.getTextComponent().getForeground();
        }

        public void setForeground(Color color) {
            AccessibleHTML.this.getTextComponent().setForeground(color);
        }

        public Cursor getCursor() {
            return AccessibleHTML.this.getTextComponent().getCursor();
        }

        public void setCursor(Cursor cursor) {
            AccessibleHTML.this.getTextComponent().setCursor(cursor);
        }

        public Font getFont() {
            return AccessibleHTML.this.getTextComponent().getFont();
        }

        public void setFont(Font font) {
            AccessibleHTML.this.getTextComponent().setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return AccessibleHTML.this.getTextComponent().getFontMetrics(font);
        }

        public boolean isEnabled() {
            return AccessibleHTML.this.getTextComponent().isEnabled();
        }

        public void setEnabled(boolean bl) {
            AccessibleHTML.this.getTextComponent().setEnabled(bl);
        }

        public boolean isVisible() {
            return AccessibleHTML.this.getTextComponent().isVisible();
        }

        public void setVisible(boolean bl) {
            AccessibleHTML.this.getTextComponent().setVisible(bl);
        }

        public boolean isShowing() {
            return AccessibleHTML.this.getTextComponent().isShowing();
        }

        public boolean contains(Point point) {
            Rectangle rectangle = this.getBounds();
            if (rectangle != null) {
                return rectangle.contains(point.x, point.y);
            }
            return false;
        }

        public Point getLocationOnScreen() {
            Point point = AccessibleHTML.this.getTextComponent().getLocationOnScreen();
            Rectangle rectangle = this.getBounds();
            if (rectangle != null) {
                return new Point(point.x + rectangle.x, point.y + rectangle.y);
            }
            return null;
        }

        public Point getLocation() {
            Rectangle rectangle = this.getBounds();
            if (rectangle != null) {
                return new Point(rectangle.x, rectangle.y);
            }
            return null;
        }

        public void setLocation(Point point) {
        }

        public Rectangle getBounds() {
            return this.elementInfo.getBounds();
        }

        public void setBounds(Rectangle rectangle) {
            AccessibleHTML.this.getTextComponent().setBounds(rectangle);
        }

        public Dimension getSize() {
            Rectangle rectangle = this.getBounds();
            if (rectangle != null) {
                return new Dimension(rectangle.width, rectangle.height);
            }
            return null;
        }

        public void setSize(Dimension dimension) {
            AccessibleHTML.this.getTextComponent().setSize(dimension);
        }

        public Accessible getAccessibleAt(Point point) {
            ElementInfo elementInfo = this.getElementInfoAt(AccessibleHTML.this.rootElementInfo, point);
            if (elementInfo instanceof Accessible) {
                return (Accessible)((Object)elementInfo);
            }
            return null;
        }

        private ElementInfo getElementInfoAt(ElementInfo elementInfo, Point point) {
            Object object;
            ElementInfo elementInfo2;
            if (elementInfo.getBounds() == null) {
                return null;
            }
            if (elementInfo.getChildCount() == 0 && elementInfo.getBounds().contains(point)) {
                return elementInfo;
            }
            if (elementInfo instanceof TableElementInfo && (elementInfo2 = ((TableElementInfo)elementInfo).getCaptionInfo()) != null && (object = elementInfo2.getBounds()) != null && ((Rectangle)object).contains(point)) {
                return elementInfo2;
            }
            int n = 0;
            while (n < elementInfo.getChildCount()) {
                object = elementInfo.getChild(n);
                ElementInfo elementInfo3 = this.getElementInfoAt((ElementInfo)object, point);
                if (elementInfo3 != null) {
                    return elementInfo3;
                }
                ++n;
            }
            return null;
        }

        public boolean isFocusTraversable() {
            return AccessibleHTML.this.getTextComponent().isFocusTraversable();
        }

        public void requestFocus() {
            AccessibleHTML.this.getTextComponent().requestFocus();
        }

        public void addFocusListener(FocusListener focusListener) {
            AccessibleHTML.this.getTextComponent().addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            AccessibleHTML.this.getTextComponent().removeFocusListener(focusListener);
        }
    }

    private class RootHTMLAccessibleContext
    extends HTMLAccessibleContext {
        public RootHTMLAccessibleContext(ElementInfo elementInfo) {
            super(elementInfo);
        }

        public String getAccessibleName() {
            if (AccessibleHTML.this.model != null) {
                return (String)AccessibleHTML.this.model.getProperty("title");
            }
            return null;
        }

        public String getAccessibleDescription() {
            return AccessibleHTML.this.editor.getContentType();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }
    }
}

