/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.lang.reflect.Constructor;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.InternationalFormatter;

public class NumberFormatter
extends InternationalFormatter {
    private String specialChars;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;

    public NumberFormatter() {
        this(NumberFormat.getNumberInstance());
    }

    public NumberFormatter(NumberFormat numberFormat) {
        super(numberFormat);
        this.setFormat(numberFormat);
        this.setAllowsInvalid(true);
        this.setCommitsOnValidEdit(false);
        this.setOverwriteMode(false);
    }

    public void setFormat(Format format) {
        super.setFormat(format);
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        if (decimalFormatSymbols != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(decimalFormatSymbols.getCurrencySymbol());
            stringBuffer.append(decimalFormatSymbols.getDecimalSeparator());
            stringBuffer.append(decimalFormatSymbols.getGroupingSeparator());
            stringBuffer.append(decimalFormatSymbols.getInfinity());
            stringBuffer.append(decimalFormatSymbols.getInternationalCurrencySymbol());
            stringBuffer.append(decimalFormatSymbols.getMinusSign());
            stringBuffer.append(decimalFormatSymbols.getMonetaryDecimalSeparator());
            stringBuffer.append(decimalFormatSymbols.getNaN());
            stringBuffer.append(decimalFormatSymbols.getPercent());
            stringBuffer.append('+');
            this.specialChars = stringBuffer.toString();
        } else {
            this.specialChars = "";
        }
    }

    Object stringToValue(String string, Format format) throws ParseException {
        if (format == null) {
            return string;
        }
        Object object = format.parseObject(string);
        return this.convertValueToValueClass(object, this.getValueClass());
    }

    private Object convertValueToValueClass(Object object, Class clazz) {
        if (clazz != null && object instanceof Number) {
            if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = NumberFormatter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Integer(((Number)object).intValue());
            }
            if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = NumberFormatter.class$("java.lang.Long")) : class$java$lang$Long)) {
                return new Long(((Number)object).longValue());
            }
            if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = NumberFormatter.class$("java.lang.Float")) : class$java$lang$Float)) {
                return new Float(((Number)object).floatValue());
            }
            if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = NumberFormatter.class$("java.lang.Double")) : class$java$lang$Double)) {
                return new Double(((Number)object).doubleValue());
            }
            if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = NumberFormatter.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return new Byte(((Number)object).byteValue());
            }
            if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = NumberFormatter.class$("java.lang.Short")) : class$java$lang$Short)) {
                return new Short(((Number)object).shortValue());
            }
        }
        return object;
    }

    private char getPositiveSign() {
        return '+';
    }

    private char getMinusSign() {
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        if (decimalFormatSymbols != null) {
            return decimalFormatSymbols.getMinusSign();
        }
        return '-';
    }

    private char getDecimalSeparator() {
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        if (decimalFormatSymbols != null) {
            return decimalFormatSymbols.getDecimalSeparator();
        }
        return '.';
    }

    private DecimalFormatSymbols getDecimalFormatSymbols() {
        Format format = this.getFormat();
        if (format instanceof DecimalFormat) {
            return ((DecimalFormat)format).getDecimalFormatSymbols();
        }
        return null;
    }

    private boolean isValidInsertionCharacter(char c) {
        return Character.isDigit(c) || this.specialChars.indexOf(c) != -1;
    }

    boolean isLegalInsertText(String string) {
        if (this.getAllowsInvalid()) {
            return true;
        }
        int n = string.length() - 1;
        while (n >= 0) {
            char c = string.charAt(n);
            if (!Character.isDigit(c) && this.specialChars.indexOf(c) == -1) {
                return false;
            }
            --n;
        }
        return true;
    }

    boolean isLiteral(Map map) {
        if (!super.isLiteral(map)) {
            if (map == null) {
                return false;
            }
            int n = map.size();
            if (map.get(NumberFormat.Field.GROUPING_SEPARATOR) != null) {
                --n;
                if (map.get(NumberFormat.Field.INTEGER) != null) {
                    --n;
                }
            }
            if (map.get(NumberFormat.Field.EXPONENT_SYMBOL) != null) {
                --n;
            }
            if (map.get(NumberFormat.Field.PERCENT) != null) {
                --n;
            }
            if (map.get(NumberFormat.Field.PERMILLE) != null) {
                --n;
            }
            if (map.get(NumberFormat.Field.CURRENCY) != null) {
                --n;
            }
            return n == 0;
        }
        return true;
    }

    boolean isNavigatable(int n) {
        if (!super.isNavigatable(n)) {
            return this.getBufferedChar(n) == this.getDecimalSeparator();
        }
        return true;
    }

    private NumberFormat.Field getFieldFrom(int n, int n2) {
        if (this.isValidMask()) {
            int n3 = this.getFormattedTextField().getDocument().getLength();
            AttributedCharacterIterator attributedCharacterIterator = this.getIterator();
            if (n >= n3) {
                n += n2;
            }
            while (n >= 0 && n < n3) {
                attributedCharacterIterator.setIndex(n);
                Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
                if (map != null && map.size() > 0) {
                    Iterator<AttributedCharacterIterator.Attribute> iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        AttributedCharacterIterator.Attribute attribute = iterator.next();
                        if (!(attribute instanceof NumberFormat.Field)) continue;
                        return (NumberFormat.Field)attribute;
                    }
                }
                n += n2;
            }
        }
        return null;
    }

    void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        if (!this.getAllowsInvalid() && n2 == 0 && string != null && string.length() == 1 && this.toggleSignIfNecessary(filterBypass, n, string.charAt(0))) {
            return;
        }
        super.replace(filterBypass, n, n2, string, attributeSet);
    }

    private boolean toggleSignIfNecessary(DocumentFilter.FilterBypass filterBypass, int n, char c) throws BadLocationException {
        block3: {
            if (c != this.getMinusSign() && c != this.getPositiveSign()) break block3;
            NumberFormat.Field field = this.getFieldFrom(n, -1);
            try {
                Object object = field == null || field != NumberFormat.Field.EXPONENT && field != NumberFormat.Field.EXPONENT_SYMBOL && field != NumberFormat.Field.EXPONENT_SIGN ? this.toggleSign(c == this.getPositiveSign()) : this.toggleExponentSign(n, c);
                if (object != null && this.isValidValue(object, false)) {
                    int n2 = this.getLiteralCountTo(n);
                    String string = this.valueToString(object);
                    filterBypass.remove(0, filterBypass.getDocument().getLength());
                    filterBypass.insertString(0, string, null);
                    this.updateValue(object);
                    this.repositionCursor(this.getLiteralCountTo(n) - n2 + n, 1);
                    return true;
                }
            }
            catch (ParseException parseException) {
                this.invalidEdit();
            }
        }
        return false;
    }

    private boolean isOnlyIntegerField(int n, int n2) {
        int n3;
        if (this.isValidMask() && (n3 = this.getAttributeStart(NumberFormat.Field.INTEGER)) != -1) {
            AttributedCharacterIterator attributedCharacterIterator = this.getIterator();
            attributedCharacterIterator.setIndex(n3);
            return n <= n3 && attributedCharacterIterator.getRunLimit(NumberFormat.Field.INTEGER) <= n + n2;
        }
        return false;
    }

    private Object toggleSign(boolean bl) throws ParseException {
        block10: {
            String string;
            Object object = this.stringToValue(this.getFormattedTextField().getText());
            if (object == null || (string = object.toString()) == null || string.length() <= 0) break block10;
            if (bl) {
                if (string.charAt(0) == '-') {
                    string = string.substring(1);
                }
            } else {
                if (string.charAt(0) == '+') {
                    string = string.substring(1);
                }
                if (string.length() > 0 && string.charAt(0) != '-') {
                    string = "-" + string;
                }
            }
            if (string != null) {
                Class<?> clazz = this.getValueClass();
                if (clazz == null) {
                    clazz = object.getClass();
                }
                try {
                    Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = NumberFormatter.class$("java.lang.String")) : class$java$lang$String);
                    if (constructor != null) {
                        return constructor.newInstance(string);
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    private Object toggleExponentSign(int n, char c) throws BadLocationException, ParseException {
        String string = this.getFormattedTextField().getText();
        int n2 = 0;
        int n3 = this.getAttributeStart(NumberFormat.Field.EXPONENT_SIGN);
        if (n3 >= 0) {
            n2 = 1;
            n = n3;
        }
        string = c == this.getPositiveSign() ? this.getReplaceString(n, n2, null) : this.getReplaceString(n, n2, new String(new char[]{c}));
        return this.stringToValue(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

