/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalUtils;

public class MetalToolBarUI
extends BasicToolBarUI {
    protected ContainerListener contListener;
    protected PropertyChangeListener rolloverListener;
    private static Border nonRolloverBorder;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalToolBarUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        nonRolloverBorder = null;
    }

    protected void installListeners() {
        super.installListeners();
        this.contListener = this.createContainerListener();
        if (this.contListener != null) {
            this.toolBar.addContainerListener(this.contListener);
        }
        this.rolloverListener = this.createRolloverListener();
        if (this.rolloverListener != null) {
            this.toolBar.addPropertyChangeListener(this.rolloverListener);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.contListener != null) {
            this.toolBar.removeContainerListener(this.contListener);
        }
        this.rolloverListener = this.createRolloverListener();
        if (this.rolloverListener != null) {
            this.toolBar.removePropertyChangeListener(this.rolloverListener);
        }
    }

    protected Border createRolloverBorder() {
        return new CompoundBorder(new MetalBorders.RolloverButtonBorder(), new MetalBorders.RolloverMarginBorder());
    }

    protected Border createNonRolloverBorder() {
        return new CompoundBorder(new MetalBorders.ButtonBorder(), new MetalBorders.RolloverMarginBorder());
    }

    private Border createNonRolloverToggleBorder() {
        return this.createNonRolloverBorder();
    }

    protected void setBorderToNonRollover(Component component) {
        if (component instanceof JToggleButton && !(component instanceof JCheckBox)) {
            JToggleButton jToggleButton = (JToggleButton)component;
            Border border = jToggleButton.getBorder();
            super.setBorderToNonRollover(component);
            if (border instanceof UIResource) {
                if (nonRolloverBorder == null) {
                    nonRolloverBorder = this.createNonRolloverToggleBorder();
                }
                jToggleButton.setBorder(nonRolloverBorder);
            }
        } else {
            super.setBorderToNonRollover(component);
        }
    }

    protected ContainerListener createContainerListener() {
        return null;
    }

    protected PropertyChangeListener createRolloverListener() {
        return null;
    }

    protected MouseInputListener createDockingListener() {
        return new MetalDockingListener(this.toolBar);
    }

    protected void setDragOffset(Point point) {
        if (!GraphicsEnvironment.isHeadless()) {
            if (this.dragWindow == null) {
                this.dragWindow = this.createDragWindow(this.toolBar);
            }
            this.dragWindow.setOffset(point);
        }
    }

    protected class MetalDockingListener
    extends BasicToolBarUI.DockingListener {
        private boolean pressedInBumps;

        public MetalDockingListener(JToolBar jToolBar) {
            super(jToolBar);
            this.pressedInBumps = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.pressedInBumps = false;
            Rectangle rectangle = new Rectangle();
            if (this.toolBar.getOrientation() == 0) {
                int n = MetalUtils.isLeftToRight(this.toolBar) ? 0 : this.toolBar.getSize().width - 14;
                rectangle.setBounds(n, 0, 14, this.toolBar.getSize().height);
            } else {
                rectangle.setBounds(0, 0, this.toolBar.getSize().width, 14);
            }
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.pressedInBumps = true;
                Point point = mouseEvent.getPoint();
                if (!MetalUtils.isLeftToRight(this.toolBar)) {
                    point.x -= this.toolBar.getSize().width - this.toolBar.getPreferredSize().width;
                }
                MetalToolBarUI.this.setDragOffset(point);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.pressedInBumps) {
                super.mouseDragged(mouseEvent);
            }
        }
    }

    protected class MetalRolloverListener
    extends BasicToolBarUI.PropertyListener {
        protected MetalRolloverListener() {
        }
    }

    protected class MetalContainerListener
    extends BasicToolBarUI.ToolBarContListener {
        protected MetalContainerListener() {
        }
    }
}

