/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.HeadspaceMixer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;

class HeadspaceSoundbank
implements Soundbank {
    String name;
    String version;
    String vendor;
    String description;
    Vector instruments = new Vector();
    Vector samples = new Vector();
    Vector sequences = new Vector();
    private long id = 0L;

    HeadspaceSoundbank(URL uRL) throws IOException {
        String string = uRL.getProtocol();
        if (!string.equals("file")) {
            this.initialize(uRL.openStream());
        } else {
            String string2 = uRL.getFile();
            this.initialize(string2);
        }
    }

    HeadspaceSoundbank(String string) {
        this.initialize(string);
    }

    HeadspaceSoundbank(InputStream inputStream) throws IOException {
        this.initialize(inputStream);
    }

    HeadspaceSoundbank(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.initialize(fileInputStream);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoundbankResource[] getResources() {
        SoundbankResource[] soundbankResourceArray;
        Vector vector = this.samples;
        synchronized (vector) {
            soundbankResourceArray = new SoundbankResource[this.samples.size()];
            int n = 0;
            while (n < soundbankResourceArray.length) {
                soundbankResourceArray[n] = (SoundbankResource)this.samples.elementAt(n);
                ++n;
            }
        }
        return soundbankResourceArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instrument[] getInstruments() {
        Instrument[] instrumentArray;
        Vector vector = this.instruments;
        synchronized (vector) {
            instrumentArray = new Instrument[this.instruments.size()];
            int n = 0;
            while (n < instrumentArray.length) {
                instrumentArray[n] = (Instrument)this.instruments.elementAt(n);
                ++n;
            }
        }
        return instrumentArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instrument getInstrument(Patch patch) {
        Vector vector = this.instruments;
        synchronized (vector) {
            int n = 0;
            while (n < this.instruments.size()) {
                Instrument instrument = (Instrument)this.instruments.elementAt(n);
                if (instrument.getPatch().getBank() == patch.getBank() && instrument.getPatch().getProgram() == patch.getProgram()) {
                    return instrument;
                }
                ++n;
            }
        }
        return null;
    }

    private void setupInformation() {
        this.name = this.nGetName(this.id);
        if (this.name == null) {
            this.name = "Untitled Headspace Soundbank";
        }
        int n = this.nGetVersionMajor(this.id);
        int n2 = this.nGetVersionMinor(this.id);
        int n3 = this.nGetVersionSubMinor(this.id);
        this.version = new String(n + "." + n2 + "." + n3);
        this.vendor = "Sun Microsystems, Headspace Corporation";
        this.description = "Soundbank for use with Headspace Mixer.";
        this.nGetInstruments(this.id, this.instruments);
        this.nGetSamples(this.id, this.samples);
    }

    private void initialize(InputStream inputStream) throws IOException {
        HeadspaceMixer headspaceMixer = HeadspaceMixer.getMixerInstance();
        inputStream.mark(1024);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        byte[] byArray2 = null;
        int n = 0;
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        this.id = this.nOpenResourceFromByteArray(byArray2, byArray2.length);
        if (this.id == 0L) {
            inputStream.reset();
            throw new IllegalArgumentException("Failed to get id");
        }
        this.setupInformation();
    }

    private void initialize(String string) {
        HeadspaceMixer headspaceMixer = HeadspaceMixer.getMixerInstance();
        this.id = this.nOpenResource(string);
        if (this.id == 0L) {
            throw new IllegalArgumentException("Failed to get id");
        }
        this.setupInformation();
    }

    private native long nOpenResource(String var1);

    private native long nOpenResourceFromByteArray(byte[] var1, int var2);

    private native boolean nCloseResource(long var1);

    private native String nGetName(long var1);

    private native int nGetVersionMajor(long var1);

    private native int nGetVersionMinor(long var1);

    private native int nGetVersionSubMinor(long var1);

    private native void nGetInstruments(long var1, Vector var3);

    private native void nGetSamples(long var1, Vector var3);
}

