/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractLine;
import java.util.Vector;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;

abstract class AbstractMixer
extends AbstractLine
implements Mixer {
    protected static final int PCM = 0;
    protected static final int ULAW = 1;
    protected static final int ALAW = 2;
    private final Mixer.Info mixerInfo;
    protected Line.Info[] sourceLineInfo;
    protected Line.Info[] targetLineInfo;
    private boolean started = false;
    private boolean manuallyOpened = false;
    protected Vector sourceLines = new Vector();
    protected Vector targetLines = new Vector();
    static /* synthetic */ Class class$javax$sound$sampled$Mixer;

    protected AbstractMixer(Mixer.Info info, Control[] controlArray, Line.Info[] infoArray, Line.Info[] infoArray2) {
        super(new Line.Info(class$javax$sound$sampled$Mixer == null ? (class$javax$sound$sampled$Mixer = AbstractMixer.class$("javax.sound.sampled.Mixer")) : class$javax$sound$sampled$Mixer), null, controlArray);
        this.mixer = this;
        if (controlArray == null) {
            controlArray = new Control[]{};
        }
        this.mixerInfo = info;
        this.sourceLineInfo = infoArray;
        this.targetLineInfo = infoArray2;
    }

    public Mixer.Info getMixerInfo() {
        return this.mixerInfo;
    }

    public Line.Info[] getSourceLineInfo() {
        Line.Info[] infoArray = new Line.Info[this.sourceLineInfo.length];
        System.arraycopy(this.sourceLineInfo, 0, infoArray, 0, this.sourceLineInfo.length);
        return infoArray;
    }

    public Line.Info[] getTargetLineInfo() {
        Line.Info[] infoArray = new Line.Info[this.targetLineInfo.length];
        System.arraycopy(this.targetLineInfo, 0, infoArray, 0, this.targetLineInfo.length);
        return infoArray;
    }

    public Line.Info[] getSourceLineInfo(Line.Info info) {
        Vector<Line.Info> vector = new Vector<Line.Info>();
        int n = 0;
        while (n < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n])) {
                vector.addElement(this.sourceLineInfo[n]);
            }
            ++n;
        }
        Line.Info[] infoArray = new Line.Info[vector.size()];
        n = 0;
        while (n < infoArray.length) {
            infoArray[n] = (Line.Info)vector.elementAt(n);
            ++n;
        }
        return infoArray;
    }

    public Line.Info[] getTargetLineInfo(Line.Info info) {
        Vector<Line.Info> vector = new Vector<Line.Info>();
        int n = 0;
        while (n < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n])) {
                vector.addElement(this.targetLineInfo[n]);
            }
            ++n;
        }
        Line.Info[] infoArray = new Line.Info[vector.size()];
        n = 0;
        while (n < infoArray.length) {
            infoArray[n] = (Line.Info)vector.elementAt(n);
            ++n;
        }
        return infoArray;
    }

    public boolean isLineSupported(Line.Info info) {
        int n = 0;
        while (n < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n])) {
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public abstract Line getLine(Line.Info var1) throws LineUnavailableException;

    public abstract int getMaxLines(Line.Info var1);

    protected abstract void implOpen() throws LineUnavailableException;

    protected abstract void implStart();

    protected abstract void implStop();

    protected abstract void implClose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Line[] getSourceLines() {
        Line[] lineArray;
        Vector vector = this.sourceLines;
        synchronized (vector) {
            lineArray = new Line[this.sourceLines.size()];
            int n = 0;
            while (n < lineArray.length) {
                lineArray[n] = (Line)this.sourceLines.elementAt(n);
                ++n;
            }
        }
        return lineArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Line[] getTargetLines() {
        Line[] lineArray;
        Vector vector = this.targetLines;
        synchronized (vector) {
            lineArray = new Line[this.targetLines.size()];
            int n = 0;
            while (n < lineArray.length) {
                lineArray[n] = (Line)this.targetLines.elementAt(n);
                ++n;
            }
        }
        return lineArray;
    }

    public void synchronize(Line[] lineArray, boolean bl) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public void unsynchronize(Line[] lineArray) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public boolean isSynchronizationSupported(Line[] lineArray, boolean bl) {
        return false;
    }

    public synchronized void open() throws LineUnavailableException {
        this.open(true);
    }

    protected synchronized void open(boolean bl) throws LineUnavailableException {
        if (!this.isOpen()) {
            this.implOpen();
            this.setOpen(true);
            if (bl) {
                this.manuallyOpened = true;
            }
        }
    }

    protected synchronized void open(Line line) throws LineUnavailableException {
        if (this.equals(line)) {
            return;
        }
        if (this.isSourceLine(line.getLineInfo())) {
            if (!this.sourceLines.contains(line)) {
                this.open(false);
                this.sourceLines.addElement(line);
            }
        } else if (this.isTargetLine(line.getLineInfo()) && !this.targetLines.contains(line)) {
            this.open(false);
            this.targetLines.addElement(line);
        }
    }

    protected synchronized void close(Line line) {
        if (this.equals(line)) {
            return;
        }
        this.sourceLines.removeElement(line);
        this.targetLines.removeElement(line);
        if (this.sourceLines.isEmpty() && this.targetLines.isEmpty() && !this.manuallyOpened) {
            this.close();
        }
    }

    public synchronized void close() {
        if (this.isOpen()) {
            Line[] lineArray = this.getSourceLines();
            int n = 0;
            while (n < lineArray.length) {
                lineArray[n].close();
                ++n;
            }
            lineArray = this.getTargetLines();
            int n2 = 0;
            while (n2 < lineArray.length) {
                lineArray[n2].close();
                ++n2;
            }
            this.implClose();
            this.setOpen(false);
        }
        this.manuallyOpened = false;
    }

    protected synchronized void start(Line line) {
        if (this.equals(line)) {
            return;
        }
        if (!this.started) {
            this.implStart();
            this.started = true;
        }
    }

    protected synchronized void stop(Line line) {
        Object object;
        if (this.equals(line)) {
            return;
        }
        Vector vector = (Vector)this.sourceLines.clone();
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof AbstractDataLine && ((AbstractDataLine)(object = (AbstractDataLine)vector.elementAt(n))).isStartedRunning() && !object.equals(line)) {
                return;
            }
            ++n;
        }
        object = (Vector)this.targetLines.clone();
        int n2 = 0;
        while (n2 < ((Vector)object).size()) {
            AbstractDataLine abstractDataLine;
            if (((Vector)object).elementAt(n2) instanceof AbstractDataLine && (abstractDataLine = (AbstractDataLine)((Vector)object).elementAt(n2)).isStartedRunning() && !abstractDataLine.equals(line)) {
                return;
            }
            ++n2;
        }
        this.started = false;
        this.implStop();
    }

    boolean isSourceLine(Line.Info info) {
        int n = 0;
        while (n < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isTargetLine(Line.Info info) {
        int n = 0;
        while (n < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    Line.Info getLineInfo(Line.Info info) {
        if (info == null) {
            return null;
        }
        int n = 0;
        while (n < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n])) {
                return this.sourceLineInfo[n];
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n2])) {
                return this.targetLineInfo[n2];
            }
            ++n2;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

