/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthPainter;
import com.sun.java.swing.plaf.gtk.SynthScrollBarUI;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;

class SynthScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants,
SynthUI {
    private SynthStyle style;
    protected JScrollPane scrollpane;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;
    private MouseWheelListener mouseScrollListener;
    private PropertyChangeListener vsbPropertyChangeListener;
    private PropertyChangeListener hsbPropertyChangeListener;
    private PropertyChangeListener sbPropertyChangeListener;
    private boolean setValueCalled = false;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$SynthScrollPaneUI;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    SynthScrollPaneUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthScrollPaneUI();
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("scrollUp", new ScrollAction("scrollUp", 1, -1, true));
        actionMap.put("scrollDown", new ScrollAction("scrollDown", 1, 1, true));
        actionMap.put("scrollHome", new ScrollHomeAction("ScrollHome"));
        actionMap.put("scrollEnd", new ScrollEndAction("ScrollEnd"));
        actionMap.put("unitScrollUp", new ScrollAction("UnitScrollUp", 1, -1, false));
        actionMap.put("unitScrollDown", new ScrollAction("UnitScrollDown", 1, 1, false));
        actionMap.put("scrollLeft", new ScrollAction("scrollLeft", 0, -1, true));
        actionMap.put("scrollRight", new ScrollAction("ScrollRight", 0, 1, true));
        actionMap.put("unitScrollRight", new ScrollAction("UnitScrollRight", 0, 1, false));
        actionMap.put("unitScrollLeft", new ScrollAction("UnitScrollLeft", 0, -1, false));
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        Border border = this.scrollpane.getViewportBorder();
        if (border != null) {
            Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
            border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void installDefaults(JScrollPane jScrollPane) {
        this.fetchStyle(jScrollPane);
    }

    private void fetchStyle(JScrollPane jScrollPane) {
        Border border;
        SynthContext synthContext = this.getContext((JComponent)jScrollPane, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle && ((border = this.scrollpane.getViewportBorder()) == null || border instanceof UIResource)) {
            this.scrollpane.setViewportBorder(new ViewportBorder(synthContext));
        }
        synthContext.dispose();
    }

    protected void installListeners(JScrollPane jScrollPane) {
        this.vsbChangeListener = this.createVSBChangeListener();
        this.vsbPropertyChangeListener = this.createVSBPropertyChangeListener();
        this.hsbChangeListener = this.createHSBChangeListener();
        this.hsbPropertyChangeListener = this.createHSBPropertyChangeListener();
        this.viewportChangeListener = this.createViewportChangeListener();
        this.spPropertyChangeListener = this.createPropertyChangeListener();
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        if (jViewport != null) {
            jViewport.addChangeListener(this.viewportChangeListener);
        }
        if (jScrollBar != null) {
            jScrollBar.getModel().addChangeListener(this.vsbChangeListener);
            jScrollBar.addPropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.getModel().addChangeListener(this.hsbChangeListener);
            jScrollBar2.addPropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.addPropertyChangeListener(this.spPropertyChangeListener);
        this.mouseScrollListener = this.createMouseWheelListener();
        this.scrollpane.addMouseWheelListener(this.mouseScrollListener);
    }

    protected void installKeyboardActions(JScrollPane jScrollPane) {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, inputMap);
        LazyActionMap.installLazyActionMap(jScrollPane, class$com$sun$java$swing$plaf$gtk$SynthScrollPaneUI == null ? (class$com$sun$java$swing$plaf$gtk$SynthScrollPaneUI = SynthScrollPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthScrollPaneUI")) : class$com$sun$java$swing$plaf$gtk$SynthScrollPaneUI, "ScrollPane.actionMap");
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            InputMap inputMap;
            SynthContext synthContext = this.getContext((JComponent)this.scrollpane, 1);
            SynthStyle synthStyle = synthContext.getStyle();
            InputMap inputMap2 = (InputMap)synthStyle.get(synthContext, "ScrollPane.ancestorInputMap");
            if (!this.scrollpane.getComponentOrientation().isLeftToRight() && (inputMap = (InputMap)synthStyle.get(synthContext, "ScrollPane.ancestorInputMap.RightToLeft")) != null) {
                inputMap.setParent(inputMap2);
                inputMap2 = inputMap;
            }
            synthContext.dispose();
            return inputMap2;
        }
        return null;
    }

    public void installUI(JComponent jComponent) {
        this.scrollpane = (JScrollPane)jComponent;
        this.installDefaults(this.scrollpane);
        this.installListeners(this.scrollpane);
        this.installKeyboardActions(this.scrollpane);
    }

    protected void uninstallDefaults(JScrollPane jScrollPane) {
        SynthContext synthContext = this.getContext((JComponent)jScrollPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        if (this.scrollpane.getViewportBorder() instanceof UIResource) {
            this.scrollpane.setViewportBorder(null);
        }
    }

    protected void uninstallListeners(JComponent jComponent) {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        if (jViewport != null) {
            jViewport.removeChangeListener(this.viewportChangeListener);
        }
        if (jScrollBar != null) {
            jScrollBar.getModel().removeChangeListener(this.vsbChangeListener);
            jScrollBar.removePropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.getModel().removeChangeListener(this.hsbChangeListener);
            jScrollBar2.removePropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.removePropertyChangeListener(this.spPropertyChangeListener);
        if (this.mouseScrollListener != null) {
            this.scrollpane.removeMouseWheelListener(this.mouseScrollListener);
        }
        this.vsbChangeListener = null;
        this.hsbChangeListener = null;
        this.viewportChangeListener = null;
        this.spPropertyChangeListener = null;
        this.mouseScrollListener = null;
    }

    protected void uninstallKeyboardActions(JScrollPane jScrollPane) {
        SwingUtilities.replaceUIActionMap(jScrollPane, null);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, null);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(this.scrollpane);
        this.uninstallListeners(this.scrollpane);
        this.uninstallKeyboardActions(this.scrollpane);
        this.scrollpane = null;
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, Region region) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthScrollPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, region, this.style, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthScrollPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    protected void syncScrollPaneWithViewport() {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        JViewport jViewport2 = this.scrollpane.getRowHeader();
        JViewport jViewport3 = this.scrollpane.getColumnHeader();
        boolean bl = this.scrollpane.getComponentOrientation().isLeftToRight();
        if (jViewport != null) {
            int n;
            int n2;
            int n3;
            Dimension dimension = jViewport.getExtentSize();
            Dimension dimension2 = jViewport.getViewSize();
            Point point = jViewport.getViewPosition();
            if (jScrollBar != null) {
                n3 = dimension.height;
                n2 = dimension2.height;
                n = Math.max(0, Math.min(point.y, n2 - n3));
                jScrollBar.setValues(n, n3, 0, n2);
            }
            if (jScrollBar2 != null) {
                n3 = dimension.width;
                n2 = dimension2.width;
                if (bl) {
                    n = Math.max(0, Math.min(point.x, n2 - n3));
                } else {
                    int n4 = jScrollBar2.getValue();
                    if (this.setValueCalled && n2 - n4 == point.x) {
                        n = Math.max(0, Math.min(n2 - n3, n4));
                        if (n3 != 0) {
                            this.setValueCalled = false;
                        }
                    } else if (n3 > n2) {
                        point.x = n2 - n3;
                        jViewport.setViewPosition(point);
                        n = 0;
                    } else {
                        n = Math.max(0, Math.min(n2 - n3, n2 - n3 - point.x));
                    }
                }
                jScrollBar2.setValues(n, n3, 0, n2);
            }
            if (jViewport2 != null) {
                Point point2 = jViewport2.getViewPosition();
                point2.y = jViewport.getViewPosition().y;
                point2.x = 0;
                jViewport2.setViewPosition(point2);
            }
            if (jViewport3 != null) {
                Point point3 = jViewport3.getViewPosition();
                point3.x = bl ? jViewport.getViewPosition().x : Math.max(0, jViewport.getViewPosition().x);
                point3.y = 0;
                jViewport3.setViewPosition(point3);
            }
        }
    }

    protected ChangeListener createViewportChangeListener() {
        return new ViewportChangeHandler();
    }

    private PropertyChangeListener createHSBPropertyChangeListener() {
        return this.getSBPropertyChangeListener();
    }

    private PropertyChangeListener getSBPropertyChangeListener() {
        if (this.sbPropertyChangeListener == null) {
            this.sbPropertyChangeListener = new ScrollBarPropertyChangeHandler();
        }
        return this.sbPropertyChangeListener;
    }

    protected ChangeListener createHSBChangeListener() {
        return new HSBChangeListener();
    }

    private PropertyChangeListener createVSBPropertyChangeListener() {
        return this.getSBPropertyChangeListener();
    }

    protected ChangeListener createVSBChangeListener() {
        return new VSBChangeListener();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent propertyChangeEvent) {
        this.scrollpane.revalidate();
        this.scrollpane.repaint();
    }

    protected void updateViewport(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getOldValue();
        JViewport jViewport2 = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            jViewport.removeChangeListener(this.viewportChangeListener);
        }
        if (jViewport2 != null) {
            int n;
            int n2;
            Point point = jViewport2.getViewPosition();
            point.x = this.scrollpane.getComponentOrientation().isLeftToRight() ? Math.max(point.x, 0) : ((n2 = jViewport2.getExtentSize().width) > (n = jViewport2.getViewSize().width) ? n - n2 : Math.max(0, Math.min(n - n2, point.x)));
            point.y = Math.max(point.y, 0);
            jViewport2.setViewPosition(point);
            jViewport2.addChangeListener(this.viewportChangeListener);
        }
    }

    protected void updateRowHeader(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            JViewport jViewport2 = this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.y = jViewport2 != null ? jViewport2.getViewPosition().y : 0;
            jViewport.setViewPosition(point);
        }
    }

    protected void updateColumnHeader(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            JViewport jViewport2 = this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.x = jViewport2 == null ? 0 : (this.scrollpane.getComponentOrientation().isLeftToRight() ? jViewport2.getViewPosition().x : Math.max(0, jViewport2.getViewPosition().x));
            jViewport.setViewPosition(point);
            this.scrollpane.add((Component)jViewport, "COLUMN_HEADER");
        }
    }

    private void updateHorizontalScrollBar(PropertyChangeEvent propertyChangeEvent) {
        this.updateScrollBar(propertyChangeEvent, this.hsbChangeListener, this.hsbPropertyChangeListener);
    }

    private void updateVerticalScrollBar(PropertyChangeEvent propertyChangeEvent) {
        this.updateScrollBar(propertyChangeEvent, this.vsbChangeListener, this.vsbPropertyChangeListener);
    }

    private void updateScrollBar(PropertyChangeEvent propertyChangeEvent, ChangeListener changeListener, PropertyChangeListener propertyChangeListener) {
        JScrollBar jScrollBar = (JScrollBar)propertyChangeEvent.getOldValue();
        if (jScrollBar != null) {
            if (changeListener != null) {
                jScrollBar.getModel().removeChangeListener(changeListener);
            }
            if (propertyChangeListener != null) {
                jScrollBar.removePropertyChangeListener(propertyChangeListener);
            }
        }
        if ((jScrollBar = (JScrollBar)propertyChangeEvent.getNewValue()) != null) {
            if (changeListener != null) {
                jScrollBar.getModel().addChangeListener(changeListener);
            }
            if (propertyChangeListener != null) {
                jScrollBar.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ViewportBorder
    extends AbstractBorder
    implements UIResource {
        private Insets insets;
        static final /* synthetic */ boolean $assertionsDisabled;

        ViewportBorder(SynthContext synthContext) {
            this.insets = (Insets)synthContext.getStyle().get(synthContext, "ScrollPane.viewportBorderInsets");
            if (this.insets == null) {
                this.insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
            }
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JComponent jComponent = (JComponent)component;
            SynthContext synthContext = SynthScrollPaneUI.this.getContext(jComponent, Region.VIEWPORT);
            SynthStyle synthStyle = synthContext.getStyle();
            if (synthStyle == null) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"SynthBorder is being used outside after the  UI has been uninstalled");
                }
                return;
            }
            SynthPainter synthPainter = (SynthPainter)synthStyle.get(synthContext, "ScrollPane.viewportBorderPainter");
            if (synthPainter != null) {
                synthPainter.paint(synthContext, "border", graphics, n, n2, n3, n4);
            }
            synthContext.dispose();
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            }
            insets.top = this.insets.top;
            insets.bottom = this.insets.bottom;
            insets.left = this.insets.left;
            insets.right = this.insets.left;
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }

        static {
            $assertionsDisabled = !(class$com$sun$java$swing$plaf$gtk$SynthScrollPaneUI == null ? (class$com$sun$java$swing$plaf$gtk$SynthScrollPaneUI = SynthScrollPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthScrollPaneUI")) : class$com$sun$java$swing$plaf$gtk$SynthScrollPaneUI).desiredAssertionStatus();
        }
    }

    private static class ScrollEndAction
    extends AbstractAction {
        protected ScrollEndAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Rectangle rectangle2 = component.getBounds();
                if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    jViewport.setViewPosition(new Point(rectangle2.width - rectangle.width, rectangle2.height - rectangle.height));
                } else {
                    jViewport.setViewPosition(new Point(0, rectangle2.height - rectangle.height));
                }
            }
        }
    }

    private static class ScrollHomeAction
    extends AbstractAction {
        protected ScrollHomeAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    jViewport.setViewPosition(new Point(0, 0));
                } else {
                    Rectangle rectangle = jViewport.getViewRect();
                    Rectangle rectangle2 = component.getBounds();
                    jViewport.setViewPosition(new Point(rectangle2.width - rectangle.width, 0));
                }
            }
        }
    }

    private static class ScrollAction
    extends AbstractAction {
        protected int orientation;
        protected int direction;
        private boolean block;

        protected ScrollAction(String string, int n, int n2, boolean bl) {
            super(string);
            this.orientation = n;
            this.direction = n2;
            this.block = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Dimension dimension = component.getSize();
                int n = component instanceof Scrollable ? (this.block ? ((Scrollable)((Object)component)).getScrollableBlockIncrement(rectangle, this.orientation, this.direction) : ((Scrollable)((Object)component)).getScrollableUnitIncrement(rectangle, this.orientation, this.direction)) : (this.block ? (this.orientation == 1 ? rectangle.height : rectangle.width) : 10);
                if (this.orientation == 1) {
                    rectangle.y += n * this.direction;
                    if (rectangle.y + rectangle.height > dimension.height) {
                        rectangle.y = Math.max(0, dimension.height - rectangle.height);
                    } else if (rectangle.y < 0) {
                        rectangle.y = 0;
                    }
                } else if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    rectangle.x += n * this.direction;
                    if (rectangle.x + rectangle.width > dimension.width) {
                        rectangle.x = Math.max(0, dimension.width - rectangle.width);
                    } else if (rectangle.x < 0) {
                        rectangle.x = 0;
                    }
                } else {
                    rectangle.x -= n * this.direction;
                    rectangle.x = rectangle.width > dimension.width ? dimension.width - rectangle.width : Math.max(0, Math.min(dimension.width - rectangle.width, rectangle.x));
                }
                jViewport.setViewPosition(rectangle.getLocation());
            }
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthScrollPaneUI.this.fetchStyle((JScrollPane)propertyChangeEvent.getSource());
            }
            if (string.equals("verticalScrollBarDisplayPolicy")) {
                SynthScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string.equals("horizontalScrollBarDisplayPolicy")) {
                SynthScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string.equals("viewport")) {
                SynthScrollPaneUI.this.updateViewport(propertyChangeEvent);
            } else if (string.equals("rowHeader")) {
                SynthScrollPaneUI.this.updateRowHeader(propertyChangeEvent);
            } else if (string.equals("columnHeader")) {
                SynthScrollPaneUI.this.updateColumnHeader(propertyChangeEvent);
            } else if (string.equals("verticalScrollBar")) {
                SynthScrollPaneUI.this.updateVerticalScrollBar(propertyChangeEvent);
            } else if (string.equals("horizontalScrollBar")) {
                SynthScrollPaneUI.this.updateHorizontalScrollBar(propertyChangeEvent);
            } else if (string.equals("componentOrientation")) {
                SynthScrollPaneUI.this.scrollpane.revalidate();
                SynthScrollPaneUI.this.scrollpane.repaint();
                InputMap inputMap = SynthScrollPaneUI.this.getInputMap(1);
                SwingUtilities.replaceUIInputMap(SynthScrollPaneUI.this.scrollpane, 1, inputMap);
            }
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        protected MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (SynthScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && mouseWheelEvent.getScrollAmount() != 0) {
                JScrollBar jScrollBar = SynthScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int n = 0;
                if (!(jScrollBar != null && jScrollBar.isVisible() || (jScrollBar = SynthScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) != null && jScrollBar.isVisible())) {
                    return;
                }
                int n2 = n = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
                if (mouseWheelEvent.getScrollType() == 0) {
                    SynthScrollBarUI.scrollByUnits(jScrollBar, n, mouseWheelEvent.getScrollAmount());
                } else if (mouseWheelEvent.getScrollType() == 1) {
                    SynthScrollBarUI.scrollByBlock(jScrollBar, n);
                }
            }
        }
    }

    private class ScrollBarPropertyChangeHandler
    implements PropertyChangeListener {
        private ScrollBarPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if ("model".equals(string)) {
                JScrollBar jScrollBar = SynthScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)propertyChangeEvent.getOldValue();
                ChangeListener changeListener = null;
                if (object == jScrollBar) {
                    changeListener = SynthScrollPaneUI.this.vsbChangeListener;
                } else if (object == SynthScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                    jScrollBar = SynthScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    changeListener = SynthScrollPaneUI.this.hsbChangeListener;
                }
                if (changeListener != null) {
                    if (boundedRangeModel != null) {
                        boundedRangeModel.removeChangeListener(changeListener);
                    }
                    if (jScrollBar.getModel() != null) {
                        jScrollBar.getModel().addChangeListener(changeListener);
                    }
                }
            } else if ("componentOrientation".equals(string) && object == SynthScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                JScrollBar jScrollBar = SynthScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                JViewport jViewport = SynthScrollPaneUI.this.scrollpane.getViewport();
                Point point = jViewport.getViewPosition();
                point.x = SynthScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight() ? jScrollBar.getValue() : jViewport.getViewSize().width - jViewport.getExtentSize().width - jScrollBar.getValue();
                jViewport.setViewPosition(point);
            }
        }
    }

    class VSBChangeListener
    implements ChangeListener {
        VSBChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = SynthScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                Point point = jViewport.getViewPosition();
                point.y = boundedRangeModel.getValue();
                jViewport.setViewPosition(point);
            }
        }
    }

    class HSBChangeListener
    implements ChangeListener {
        HSBChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = SynthScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                Point point = jViewport.getViewPosition();
                int n = boundedRangeModel.getValue();
                if (SynthScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight()) {
                    point.x = n;
                } else {
                    int n2 = jViewport.getViewSize().width;
                    int n3 = jViewport.getExtentSize().width;
                    int n4 = point.x;
                    point.x = n2 - n3 - n;
                    if (n3 == 0 && n != 0 && n4 == n2) {
                        SynthScrollPaneUI.this.setValueCalled = true;
                    } else if (n3 != 0 && n4 < 0 && point.x == 0) {
                        point.x += n;
                    }
                }
                jViewport.setViewPosition(point);
            }
        }
    }

    class ViewportChangeHandler
    implements ChangeListener {
        ViewportChangeHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SynthScrollPaneUI.this.syncScrollPaneWithViewport();
        }
    }
}

