/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.pi;

import com.ibm.CORBA.iiop.PMIPlugin;
import com.ibm.CORBA.iiop.RequestMessage;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.Profile;
import com.ibm.rmi.corba.ClientDelegate;
import com.ibm.rmi.corba.ORB;
import com.ibm.rmi.pi.ClientRequestInfoImpl;
import com.ibm.rmi.pi.CurrentImpl;
import com.ibm.rmi.pi.IORInfoImpl;
import com.ibm.rmi.pi.ORBInitInfoImpl;
import com.ibm.rmi.pi.ServerRequestInfoImpl;
import com.ibm.rmi.poa.POAImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorManager {
    private ORB orb;
    private boolean localClientInterceptors = false;
    private boolean localServerInterceptors = false;
    private PMIPlugin pmiServer;
    public static final int STATE_NOTHING = 0;
    public static final int STATE_PRE_INIT = 1;
    public static final int STATE_POST_INIT = 2;
    public static final int STATE_SEND_REQUEST = 3;
    public static final int STATE_SEND_POLL = 4;
    public static final int STATE_RECEIVE_REPLY = 5;
    public static final int STATE_RECEIVE_EXCEPTION = 6;
    public static final int STATE_RECEIVE_OTHER = 7;
    public static final int STATE_RECEIVE_CONTEXT = 8;
    public static final int STATE_RECEIVE_REQUEST = 9;
    public static final int STATE_SEND_REPLY = 10;
    public static final int STATE_SEND_EXCEPTION = 11;
    public static final int STATE_SEND_OTHER = 12;
    private ORBInitInfoImpl orbInitInfo = null;
    private List clientList = new ArrayList();
    private List clientLocalInfo = new ArrayList();
    private Set clientNames = new HashSet();
    private List serverList = new ArrayList();
    private List serverLocalInfo = new ArrayList();
    private Set serverNames = new HashSet();
    private List iorList = new ArrayList();
    private Set iorNames = new HashSet();
    private ClientRequestInterceptor[] clientInterceptors = null;
    private boolean[] clientInterceptorsLocalInfo = null;
    private ServerRequestInterceptor[] serverInterceptors = null;
    private boolean[] serverInterceptorsLocalInfo = null;
    private IORInterceptor[] iorInterceptors = null;
    private CurrentImpl piCurrent;
    private int maxSlotId = 0;

    public InterceptorManager(ORB oRB) {
        this.orb = oRB;
    }

    public void pmiInit() {
        if (this.orb != null) {
            this.pmiServer = this.orb.getPMIServer();
        }
    }

    public List runPreInit(List list) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "runPreInit:141");
        }
        this.pmiInit();
        ArrayList<ORBInitializer> arrayList = new ArrayList<ORBInitializer>();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            try {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "runPreInit:153", "Run initializer: " + string);
                }
                Class clazz = Util.loadClass((String)string, null, null);
                ORBInitializer oRBInitializer = (ORBInitializer)clazz.newInstance();
                oRBInitializer.pre_init(this.getORBInitInfo(1));
                arrayList.add(oRBInitializer);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!ORBRas.isTrcLogging) continue;
                ORBRas.orbTrcLogger.trace(4104L, this, "runPreInit:163", classNotFoundException.toString());
                continue;
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "runPreInit:170", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "runPreInit:177");
        }
        return arrayList;
    }

    public void runPostInit(List list) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "runPostInit:186");
        }
        for (int i = 0; i < list.size(); ++i) {
            ORBInitializer oRBInitializer = (ORBInitializer)list.get(i);
            try {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "runPostInit:194", "Run initializer: " + oRBInitializer.getClass().getName());
                }
                oRBInitializer.post_init(this.getORBInitInfo(2));
                continue;
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "runPostInit:202", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "runPostInit:209");
        }
    }

    private ORBInitInfo getORBInitInfo(int n) {
        if (this.orbInitInfo == null) {
            this.orbInitInfo = new ORBInitInfoImpl(this.orb, this);
        }
        this.orbInitInfo.setState(n);
        return this.orbInitInfo;
    }

    public void addClientInterceptor(ClientRequestInterceptor clientRequestInterceptor, boolean bl, boolean bl2) throws DuplicateName {
        this.addInterceptor((Interceptor)clientRequestInterceptor, bl, this.clientList, this.clientLocalInfo, this.clientNames, bl2);
    }

    public void addServerInterceptor(ServerRequestInterceptor serverRequestInterceptor, boolean bl, boolean bl2) throws DuplicateName {
        this.addInterceptor((Interceptor)serverRequestInterceptor, bl, this.serverList, this.serverLocalInfo, this.serverNames, bl2);
    }

    public void addIORInterceptor(IORInterceptor iORInterceptor, boolean bl) throws DuplicateName {
        this.addInterceptor((Interceptor)iORInterceptor, bl, this.iorList, null, this.iorNames, false);
    }

    private void addInterceptor(Interceptor interceptor, boolean bl, List list, List list2, Set set, boolean bl2) throws DuplicateName {
        String string = interceptor.name();
        if (string == null) {
            throw new BAD_PARAM("Interceptor name is null", 1229124118, CompletionStatus.COMPLETED_NO);
        }
        if (!string.equals("")) {
            if (set.contains(string)) {
                throw new DuplicateName(string);
            }
            set.add(string);
        }
        if (bl) {
            list.add(0, interceptor);
            if (this.pmiServer != null) {
                this.pmiServer.onInterceptorRegister(interceptor);
            }
            if (list2 != null) {
                list2.add(0, new Boolean(bl2));
            }
        } else {
            list.add(interceptor);
            if (this.pmiServer != null) {
                this.pmiServer.onInterceptorRegister(interceptor);
            }
            if (list2 != null) {
                list2.add(new Boolean(bl2));
            }
        }
    }

    public void initComplete(CurrentImpl currentImpl) {
        boolean bl;
        int n;
        this.clientInterceptors = new ClientRequestInterceptor[this.clientList.size()];
        this.clientInterceptors = this.clientList.toArray(this.clientInterceptors);
        this.clientInterceptorsLocalInfo = new boolean[this.clientLocalInfo.size()];
        for (n = 0; n < this.clientLocalInfo.size(); ++n) {
            this.clientInterceptorsLocalInfo[n] = bl = ((Boolean)this.clientLocalInfo.get(n)).booleanValue();
            if (!bl) continue;
            this.localClientInterceptors = true;
        }
        this.serverInterceptors = new ServerRequestInterceptor[this.serverList.size()];
        this.serverInterceptors = this.serverList.toArray(this.serverInterceptors);
        this.serverInterceptorsLocalInfo = new boolean[this.serverLocalInfo.size()];
        for (n = 0; n < this.serverLocalInfo.size(); ++n) {
            this.serverInterceptorsLocalInfo[n] = bl = ((Boolean)this.serverLocalInfo.get(n)).booleanValue();
            if (!bl) continue;
            this.localServerInterceptors = true;
        }
        this.iorInterceptors = new IORInterceptor[this.iorList.size()];
        this.iorInterceptors = this.iorList.toArray(this.iorInterceptors);
        this.iorList = null;
        this.serverList = null;
        this.clientList = null;
        this.iorNames = null;
        this.serverNames = null;
        this.clientNames = null;
        this.serverLocalInfo = null;
        this.clientLocalInfo = null;
        this.piCurrent = currentImpl;
        this.piCurrent.setSlotCount(this.maxSlotId);
    }

    public boolean haveClientInterceptors() {
        return this.clientInterceptors != null && this.clientInterceptors.length > 0;
    }

    public boolean haveServerInterceptors() {
        return this.serverInterceptors != null && this.serverInterceptors.length > 0;
    }

    public boolean haveIORInterceptors() {
        return this.iorInterceptors != null && this.iorInterceptors.length > 0;
    }

    public boolean haveLocalClientInterceptors() {
        return this.localClientInterceptors && !this.orb.noLocalInterceptors();
    }

    public boolean haveLocalServerInterceptors() {
        return this.localServerInterceptors && !this.orb.noLocalInterceptors();
    }

    public void iterateSendRequest(ClientRequestInfoImpl clientRequestInfoImpl) throws ForwardRequest, Throwable {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateSendRequest:376");
        }
        int n = 0;
        clientRequestInfoImpl.setState(3);
        clientRequestInfoImpl.setRecursionDepth(this.piCurrent.depth());
        try {
            this.piCurrent.push();
            for (n = 0; n < this.clientInterceptors.length; ++n) {
                if (!clientRequestInfoImpl.notLocal() && (this.orb.noLocalInterceptors() || !this.clientInterceptorsLocalInfo[n])) continue;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateSendRequest:389", "Run interceptor: " + this.clientInterceptors[n]);
                }
                if (this.pmiServer != null) {
                    long l = System.currentTimeMillis();
                    this.clientInterceptors[n].send_request((ClientRequestInfo)clientRequestInfoImpl);
                    long l2 = System.currentTimeMillis();
                    this.pmiServer.postInterceptorRun((Interceptor)this.clientInterceptors[n], l2 - l);
                    continue;
                }
                this.clientInterceptors[n].send_request((ClientRequestInfo)clientRequestInfoImpl);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof ForwardRequest) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateSendRequest:417", throwable.toString());
                }
            } else if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateSendRequest:422", (Exception)throwable);
            } else {
                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "iterateSendRequest:426", throwable.toString(), (java.lang.Object)throwable);
            }
            throw throwable;
        }
        finally {
            this.piCurrent.pop();
            clientRequestInfoImpl.setLastIndex(n - 1);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateSendRequest:438");
        }
    }

    public void iterateReceiveReply(ClientRequestInfoImpl clientRequestInfoImpl) throws Throwable {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateReceiveReply:446");
        }
        int n = 0;
        clientRequestInfoImpl.setState(5);
        try {
            this.piCurrent.push();
            for (n = clientRequestInfoImpl.getLastIndex(); n >= 0; --n) {
                if (!clientRequestInfoImpl.notLocal() && (this.orb.noLocalInterceptors() || !this.clientInterceptorsLocalInfo[n])) continue;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateReceiveReply:458", "Run interceptor: " + this.clientInterceptors[n]);
                }
                if (this.pmiServer != null) {
                    long l = System.currentTimeMillis();
                    this.clientInterceptors[n].receive_reply((ClientRequestInfo)clientRequestInfoImpl);
                    long l2 = System.currentTimeMillis();
                    this.pmiServer.postInterceptorRun((Interceptor)this.clientInterceptors[n], l2 - l);
                    continue;
                }
                this.clientInterceptors[n].receive_reply((ClientRequestInfo)clientRequestInfoImpl);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateReceiveReply:484", (Exception)throwable);
            } else {
                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "iterateReceiveReply:488", throwable.toString(), (java.lang.Object)throwable);
            }
            throw throwable;
        }
        finally {
            this.piCurrent.pop();
            clientRequestInfoImpl.setLastIndex(n - 1);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateReceiveReply:499");
        }
    }

    public void iterateReceiveException(ClientRequestInfoImpl clientRequestInfoImpl) throws ForwardRequest, Throwable {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateReceiveException:507");
        }
        int n = 0;
        clientRequestInfoImpl.setState(6);
        try {
            this.piCurrent.push();
            for (n = clientRequestInfoImpl.getLastIndex(); n >= 0; --n) {
                if (!clientRequestInfoImpl.notLocal() && (this.orb.noLocalInterceptors() || !this.clientInterceptorsLocalInfo[n])) continue;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateReceiveException:519", "Run interceptor: " + this.clientInterceptors[n]);
                }
                if (this.pmiServer != null) {
                    long l = System.currentTimeMillis();
                    this.clientInterceptors[n].receive_exception((ClientRequestInfo)clientRequestInfoImpl);
                    long l2 = System.currentTimeMillis();
                    this.pmiServer.postInterceptorRun((Interceptor)this.clientInterceptors[n], l2 - l);
                    continue;
                }
                this.clientInterceptors[n].receive_exception((ClientRequestInfo)clientRequestInfoImpl);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof ForwardRequest) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateReceiveException:547", throwable.toString());
                }
            } else if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateReceiveException:552", (Exception)throwable);
            } else {
                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "iterateReceiveException:556", throwable.toString(), (java.lang.Object)throwable);
            }
            throw throwable;
        }
        finally {
            this.piCurrent.pop();
            clientRequestInfoImpl.setLastIndex(n - 1);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateReceiveException:568");
        }
    }

    public void iterateReceiveOther(ClientRequestInfoImpl clientRequestInfoImpl) throws ForwardRequest, Throwable {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateReceiveOther:576");
        }
        int n = 0;
        clientRequestInfoImpl.setState(7);
        try {
            this.piCurrent.push();
            for (n = clientRequestInfoImpl.getLastIndex(); n >= 0; --n) {
                if (!clientRequestInfoImpl.notLocal() && (this.orb.noLocalInterceptors() || !this.clientInterceptorsLocalInfo[n])) continue;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateReceiveOther:588", "Run interceptor: " + this.clientInterceptors[n]);
                }
                if (this.pmiServer != null) {
                    long l = System.currentTimeMillis();
                    this.clientInterceptors[n].receive_other((ClientRequestInfo)clientRequestInfoImpl);
                    long l2 = System.currentTimeMillis();
                    this.pmiServer.postInterceptorRun((Interceptor)this.clientInterceptors[n], l2 - l);
                    continue;
                }
                this.clientInterceptors[n].receive_other((ClientRequestInfo)clientRequestInfoImpl);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof ForwardRequest) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateReceiveOther:616", throwable.toString());
                }
            } else if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateReceiveOther:621", (Exception)throwable);
            } else {
                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "iterateReceiveOther:625", throwable.toString(), (java.lang.Object)throwable);
            }
            throw throwable;
        }
        finally {
            this.piCurrent.pop();
            clientRequestInfoImpl.setLastIndex(n - 1);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateReceiveOther:637");
        }
    }

    public void iterateReceiveContext(ServerRequestInfoImpl serverRequestInfoImpl) throws ForwardRequest, Throwable {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateReceiveContext:650");
        }
        int n = 0;
        serverRequestInfoImpl.setState(8);
        try {
            this.piCurrent.push();
            for (n = 0; n < this.serverInterceptors.length; ++n) {
                if (!serverRequestInfoImpl.notLocal() && (this.orb.noLocalInterceptors() || !this.serverInterceptorsLocalInfo[n])) continue;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateReceiveContext:662", "Run interceptor: " + this.serverInterceptors[n]);
                }
                if (this.pmiServer != null) {
                    long l = System.currentTimeMillis();
                    this.serverInterceptors[n].receive_request_service_contexts((ServerRequestInfo)serverRequestInfoImpl);
                    long l2 = System.currentTimeMillis();
                    this.pmiServer.postInterceptorRun((Interceptor)this.serverInterceptors[n], l2 - l);
                    continue;
                }
                this.serverInterceptors[n].receive_request_service_contexts((ServerRequestInfo)serverRequestInfoImpl);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof ForwardRequest) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateReceiveContext:690", throwable.toString());
                }
            } else if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateReceiveContext:695", (Exception)throwable);
            } else {
                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "iterateReceiveContext:699", throwable.toString(), (java.lang.Object)throwable);
            }
            throw throwable;
        }
        finally {
            this.piCurrent.pop();
            serverRequestInfoImpl.setLastIndex(n - 1);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateReceiveContext:711");
        }
    }

    public void iterateReceiveRequest(ServerRequestInfoImpl serverRequestInfoImpl) throws ForwardRequest, Throwable {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateReceiveRequest:719");
        }
        int n = 0;
        serverRequestInfoImpl.setState(9);
        try {
            for (n = 0; n <= serverRequestInfoImpl.getLastIndex(); ++n) {
                if (!serverRequestInfoImpl.notLocal() && (this.orb.noLocalInterceptors() || !this.serverInterceptorsLocalInfo[n])) continue;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateReceiveRequest:733", "Run interceptor: " + this.serverInterceptors[n]);
                }
                if (this.pmiServer != null) {
                    long l = System.currentTimeMillis();
                    this.serverInterceptors[n].receive_request((ServerRequestInfo)serverRequestInfoImpl);
                    long l2 = System.currentTimeMillis();
                    this.pmiServer.postInterceptorRun((Interceptor)this.serverInterceptors[n], l2 - l);
                    continue;
                }
                this.serverInterceptors[n].receive_request((ServerRequestInfo)serverRequestInfoImpl);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof ForwardRequest) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateReceiveRequest:761", throwable.toString());
                }
            } else if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateReceiveRequest:766", (Exception)throwable);
            } else {
                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "iterateReceiveRequest:770", throwable.toString(), (java.lang.Object)throwable);
            }
            throw throwable;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateReceiveRequest:778");
        }
    }

    public void iterateSendReply(ServerRequestInfoImpl serverRequestInfoImpl) throws Throwable {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateSendReply:786");
        }
        int n = 0;
        serverRequestInfoImpl.setState(10);
        try {
            for (n = serverRequestInfoImpl.getLastIndex(); n >= 0; --n) {
                if (!serverRequestInfoImpl.notLocal() && (this.orb.noLocalInterceptors() || !this.serverInterceptorsLocalInfo[n])) continue;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateSendReply:798", "Run interceptor: " + this.serverInterceptors[n]);
                }
                if (this.pmiServer != null) {
                    long l = System.currentTimeMillis();
                    this.serverInterceptors[n].send_reply((ServerRequestInfo)serverRequestInfoImpl);
                    long l2 = System.currentTimeMillis();
                    this.pmiServer.postInterceptorRun((Interceptor)this.serverInterceptors[n], l2 - l);
                    continue;
                }
                this.serverInterceptors[n].send_reply((ServerRequestInfo)serverRequestInfoImpl);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateSendReply:824", (Exception)throwable);
            } else {
                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "iterateSendReply:828", throwable.toString(), (java.lang.Object)throwable);
            }
            throw throwable;
        }
        finally {
            serverRequestInfoImpl.setLastIndex(n - 1);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateSendReply:838");
        }
    }

    public void iterateSendException(ServerRequestInfoImpl serverRequestInfoImpl) throws ForwardRequest, Throwable {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateSendException:846");
        }
        int n = 0;
        serverRequestInfoImpl.setState(11);
        try {
            for (n = serverRequestInfoImpl.getLastIndex(); n >= 0; --n) {
                if (!serverRequestInfoImpl.notLocal() && (this.orb.noLocalInterceptors() || !this.serverInterceptorsLocalInfo[n])) continue;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateSendException:857", "Run interceptor: " + this.serverInterceptors[n]);
                }
                if (this.pmiServer != null) {
                    long l = System.currentTimeMillis();
                    this.serverInterceptors[n].send_exception((ServerRequestInfo)serverRequestInfoImpl);
                    long l2 = System.currentTimeMillis();
                    this.pmiServer.postInterceptorRun((Interceptor)this.serverInterceptors[n], l2 - l);
                    continue;
                }
                this.serverInterceptors[n].send_exception((ServerRequestInfo)serverRequestInfoImpl);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof ForwardRequest) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateSendException:885", throwable.toString());
                }
            } else if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateSendException:890", (Exception)throwable);
            } else {
                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "iterateSendException:894", throwable.toString(), (java.lang.Object)throwable);
            }
            throw throwable;
        }
        finally {
            serverRequestInfoImpl.setLastIndex(n - 1);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateSendException:905");
        }
    }

    public void iterateSendOther(ServerRequestInfoImpl serverRequestInfoImpl) throws ForwardRequest, Throwable {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateSendOther:913");
        }
        int n = 0;
        serverRequestInfoImpl.setState(12);
        try {
            for (n = serverRequestInfoImpl.getLastIndex(); n >= 0; --n) {
                if (!serverRequestInfoImpl.notLocal() && (this.orb.noLocalInterceptors() || !this.serverInterceptorsLocalInfo[n])) continue;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateSendOther:924", "Run interceptor: " + this.serverInterceptors[n]);
                }
                if (this.pmiServer != null) {
                    long l = System.currentTimeMillis();
                    this.serverInterceptors[n].send_other((ServerRequestInfo)serverRequestInfoImpl);
                    long l2 = System.currentTimeMillis();
                    this.pmiServer.postInterceptorRun((Interceptor)this.serverInterceptors[n], l2 - l);
                    continue;
                }
                this.serverInterceptors[n].send_other((ServerRequestInfo)serverRequestInfoImpl);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof ForwardRequest) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateSendOther:952", throwable.toString());
                }
            } else if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateSendOther:957", (Exception)throwable);
            } else {
                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "iterateSendOther:961", throwable.toString(), (java.lang.Object)throwable);
            }
            throw throwable;
        }
        finally {
            serverRequestInfoImpl.setLastIndex(n - 1);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateSendOther:972");
        }
    }

    public void iterateEstablishComponents(IORInfoImpl iORInfoImpl) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateEstablishComponents:980");
        }
        try {
            for (int i = 0; i < this.iorInterceptors.length; ++i) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateEstablishComponents:987", "Run interceptor: " + this.iorInterceptors[i]);
                }
                if (this.pmiServer != null) {
                    long l = System.currentTimeMillis();
                    this.iorInterceptors[i].establish_components((IORInfo)iORInfoImpl);
                    long l2 = System.currentTimeMillis();
                    this.pmiServer.postInterceptorRun((Interceptor)this.iorInterceptors[i], l2 - l);
                    continue;
                }
                this.iorInterceptors[i].establish_components((IORInfo)iORInfoImpl);
            }
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "iterateEstablishComponents:1009", exception);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateEstablishComponents:1015");
        }
    }

    public ClientRequestInfoImpl createClientInfo(com.ibm.CORBA.iiop.Request request, RequestMessage requestMessage, ClientDelegate clientDelegate, Object object, Request request2, java.lang.Object object2, boolean bl) {
        ClientRequestInfoImpl clientRequestInfoImpl = new ClientRequestInfoImpl(this.orb, request, requestMessage, clientDelegate, object, object2, bl);
        if (request2 != null) {
            clientRequestInfoImpl.setParameters(request2);
        }
        clientRequestInfoImpl.setRequestCurrent(this.piCurrent.peek());
        return clientRequestInfoImpl;
    }

    public ServerRequestInfoImpl createServerInfo(com.ibm.CORBA.iiop.Request request, RequestMessage requestMessage, java.lang.Object object, boolean bl) {
        ServerRequestInfoImpl serverRequestInfoImpl = new ServerRequestInfoImpl(this.orb, request, requestMessage, object, bl);
        serverRequestInfoImpl.setRequestCurrent(this.piCurrent.empty());
        return serverRequestInfoImpl;
    }

    public IORInfoImpl createIORInfo(Profile profile, java.lang.Object object, POAImpl pOAImpl) {
        IORInfoImpl iORInfoImpl = new IORInfoImpl(this.orb, profile, object, pOAImpl);
        return iORInfoImpl;
    }

    public void setThreadCurrent(Any[] anyArray) {
        this.piCurrent.set(anyArray);
    }

    public int getNextSlotId() {
        return this.maxSlotId++;
    }

    public CurrentImpl getPICurrent() {
        return this.piCurrent;
    }

    public Interceptor[] getInterceptors() {
        int n;
        int n2 = this.clientInterceptors == null ? 0 : this.clientInterceptors.length;
        n2 += this.serverInterceptors == null ? 0 : this.serverInterceptors.length;
        Interceptor[] interceptorArray = new Interceptor[n2 += this.iorInterceptors == null ? 0 : this.iorInterceptors.length];
        int n3 = 0;
        if (this.clientInterceptors != null) {
            for (n = 0; n < this.clientInterceptors.length; ++n) {
                interceptorArray[n3] = this.clientInterceptors[n];
                ++n3;
            }
        }
        if (this.serverInterceptors != null) {
            for (n = 0; n < this.serverInterceptors.length; ++n) {
                interceptorArray[n3] = this.serverInterceptors[n];
                ++n3;
            }
        }
        if (this.iorInterceptors != null) {
            for (n = 0; n < this.iorInterceptors.length; ++n) {
                interceptorArray[n3] = this.iorInterceptors[n];
                ++n3;
            }
        }
        return interceptorArray;
    }
}

