/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsClient;
import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.ResourceRecord;
import com.sun.jndi.dns.ResourceRecords;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

class Resolver {
    private DnsClient dnsClient;
    private int timeout;
    private int retries;

    Resolver(String[] stringArray, int n, int n2) throws NamingException {
        this.timeout = n;
        this.retries = n2;
        this.dnsClient = new DnsClient(stringArray, n, n2);
    }

    public void close() {
        this.dnsClient.close();
    }

    ResourceRecords query(DnsName dnsName, int n, int n2, boolean bl, boolean bl2) throws NamingException {
        return this.dnsClient.query(dnsName, n, n2, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords queryZone(DnsName dnsName, int n, boolean bl) throws NamingException {
        DnsClient dnsClient = new DnsClient(this.findNameServers(dnsName, bl), this.timeout, this.retries);
        try {
            ResourceRecords resourceRecords = dnsClient.queryZone(dnsName, n, bl);
            Object var7_6 = null;
            dnsClient.close();
            return resourceRecords;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            dnsClient.close();
            throw throwable;
        }
    }

    DnsName findZoneName(DnsName dnsName, int n, boolean bl) throws NamingException {
        dnsName = (DnsName)dnsName.clone();
        while (dnsName.size() > 1) {
            ResourceRecords resourceRecords = null;
            try {
                resourceRecords = this.query(dnsName, n, 6, bl, false);
            }
            catch (NameNotFoundException nameNotFoundException) {
                throw nameNotFoundException;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (resourceRecords != null) {
                if (resourceRecords.answer.size() > 0) {
                    return dnsName;
                }
                int n2 = 0;
                while (n2 < resourceRecords.authority.size()) {
                    DnsName dnsName2;
                    ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.authority.elementAt(n2);
                    if (resourceRecord.getType() == 6 && dnsName.endsWith(dnsName2 = resourceRecord.getName())) {
                        return dnsName2;
                    }
                    ++n2;
                }
            }
            dnsName.remove(dnsName.size() - 1);
        }
        return dnsName;
    }

    ResourceRecord findSoa(DnsName dnsName, int n, boolean bl) throws NamingException {
        ResourceRecords resourceRecords = this.query(dnsName, n, 6, bl, false);
        int n2 = 0;
        while (n2 < resourceRecords.answer.size()) {
            ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.answer.elementAt(n2);
            if (resourceRecord.getType() == 6) {
                return resourceRecord;
            }
            ++n2;
        }
        return null;
    }

    private String[] findNameServers(DnsName dnsName, boolean bl) throws NamingException {
        ResourceRecords resourceRecords = this.query(dnsName, 1, 2, bl, false);
        String[] stringArray = new String[resourceRecords.answer.size()];
        int n = 0;
        while (n < stringArray.length) {
            ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.answer.elementAt(n);
            if (resourceRecord.getType() != 2) {
                throw new CommunicationException("Corrupted DNS message");
            }
            stringArray[n] = (String)resourceRecord.getRdata();
            stringArray[n] = stringArray[n].substring(0, stringArray[n].length() - 1);
            ++n;
        }
        return stringArray;
    }
}

