/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.Header;
import com.sun.jndi.dns.Packet;
import com.sun.jndi.dns.ResourceRecords;
import com.sun.jndi.dns.Tcp;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;

public class DnsClient {
    private static final int IDENT_OFFSET = 0;
    private static final int FLAGS_OFFSET = 2;
    private static final int NUMQ_OFFSET = 4;
    private static final int NUMANS_OFFSET = 6;
    private static final int NUMAUTH_OFFSET = 8;
    private static final int NUMADD_OFFSET = 10;
    private static final int DNS_HDR_SIZE = 12;
    private static final int NO_ERROR = 0;
    private static final int FORMAT_ERROR = 1;
    private static final int SERVER_FAILURE = 2;
    private static final int NAME_ERROR = 3;
    private static final int NOT_IMPL = 4;
    private static final int REFUSED = 5;
    private static final String[] rcodeDescription = new String[]{"No error", "DNS format error", "DNS server failure", "DNS name not found", "DNS operation not supported", "DNS service refused"};
    private static final int DEFAULT_PORT = 53;
    private InetAddress[] servers;
    private int[] serverPorts;
    private int timeout;
    private int retries;
    private DatagramSocket udpSocket;
    private short ident = 0;
    private Object identLock = new Object();

    public DnsClient(String[] stringArray, int n, int n2) throws NamingException {
        this.timeout = n;
        this.retries = n2;
        try {
            this.udpSocket = new DatagramSocket();
        }
        catch (SocketException socketException) {
            ConfigurationException configurationException = new ConfigurationException();
            configurationException.setRootCause(socketException);
            throw configurationException;
        }
        this.servers = new InetAddress[stringArray.length];
        this.serverPorts = new int[stringArray.length];
        int n3 = 0;
        while (n3 < stringArray.length) {
            int n4 = stringArray[n3].indexOf(58, stringArray[n3].indexOf(93) + 1);
            this.serverPorts[n3] = n4 < 0 ? 53 : Integer.parseInt(stringArray[n3].substring(n4 + 1));
            String string = n4 < 0 ? stringArray[n3] : stringArray[n3].substring(0, n4);
            try {
                this.servers[n3] = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                ConfigurationException configurationException = new ConfigurationException("Unknown DNS server: " + string);
                configurationException.setRootCause(unknownHostException);
                throw configurationException;
            }
            ++n3;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        this.udpSocket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords query(DnsName dnsName, int n, int n2, boolean bl, boolean bl2) throws NamingException {
        short s;
        Object object = this.identLock;
        synchronized (object) {
            s = this.ident = (short)(this.ident + 1);
        }
        Packet packet = this.makeQueryPacket(dnsName, s, n, n2, bl);
        Exception exception = null;
        boolean[] blArray = new boolean[this.servers.length];
        int n3 = 0;
        while (n3 < this.retries) {
            int n4 = 0;
            while (n4 < this.servers.length) {
                block25: {
                    if (!blArray[n4]) {
                        try {
                            DatagramPacket datagramPacket = this.doUdpQuery(packet, this.servers[n4], this.serverPorts[n4], n3);
                            byte[] byArray = datagramPacket.getData();
                            int n5 = datagramPacket.getLength();
                            Header header = new Header(byArray, n5);
                            this.checkHeader(header, s);
                            if (bl2 && !header.authoritative) {
                                exception = new NameNotFoundException("DNS response not authoritative");
                                blArray[n4] = true;
                                break block25;
                            }
                            if (header.truncated) {
                                int n6 = 0;
                                while (n6 < this.servers.length) {
                                    int n7 = (n4 + n6) % this.servers.length;
                                    if (!blArray[n7]) {
                                        try {
                                            Object var22_30;
                                            byte[] byArray2;
                                            Tcp tcp = new Tcp(this.servers[n7], this.serverPorts[n7]);
                                            try {
                                                byArray2 = this.doTcpQuery(tcp, packet);
                                                var22_30 = null;
                                            }
                                            catch (Throwable throwable) {
                                                var22_30 = null;
                                                tcp.close();
                                                throw throwable;
                                            }
                                            tcp.close();
                                            Header header2 = new Header(byArray2, byArray2.length);
                                            this.checkHeader(header2, s);
                                            if (!bl2 || header2.authoritative) {
                                                header = header2;
                                                byArray = byArray2;
                                                n5 = byArray2.length;
                                                break;
                                            }
                                            blArray[n7] = true;
                                        }
                                        catch (Exception exception2) {
                                            // empty catch block
                                        }
                                    }
                                    ++n6;
                                }
                            }
                            return new ResourceRecords(byArray, n5, header, false);
                        }
                        catch (IOException iOException) {
                            if (exception == null) {
                                exception = iOException;
                            }
                            if (iOException.getClass().getName().equals("java.net.PortUnreachableException")) {
                                blArray[n4] = true;
                            }
                        }
                        catch (NameNotFoundException nameNotFoundException) {
                            throw nameNotFoundException;
                        }
                        catch (CommunicationException communicationException) {
                            if (exception == null) {
                                exception = communicationException;
                            }
                        }
                        catch (NamingException namingException) {
                            if (exception == null) {
                                exception = namingException;
                            }
                            blArray[n4] = true;
                        }
                    }
                }
                ++n4;
            }
            ++n3;
        }
        if (exception instanceof NamingException) {
            throw (NamingException)exception;
        }
        CommunicationException communicationException = new CommunicationException("DNS error");
        communicationException.setRootCause(exception);
        throw communicationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ResourceRecords queryZone(DnsName dnsName, int n, boolean bl) throws NamingException {
        short s;
        Object object = this.identLock;
        synchronized (object) {
            s = this.ident = (short)(this.ident + 1);
        }
        Packet packet = this.makeQueryPacket(dnsName, s, n, 252, bl);
        Exception exception = null;
        int n2 = 0;
        while (true) {
            if (n2 >= this.servers.length) {
                if (!(exception instanceof NamingException)) break;
                throw (NamingException)exception;
            }
            try {
                ResourceRecords resourceRecords;
                Tcp tcp = new Tcp(this.servers[n2], this.serverPorts[n2]);
                try {
                    byte[] byArray = this.doTcpQuery(tcp, packet);
                    Header header = new Header(byArray, byArray.length);
                    this.checkResponseCode(header);
                    ResourceRecords resourceRecords2 = new ResourceRecords(byArray, byArray.length, header, true);
                    if (resourceRecords2.getFirstAnsType() != 6) {
                        throw new CommunicationException("DNS error: zone xfer doesn't begin with SOA");
                    }
                    if (resourceRecords2.answer.size() == 1 || resourceRecords2.getLastAnsType() != 6) {
                        do {
                            if ((byArray = this.continueTcpQuery(tcp)) == null) {
                                throw new CommunicationException("DNS error: incomplete zone transfer");
                            }
                            header = new Header(byArray, byArray.length);
                            this.checkResponseCode(header);
                            resourceRecords2.add(byArray, byArray.length, header);
                        } while (resourceRecords2.getLastAnsType() != 6);
                    }
                    resourceRecords2.answer.removeElementAt(resourceRecords2.answer.size() - 1);
                    resourceRecords = resourceRecords2;
                    Object var15_18 = null;
                }
                catch (Throwable throwable) {
                    Object var15_19 = null;
                    tcp.close();
                    throw throwable;
                }
                tcp.close();
                return resourceRecords;
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (NameNotFoundException nameNotFoundException) {
                throw nameNotFoundException;
            }
            catch (NamingException namingException) {
                exception = namingException;
            }
            ++n2;
        }
        CommunicationException communicationException = new CommunicationException("DNS error during zone transfer");
        communicationException.setRootCause(exception);
        throw communicationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatagramPacket doUdpQuery(Packet packet, InetAddress inetAddress, int n, int n2) throws IOException {
        DatagramSocket datagramSocket = this.udpSocket;
        synchronized (datagramSocket) {
            DatagramPacket datagramPacket = new DatagramPacket(packet.getData(), packet.length(), inetAddress, n);
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[8000], 8000);
            this.udpSocket.connect(inetAddress, n);
            try {
                this.udpSocket.send(datagramPacket);
                this.udpSocket.setSoTimeout(this.timeout * (1 << n2));
                this.udpSocket.receive(datagramPacket2);
                Object var9_8 = null;
                this.udpSocket.disconnect();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.udpSocket.disconnect();
                throw throwable;
            }
            return datagramPacket2;
        }
    }

    private byte[] doTcpQuery(Tcp tcp, Packet packet) throws IOException {
        int n = packet.length();
        tcp.out.write(n >> 8);
        tcp.out.write(n);
        tcp.out.write(packet.getData(), 0, n);
        tcp.out.flush();
        byte[] byArray = this.continueTcpQuery(tcp);
        if (byArray == null) {
            throw new IOException("DNS error: no response");
        }
        return byArray;
    }

    private byte[] continueTcpQuery(Tcp tcp) throws IOException {
        int n = tcp.in.read();
        if (n == -1) {
            return null;
        }
        int n2 = tcp.in.read();
        if (n2 == -1) {
            throw new IOException("Corrupted DNS response: bad length");
        }
        int n3 = n << 8 | n2;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n3 > 0) {
            int n5 = tcp.in.read(byArray, n4, n3);
            if (n5 == -1) {
                throw new IOException("Corrupted DNS response: too little data");
            }
            n3 -= n5;
            n4 += n5;
        }
        return byArray;
    }

    private Packet makeQueryPacket(DnsName dnsName, int n, int n2, int n3, boolean bl) {
        short s = dnsName.getOctets();
        int n4 = 12 + s + 4;
        Packet packet = new Packet(n4);
        int n5 = bl ? 256 : 0;
        packet.putShort(n, 0);
        packet.putShort(n5, 2);
        packet.putShort(1, 4);
        packet.putShort(0, 6);
        packet.putInt(0, 8);
        this.makeQueryName(dnsName, packet, 12);
        packet.putShort(n3, 12 + s);
        packet.putShort(n2, 12 + s + 2);
        return packet;
    }

    private void makeQueryName(DnsName dnsName, Packet packet, int n) {
        int n2 = dnsName.size() - 1;
        while (n2 >= 0) {
            String string = dnsName.get(n2);
            int n3 = string.length();
            packet.putByte(n3, n++);
            int n4 = 0;
            while (n4 < n3) {
                packet.putByte(string.charAt(n4), n++);
                ++n4;
            }
            --n2;
        }
        if (!dnsName.hasRootLabel()) {
            packet.putByte(0, n);
        }
    }

    private void checkHeader(Header header, int n) throws NamingException {
        if (n != -1 && n != header.xid) {
            throw new CommunicationException("DNS error: ID doesn't match");
        }
        if (header.query) {
            throw new CommunicationException("DNS error: expecting response");
        }
        this.checkResponseCode(header);
    }

    private void checkResponseCode(Header header) throws NamingException {
        int n = header.rcode;
        if (n == 0) {
            return;
        }
        String string = n < rcodeDescription.length ? rcodeDescription[n] : "DNS error";
        string = string + " [response code " + n + "]";
        switch (n) {
            case 2: {
                throw new ServiceUnavailableException(string);
            }
            case 3: {
                throw new NameNotFoundException(string);
            }
            case 4: 
            case 5: {
                throw new OperationNotSupportedException(string);
            }
        }
        throw new NamingException(string);
    }
}

