/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CRLNumberExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.security.cert.CRLSelector;
import javax.security.cert.CertPathValidatorException;

public class X509CRLSelector
implements CRLSelector {
    private Collection issuerNames;
    private Collection issuerNamesFromApp;
    private BigInteger minCRLNumber;
    private BigInteger maxCRLNumber;
    private Date dateAndTime;
    private X509Certificate certificate;

    public void setIssuerNames(Collection collection) throws IOException {
        if (collection != null && collection.size() > 0) {
            this.issuerNames = new ArrayList();
            this.issuerNamesFromApp = new ArrayList();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof byte[]) {
                    this.addIssuerName((byte[])e);
                    continue;
                }
                if (e instanceof String) {
                    this.addIssuerName((String)e);
                    continue;
                }
                throw new IOException("name not byte array or String");
            }
        } else {
            this.issuerNames = null;
            this.issuerNamesFromApp = null;
        }
    }

    public void addIssuerName(String string) throws IOException {
        if (string == null) {
            throw new IOException("Name is null");
        }
        if (this.issuerNames == null) {
            this.issuerNames = new ArrayList();
            this.issuerNamesFromApp = new ArrayList();
        }
        this.issuerNames.add(new X500Name(string));
        this.issuerNamesFromApp.add(string);
    }

    public void addIssuerName(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IOException("Name is null");
        }
        byte[] byArray2 = (byte[])byArray.clone();
        if (this.issuerNames == null) {
            this.issuerNames = new ArrayList();
            this.issuerNamesFromApp = new ArrayList();
        }
        this.issuerNames.add(new X500Name(byArray2));
        this.issuerNamesFromApp.add(byArray2);
    }

    public void setMinCRLNumber(BigInteger bigInteger) {
        this.minCRLNumber = bigInteger != null ? new BigInteger(bigInteger.toByteArray()) : null;
    }

    public void setMaxCRLNumber(BigInteger bigInteger) {
        this.maxCRLNumber = bigInteger != null ? new BigInteger(bigInteger.toByteArray()) : null;
    }

    public void setDateAndTime(Date date) {
        this.dateAndTime = date != null ? new Date(date.getTime()) : null;
    }

    public void setCertificateChecking(X509Certificate x509Certificate) {
        this.certificate = x509Certificate;
    }

    public Collection getIssuerNames() {
        if (this.issuerNamesFromApp != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = this.issuerNamesFromApp.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof byte[]) {
                    arrayList.add(((byte[])e).clone());
                    continue;
                }
                arrayList.add(e);
            }
            return arrayList;
        }
        return null;
    }

    public BigInteger getMinCRL() {
        return this.minCRLNumber != null ? new BigInteger(this.minCRLNumber.toByteArray()) : null;
    }

    public BigInteger getMaxCRL() {
        return this.maxCRLNumber != null ? new BigInteger(this.maxCRLNumber.toByteArray()) : null;
    }

    public Date getDateAndTime() {
        return this.dateAndTime != null ? new Date(this.dateAndTime.getTime()) : null;
    }

    public X509Certificate getCertificateChecking() {
        return this.certificate;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("509CRLSelector:");
        stringBuffer.append("\n    IssuerNames:");
        stringBuffer.append(this.dumpIssuerNames(this.getIssuerNames()));
        stringBuffer.append("\n    MinCRLNumber:");
        stringBuffer.append(this.getMinCRL());
        stringBuffer.append("\n    MaxCRLNumber:");
        stringBuffer.append(this.getMaxCRL());
        stringBuffer.append("\n    DateAndTime:");
        stringBuffer.append(this.getDateAndTime());
        stringBuffer.append("\n    CertificateChecking:");
        stringBuffer.append(this.getCertificateChecking());
        return stringBuffer.toString();
    }

    private String dumpIssuerNames(Collection collection) {
        if (collection == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n       next name:\n");
            Object e = iterator.next();
            if (e instanceof byte[]) {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                stringBuffer.append(hexDumpEncoder.encodeBuffer((byte[])e));
                continue;
            }
            stringBuffer.append(iterator);
        }
        return stringBuffer.toString();
    }

    public boolean match(CRL cRL) {
        Object object;
        X509CRLImpl x509CRLImpl;
        if (!(cRL instanceof X509CRL)) {
            return false;
        }
        try {
            x509CRLImpl = new X509CRLImpl(((X509CRL)cRL).getEncoded());
        }
        catch (CRLException cRLException) {
            return false;
        }
        if (this.issuerNames != null) {
            boolean bl = false;
            object = this.issuerNames.iterator();
            while (object.hasNext()) {
                if (!((X500Name)object.next()).equals((Object)x509CRLImpl.getIssuerDN())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        if (this.getMinCRL() != null || this.getMaxCRL() != null) {
            try {
                Object[] objectArray = this.getExtension("x509.info.extensions.CRLNumber", (X509CRL)x509CRLImpl);
                CRLNumberExtension cRLNumberExtension = new CRLNumberExtension((Boolean)objectArray[0], objectArray[1]);
                object = (BigInteger)cRLNumberExtension.get("value");
            }
            catch (CertPathValidatorException certPathValidatorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            if (this.getMinCRL() != null && ((BigInteger)object).compareTo(this.getMinCRL()) < 0) {
                return false;
            }
            if (this.getMaxCRL() != null && ((BigInteger)object).compareTo(this.getMaxCRL()) > 0) {
                return false;
            }
        }
        return this.getDateAndTime() == null || !this.getDateAndTime().before(x509CRLImpl.getThisUpdate()) && this.getDateAndTime().before(x509CRLImpl.getNextUpdate());
    }

    private Object[] getExtension(String string, X509CRL x509CRL) throws CertPathValidatorException {
        boolean bl = false;
        String string2 = OIDMap.getOID((String)string).toString();
        byte[] byArray = x509CRL.getExtensionValue(string2);
        if (byArray != null) {
            bl = x509CRL.getCriticalExtensionOIDs().contains(string2);
            try {
                byArray = new DerValue(byArray).getOctetString();
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        Object[] objectArray = new Object[]{new Boolean(bl), byArray};
        return objectArray;
    }

    public Object clone() {
        try {
            Object object = super.clone();
            if (this.issuerNames != null) {
                this.issuerNames = new ArrayList(this.issuerNames);
                this.issuerNamesFromApp = new ArrayList(this.issuerNamesFromApp);
            }
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }
}

