/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.io.IOException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import javax.security.cert.CRLSelector;
import javax.security.cert.CertSelector;
import javax.security.cert.CertStoreException;
import javax.security.cert.CertStoreParameters;
import javax.security.cert.CollectionCertStoreParameters;
import javax.security.cert.LDAPCertStoreParameters;
import javax.security.cert.X509CRLSelector;
import javax.security.cert.X509CertSelector;

public class CertStore {
    private CertStoreParameters params;
    private java.security.cert.CertStore store;

    private CertStore() {
    }

    public final Collection getCertificates(CertSelector certSelector) throws CertStoreException {
        X509CertSelector x509CertSelector = null;
        try {
            x509CertSelector = (X509CertSelector)certSelector;
        }
        catch (ClassCastException classCastException) {
            throw new CertStoreException("not an X509CertSelector");
        }
        java.security.cert.X509CertSelector x509CertSelector2 = new java.security.cert.X509CertSelector();
        try {
            x509CertSelector2.setAuthorityKeyIdentifier(x509CertSelector.getAuthorityKeyIdentifier());
            x509CertSelector2.setBasicConstraints(x509CertSelector.getBasicConstraints());
            x509CertSelector2.setCertificate(x509CertSelector.getCertificate());
            x509CertSelector2.setCertificateValid(x509CertSelector.getCertificateValid());
            x509CertSelector2.setExtendedKeyUsage(x509CertSelector.getExtendedKeyUsage());
            x509CertSelector2.setIssuer(x509CertSelector.getIssuerAsBytes());
            x509CertSelector2.setIssuer(x509CertSelector.getIssuerAsString());
            x509CertSelector2.setKeyUsage(x509CertSelector.getKeyUsage());
            x509CertSelector2.setMatchAllSubjectAltNames(x509CertSelector.getMatchAllSubjectAltNames());
            x509CertSelector2.setNameConstraints(x509CertSelector.getNameConstraints());
            x509CertSelector2.setPathToNames(x509CertSelector.getPathToNames());
            x509CertSelector2.setPolicy(x509CertSelector.getPolicy());
            x509CertSelector2.setPrivateKeyValid(x509CertSelector.getPrivateKeyValid());
            x509CertSelector2.setSerialNumber(x509CertSelector.getSerialNumber());
            x509CertSelector2.setSubject(x509CertSelector.getSubjectAsString());
            x509CertSelector2.setSubjectAlternativeNames(x509CertSelector.getSubjectAlternativeNames());
            x509CertSelector2.setSubjectKeyIdentifier(x509CertSelector.getSubjectKeyIdentifier());
            x509CertSelector2.setSubjectPublicKey(x509CertSelector.getSubjectPublicKey());
            x509CertSelector2.setSubjectPublicKeyAlgID(x509CertSelector.getSubjectPublicKeyAlgID());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return this.store.getCertificates(x509CertSelector2);
        }
        catch (java.security.cert.CertStoreException certStoreException) {
            throw new CertStoreException(certStoreException.getMessage());
        }
    }

    public final Collection getCRLs(CRLSelector cRLSelector) throws CertStoreException {
        X509CRLSelector x509CRLSelector = null;
        try {
            x509CRLSelector = (X509CRLSelector)cRLSelector;
        }
        catch (ClassCastException classCastException) {
            throw new CertStoreException("not an X509CRLSelector");
        }
        java.security.cert.X509CRLSelector x509CRLSelector2 = new java.security.cert.X509CRLSelector();
        x509CRLSelector2.setCertificateChecking(x509CRLSelector.getCertificateChecking());
        x509CRLSelector2.setDateAndTime(x509CRLSelector.getDateAndTime());
        try {
            x509CRLSelector2.setIssuerNames(x509CRLSelector.getIssuerNames());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        x509CRLSelector2.setMaxCRLNumber(x509CRLSelector.getMaxCRL());
        x509CRLSelector2.setMinCRLNumber(x509CRLSelector.getMinCRL());
        try {
            return this.store.getCRLs(x509CRLSelector2);
        }
        catch (java.security.cert.CertStoreException certStoreException) {
            throw new CertStoreException(certStoreException.getMessage());
        }
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        java.security.cert.CertStoreParameters certStoreParameters2 = null;
        if (certStoreParameters instanceof CollectionCertStoreParameters) {
            certStoreParameters2 = new java.security.cert.CollectionCertStoreParameters(((CollectionCertStoreParameters)certStoreParameters).getCollection());
        } else if (certStoreParameters instanceof LDAPCertStoreParameters) {
            certStoreParameters2 = new java.security.cert.LDAPCertStoreParameters(((LDAPCertStoreParameters)certStoreParameters).getServerName(), ((LDAPCertStoreParameters)certStoreParameters).getPort());
        } else {
            throw new InvalidAlgorithmParameterException("Invalid algorithm parameters");
        }
        CertStore certStore = new CertStore();
        certStore.store = java.security.cert.CertStore.getInstance(string, certStoreParameters2);
        certStore.params = certStoreParameters;
        return certStore;
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        java.security.cert.CertStoreParameters certStoreParameters2 = null;
        if (certStoreParameters instanceof CollectionCertStoreParameters) {
            certStoreParameters2 = new java.security.cert.CollectionCertStoreParameters(((CollectionCertStoreParameters)certStoreParameters).getCollection());
        } else if (certStoreParameters instanceof LDAPCertStoreParameters) {
            certStoreParameters2 = new java.security.cert.LDAPCertStoreParameters(((LDAPCertStoreParameters)certStoreParameters).getServerName(), ((LDAPCertStoreParameters)certStoreParameters).getPort());
        } else {
            throw new InvalidAlgorithmParameterException("Invalid algorithm parameters");
        }
        CertStore certStore = new CertStore();
        certStore.store = java.security.cert.CertStore.getInstance(string, certStoreParameters2, string2);
        certStore.params = certStoreParameters;
        return certStore;
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters, Provider provider) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        java.security.cert.CertStoreParameters certStoreParameters2 = null;
        if (certStoreParameters instanceof CollectionCertStoreParameters) {
            certStoreParameters2 = new java.security.cert.CollectionCertStoreParameters(((CollectionCertStoreParameters)certStoreParameters).getCollection());
        } else if (certStoreParameters instanceof LDAPCertStoreParameters) {
            certStoreParameters2 = new java.security.cert.LDAPCertStoreParameters(((LDAPCertStoreParameters)certStoreParameters).getServerName(), ((LDAPCertStoreParameters)certStoreParameters).getPort());
        } else {
            throw new InvalidAlgorithmParameterException("Invalid algorithm parameters");
        }
        CertStore certStore = new CertStore();
        certStore.store = java.security.cert.CertStore.getInstance(string, certStoreParameters2, provider);
        certStore.params = certStoreParameters;
        return certStore;
    }

    public final String getType() {
        return this.store.getType();
    }

    public final Provider getProvider() {
        return this.store.getProvider();
    }

    public static final String getDefaultType() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("certstore.type");
            }
        });
        if (string == null) {
            string = "LDAP";
        }
        return string;
    }

    public final CertStoreParameters getCertStoreParameters() {
        return this.params;
    }
}

