/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateDialog;
import sun.plugin.util.DialogFactory;
import sun.plugin.util.PluginUIManager;
import sun.plugin.util.Trace;

class TrustDeciderDialog
implements ActionListener {
    public static final int TrustOption_GrantThisSession = 0;
    public static final int TrustOption_Deny = 1;
    public static final int TrustOption_GrantAlways = 2;
    private Certificate[] certs = null;
    private int start = 0;
    private int end = 0;
    private boolean rootCANotValid = false;
    private boolean timeNotValid = false;
    private boolean httpsDialog = false;
    private CertificateDialog dialog = null;

    TrustDeciderDialog(Certificate[] certificateArray, int n, int n2, boolean bl, boolean bl2) {
        this.certs = certificateArray;
        this.start = n;
        this.end = n2;
        this.rootCANotValid = bl;
        this.timeNotValid = bl2;
        this.dialog = new CertificateDialog(certificateArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int DoModal() {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = PluginUIManager.setTheme();
            int n = -1;
            if (this.certs[this.start] instanceof X509Certificate && this.certs[this.end - 1] instanceof X509Certificate) {
                Object[] objectArray;
                X509Certificate x509Certificate = (X509Certificate)this.certs[this.start];
                X509Certificate x509Certificate2 = (X509Certificate)this.certs[this.end - 1];
                Principal principal = x509Certificate.getSubjectDN();
                Principal principal2 = x509Certificate2.getIssuerDN();
                String string = principal.getName();
                String string2 = null;
                int n2 = string.indexOf("CN=");
                int n3 = 0;
                if (n2 < 0) {
                    string2 = TrustDeciderDialog.getMessage("security_dialog.unknown.subject");
                } else {
                    try {
                        n3 = string.charAt(n2 += 3) == '\"' ? string.indexOf(34, ++n2) : string.indexOf(44, n2);
                        string2 = n3 < 0 ? string.substring(n2) : string.substring(n2, n3);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        string2 = TrustDeciderDialog.getMessage("security_dialog.unknown.subject");
                    }
                }
                String string3 = principal2.getName();
                String string4 = null;
                n2 = string3.indexOf("O=");
                n3 = 0;
                if (n2 < 0) {
                    string4 = TrustDeciderDialog.getMessage("security_dialog.unknown.issuer");
                } else {
                    try {
                        n3 = string3.charAt(n2 += 2) == '\"' ? string3.indexOf(34, ++n2) : string3.indexOf(44, n2);
                        string4 = n3 < 0 ? string3.substring(n2) : string3.substring(n2, n3);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        string4 = TrustDeciderDialog.getMessage("security_dialog.unknown.issuer");
                    }
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                MessageFormat messageFormat = null;
                messageFormat = this.getHttpsDialog() ? new MessageFormat(TrustDeciderDialog.getMessage("security_dialog_https.text0")) : new MessageFormat(TrustDeciderDialog.getMessage("security_dialog.text0"));
                Object[] objectArray2 = new Object[]{string2, string4};
                arrayList.add(messageFormat.format(objectArray2));
                arrayList.add("");
                if (this.rootCANotValid) {
                    objectArray = new JLabel(TrustDeciderDialog.getMessage("security_dialog.rootCANotValid"));
                    objectArray.setIcon(this.getWarningIcon());
                    arrayList.add(objectArray);
                } else {
                    objectArray = new JLabel(TrustDeciderDialog.getMessage("security_dialog.rootCAValid"));
                    objectArray.setIcon(this.getInfoIcon());
                    arrayList.add(objectArray);
                }
                arrayList.add("");
                if (this.timeNotValid) {
                    objectArray = new JLabel(TrustDeciderDialog.getMessage("security_dialog.timeNotValid"));
                    objectArray.setIcon(this.getWarningIcon());
                    arrayList.add(objectArray);
                } else {
                    objectArray = new JLabel(TrustDeciderDialog.getMessage("security_dialog.timeValid"));
                    objectArray.setIcon(this.getInfoIcon());
                    arrayList.add(objectArray);
                }
                messageFormat = new MessageFormat(TrustDeciderDialog.getMessage("security_dialog.text1"));
                objectArray = new Object[]{string2, string2};
                arrayList.add(messageFormat.format(objectArray));
                JButton jButton = new JButton(TrustDeciderDialog.getMessage("security_dialog.buttonViewCert"));
                jButton.setMnemonic(TrustDeciderDialog.getAcceleratorKey("security_dialog.buttonViewCert"));
                jButton.addActionListener(this);
                JPanel jPanel = new JPanel();
                jPanel.add(jButton);
                jPanel.setLayout(new FlowLayout(2));
                arrayList.add(jPanel);
                JButton jButton2 = new JButton(TrustDeciderDialog.getMessage("security_dialog.buttonYes"));
                JButton jButton3 = new JButton(TrustDeciderDialog.getMessage("security_dialog.buttonNo"));
                JButton jButton4 = new JButton(TrustDeciderDialog.getMessage("security_dialog.buttonAlways"));
                jButton2.setMnemonic(TrustDeciderDialog.getAcceleratorKey("security_dialog.buttonYes"));
                jButton3.setMnemonic(TrustDeciderDialog.getAcceleratorKey("security_dialog.buttonNo"));
                jButton4.setMnemonic(TrustDeciderDialog.getAcceleratorKey("security_dialog.buttonAlways"));
                Object[] objectArray3 = new Object[]{jButton2, jButton3, jButton4};
                if (!Trace.isAutomationEnabled()) {
                    n = DialogFactory.showOptionDialog(4, (Object)arrayList.toArray(), TrustDeciderDialog.getMessage("security_dialog.caption"), objectArray3, objectArray3[0]);
                } else {
                    Trace.msgSecurityPrintln("trustdecider.automation.trustcert");
                    n = 0;
                }
            }
            int n4 = n;
            return n4;
        }
        finally {
            PluginUIManager.restoreTheme(lookAndFeel);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.dialog.DoModal();
    }

    private static String getMessage(String string) {
        return ResourceHandler.getMessage(string);
    }

    private static int getAcceleratorKey(String string) {
        return ResourceHandler.getAcceleratorKey(string);
    }

    private Icon getWarningIcon() {
        return this.getIcon("javax/swing/plaf/metal/icons/Warn.gif");
    }

    private Icon getInfoIcon() {
        return this.getIcon("javax/swing/plaf/metal/icons/Inform.gif");
    }

    private Icon getIcon(final String string) {
        Icon icon = null;
        try {
            icon = (Icon)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    URL uRL = ClassLoader.getSystemResource(string);
                    return new ImageIcon(uRL);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
        return icon;
    }

    private boolean getHttpsDialog() {
        return this.httpsDialog;
    }

    public void setHttpsDialog(boolean bl) {
        this.httpsDialog = bl;
    }
}

