/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.NetscapeCertTypeExtension;
import java.io.IOException;
import java.io.Serializable;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateStore;
import sun.plugin.security.DeniedCertificateStore;
import sun.plugin.security.PluginCertificateStore;
import sun.plugin.security.RootCACertificateStore;
import sun.plugin.security.SessionCertificateStore;
import sun.plugin.security.TrustDeciderDialog;
import sun.plugin.util.PluginSysAction;
import sun.plugin.util.PluginSysUtil;
import sun.plugin.util.Trace;

public class TrustDecider {
    private static CertificateStore rootStore;
    private static CertificateStore permanentStore;
    private static CertificateStore sessionStore;
    private static CertificateStore deniedStore;
    private static Map trustedX500Principals;
    private static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    private static final String OID_KEY_USAGE = "2.5.29.15";
    private static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    private static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    private static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    private static final String OID_EKU_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    private static final String NSCT_OBJECT_SIGNING_CA = "object_signing_ca";
    private static final String NSCT_OBJECT_SIGNING = "object_signing";
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_S_MIME_CA = "s_mime_ca";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void reset() {
        rootStore = new RootCACertificateStore();
        permanentStore = new PluginCertificateStore();
        sessionStore = new SessionCertificateStore();
        deniedStore = new DeniedCertificateStore();
    }

    public static boolean isAllPermissionGranted(CodeSource codeSource) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        int n;
        Certificate[] certificateArray = codeSource.getCertificates();
        String string = codeSource.getLocation().toString();
        if (certificateArray == null) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        LinkedList<Boolean> linkedList = new LinkedList<Boolean>();
        String string2 = null;
        rootStore.load();
        permanentStore.load();
        sessionStore.load();
        deniedStore.load();
        while (n3 < certificateArray.length) {
            n = n2;
            while (n + 1 < certificateArray.length && certificateArray[n] instanceof X509Certificate && certificateArray[n + 1] instanceof X509Certificate && TrustDecider.isIssuerOf((X509Certificate)certificateArray[n], (X509Certificate)certificateArray[n + 1])) {
                ++n;
            }
            n3 = n + 1;
            if (deniedStore.contains(certificateArray[n2])) {
                linkedList.add(n4, new Boolean(true));
            } else {
                linkedList.add(n4, new Boolean(false));
                if (permanentStore.contains(certificateArray[n2])) {
                    return true;
                }
                if (sessionStore.contains(certificateArray[n2])) {
                    return true;
                }
            }
            n2 = n3;
            ++n4;
        }
        n = 0;
        boolean bl = false;
        boolean bl2 = false;
        n2 = 0;
        n3 = 0;
        KeyStore keyStore = rootStore.getKeyStore();
        TrustDecider.getCertMap(keyStore);
        Date date = new Date();
        certificateArray = TrustDecider.canonicalize(certificateArray, date);
        n4 = 0;
        while (n3 < certificateArray.length) {
            Serializable serializable;
            int n5 = n2;
            CertificateExpiredException certificateExpiredException = null;
            CertificateNotYetValidException certificateNotYetValidException = null;
            for (n5 = n2; n5 < certificateArray.length; ++n5) {
                Serializable serializable2;
                block32: {
                    serializable = null;
                    serializable2 = null;
                    if (certificateArray[n5] instanceof X509Certificate) {
                        serializable = (X509Certificate)certificateArray[n5];
                    }
                    serializable2 = n5 + 1 < certificateArray.length && certificateArray[n5 + 1] instanceof X509Certificate ? (X509Certificate)certificateArray[n5 + 1] : serializable;
                    try {
                        ((X509Certificate)serializable).checkValidity();
                    }
                    catch (CertificateExpiredException certificateExpiredException2) {
                        if (certificateExpiredException == null) {
                            certificateExpiredException = certificateExpiredException2;
                        }
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException2) {
                        if (certificateNotYetValidException != null) break block32;
                        certificateNotYetValidException = certificateNotYetValidException2;
                    }
                }
                if (!rootStore.contains((Certificate)serializable) && n5 + 1 != certificateArray.length && TrustDecider.isIssuerOf((X509Certificate)serializable, (X509Certificate)serializable2)) {
                    Set set = serializable.getCriticalExtensionOIDs();
                    if (set == null) {
                        set = Collections.EMPTY_SET;
                    }
                    if (!TrustDecider.checkBasicConstraints((X509Certificate)serializable, set, n5 - n2)) {
                        Trace.msgSecurityPrintln("trustdecider.check.basicconstraints");
                        string2 = ResourceHandler.getMessage("trustdecider.check.basicconstraints");
                        throw new CertificateException(string2);
                    }
                    if (n5 == n2) {
                        if (!TrustDecider.checkLeafKeyUsage((X509Certificate)serializable, set)) {
                            Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage");
                            string2 = ResourceHandler.getMessage("trustdecider.check.leafkeyusage");
                            throw new CertificateException(string2);
                        }
                    } else if (!TrustDecider.checkSignerKeyUsage((X509Certificate)serializable, set)) {
                        Trace.msgSecurityPrintln("trustdecider.check.signerkeyusage");
                        string2 = ResourceHandler.getMessage("trustdecider.check.signerkeyusage");
                        throw new CertificateException(string2);
                    }
                    if (!set.isEmpty()) {
                        Trace.msgSecurityPrintln("trustdecider.check.extensions");
                        string2 = ResourceHandler.getMessage("trustdecider.check.extensions");
                        throw new CertificateException(string2);
                    }
                }
                if (!TrustDecider.isIssuerOf((X509Certificate)serializable, (X509Certificate)serializable2)) break;
                try {
                    ((Certificate)serializable).verify(((Certificate)serializable2).getPublicKey());
                    continue;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    Trace.msgSecurityPrintln("trustdecider.check.signature");
                    string2 = ResourceHandler.getMessage("trustdecider.check.signature");
                    throw new CertificateException(string2);
                }
            }
            n3 = n5 < certificateArray.length ? n5 + 1 : n5;
            serializable = (Boolean)linkedList.get(n4);
            if (!((Boolean)serializable).booleanValue()) {
                int n6;
                if (!rootStore.verify(certificateArray[n3 - 1])) {
                    n = 1;
                }
                if (certificateExpiredException != null || certificateNotYetValidException != null) {
                    bl = true;
                }
                if ((n6 = TrustDecider.showSecurityDialog(certificateArray, n2, n3, n != 0, bl)) == 0) {
                    Trace.msgSecurityPrintln("trustdecider.user.grant.session");
                    sessionStore.add(certificateArray[n2]);
                    sessionStore.save();
                    bl2 = true;
                } else if (n6 == 2) {
                    Trace.msgSecurityPrintln("trustdecider.user.grant.forever");
                    permanentStore.add(certificateArray[n2]);
                    permanentStore.save();
                    bl2 = true;
                } else {
                    Trace.msgSecurityPrintln("trustdecider.user.deny");
                    deniedStore.add(certificateArray[n2]);
                    deniedStore.save();
                }
                if (bl2) {
                    return true;
                }
            }
            n2 = n3;
            ++n4;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkBasicConstraints(X509Certificate x509Certificate, Set set, int n) throws CertificateException, IOException {
        set.remove(OID_BASIC_CONSTRAINTS);
        set.remove(OID_NETSCAPE_CERT_TYPE);
        if (n == 0) {
            return true;
        }
        if (x509Certificate.getExtensionValue(OID_BASIC_CONSTRAINTS) == null) {
            if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null) {
                if (TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) return true;
                Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.certtypebit");
                return false;
            }
            Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.extensionvalue");
            return false;
        }
        if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && (TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_SSL_CA) || TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_S_MIME_CA) || TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) && !TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) {
            Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.bitvalue");
            return false;
        }
        int n2 = x509Certificate.getBasicConstraints();
        if (n2 < 0) {
            Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.enduser");
            return false;
        }
        if (n - 1 <= n2) return true;
        Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.pathlength");
        return false;
    }

    private static boolean checkLeafKeyUsage(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        List<String> list;
        set.remove(OID_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            if (blArray.length == 0) {
                Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.length");
                return false;
            }
            boolean bl = blArray[0];
            if (!bl) {
                Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.digitalsignature");
                return false;
            }
        }
        if ((list = x509Certificate.getExtendedKeyUsage()) != null && set.contains(OID_EXTENDED_KEY_USAGE)) {
            set.remove(OID_EXTENDED_KEY_USAGE);
            if (!list.contains(OID_EKU_ANY_USAGE) && !list.contains(OID_EKU_CODE_SIGNING)) {
                Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.extkeyusageinfo");
                return false;
            }
        }
        if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && !TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING)) {
            Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.certtypebit");
            return false;
        }
        return true;
    }

    private static boolean checkSignerKeyUsage(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        set.remove(OID_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!(blArray == null || blArray.length >= 6 && blArray[5])) {
            Trace.msgSecurityPrintln("trustdecider.check.signerkeyusage.lengthandbit");
            return false;
        }
        List<String> list = x509Certificate.getExtendedKeyUsage();
        if (list != null && set.contains(OID_EXTENDED_KEY_USAGE)) {
            set.remove(OID_EXTENDED_KEY_USAGE);
            if (!list.contains(OID_EKU_ANY_USAGE)) {
                Trace.msgSecurityPrintln("trustdecider.check.signerkeyusage.keyusage");
                return false;
            }
        }
        return true;
    }

    private static boolean getNetscapeCertTypeBit(X509Certificate x509Certificate, String string) throws CertificateException, IOException {
        byte[] byArray = x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE);
        if (byArray == null) {
            return false;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        byArray2 = new DerValue(byArray2).getUnalignedBitString().toByteArray();
        NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray2);
        Boolean bl = (Boolean)netscapeCertTypeExtension.get(string);
        return bl;
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return ((Object)principal2).equals(principal = x509Certificate2.getSubjectDN());
    }

    private static synchronized void getCertMap(KeyStore keyStore) throws KeyStoreException {
        trustedX500Principals = new HashMap();
        if (keyStore == null) {
            return;
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
            TrustDecider.addTrustedCert((X509Certificate)certificate);
        }
    }

    private static void addTrustedCert(X509Certificate x509Certificate) {
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        ArrayList<X509Certificate> arrayList = (ArrayList<X509Certificate>)trustedX500Principals.get(x500Principal);
        if (arrayList == null) {
            arrayList = new ArrayList<X509Certificate>();
            trustedX500Principals.put(x500Principal, arrayList);
        }
        arrayList.add(x509Certificate);
    }

    private static Certificate[] canonicalize(Certificate[] certificateArray, Date date) throws CertificateException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(certificateArray.length);
        boolean bl = false;
        if (certificateArray.length == 0) {
            return certificateArray;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2 = (X509Certificate)certificateArray[i];
            X509Certificate x509Certificate3 = TrustDecider.getTrustedCertificate(x509Certificate2, date);
            if (x509Certificate3 != null) {
                Trace.msgSecurityPrintln("trustdecider.check.canonicalize.updatecert");
                x509Certificate2 = x509Certificate3;
                bl = true;
            }
            arrayList.add(x509Certificate2);
            X500Principal x500Principal = ((X509Certificate)certificateArray[i]).getSubjectX500Principal();
            X500Principal x500Principal2 = ((X509Certificate)certificateArray[i]).getIssuerX500Principal();
            X500Principal x500Principal3 = null;
            if (i < certificateArray.length - 1) {
                x500Principal3 = ((X509Certificate)certificateArray[i + 1]).getSubjectX500Principal();
            }
            if (((Object)x500Principal2).equals(x500Principal) || ((Object)x500Principal2).equals(x500Principal3) || (x509Certificate = TrustDecider.getTrustedIssuerCertificate((X509Certificate)certificateArray[i], date)) == null) continue;
            Trace.msgSecurityPrintln("trustdecider.check.canonicalize.missing");
            bl = true;
            arrayList.add(x509Certificate);
        }
        if (bl) {
            return arrayList.toArray(new Certificate[arrayList.size()]);
        }
        return certificateArray;
    }

    private static X509Certificate getTrustedCertificate(X509Certificate x509Certificate, Date date) {
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        List list = (List)trustedX500Principals.get(x500Principal);
        if (list == null) {
            return null;
        }
        X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
        PublicKey publicKey = x509Certificate.getPublicKey();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            if (x509Certificate2.equals(x509Certificate) || !x509Certificate2.getIssuerX500Principal().equals(x500Principal2) || !x509Certificate2.getPublicKey().equals(publicKey)) continue;
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (Exception exception) {
                continue;
            }
            Trace.msgSecurityPrintln("trustdecider.check.gettrustedcert.find");
            return x509Certificate2;
        }
        return null;
    }

    private static X509Certificate getTrustedIssuerCertificate(X509Certificate x509Certificate, Date date) {
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        List list = (List)trustedX500Principals.get(x500Principal);
        if (list == null) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (Exception exception) {
                continue;
            }
            Trace.msgSecurityPrintln("trustdecider.check.gettrustedissuercert.find");
            return x509Certificate2;
        }
        return null;
    }

    static int showSecurityDialog(final Certificate[] certificateArray, final int n, final int n2, final boolean bl, final boolean bl2) {
        int n3;
        block2: {
            n3 = -1;
            try {
                n3 = (Integer)PluginSysUtil.execute(new PluginSysAction(){

                    public Object execute() throws Exception {
                        TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(certificateArray, n, n2, bl, bl2);
                        return new Integer(trustDeciderDialog.DoModal());
                    }
                });
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return n3;
    }

    static {
        $assertionsDisabled = !TrustDecider.class.desiredAssertionStatus();
        rootStore = new RootCACertificateStore();
        permanentStore = new PluginCertificateStore();
        sessionStore = new SessionCertificateStore();
        deniedStore = new DeniedCertificateStore();
    }
}

