/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JPanel;

public class TextLabel
extends JPanel {
    private String[] inputLines;
    private String[] textLines;
    private int panelWidth = 100;
    private int panelHeight = 10;

    public TextLabel() {
    }

    public TextLabel(String[] stringArray) {
        this.inputLines = stringArray;
    }

    public TextLabel(String string) {
        this.inputLines = new String[1];
        this.inputLines[0] = string;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.panelWidth, this.panelHeight);
    }

    private String[] getTextLines() {
        Object[] objectArray;
        if (this.inputLines == null) {
            return null;
        }
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        Locale locale = this.getLocale();
        int n = this.panelWidth - this.getInsets().left - this.getInsets().right;
        Vector<String> vector = new Vector<String>();
        int n2 = this.inputLines.length;
        int n3 = 0;
        while (n3 < n2) {
            objectArray = this.inputLines[n3];
            BreakIterator breakIterator = BreakIterator.getLineInstance(locale);
            breakIterator.setText((String)objectArray);
            int n4 = breakIterator.first();
            int n5 = breakIterator.next();
            int n6 = 0;
            StringBuffer stringBuffer = new StringBuffer("");
            int n7 = 0;
            while (n5 != -1) {
                String string = objectArray.substring(n4, n5);
                n7 = fontMetrics.stringWidth(string);
                if (n6 + n7 > n) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = new StringBuffer(string);
                    n6 = n7;
                } else {
                    stringBuffer.append(string);
                    n6 += n7;
                }
                n4 = n5;
                n5 = breakIterator.next();
            }
            vector.addElement(stringBuffer.toString());
            ++n3;
        }
        vector.trimToSize();
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void paint(Graphics graphics) {
        if (this.textLines == null) {
            this.reformat();
            this.revalidate();
            this.repaint();
        } else if (this.textLines != null) {
            int n = this.textLines.length;
            int n2 = this.getInsets().left;
            int n3 = this.getInsets().top;
            int n4 = ((Component)this).getFontMetrics(this.getFont()).getHeight();
            int n5 = 0;
            while (n5 < n) {
                graphics.drawString(this.textLines[n5], n2, n3 += n4);
                ++n5;
            }
        }
    }

    private void reformat() {
        if (this.textLines == null || this.panelWidth != this.getSize().width || this.panelHeight != this.getSize().height) {
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
            if (fontMetrics != null) {
                this.panelWidth = this.getSize().width;
                this.textLines = this.getTextLines();
                this.panelHeight = this.textLines.length * fontMetrics.getHeight() + this.getInsets().top + this.getInsets().bottom;
            } else {
                this.textLines = null;
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.reformat();
    }

    public void setText(String[] stringArray) {
        this.inputLines = stringArray;
        this.textLines = null;
        this.reformat();
    }

    public void setText(String string) {
        String[] stringArray = new String[]{string};
        this.setText(stringArray);
        this.reformat();
    }
}

