/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import com.ibm.jvm.ExtendedSystem;
import com.ibm.jvm.io.LocalizedInputStream;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import sun.awt.DebugHelper;
import sun.awt.FontProperties;
import sun.awt.X11GraphicsDevice;
import sun.awt.font.NativeFontWrapper;
import sun.awt.motif.MFontProperties;
import sun.java2d.SunGraphicsEnvironment;
import sun.print.PSPrinterJob;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class X11GraphicsEnvironment
extends SunGraphicsEnvironment {
    private static final DebugHelper dbg;
    static Boolean xinerState;
    private HashSet fontPropDirs;
    Map fontNameMap;
    Map xFontDirsMap;
    Map xlfdMap;
    Vector registeredPaths;
    private static boolean registerNativeFonts;
    private static String display;
    private static boolean isDisplayLocal;
    private static final int FOUNDRY_FIELD = 1;
    private static final int FAMILY_NAME_FIELD = 2;
    private static final int WEIGHT_NAME_FIELD = 3;
    private static final int SLANT_FIELD = 4;
    private static final int SETWIDTH_NAME_FIELD = 5;
    private static final int ADD_STYLE_NAME_FIELD = 6;
    private static final int PIXEL_SIZE_FIELD = 7;
    private static final int POINT_SIZE_FIELD = 8;
    private static final int RESOLUTION_X_FIELD = 9;
    private static final int RESOLUTION_Y_FIELD = 10;
    private static final int SPACING_FIELD = 11;
    private static final int AVERAGE_WIDTH_FIELD = 12;
    private static final int CHARSET_REGISTRY_FIELD = 13;
    private static final int CHARSET_ENCODING_FIELD = 14;
    private static final int[] fontIDFields;
    private Vector nativeFonts;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static native int checkShmExt();

    private static native String getDisplayString();

    private static synchronized native void initDisplay();

    protected native int getNumScreens();

    protected GraphicsDevice makeScreenDevice(int n) {
        return new X11GraphicsDevice(n);
    }

    protected native int getDefaultScreenNum();

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[this.getDefaultScreenNum()];
    }

    public static synchronized boolean isDisplayLocal() {
        if (display != null) {
            return isDisplayLocal;
        }
        if (X11GraphicsEnvironment.isHeadless()) {
            display = "";
            isDisplayLocal = true;
            return true;
        }
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.remote"));
        if (string != null) {
            display = "";
            isDisplayLocal = string.equals("false");
            return isDisplayLocal;
        }
        int n = X11GraphicsEnvironment.checkShmExt();
        if (n != -1) {
            display = "";
            isDisplayLocal = n == 1;
            return isDisplayLocal;
        }
        display = X11GraphicsEnvironment.getDisplayString();
        int n2 = display.indexOf(":");
        final String string2 = display.substring(0, n2);
        if (n2 <= 0) {
            isDisplayLocal = true;
            return true;
        }
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InetAddress[] inetAddressArray = null;
                Enumeration<InetAddress> enumeration = null;
                Enumeration<NetworkInterface> enumeration2 = null;
                try {
                    enumeration2 = NetworkInterface.getNetworkInterfaces();
                    inetAddressArray = InetAddress.getAllByName(string2);
                    if (inetAddressArray == null) {
                        return Boolean.FALSE;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    System.err.println("Unknown host: " + string2);
                    return Boolean.FALSE;
                }
                catch (SocketException socketException) {
                    System.err.println(socketException.getMessage());
                    return Boolean.FALSE;
                }
                while (enumeration2.hasMoreElements()) {
                    enumeration = enumeration2.nextElement().getInetAddresses();
                    while (enumeration.hasMoreElements()) {
                        for (int i = 0; i < inetAddressArray.length; ++i) {
                            if (!((Object)enumeration.nextElement()).equals(inetAddressArray[i])) continue;
                            return Boolean.TRUE;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        isDisplayLocal = bl;
        return isDisplayLocal;
    }

    public PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new PSPrinterJob();
    }

    protected String getBasePlatformFontPath(boolean bl) {
        return this.getPlatformFontPath(bl);
    }

    protected String getFontPropertyFD(String string) {
        if (string.charAt(0) != '-') {
            return super.getFontPropertyFD(string);
        }
        return string;
    }

    protected String getFileNameFromPlatformName(String string) {
        if (string.charAt(0) != '-') {
            return super.getFileNameFromPlatformName(string);
        }
        String string2 = null;
        String string3 = this.specificFontIDForName(string);
        if (this.fontNameMap == null) {
            this.fontNameMap = new Hashtable();
        }
        if ((string2 = super.getFileNameFromPlatformName(string)) != null) {
            if (string2.startsWith("-")) {
                if (X11GraphicsEnvironment.isHeadless()) {
                    return null;
                }
                if (this.fontNameMap.get(this.specificFontIDForName(string2)) == null && (string2 = (String)this.fontNameMap.get(this.switchFontIDForName(string2))) == null) {
                    return null;
                }
            }
            this.fontNameMap.put(string3, string2);
            return string2;
        }
        if (string3 != null) {
            string2 = (String)this.fontNameMap.get(string3);
            if (!(this.registeredAllPaths || string2 != null && string2.startsWith("/"))) {
                if (debugMapping) {
                    System.out.println("** Registering all font paths");
                }
                String string4 = this.getPlatformFontPath(this.noType1Font);
                this.fontPath = this.fontPath + File.pathSeparator + string4;
                this.registerFontPaths(string4);
                string2 = (String)this.fontNameMap.get(string3);
            }
            if (string2 == null) {
                string3 = this.switchFontIDForName(string);
                string2 = (String)this.fontNameMap.get(string3);
            }
        }
        return string2;
    }

    protected String parseFamilyNameProperty(String string) {
        String string2;
        String string3 = "default";
        String string4 = this.specificFontIDForName(string);
        String string5 = null;
        if (string.charAt(0) != '-') {
            return super.parseFamilyNameProperty(string);
        }
        if (this.fontNameMap != null) {
            string5 = (String)this.fontNameMap.get(string4);
        }
        if (string5 == null) {
            string5 = super.getFileNameFromPlatformName(string4);
        }
        if (string5 == null) {
            string5 = this.SubstFontIDForName(string);
        }
        if (string5 != null && (string2 = NativeFontWrapper.getFullNameByFileName(string5)) != null) {
            string3 = string2;
        }
        return string3;
    }

    private String switchFontIDForName(String string) {
        String string2 = this.getXLFDField(string, 2);
        String string3 = this.getXLFDField(string, 3);
        String string4 = this.getXLFDField(string, 4);
        String string5 = this.getXLFDField(string, 5);
        String string6 = this.getXLFDField(string, 13);
        String string7 = this.getXLFDField(string, 14);
        if (string4.equals("i")) {
            string4 = "o";
        } else if (string4.equals("o")) {
            string4 = "i";
        }
        String string8 = "-" + string2 + "-" + string3 + "-" + string4 + "-" + string5 + "-" + string6 + "-" + string7;
        return string8.toLowerCase(Locale.ENGLISH);
    }

    private String specificFontIDForName(String string) {
        String string2 = this.getXLFDField(string, 2);
        String string3 = this.getXLFDField(string, 3);
        String string4 = this.getXLFDField(string, 4);
        String string5 = this.getXLFDField(string, 5);
        String string6 = this.getXLFDField(string, 13);
        String string7 = this.getXLFDField(string, 14);
        String string8 = "-" + string2 + "-" + string3 + "-" + string4 + "-" + string5 + "-" + string6 + "-" + string7;
        return string8.toLowerCase(Locale.ENGLISH);
    }

    private String SubstFontIDForName(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = this.getXLFDField(string, 2);
        String string5 = this.getXLFDField(string, 3);
        String string6 = this.getXLFDField(string, 4);
        String string7 = this.getXLFDField(string, 5);
        String string8 = this.getXLFDField(string, 13);
        String string9 = this.getXLFDField(string, 14);
        if (string6.equals("i")) {
            string6 = "o";
        } else if (string6.equals("o")) {
            string6 = "i";
        }
        FontProperties fontProperties = this.createFontProperties();
        int n = 0;
        while (fontProperties.containsKey("substitute." + n)) {
            ++n;
        }
        if (n > 0) {
            int n2;
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            String[] stringArray3 = new String[n];
            for (n2 = 0; n2 < n; ++n2) {
                stringArray[n2] = fontProperties.getProperty("substitute." + n2);
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n2], "=");
                if (stringTokenizer.countTokens() != 2) continue;
                stringArray2[n2] = stringTokenizer.nextToken();
                stringArray3[n2] = stringTokenizer.nextToken();
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (!stringArray2[n2].equals(string4)) continue;
                string3 = "-" + stringArray3[n2] + "-" + string5 + "-" + string6 + "-" + string7 + "-" + string8 + "-" + string9;
                if (this.fontNameMap == null) continue;
                string2 = (String)this.fontNameMap.get(string3.toLowerCase(Locale.ENGLISH));
                if (string2 == null) {
                    string2 = super.getFileNameFromPlatformName(string3.toLowerCase(Locale.ENGLISH));
                }
                if (string2 == null) continue;
                return string2;
            }
        }
        return string3;
    }

    private String getXLFDField(String string, int n) {
        return this.getFontField(string, n);
    }

    private String getFontIDField(String string, int n) {
        for (int i = 1; i < fontIDFields.length; ++i) {
            if (fontIDFields[i] != n) continue;
            return this.getFontField(string, i);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private String getFontField(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n-- > 0 && n2 >= 0) {
            n2 = string.indexOf("-", n2) + 1;
        }
        if (n2 == -1) {
            return "";
        }
        n3 = string.indexOf("-", n2);
        if (n3 == -1) {
            return string.substring(n2);
        }
        return string.substring(n2, n3);
    }

    protected void registerFontPath(String string) {
        final File file = new File(string + File.separator + "fonts.dir");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    X11GraphicsEnvironment.this.parseFontDir(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private native String[] getNativeFonts();

    protected Vector getNativeNames(String string) {
        Vector vector;
        if (this.xlfdMap == null || (vector = (Vector)this.xlfdMap.get(string)) == null) {
            Vector vector2 = new Vector();
            return vector2;
        }
        return vector;
    }

    protected void registerNative(String string) {
        Vector<String> vector = new Vector<String>(1, 1);
        vector.addElement(string);
        this.registeredFonts.put(string, string);
        NativeFontWrapper.registerFonts(vector, vector.size(), vector, 5, false);
    }

    private void initNativeFonts() {
        if (this.nativeFonts != null || X11GraphicsEnvironment.isHeadless()) {
            return;
        }
        String[] stringArray = this.getNativeFonts();
        if (stringArray != null) {
            this.nativeFonts = new Vector();
            if (this.fontNameMap == null) {
                this.fontNameMap = new Hashtable();
            }
            if (this.xlfdMap == null) {
                this.xlfdMap = new Hashtable();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string = this.specificFontIDForName(stringArray[i]);
                String string2 = (String)this.fontNameMap.get(string);
                if (string2 != null) continue;
                this.nativeFonts.addElement(stringArray[i]);
                this.fontNameMap.put(string, stringArray[i]);
                Vector<String> vector = new Vector<String>();
                vector.add(stringArray[i]);
                this.xlfdMap.put(stringArray[i], vector);
            }
        }
    }

    protected void addToFontPath(String string) {
        NativeFontWrapper.setNativeFontPath(string);
    }

    protected void addPlatformNameForFontProperties(String string) {
        if (this.fontPropDirs == null) {
            this.fontPropDirs = new HashSet();
        }
        if (this.xFontDirsMap == null) {
            return;
        }
        String string2 = this.specificFontIDForName(string);
        String string3 = (String)this.xFontDirsMap.get(string2);
        if (string3 != null && !this.fontPropDirs.contains(string3)) {
            this.fontPropDirs.add(string3);
        }
    }

    protected void registerFontPropertiesFonts(TreeMap treeMap) {
        Object[] objectArray = treeMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            HashSet hashSet = (HashSet)treeMap.get(string);
            Vector vector = this.getNativeNames(string);
            String[] stringArray = hashSet.toArray(new String[0]);
            Vector<String> vector2 = new Vector<String>();
            for (int j = 0; j < stringArray.length; ++j) {
                vector2.add(this.specificFontIDForName(stringArray[j]));
            }
            Vector<String> vector3 = new Vector<String>(hashSet);
            for (int j = 0; j < vector.size(); ++j) {
                String string2 = (String)vector.elementAt(j);
                String string3 = this.specificFontIDForName(string2);
                if (vector2.contains(string3)) continue;
                vector3.add(string2);
            }
            this.registerFontFile(string, vector3);
        }
        String[] stringArray = this.fontPropDirs.toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            if (debugMapping) {
                System.out.println("Add " + stringArray[i] + " to X11 fontpath");
            }
            this.addToFontPath(stringArray[i]);
        }
        this.fontPropDirs = null;
        this.xFontDirsMap = null;
    }

    protected boolean registerNativeFonts() {
        return false;
    }

    protected void registerFontPaths(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.registerFontPath(string2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
        if (this.loadNativeFonts) {
            this.initNativeFonts();
        }
    }

    private void parseFontDir(File file) throws FileNotFoundException, IOException {
        String string = file.getParent();
        if (debugMapping) {
            System.out.println("ParseFontDir " + string);
        }
        if (file.canRead()) {
            boolean bl = string.indexOf("rue") > 0 || string.indexOf("tt") > 0;
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(LocalizedInputStream.localize((InputStream)fileInputStream), 8192);
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedInputStream);
            streamTokenizer.eolIsSignificant(true);
            int n = streamTokenizer.nextToken();
            if (n == -2) {
                int n2 = (int)streamTokenizer.nval;
                n = streamTokenizer.nextToken();
                if (n == 10) {
                    int n3;
                    if (this.fontNameMap == null) {
                        this.fontNameMap = new Hashtable();
                    }
                    if (this.xlfdMap == null) {
                        this.xlfdMap = new Hashtable();
                    }
                    if (this.xFontDirsMap == null) {
                        this.xFontDirsMap = new Hashtable();
                    }
                    streamTokenizer.resetSyntax();
                    streamTokenizer.wordChars(32, 127);
                    streamTokenizer.wordChars(160, 255);
                    streamTokenizer.whitespaceChars(0, 31);
                    for (int i = 0; i < n2 && (n = streamTokenizer.nextToken()) != -1 && n == -3 && (n3 = streamTokenizer.sval.indexOf(" ")) > 0; ++i) {
                        String string2 = streamTokenizer.sval.substring(0, n3);
                        int n4 = string2.lastIndexOf(58);
                        if (n4 >= 0) {
                            string2 = string2.substring(n4 + 1);
                        }
                        String string3 = streamTokenizer.sval.substring(n3 + 1);
                        if (debugMapping) {
                            System.out.println("file=" + string2 + " xlfd=" + string3);
                        }
                        if (!bl || string2.indexOf(".pfb") < 0) {
                            Serializable serializable;
                            String string4 = this.specificFontIDForName(string3);
                            String string5 = (String)this.fontNameMap.get(string4);
                            String string6 = null;
                            try {
                                serializable = new File(string, string2);
                                File file2 = ((File)serializable).getParentFile();
                                if (file2 != null) {
                                    this.xFontDirsMap.put(string4, file2.getAbsolutePath());
                                }
                                string6 = ((File)serializable).getCanonicalPath();
                            }
                            catch (IOException iOException) {
                                string6 = string + File.separator + string2;
                            }
                            serializable = (Vector)this.xlfdMap.get(string6);
                            if ((serializable == null || !((Vector)serializable).contains(string3)) && string5 == null || !string5.startsWith("/")) {
                                if (debugMapping) {
                                    System.out.println("Map fontID:" + string4 + "to file:" + string6);
                                }
                                this.fontNameMap.put(string4, string6);
                                if (serializable == null) {
                                    serializable = new Vector();
                                    this.xlfdMap.put(string6, serializable);
                                }
                                ((Vector)serializable).add(string3);
                            }
                        }
                        if ((n = streamTokenizer.nextToken()) != 10) break;
                    }
                }
            }
        }
    }

    protected void addPlatformCompatibilityFileNames(Map map) {
        if (this.fontNameMap == null || this.xlfdMap == null) {
            return;
        }
        Iterator iterator = this.fontNameMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            String string3 = (String)iterator.next();
            String string4 = (String)this.fontNameMap.get(string3);
            if (map.get(string4) != null || string4.startsWith("-") || !this.isCompatibilityFont(string2 = this.getFontIDField(string3, 2), string = this.getFontIDField(string3, 13) + "-" + this.getFontIDField(string3, 14))) continue;
            HashSet<String> hashSet = new HashSet<String>();
            List list = (List)this.xlfdMap.get(string4);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string5 = (String)iterator2.next();
                string2 = this.getXLFDField(string5, 2);
                if (!this.isCompatibilityFont(string2, string = this.getXLFDField(string5, 13) + "-" + this.getXLFDField(string5, 14))) continue;
                hashSet.add(string5);
            }
            map.put(string4, hashSet);
        }
    }

    private boolean isCompatibilityFont(String string, String string2) {
        return "iso8859-1".equals(string2) && ("timesroman".equals(string) || "helvetica".equals(string) || "courier".equals(string));
    }

    protected FontProperties createFontProperties() {
        return new MFontProperties();
    }

    private static native boolean pRunningXinerama();

    private static native Point getXineramaCenterPoint();

    public Point getCenterPoint() {
        Point point;
        if (this.runningXinerama() && (point = X11GraphicsEnvironment.getXineramaCenterPoint()) != null) {
            return point;
        }
        return super.getCenterPoint();
    }

    public Rectangle getMaximumWindowBounds() {
        if (this.runningXinerama()) {
            return this.getXineramaWindowBounds();
        }
        return super.getMaximumWindowBounds();
    }

    private synchronized boolean runningXinerama() {
        if (xinerState == null) {
            xinerState = new Boolean(X11GraphicsEnvironment.pRunningXinerama());
        }
        return xinerState;
    }

    protected Rectangle getXineramaWindowBounds() {
        Point point = this.getCenterPoint();
        GraphicsDevice[] graphicsDeviceArray = this.getScreenDevices();
        Rectangle rectangle = null;
        Rectangle rectangle2 = X11GraphicsEnvironment.getUsableBounds(graphicsDeviceArray[0]);
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            Rectangle rectangle3 = X11GraphicsEnvironment.getUsableBounds(graphicsDeviceArray[i]);
            if (rectangle == null && rectangle3.width / 2 + rectangle3.x > point.x - 1 && rectangle3.height / 2 + rectangle3.y > point.y - 1 && rectangle3.width / 2 + rectangle3.x < point.x + 1 && rectangle3.height / 2 + rectangle3.y < point.y + 1) {
                rectangle = rectangle3;
            }
            rectangle2 = rectangle2.union(rectangle3);
        }
        if (rectangle2.width / 2 + rectangle2.x > point.x - 1 && rectangle2.height / 2 + rectangle2.y > point.y - 1 && rectangle2.width / 2 + rectangle2.x < point.x + 1 && rectangle2.height / 2 + rectangle2.y < point.y + 1) {
            return rectangle2;
        }
        if (rectangle != null) {
            return rectangle;
        }
        return rectangle2;
    }

    static {
        $assertionsDisabled = !X11GraphicsEnvironment.class.desiredAssertionStatus();
        dbg = DebugHelper.create(X11GraphicsEnvironment.class);
        xinerState = null;
        registerNativeFonts = false;
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        ExtendedSystem.setJVMUnresettableConditionally((int)196610);
        if (!X11GraphicsEnvironment.isHeadless()) {
            X11GraphicsEnvironment.initDisplay();
            String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.registerNativeFonts"));
            if (string != null) {
                registerNativeFonts = true;
            }
        }
        display = null;
        isDisplayLocal = false;
        fontIDFields = new int[]{0, 2, 3, 4, 5, 13, 14};
    }
}

