/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.BitSet;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.Option;
import javax.swing.text.html.OptionComboBoxModel;
import javax.swing.text.html.OptionListModel;
import javax.swing.text.html.TextAreaDocument;

public class FormView
extends ComponentView
implements ActionListener {
    public static final String SUBMIT = new String("Submit Query");
    public static final String RESET = new String("Reset");
    private short maxIsPreferred;

    public FormView(Element element) {
        super(element);
    }

    protected Component createComponent() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        HTML.Tag tag = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
        JComponent jComponent = null;
        Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        if (tag == HTML.Tag.INPUT) {
            jComponent = this.createInputComponent(attributeSet, object);
        } else if (tag == HTML.Tag.SELECT) {
            if (object instanceof OptionListModel) {
                JList jList = new JList((ListModel)object);
                int n = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.SIZE, 1);
                jList.setVisibleRowCount(n);
                jList.setSelectionModel((ListSelectionModel)object);
                jComponent = new JScrollPane(jList);
            } else {
                jComponent = new JComboBox((ComboBoxModel)object);
                this.maxIsPreferred = (short)3;
            }
        } else if (tag == HTML.Tag.TEXTAREA) {
            JTextArea jTextArea = new JTextArea((Document)object);
            int n = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.ROWS, 1);
            jTextArea.setRows(n);
            int n2 = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.COLS, 20);
            this.maxIsPreferred = (short)3;
            jTextArea.setColumns(n2);
            jComponent = new JScrollPane(jTextArea, 22, 32);
        }
        if (jComponent != null) {
            jComponent.setAlignmentY(1.0f);
        }
        return jComponent;
    }

    private JComponent createInputComponent(AttributeSet attributeSet, Object object) {
        JComponent jComponent = null;
        String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
        if (string.equals("submit") || string.equals("reset")) {
            String string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
            if (string2 == null) {
                string2 = string.equals("submit") ? UIManager.getString("FormView.submitButtonText") : UIManager.getString("FormView.resetButtonText");
            }
            JButton jButton = new JButton(string2);
            if (object != null) {
                jButton.setModel((ButtonModel)object);
                jButton.addActionListener(this);
            }
            jComponent = jButton;
            this.maxIsPreferred = (short)3;
        } else if (string.equals("image")) {
            JButton jButton;
            String string3 = (String)attributeSet.getAttribute(HTML.Attribute.SRC);
            try {
                URL uRL = ((HTMLDocument)this.getElement().getDocument()).getBase();
                URL uRL2 = new URL(uRL, string3);
                ImageIcon imageIcon = new ImageIcon(uRL2);
                jButton = new JButton(imageIcon);
            }
            catch (MalformedURLException malformedURLException) {
                jButton = new JButton(string3);
            }
            if (object != null) {
                jButton.setModel((ButtonModel)object);
                jButton.addMouseListener(new MouseEventListener());
            }
            jComponent = jButton;
            this.maxIsPreferred = (short)3;
        } else if (string.equals("checkbox")) {
            jComponent = new JCheckBox();
            if (object != null) {
                boolean bl = attributeSet.getAttribute(HTML.Attribute.CHECKED) != null;
                ((JToggleButton.ToggleButtonModel)object).setSelected(bl);
                jComponent.setModel((JToggleButton.ToggleButtonModel)object);
            }
            this.maxIsPreferred = (short)3;
        } else if (string.equals("radio")) {
            jComponent = new JRadioButton();
            if (object != null) {
                boolean bl = attributeSet.getAttribute(HTML.Attribute.CHECKED) != null;
                ((JToggleButton.ToggleButtonModel)object).setSelected(bl);
                ((JRadioButton)jComponent).setModel((JToggleButton.ToggleButtonModel)object);
            }
            this.maxIsPreferred = (short)3;
        } else if (string.equals("text")) {
            String string4;
            JTextField jTextField;
            int n = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.SIZE, -1);
            if (n > 0) {
                jTextField = new JTextField();
                jTextField.setColumns(n);
            } else {
                jTextField = new JTextField();
                jTextField.setColumns(20);
            }
            jComponent = jTextField;
            if (object != null) {
                jTextField.setDocument((Document)object);
            }
            if ((string4 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE)) != null) {
                jTextField.setText(string4);
            }
            jTextField.addActionListener(this);
            this.maxIsPreferred = (short)3;
        } else if (string.equals("password")) {
            int n;
            JPasswordField jPasswordField = new JPasswordField();
            jComponent = jPasswordField;
            if (object != null) {
                jPasswordField.setDocument((Document)object);
            }
            jPasswordField.setColumns((n = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.SIZE, -1)) > 0 ? n : 20);
            String string5 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
            if (string5 != null) {
                jPasswordField.setText(string5);
            }
            jPasswordField.addActionListener(this);
            this.maxIsPreferred = (short)3;
        } else if (string.equals("file")) {
            int n;
            JTextField jTextField = new JTextField();
            if (object != null) {
                jTextField.setDocument((Document)object);
            }
            jTextField.setColumns((n = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.SIZE, -1)) > 0 ? n : 20);
            JButton jButton = new JButton(UIManager.getString("FormView.browseFileButtonText"));
            Box box = Box.createHorizontalBox();
            box.add(jTextField);
            box.add(Box.createHorizontalStrut(5));
            box.add(jButton);
            jButton.addActionListener(new BrowseFileAction(attributeSet, (Document)object));
            jComponent = box;
            this.maxIsPreferred = (short)3;
        }
        return jComponent;
    }

    public float getMaximumSpan(int n) {
        switch (n) {
            case 0: {
                if ((this.maxIsPreferred & 1) == 1) {
                    super.getMaximumSpan(n);
                    return this.getPreferredSpan(n);
                }
                return super.getMaximumSpan(n);
            }
            case 1: {
                if ((this.maxIsPreferred & 2) == 2) {
                    super.getMaximumSpan(n);
                    return this.getPreferredSpan(n);
                }
                return super.getMaximumSpan(n);
            }
        }
        return super.getMaximumSpan(n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Element element = this.getElement();
        StringBuffer stringBuffer = new StringBuffer();
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        AttributeSet attributeSet = element.getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
        if (string.equals("submit")) {
            this.getFormData(stringBuffer);
            this.submitData(stringBuffer.toString());
        } else if (string.equals("reset")) {
            this.resetForm();
        } else if (string.equals("text") || string.equals("password")) {
            if (this.isLastTextOrPasswordField()) {
                this.getFormData(stringBuffer);
                this.submitData(stringBuffer.toString());
            } else {
                this.getComponent().transferFocus();
            }
        }
    }

    protected void submitData(String string) {
        SubmitThread submitThread = new SubmitThread(this.getElement(), string);
        submitThread.start();
    }

    protected void imageSubmit(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Element element = this.getElement();
        HTMLDocument hTMLDocument = (HTMLDocument)element.getDocument();
        this.getFormData(stringBuffer);
        if (stringBuffer.length() > 0) {
            stringBuffer.append('&');
        }
        stringBuffer.append(string);
        this.submitData(stringBuffer.toString());
    }

    private String getImageData(Point point) {
        String string;
        String string2 = point.x + ":" + point.y;
        int n = string2.indexOf(58);
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(++n);
        String string5 = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.NAME);
        if (string5 == null || string5.equals("")) {
            string = "x=" + string3 + "&y=" + string4;
        } else {
            string5 = URLEncoder.encode(string5);
            string = string5 + ".x" + "=" + string3 + "&" + string5 + ".y" + "=" + string4;
        }
        return string;
    }

    private Element getFormElement() {
        for (Element element = this.getElement(); element != null; element = element.getParentElement()) {
            if (element.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.FORM) continue;
            return element;
        }
        return null;
    }

    void getFormData(StringBuffer stringBuffer) {
        Element element = this.getFormElement();
        if (element != null) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                String string;
                if (!this.isControl(element2) || (string = (String)element2.getAttributes().getAttribute(HTML.Attribute.TYPE)) != null && string.equals("submit") && element2 != this || string != null && string.equals("image")) continue;
                this.loadElementDataIntoBuffer(element2, stringBuffer);
            }
        }
    }

    private void loadElementDataIntoBuffer(Element element, StringBuffer stringBuffer) {
        AttributeSet attributeSet = element.getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
        if (string == null) {
            return;
        }
        String string2 = null;
        HTML.Tag tag = (HTML.Tag)element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (tag == HTML.Tag.INPUT) {
            string2 = this.getInputElementData(attributeSet);
        } else if (tag == HTML.Tag.TEXTAREA) {
            string2 = this.getTextAreaData(attributeSet);
        } else if (tag == HTML.Tag.SELECT) {
            this.loadSelectData(attributeSet, stringBuffer);
        }
        if (string != null && string2 != null) {
            this.appendBuffer(stringBuffer, string, string2);
        }
    }

    private String getInputElementData(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
        String string2 = null;
        if (string.equals("text") || string.equals("password")) {
            Document document = (Document)object;
            try {
                string2 = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                string2 = null;
            }
        } else if (string.equals("submit") || string.equals("hidden")) {
            string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
            if (string2 == null) {
                string2 = "";
            }
        } else if (string.equals("radio") || string.equals("checkbox")) {
            ButtonModel buttonModel = (ButtonModel)object;
            if (buttonModel.isSelected() && (string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE)) == null) {
                string2 = "on";
            }
        } else if (string.equals("file")) {
            String string3;
            Document document = (Document)object;
            try {
                string3 = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                string3 = null;
            }
            if (string3 != null && string3.length() > 0) {
                string2 = string3;
            }
        }
        return string2;
    }

    private String getTextAreaData(AttributeSet attributeSet) {
        Document document = (Document)attributeSet.getAttribute(StyleConstants.ModelAttribute);
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private void loadSelectData(AttributeSet attributeSet, StringBuffer stringBuffer) {
        ComboBoxModel comboBoxModel;
        Option option;
        String string = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
        if (string == null) {
            return;
        }
        Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        if (object instanceof OptionListModel) {
            OptionListModel optionListModel = (OptionListModel)object;
            for (int i = 0; i < optionListModel.getSize(); ++i) {
                if (!optionListModel.isSelectedIndex(i)) continue;
                Option option2 = (Option)optionListModel.getElementAt(i);
                this.appendBuffer(stringBuffer, string, option2.getValue());
            }
        } else if (object instanceof ComboBoxModel && (option = (Option)(comboBoxModel = (ComboBoxModel)object).getSelectedItem()) != null) {
            this.appendBuffer(stringBuffer, string, option.getValue());
        }
    }

    private void appendBuffer(StringBuffer stringBuffer, String string, String string2) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append('&');
        }
        String string3 = URLEncoder.encode(string);
        stringBuffer.append(string3);
        stringBuffer.append('=');
        String string4 = URLEncoder.encode(string2);
        stringBuffer.append(string4);
    }

    private boolean isControl(Element element) {
        return element.isLeaf();
    }

    boolean isLastTextOrPasswordField() {
        Element element = this.getFormElement();
        Element element2 = this.getElement();
        if (element != null) {
            Element element3;
            ElementIterator elementIterator = new ElementIterator(element);
            boolean bl = false;
            while ((element3 = elementIterator.next()) != null) {
                String string;
                AttributeSet attributeSet;
                if (element3 == element2) {
                    bl = true;
                    continue;
                }
                if (!bl || !this.isControl(element3) || !HTMLDocument.matchNameAttribute(attributeSet = element3.getAttributes(), HTML.Tag.INPUT) || !"text".equals(string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE)) && !"password".equals(string)) continue;
                return false;
            }
        }
        return true;
    }

    void resetForm() {
        Element element = this.getFormElement();
        if (element != null) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                Object object;
                if (!this.isControl(element2)) continue;
                AttributeSet attributeSet = element2.getAttributes();
                Object object2 = attributeSet.getAttribute(StyleConstants.ModelAttribute);
                if (object2 instanceof TextAreaDocument) {
                    TextAreaDocument textAreaDocument = (TextAreaDocument)object2;
                    textAreaDocument.reset();
                    continue;
                }
                if (object2 instanceof PlainDocument) {
                    try {
                        PlainDocument plainDocument = (PlainDocument)object2;
                        plainDocument.remove(0, plainDocument.getLength());
                        if (!HTMLDocument.matchNameAttribute(attributeSet, HTML.Tag.INPUT) || (object = (String)attributeSet.getAttribute(HTML.Attribute.VALUE)) == null) continue;
                        plainDocument.insertString(0, (String)object, null);
                    }
                    catch (BadLocationException badLocationException) {}
                    continue;
                }
                if (object2 instanceof OptionListModel) {
                    OptionListModel optionListModel = (OptionListModel)object2;
                    int n = optionListModel.getSize();
                    for (int i = 0; i < n; ++i) {
                        optionListModel.removeIndexInterval(i, i);
                    }
                    BitSet bitSet = optionListModel.getInitialSelection();
                    for (int i = 0; i < bitSet.size(); ++i) {
                        if (!bitSet.get(i)) continue;
                        optionListModel.addSelectionInterval(i, i);
                    }
                    continue;
                }
                if (object2 instanceof OptionComboBoxModel) {
                    OptionComboBoxModel optionComboBoxModel = (OptionComboBoxModel)object2;
                    object = optionComboBoxModel.getInitialSelection();
                    if (object == null) continue;
                    optionComboBoxModel.setSelectedItem(object);
                    continue;
                }
                if (!(object2 instanceof JToggleButton.ToggleButtonModel)) continue;
                boolean bl = (String)attributeSet.getAttribute(HTML.Attribute.CHECKED) != null;
                object = (JToggleButton.ToggleButtonModel)object2;
                ((JToggleButton.ToggleButtonModel)object).setSelected(bl);
            }
        }
    }

    private class BrowseFileAction
    implements ActionListener {
        private AttributeSet attrs;
        private Document model;

        BrowseFileAction(AttributeSet attributeSet, Document document) {
            this.attrs = attributeSet;
            this.model = document;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(false);
            if (jFileChooser.showOpenDialog(FormView.this.getContainer()) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                try {
                    if (this.model.getLength() > 0) {
                        this.model.remove(0, this.model.getLength());
                    }
                    this.model.insertString(0, file.getPath(), null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    protected class MouseEventListener
    extends MouseAdapter {
        protected MouseEventListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            String string = FormView.this.getImageData(mouseEvent.getPoint());
            FormView.this.imageSubmit(string);
        }
    }

    class SubmitThread
    extends Thread {
        String data;
        HTMLDocument hdoc;
        HTMLDocument newDoc;
        AttributeSet formAttr;
        InputStream in;

        public SubmitThread(Element element, String string) {
            this.data = string;
            this.hdoc = (HTMLDocument)element.getDocument();
            Element element2 = FormView.this.getFormElement();
            if (element2 != null) {
                this.formAttr = element2.getAttributes();
            }
        }

        public void run() {
            if (this.data.length() > 0) {
                String string = this.getMethod();
                String string2 = this.getAction();
                try {
                    URL uRL;
                    URL uRL2;
                    Object object;
                    URL uRL3 = this.hdoc.getBase();
                    if (string2 == null) {
                        object = uRL3.getFile();
                        uRL2 = new URL(uRL3.getProtocol(), uRL3.getHost(), uRL3.getPort(), (String)object);
                    } else {
                        uRL2 = new URL(uRL3, string2);
                    }
                    if ("post".equals(string)) {
                        uRL = uRL2;
                        object = uRL.openConnection();
                        this.postData((URLConnection)object, this.data);
                    } else {
                        uRL = new URL(uRL2 + "?" + this.data);
                        object = uRL.openConnection();
                    }
                    this.in = ((URLConnection)object).getInputStream();
                    JEditorPane jEditorPane = (JEditorPane)FormView.this.getContainer();
                    HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
                    this.newDoc = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
                    this.newDoc.putProperty("stream", uRL);
                    Runnable runnable = new Runnable(this){
                        private final /* synthetic */ SubmitThread this$1;
                        {
                            this.this$1 = submitThread;
                        }

                        public void run() {
                            this.this$1.loadDocument();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void loadDocument() {
            JEditorPane jEditorPane = (JEditorPane)FormView.this.getContainer();
            try {
                jEditorPane.read(this.in, (Object)this.newDoc);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getAction() {
            if (this.formAttr == null) {
                return null;
            }
            return (String)this.formAttr.getAttribute(HTML.Attribute.ACTION);
        }

        String getMethod() {
            String string;
            if (this.formAttr != null && (string = (String)this.formAttr.getAttribute(HTML.Attribute.METHOD)) != null) {
                return string.toLowerCase();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postData(URLConnection uRLConnection, String string) {
            uRLConnection.setDoOutput(true);
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new OutputStreamWriter(uRLConnection.getOutputStream()));
                printWriter.print(string);
                printWriter.flush();
            }
            catch (IOException iOException) {
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
    }
}

