/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class BasicSplitPaneUI
extends SplitPaneUI {
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    protected static int KEYBOARD_DIVIDER_MOVE_OFFSET = 3;
    protected JSplitPane splitPane;
    protected BasicHorizontalLayoutManager layoutManager;
    protected BasicSplitPaneDivider divider;
    protected PropertyChangeListener propertyChangeListener;
    protected FocusListener focusListener;
    private static Set managingFocusForwardTraversalKeys;
    private static Set managingFocusBackwardTraversalKeys;
    protected int dividerSize;
    protected Component nonContinuousLayoutDivider;
    protected boolean draggingHW;
    protected int beginDragDividerLocation;
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke homeKey;
    protected KeyStroke endKey;
    protected KeyStroke dividerResizeToggleKey;
    protected ActionListener keyboardUpLeftListener;
    protected ActionListener keyboardDownRightListener;
    protected ActionListener keyboardHomeListener;
    protected ActionListener keyboardEndListener;
    protected ActionListener keyboardResizeToggleListener;
    private int orientation;
    private int lastDragLocation;
    private boolean continuousLayout;
    private boolean dividerKeyboardResize;
    private boolean dividerLocationIsSet;
    private boolean rememberPaneSizes;
    boolean painted;
    boolean ignoreDividerLocationChange;
    static /* synthetic */ Class class$javax$swing$JSplitPane;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSplitPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.splitPane = (JSplitPane)jComponent;
        this.dividerLocationIsSet = false;
        this.dividerKeyboardResize = false;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.setLastDragLocation(-1);
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.splitPane, "SplitPane.border");
        LookAndFeel.installColors(this.splitPane, "SplitPane.background", "SplitPane.foreground");
        if (this.divider == null) {
            this.divider = this.createDefaultDivider();
        }
        this.divider.setBasicSplitPaneUI(this);
        Border border = this.divider.getBorder();
        if (border == null || !(border instanceof UIResource)) {
            this.divider.setBorder(UIManager.getBorder("SplitPaneDivider.border"));
        }
        this.setOrientation(this.splitPane.getOrientation());
        this.splitPane.setDividerSize((Integer)UIManager.get("SplitPane.dividerSize"));
        this.divider.setDividerSize(this.splitPane.getDividerSize());
        this.dividerSize = this.divider.getDividerSize();
        this.splitPane.add((Component)this.divider, "divider");
        this.setContinuousLayout(this.splitPane.isContinuousLayout());
        this.resetLayoutManager();
        if (this.nonContinuousLayoutDivider == null) {
            this.setNonContinuousLayoutDivider(this.createDefaultNonContinuousLayoutDivider(), true);
        } else {
            this.setNonContinuousLayoutDivider(this.nonContinuousLayoutDivider, true);
        }
        if (managingFocusForwardTraversalKeys == null) {
            managingFocusForwardTraversalKeys = new TreeSet();
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        }
        this.splitPane.setFocusTraversalKeys(0, managingFocusForwardTraversalKeys);
        if (managingFocusBackwardTraversalKeys == null) {
            managingFocusBackwardTraversalKeys = new TreeSet();
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        }
        this.splitPane.setFocusTraversalKeys(1, managingFocusBackwardTraversalKeys);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.splitPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.splitPane.addFocusListener(this.focusListener);
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.splitPane, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.splitPane, actionMap);
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("SplitPane.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("SplitPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("SplitPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("negativeIncrement", new KeyboardUpLeftAction());
        actionMapUIResource.put("positiveIncrement", new KeyboardDownRightAction());
        actionMapUIResource.put("selectMin", new KeyboardHomeAction());
        actionMapUIResource.put("selectMax", new KeyboardEndAction());
        actionMapUIResource.put("startResize", new KeyboardResizeToggleAction());
        actionMapUIResource.put("toggleFocus", new ToggleSideFocusAction());
        actionMapUIResource.put("focusOutForward", new MoveFocusOutAction(1));
        actionMapUIResource.put("focusOutBackward", new MoveFocusOutAction(-1));
        return actionMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.dividerLocationIsSet = false;
        this.dividerKeyboardResize = false;
        this.splitPane = null;
    }

    protected void uninstallDefaults() {
        if (this.splitPane.getLayout() == this.layoutManager) {
            this.splitPane.setLayout(null);
        }
        if (this.nonContinuousLayoutDivider != null) {
            this.splitPane.remove(this.nonContinuousLayoutDivider);
        }
        LookAndFeel.uninstallBorder(this.splitPane);
        Border border = this.divider.getBorder();
        if (border instanceof UIResource) {
            this.divider.setBorder(null);
        }
        this.splitPane.remove(this.divider);
        this.divider.setBasicSplitPaneUI(null);
        this.layoutManager = null;
        this.divider = null;
        this.nonContinuousLayoutDivider = null;
        this.setNonContinuousLayoutDivider(null);
        this.splitPane.setFocusTraversalKeys(0, null);
        this.splitPane.setFocusTraversalKeys(1, null);
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.splitPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (this.focusListener != null) {
            this.splitPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        this.keyboardUpLeftListener = null;
        this.keyboardDownRightListener = null;
        this.keyboardHomeListener = null;
        this.keyboardEndListener = null;
        this.keyboardResizeToggleListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.splitPane, null);
        SwingUtilities.replaceUIInputMap(this.splitPane, 1, null);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ActionListener createKeyboardUpLeftListener() {
        return new KeyboardUpLeftHandler();
    }

    protected ActionListener createKeyboardDownRightListener() {
        return new KeyboardDownRightHandler();
    }

    protected ActionListener createKeyboardHomeListener() {
        return new KeyboardHomeHandler();
    }

    protected ActionListener createKeyboardEndListener() {
        return new KeyboardEndHandler();
    }

    protected ActionListener createKeyboardResizeToggleListener() {
        return new KeyboardResizeToggleHandler();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public void setContinuousLayout(boolean bl) {
        this.continuousLayout = bl;
    }

    public int getLastDragLocation() {
        return this.lastDragLocation;
    }

    public void setLastDragLocation(int n) {
        this.lastDragLocation = n;
    }

    int getKeyboardMoveIncrement() {
        return KEYBOARD_DIVIDER_MOVE_OFFSET;
    }

    public BasicSplitPaneDivider getDivider() {
        return this.divider;
    }

    protected Component createDefaultNonContinuousLayoutDivider() {
        return new Canvas(){

            public void paint(Graphics graphics) {
                if (!BasicSplitPaneUI.this.isContinuousLayout() && BasicSplitPaneUI.this.getLastDragLocation() != -1) {
                    Dimension dimension = BasicSplitPaneUI.this.splitPane.getSize();
                    graphics.setColor(Color.darkGray);
                    if (BasicSplitPaneUI.this.orientation == 1) {
                        graphics.fillRect(0, 0, BasicSplitPaneUI.this.dividerSize - 1, dimension.height - 1);
                    } else {
                        graphics.fillRect(0, 0, dimension.width - 1, BasicSplitPaneUI.this.dividerSize - 1);
                    }
                }
            }
        };
    }

    protected void setNonContinuousLayoutDivider(Component component) {
        this.setNonContinuousLayoutDivider(component, true);
    }

    protected void setNonContinuousLayoutDivider(Component component, boolean bl) {
        this.rememberPaneSizes = bl;
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            this.splitPane.remove(this.nonContinuousLayoutDivider);
        }
        this.nonContinuousLayoutDivider = component;
    }

    private void addHeavyweightDivider() {
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            Component component = this.splitPane.getLeftComponent();
            Component component2 = this.splitPane.getRightComponent();
            int n = this.splitPane.getDividerLocation();
            if (component != null) {
                this.splitPane.setLeftComponent(null);
            }
            if (component2 != null) {
                this.splitPane.setRightComponent(null);
            }
            this.splitPane.remove(this.divider);
            this.splitPane.add(this.nonContinuousLayoutDivider, NON_CONTINUOUS_DIVIDER, this.splitPane.getComponentCount());
            this.splitPane.setLeftComponent(component);
            this.splitPane.setRightComponent(component2);
            this.splitPane.add((Component)this.divider, "divider");
            if (this.rememberPaneSizes) {
                this.splitPane.setDividerLocation(n);
            }
        }
    }

    public Component getNonContinuousLayoutDivider() {
        return this.nonContinuousLayoutDivider;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public BasicSplitPaneDivider createDefaultDivider() {
        return new BasicSplitPaneDivider(this);
    }

    public void resetToPreferredSizes(JSplitPane jSplitPane) {
        if (this.splitPane != null) {
            this.layoutManager.resetToPreferredSizes();
            this.splitPane.revalidate();
            this.layoutManager.layoutContainer(this.splitPane);
            this.splitPane.repaint();
        }
    }

    public void setDividerLocation(JSplitPane jSplitPane, int n) {
        if (!this.ignoreDividerLocationChange) {
            this.dividerLocationIsSet = true;
            this.splitPane.revalidate();
            this.splitPane.repaint();
        } else {
            this.ignoreDividerLocationChange = false;
        }
    }

    public int getDividerLocation(JSplitPane jSplitPane) {
        if (this.orientation == 1) {
            return this.divider.getLocation().x;
        }
        return this.divider.getLocation().y;
    }

    public int getMinimumDividerLocation(JSplitPane jSplitPane) {
        int n = 0;
        Component component = this.splitPane.getLeftComponent();
        if (component != null && component.isVisible()) {
            Insets insets = this.splitPane.getInsets();
            Dimension dimension = component.getMinimumSize();
            n = this.orientation == 1 ? dimension.width : dimension.height;
            if (insets != null) {
                n = this.orientation == 1 ? (n += insets.left) : (n += insets.top);
            }
        }
        return n;
    }

    public int getMaximumDividerLocation(JSplitPane jSplitPane) {
        Dimension dimension = this.splitPane.getSize();
        int n = 0;
        Component component = this.splitPane.getRightComponent();
        if (component != null) {
            Insets insets = this.splitPane.getInsets();
            Dimension dimension2 = new Dimension(0, 0);
            if (component.isVisible()) {
                dimension2 = component.getMinimumSize();
            }
            n = this.orientation == 1 ? dimension.width - dimension2.width : dimension.height - dimension2.height;
            n -= this.dividerSize;
            if (insets != null) {
                n = this.orientation == 1 ? (n -= insets.right) : (n -= insets.top);
            }
        }
        return Math.max(this.getMinimumDividerLocation(this.splitPane), n);
    }

    public void finishedPaintingChildren(JSplitPane jSplitPane, Graphics graphics) {
        if (jSplitPane == this.splitPane && this.getLastDragLocation() != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            Dimension dimension = this.splitPane.getSize();
            graphics.setColor(Color.darkGray);
            if (this.orientation == 1) {
                graphics.fillRect(this.getLastDragLocation(), 0, this.dividerSize - 1, dimension.height - 1);
            } else {
                graphics.fillRect(0, this.lastDragLocation, dimension.width - 1, this.dividerSize - 1);
            }
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (!this.painted && this.splitPane.getDividerLocation() < 0) {
            this.ignoreDividerLocationChange = true;
            this.splitPane.setDividerLocation(this.getDividerLocation(this.splitPane));
        }
        this.painted = true;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.splitPane != null) {
            return this.layoutManager.preferredLayoutSize(this.splitPane);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.splitPane != null) {
            return this.layoutManager.minimumLayoutSize(this.splitPane);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.splitPane != null) {
            return this.layoutManager.maximumLayoutSize(this.splitPane);
        }
        return new Dimension(0, 0);
    }

    public Insets getInsets(JComponent jComponent) {
        return null;
    }

    protected void resetLayoutManager() {
        this.layoutManager = this.orientation == 1 ? new BasicHorizontalLayoutManager() : new BasicVerticalLayoutManager();
        this.splitPane.setLayout(this.layoutManager);
        this.layoutManager.updateComponents();
        this.splitPane.revalidate();
        this.splitPane.repaint();
    }

    protected void startDragging() {
        ComponentPeer componentPeer;
        Component component = this.splitPane.getLeftComponent();
        Component component2 = this.splitPane.getRightComponent();
        this.beginDragDividerLocation = this.getDividerLocation(this.splitPane);
        this.draggingHW = false;
        if (component != null && (componentPeer = component.getPeer()) != null && !(componentPeer instanceof LightweightPeer)) {
            this.draggingHW = true;
        } else if (component2 != null && (componentPeer = component2.getPeer()) != null && !(componentPeer instanceof LightweightPeer)) {
            this.draggingHW = true;
        }
        if (this.orientation == 1) {
            this.setLastDragLocation(this.divider.getBounds().x);
            this.dividerSize = this.divider.getSize().width;
            if (!this.isContinuousLayout() && this.draggingHW) {
                this.nonContinuousLayoutDivider.setBounds(this.getLastDragLocation(), 0, this.dividerSize, this.splitPane.getHeight());
                this.addHeavyweightDivider();
            }
        } else {
            this.setLastDragLocation(this.divider.getBounds().y);
            this.dividerSize = this.divider.getSize().height;
            if (!this.isContinuousLayout() && this.draggingHW) {
                this.nonContinuousLayoutDivider.setBounds(0, this.getLastDragLocation(), this.splitPane.getWidth(), this.dividerSize);
                this.addHeavyweightDivider();
            }
        }
    }

    protected void dragDividerTo(int n) {
        if (this.getLastDragLocation() != n) {
            if (this.isContinuousLayout()) {
                this.splitPane.setDividerLocation(n);
                this.setLastDragLocation(n);
            } else {
                int n2 = this.getLastDragLocation();
                this.setLastDragLocation(n);
                if (this.orientation == 1) {
                    if (this.draggingHW) {
                        this.nonContinuousLayoutDivider.setLocation(this.getLastDragLocation(), 0);
                    } else {
                        int n3 = this.splitPane.getHeight();
                        this.splitPane.repaint(n2, 0, this.dividerSize, n3);
                        this.splitPane.repaint(n, 0, this.dividerSize, n3);
                    }
                } else if (this.draggingHW) {
                    this.nonContinuousLayoutDivider.setLocation(0, this.getLastDragLocation());
                } else {
                    int n4 = this.splitPane.getWidth();
                    this.splitPane.repaint(0, n2, n4, this.dividerSize);
                    this.splitPane.repaint(0, n, n4, this.dividerSize);
                }
            }
        }
    }

    protected void finishDraggingTo(int n) {
        this.dragDividerTo(n);
        this.setLastDragLocation(-1);
        if (!this.isContinuousLayout()) {
            Component component = this.splitPane.getLeftComponent();
            Rectangle rectangle = component.getBounds();
            if (this.draggingHW) {
                if (this.orientation == 1) {
                    this.nonContinuousLayoutDivider.setLocation(-this.dividerSize, 0);
                } else {
                    this.nonContinuousLayoutDivider.setLocation(0, -this.dividerSize);
                }
                this.splitPane.remove(this.nonContinuousLayoutDivider);
            }
            this.splitPane.setDividerLocation(n);
        }
    }

    protected int getDividerBorderSize() {
        return 1;
    }

    public class BasicVerticalLayoutManager
    extends BasicHorizontalLayoutManager {
        public BasicVerticalLayoutManager() {
            super(1);
        }
    }

    public class BasicHorizontalLayoutManager
    implements LayoutManager2 {
        protected int[] sizes;
        protected Component[] components;
        private int lastSplitPaneSize;
        private boolean doReset;
        private int axis;

        BasicHorizontalLayoutManager() {
            this(0);
        }

        BasicHorizontalLayoutManager(int n) {
            this.axis = n;
            this.components = new Component[3];
            this.components[2] = null;
            this.components[1] = null;
            this.components[0] = null;
            this.sizes = new int[3];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            int n;
            Dimension dimension;
            Dimension dimension2 = container.getSize();
            if (dimension2.height <= 0 || dimension2.width <= 0) {
                this.lastSplitPaneSize = 0;
                return;
            }
            int n2 = BasicSplitPaneUI.this.splitPane.getDividerLocation();
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            int n3 = this.getAvailableSize(dimension2, insets);
            int n4 = this.getSizeForPrimaryAxis(dimension2);
            int n5 = BasicSplitPaneUI.this.getDividerLocation(BasicSplitPaneUI.this.splitPane);
            int n6 = this.getSizeForPrimaryAxis(insets, true);
            Dimension dimension3 = dimension = this.components[2] == null ? null : this.components[2].getPreferredSize();
            if (this.doReset && !BasicSplitPaneUI.this.dividerLocationIsSet || n2 < 0) {
                this.resetToPreferredSizes(n3);
            } else if (this.lastSplitPaneSize <= 0 || n3 == this.lastSplitPaneSize || !BasicSplitPaneUI.this.painted || dimension != null && this.getSizeForPrimaryAxis(dimension) != this.sizes[2]) {
                this.sizes[2] = dimension != null ? this.getSizeForPrimaryAxis(dimension) : 0;
                this.setDividerLocation(n2 - n6, n3);
                BasicSplitPaneUI.this.dividerLocationIsSet = false;
            } else if (n3 != this.lastSplitPaneSize) {
                this.distributeSpace(n3 - this.lastSplitPaneSize, true);
            }
            this.doReset = false;
            BasicSplitPaneUI.this.dividerLocationIsSet = false;
            this.lastSplitPaneSize = n3;
            int n7 = this.getInitialLocation(insets);
            int n8 = 0;
            while (n8 < 3) {
                if (this.components[n8] != null && this.components[n8].isVisible()) {
                    this.setComponentToSize(this.components[n8], this.sizes[n8], n7, insets, dimension2);
                    n7 += this.sizes[n8];
                }
                switch (n8) {
                    case 0: {
                        n8 = 2;
                        break;
                    }
                    case 2: {
                        n8 = 1;
                        break;
                    }
                    case 1: {
                        n8 = 3;
                    }
                }
            }
            if (BasicSplitPaneUI.this.painted && (n = BasicSplitPaneUI.this.getDividerLocation(BasicSplitPaneUI.this.splitPane)) != n2 - n6) {
                int n9 = BasicSplitPaneUI.this.splitPane.getLastDividerLocation();
                BasicSplitPaneUI.this.ignoreDividerLocationChange = true;
                try {
                    BasicSplitPaneUI.this.splitPane.setDividerLocation(n);
                    BasicSplitPaneUI.this.splitPane.setLastDividerLocation(n9);
                }
                finally {
                    BasicSplitPaneUI.this.ignoreDividerLocationChange = false;
                }
            }
        }

        public void addLayoutComponent(String string, Component component) {
            boolean bl = true;
            if (string != null) {
                if (string.equals("divider")) {
                    this.components[2] = component;
                    this.sizes[2] = this.getSizeForPrimaryAxis(component.getPreferredSize());
                } else if (string.equals("left") || string.equals("top")) {
                    this.components[0] = component;
                    this.sizes[0] = 0;
                } else if (string.equals("right") || string.equals("bottom")) {
                    this.components[1] = component;
                    this.sizes[1] = 0;
                } else if (!string.equals(BasicSplitPaneUI.NON_CONTINUOUS_DIVIDER)) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (!bl) {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
            }
            this.doReset = true;
        }

        public Dimension minimumLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            for (int i = 0; i < 3; ++i) {
                if (this.components[i] == null) continue;
                Dimension dimension = this.components[i].getMinimumSize();
                int n3 = this.getSizeForSecondaryAxis(dimension);
                n += this.getSizeForPrimaryAxis(dimension);
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (insets != null) {
                n += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                n2 += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
            if (this.axis == 0) {
                return new Dimension(n, n2);
            }
            return new Dimension(n2, n);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            for (int i = 0; i < 3; ++i) {
                if (this.components[i] == null) continue;
                Dimension dimension = this.components[i].getPreferredSize();
                int n3 = this.getSizeForSecondaryAxis(dimension);
                n += this.getSizeForPrimaryAxis(dimension);
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (insets != null) {
                n += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                n2 += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
            if (this.axis == 0) {
                return new Dimension(n, n2);
            }
            return new Dimension(n2, n);
        }

        public void removeLayoutComponent(Component component) {
            for (int i = 0; i < 3; ++i) {
                if (this.components[i] != component) continue;
                this.components[i] = null;
                this.sizes[i] = 0;
                this.doReset = true;
            }
        }

        public void addLayoutComponent(Component component, Object object) {
            if (object != null && !(object instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)object, component);
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }

        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public void resetToPreferredSizes() {
            this.doReset = true;
        }

        protected void resetSizeAt(int n) {
            this.sizes[n] = 0;
            this.doReset = true;
        }

        protected void setSizes(int[] nArray) {
            System.arraycopy(nArray, 0, this.sizes, 0, 3);
        }

        protected int[] getSizes() {
            int[] nArray = new int[3];
            System.arraycopy(this.sizes, 0, nArray, 0, 3);
            return nArray;
        }

        protected int getPreferredSizeOfComponent(Component component) {
            return this.getSizeForPrimaryAxis(component.getPreferredSize());
        }

        int getMinimumSizeOfComponent(Component component) {
            return this.getSizeForPrimaryAxis(component.getMinimumSize());
        }

        protected int getSizeOfComponent(Component component) {
            return this.getSizeForPrimaryAxis(component.getSize());
        }

        protected int getAvailableSize(Dimension dimension, Insets insets) {
            if (insets == null) {
                return this.getSizeForPrimaryAxis(dimension);
            }
            return this.getSizeForPrimaryAxis(dimension) - (this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false));
        }

        protected int getInitialLocation(Insets insets) {
            if (insets != null) {
                return this.getSizeForPrimaryAxis(insets, true);
            }
            return 0;
        }

        protected void setComponentToSize(Component component, int n, int n2, Insets insets, Dimension dimension) {
            if (insets != null) {
                if (this.axis == 0) {
                    component.setBounds(n2, insets.top, n, dimension.height - (insets.top + insets.bottom));
                } else {
                    component.setBounds(insets.left, n2, dimension.width - (insets.left + insets.right), n);
                }
            } else if (this.axis == 0) {
                component.setBounds(n2, 0, n, dimension.height);
            } else {
                component.setBounds(0, n2, dimension.width, n);
            }
        }

        int getSizeForPrimaryAxis(Dimension dimension) {
            if (this.axis == 0) {
                return dimension.width;
            }
            return dimension.height;
        }

        int getSizeForSecondaryAxis(Dimension dimension) {
            if (this.axis == 0) {
                return dimension.height;
            }
            return dimension.width;
        }

        int getSizeForPrimaryAxis(Insets insets, boolean bl) {
            if (this.axis == 0) {
                if (bl) {
                    return insets.left;
                }
                return insets.right;
            }
            if (bl) {
                return insets.top;
            }
            return insets.bottom;
        }

        int getSizeForSecondaryAxis(Insets insets, boolean bl) {
            if (this.axis == 0) {
                if (bl) {
                    return insets.top;
                }
                return insets.bottom;
            }
            if (bl) {
                return insets.left;
            }
            return insets.right;
        }

        protected void updateComponents() {
            Component component = BasicSplitPaneUI.this.splitPane.getLeftComponent();
            if (this.components[0] != component) {
                this.components[0] = component;
                this.sizes[0] = component == null ? 0 : -1;
            }
            if (this.components[1] != (component = BasicSplitPaneUI.this.splitPane.getRightComponent())) {
                this.components[1] = component;
                this.sizes[1] = component == null ? 0 : -1;
            }
            Component[] componentArray = BasicSplitPaneUI.this.splitPane.getComponents();
            Component component2 = this.components[2];
            this.components[2] = null;
            for (int i = componentArray.length - 1; i >= 0; --i) {
                if (componentArray[i] == this.components[0] || componentArray[i] == this.components[1] || componentArray[i] == BasicSplitPaneUI.this.nonContinuousLayoutDivider) continue;
                if (component2 != componentArray[i]) {
                    this.components[2] = componentArray[i];
                    break;
                }
                this.components[2] = component2;
                break;
            }
            this.sizes[2] = this.components[2] == null ? 0 : this.getSizeForPrimaryAxis(this.components[2].getPreferredSize());
        }

        void setDividerLocation(int n, int n2) {
            boolean bl = this.components[0] != null && this.components[0].isVisible();
            boolean bl2 = this.components[1] != null && this.components[1].isVisible();
            boolean bl3 = this.components[2] != null && this.components[2].isVisible();
            int n3 = n2;
            if (bl3) {
                n3 -= this.sizes[2];
            }
            n = Math.max(0, Math.min(n, n3));
            if (bl) {
                if (bl2) {
                    this.sizes[0] = n;
                    this.sizes[1] = n3 - n;
                } else {
                    this.sizes[0] = n3;
                    this.sizes[1] = 0;
                }
            } else if (bl2) {
                this.sizes[1] = n3;
                this.sizes[0] = 0;
            }
        }

        int[] getPreferredSizes() {
            int[] nArray = new int[3];
            for (int i = 0; i < 3; ++i) {
                nArray[i] = this.components[i] != null && this.components[i].isVisible() ? this.getPreferredSizeOfComponent(this.components[i]) : -1;
            }
            return nArray;
        }

        int[] getMinimumSizes() {
            int[] nArray = new int[3];
            for (int i = 0; i < 2; ++i) {
                nArray[i] = this.components[i] != null && this.components[i].isVisible() ? this.getMinimumSizeOfComponent(this.components[i]) : -1;
            }
            nArray[2] = this.components[2] != null ? this.getMinimumSizeOfComponent(this.components[2]) : -1;
            return nArray;
        }

        void resetToPreferredSizes(int n) {
            int n2;
            int[] nArray = this.getPreferredSizes();
            int n3 = 0;
            for (n2 = 0; n2 < 3; ++n2) {
                if (nArray[n2] == -1) continue;
                n3 += nArray[n2];
            }
            if (n3 > n) {
                nArray = this.getMinimumSizes();
                n3 = 0;
                for (n2 = 0; n2 < 3; ++n2) {
                    if (nArray[n2] == -1) continue;
                    n3 += nArray[n2];
                }
            }
            this.setSizes(nArray);
            this.distributeSpace(n - n3, false);
        }

        void distributeSpace(int n, boolean bl) {
            boolean bl2;
            boolean bl3 = this.components[0] != null && this.components[0].isVisible();
            boolean bl4 = bl2 = this.components[1] != null && this.components[1].isVisible();
            if (bl) {
                if (bl3 && this.getSizeForPrimaryAxis(this.components[0].getSize()) == 0) {
                    bl3 = false;
                    if (bl2 && this.getSizeForPrimaryAxis(this.components[1].getSize()) == 0) {
                        bl3 = true;
                    }
                } else if (bl2 && this.getSizeForPrimaryAxis(this.components[1].getSize()) == 0) {
                    bl2 = false;
                }
            }
            if (bl3 && bl2) {
                boolean bl5;
                double d = BasicSplitPaneUI.this.splitPane.getResizeWeight();
                int n2 = (int)(d * (double)n);
                int n3 = n - n2;
                this.sizes[0] = this.sizes[0] + n2;
                this.sizes[1] = this.sizes[1] + n3;
                int n4 = this.getMinimumSizeOfComponent(this.components[0]);
                int n5 = this.getMinimumSizeOfComponent(this.components[1]);
                boolean bl6 = this.sizes[0] >= n4;
                boolean bl7 = bl5 = this.sizes[1] >= n5;
                if (!bl6 && !bl5) {
                    if (this.sizes[0] < 0) {
                        this.sizes[1] = this.sizes[1] + this.sizes[0];
                        this.sizes[0] = 0;
                    } else if (this.sizes[1] < 0) {
                        this.sizes[0] = this.sizes[0] + this.sizes[1];
                        this.sizes[1] = 0;
                    }
                } else if (!bl6) {
                    if (this.sizes[1] - (n4 - this.sizes[0]) < n5) {
                        if (this.sizes[0] < 0) {
                            this.sizes[1] = this.sizes[1] + this.sizes[0];
                            this.sizes[0] = 0;
                        }
                    } else {
                        this.sizes[1] = this.sizes[1] - (n4 - this.sizes[0]);
                        this.sizes[0] = n4;
                    }
                } else if (!bl5) {
                    if (this.sizes[0] - (n5 - this.sizes[1]) < n4) {
                        if (this.sizes[1] < 0) {
                            this.sizes[0] = this.sizes[0] + this.sizes[1];
                            this.sizes[1] = 0;
                        }
                    } else {
                        this.sizes[0] = this.sizes[0] - (n5 - this.sizes[1]);
                        this.sizes[1] = n5;
                    }
                }
                if (this.sizes[0] < 0) {
                    this.sizes[0] = 0;
                }
                if (this.sizes[1] < 0) {
                    this.sizes[1] = 0;
                }
            } else if (bl3) {
                this.sizes[0] = Math.max(0, this.sizes[0] + n);
            } else if (bl2) {
                this.sizes[1] = Math.max(0, this.sizes[1] + n);
            }
        }
    }

    static class MoveFocusOutAction
    extends AbstractAction {
        private int direction;

        public MoveFocusOutAction(int n) {
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            Container container = jSplitPane.getFocusCycleRootAncestor();
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            Component component = this.direction > 0 ? focusTraversalPolicy.getComponentAfter(container, jSplitPane) : focusTraversalPolicy.getComponentBefore(container, jSplitPane);
            HashSet<Component> hashSet = new HashSet<Component>();
            if (jSplitPane.isAncestorOf(component)) {
                do {
                    hashSet.add(component);
                    container = component.getFocusCycleRootAncestor();
                    focusTraversalPolicy = container.getFocusTraversalPolicy();
                    Component component2 = component = this.direction > 0 ? focusTraversalPolicy.getComponentAfter(container, component) : focusTraversalPolicy.getComponentBefore(container, component);
                } while (jSplitPane.isAncestorOf(component) && !hashSet.contains(component));
            }
            if (component != null && !jSplitPane.isAncestorOf(component)) {
                component.requestFocus();
            }
        }
    }

    static class ToggleSideFocusAction
    extends AbstractAction {
        ToggleSideFocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            Component component = jSplitPane.getLeftComponent();
            Component component2 = jSplitPane.getRightComponent();
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component3 = keyboardFocusManager.getFocusOwner();
            Component component4 = this.getNextSide(jSplitPane, component3);
            if (component4 != null) {
                if (component3 != null && (SwingUtilities.isDescendingFrom(component3, component) && SwingUtilities.isDescendingFrom(component4, component) || SwingUtilities.isDescendingFrom(component3, component2) && SwingUtilities.isDescendingFrom(component4, component2))) {
                    return;
                }
                BasicLookAndFeel.compositeRequestFocus(component4);
            }
        }

        private Component getNextSide(JSplitPane jSplitPane, Component component) {
            Component component2 = jSplitPane.getLeftComponent();
            Component component3 = jSplitPane.getRightComponent();
            Component component4 = null;
            if (component != null && SwingUtilities.isDescendingFrom(component, component2) && component3 != null && (component4 = this.getFirstAvailableComponent(component3)) != null) {
                return component4;
            }
            JSplitPane jSplitPane2 = (JSplitPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = BasicSplitPaneUI.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane, jSplitPane);
            if (jSplitPane2 != null) {
                component4 = this.getNextSide(jSplitPane2, component);
            } else {
                component4 = this.getFirstAvailableComponent(component2);
                if (component4 == null) {
                    component4 = this.getFirstAvailableComponent(component3);
                }
            }
            return component4;
        }

        private Component getFirstAvailableComponent(Component component) {
            if (component != null && component instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)component;
                Component component2 = this.getFirstAvailableComponent(jSplitPane.getLeftComponent());
                component = component2 != null ? component2 : this.getFirstAvailableComponent(jSplitPane.getRightComponent());
            }
            return component;
        }
    }

    static class KeyboardResizeToggleAction
    extends AbstractAction {
        KeyboardResizeToggleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            BasicSplitPaneUI basicSplitPaneUI = (BasicSplitPaneUI)jSplitPane.getUI();
            if (!basicSplitPaneUI.dividerKeyboardResize) {
                jSplitPane.requestFocus();
            } else {
                JSplitPane jSplitPane2 = (JSplitPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = BasicSplitPaneUI.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane, jSplitPane);
                if (jSplitPane2 != null) {
                    jSplitPane2.requestFocus();
                }
            }
        }
    }

    public class KeyboardResizeToggleHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BasicSplitPaneUI.this.dividerKeyboardResize) {
                BasicSplitPaneUI.this.splitPane.requestFocus();
            }
        }
    }

    static class KeyboardEndAction
    extends AbstractAction {
        KeyboardEndAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            BasicSplitPaneUI basicSplitPaneUI = (BasicSplitPaneUI)jSplitPane.getUI();
            if (basicSplitPaneUI.dividerKeyboardResize) {
                int n;
                Insets insets = jSplitPane.getInsets();
                int n2 = insets != null ? insets.bottom : 0;
                int n3 = n = insets != null ? insets.right : 0;
                if (basicSplitPaneUI.orientation == 0) {
                    if (jSplitPane.getDividerLocation() >= jSplitPane.getHeight() - n2 - jSplitPane.getDividerSize()) {
                        jSplitPane.setDividerLocation(jSplitPane.getLastDividerLocation());
                    } else {
                        jSplitPane.setDividerLocation(jSplitPane.getHeight() - n2);
                    }
                } else if (jSplitPane.getDividerLocation() >= jSplitPane.getWidth() - n - jSplitPane.getDividerSize()) {
                    jSplitPane.setDividerLocation(jSplitPane.getLastDividerLocation());
                } else {
                    jSplitPane.setDividerLocation(jSplitPane.getWidth() - n);
                }
            }
        }
    }

    public class KeyboardEndHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicSplitPaneUI.this.dividerKeyboardResize) {
                int n;
                Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
                int n2 = insets != null ? insets.bottom : 0;
                int n3 = n = insets != null ? insets.right : 0;
                if (BasicSplitPaneUI.this.orientation == 0) {
                    if (BasicSplitPaneUI.this.splitPane.getDividerLocation() >= BasicSplitPaneUI.this.splitPane.getHeight() - n2 - BasicSplitPaneUI.this.splitPane.getDividerSize()) {
                        BasicSplitPaneUI.this.splitPane.setDividerLocation(BasicSplitPaneUI.this.splitPane.getLastDividerLocation());
                    } else {
                        BasicSplitPaneUI.this.splitPane.setDividerLocation(BasicSplitPaneUI.this.splitPane.getHeight() - n2);
                    }
                } else if (BasicSplitPaneUI.this.splitPane.getDividerLocation() >= BasicSplitPaneUI.this.splitPane.getWidth() - n - BasicSplitPaneUI.this.splitPane.getDividerSize()) {
                    BasicSplitPaneUI.this.splitPane.setDividerLocation(BasicSplitPaneUI.this.splitPane.getLastDividerLocation());
                } else {
                    BasicSplitPaneUI.this.splitPane.setDividerLocation(BasicSplitPaneUI.this.splitPane.getWidth() - n);
                }
            }
        }
    }

    static class KeyboardHomeAction
    extends AbstractAction {
        KeyboardHomeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            BasicSplitPaneUI basicSplitPaneUI = (BasicSplitPaneUI)jSplitPane.getUI();
            if (basicSplitPaneUI.dividerKeyboardResize) {
                if (jSplitPane.getDividerLocation() <= 1) {
                    jSplitPane.setDividerLocation(jSplitPane.getLastDividerLocation());
                } else {
                    jSplitPane.setDividerLocation(0);
                }
            }
        }
    }

    public class KeyboardHomeHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicSplitPaneUI.this.dividerKeyboardResize) {
                if (BasicSplitPaneUI.this.splitPane.getDividerLocation() <= 1) {
                    BasicSplitPaneUI.this.splitPane.setDividerLocation(BasicSplitPaneUI.this.splitPane.getLastDividerLocation());
                } else {
                    BasicSplitPaneUI.this.splitPane.setDividerLocation(0);
                }
            }
        }
    }

    static class KeyboardDownRightAction
    extends AbstractAction {
        KeyboardDownRightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            BasicSplitPaneUI basicSplitPaneUI = (BasicSplitPaneUI)jSplitPane.getUI();
            if (basicSplitPaneUI.dividerKeyboardResize) {
                JComponent jComponent;
                Component component = jSplitPane.getTopComponent();
                Component component2 = jSplitPane.getBottomComponent();
                if (basicSplitPaneUI.orientation == 0 ? component.getMinimumSize().height + component2.getMinimumSize().height > jSplitPane.getHeight() : component.getMinimumSize().width + component2.getMinimumSize().width > jSplitPane.getWidth()) {
                    return;
                }
                if (jSplitPane.getBottomComponent() instanceof JComponent && (jComponent = (JComponent)jSplitPane.getBottomComponent()).isMinimumSizeSet() && basicSplitPaneUI.getDividerLocation(jSplitPane) + basicSplitPaneUI.getKeyboardMoveIncrement() > jSplitPane.getMaximumDividerLocation()) {
                    return;
                }
                jSplitPane.setDividerLocation(basicSplitPaneUI.getDividerLocation(jSplitPane) + basicSplitPaneUI.getKeyboardMoveIncrement());
            }
        }
    }

    public class KeyboardDownRightHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicSplitPaneUI.this.dividerKeyboardResize) {
                BasicSplitPaneUI.this.splitPane.setDividerLocation(BasicSplitPaneUI.this.getDividerLocation(BasicSplitPaneUI.this.splitPane) + BasicSplitPaneUI.this.getKeyboardMoveIncrement());
            }
        }
    }

    static class KeyboardUpLeftAction
    extends AbstractAction {
        KeyboardUpLeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            BasicSplitPaneUI basicSplitPaneUI = (BasicSplitPaneUI)jSplitPane.getUI();
            if (basicSplitPaneUI.dividerKeyboardResize) {
                JComponent jComponent;
                if (jSplitPane.getTopComponent() instanceof JComponent && (jComponent = (JComponent)jSplitPane.getTopComponent()).isMinimumSizeSet() && basicSplitPaneUI.getDividerLocation(jSplitPane) - basicSplitPaneUI.getKeyboardMoveIncrement() < jSplitPane.getMinimumDividerLocation()) {
                    return;
                }
                jSplitPane.setDividerLocation(Math.max(0, basicSplitPaneUI.getDividerLocation(jSplitPane) - basicSplitPaneUI.getKeyboardMoveIncrement()));
            }
        }
    }

    public class KeyboardUpLeftHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicSplitPaneUI.this.dividerKeyboardResize) {
                BasicSplitPaneUI.this.splitPane.setDividerLocation(Math.max(0, BasicSplitPaneUI.this.getDividerLocation(BasicSplitPaneUI.this.splitPane) - BasicSplitPaneUI.this.getKeyboardMoveIncrement()));
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
            BasicSplitPaneUI.this.dividerKeyboardResize = true;
            BasicSplitPaneUI.this.splitPane.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicSplitPaneUI.this.dividerKeyboardResize = false;
            BasicSplitPaneUI.this.splitPane.repaint();
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicSplitPaneUI.this.splitPane) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("orientation")) {
                    BasicSplitPaneUI.this.orientation = BasicSplitPaneUI.this.splitPane.getOrientation();
                    BasicSplitPaneUI.this.resetLayoutManager();
                } else if (string.equals("continuousLayout")) {
                    BasicSplitPaneUI.this.setContinuousLayout(BasicSplitPaneUI.this.splitPane.isContinuousLayout());
                    if (!BasicSplitPaneUI.this.isContinuousLayout()) {
                        if (BasicSplitPaneUI.this.nonContinuousLayoutDivider == null) {
                            BasicSplitPaneUI.this.setNonContinuousLayoutDivider(BasicSplitPaneUI.this.createDefaultNonContinuousLayoutDivider(), true);
                        } else if (BasicSplitPaneUI.this.nonContinuousLayoutDivider.getParent() == null) {
                            BasicSplitPaneUI.this.setNonContinuousLayoutDivider(BasicSplitPaneUI.this.nonContinuousLayoutDivider, true);
                        }
                    }
                } else if (string.equals("dividerSize")) {
                    BasicSplitPaneUI.this.divider.setDividerSize(BasicSplitPaneUI.this.splitPane.getDividerSize());
                    BasicSplitPaneUI.this.dividerSize = BasicSplitPaneUI.this.divider.getDividerSize();
                    BasicSplitPaneUI.this.splitPane.revalidate();
                    BasicSplitPaneUI.this.splitPane.repaint();
                }
            }
        }
    }
}

