/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import com.ibm.swing.ArrowKeyAction;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class ButtonGroup
implements Serializable {
    protected Vector buttons = new Vector();
    ButtonModel selection = null;

    public void add(AbstractButton abstractButton) {
        ActionMap actionMap;
        if (abstractButton == null) {
            return;
        }
        this.buttons.addElement(abstractButton);
        if (abstractButton.isSelected()) {
            if (this.selection == null) {
                this.selection = abstractButton.getModel();
            } else {
                abstractButton.setSelected(false);
            }
        }
        abstractButton.getModel().setGroup(this);
        if (abstractButton instanceof JToggleButton && (actionMap = SwingUtilities.getUIActionMap(abstractButton)) != null) {
            actionMap.put("up", new ArrowKeyAction(1));
            actionMap.put("down", new ArrowKeyAction(5));
            actionMap.put("left", new ArrowKeyAction(7));
            actionMap.put("right", new ArrowKeyAction(3));
        }
    }

    public void remove(AbstractButton abstractButton) {
        ActionMap actionMap;
        if (abstractButton == null) {
            return;
        }
        this.buttons.removeElement(abstractButton);
        if (abstractButton.getModel() == this.selection) {
            this.selection = null;
        }
        abstractButton.getModel().setGroup(null);
        if (abstractButton instanceof JToggleButton && (actionMap = SwingUtilities.getUIActionMap(abstractButton)) != null) {
            actionMap.remove("up");
            actionMap.remove("down");
            actionMap.remove("left");
            actionMap.remove("right");
        }
    }

    public Enumeration getElements() {
        return this.buttons.elements();
    }

    public ButtonModel getSelection() {
        return this.selection;
    }

    public void setSelected(ButtonModel buttonModel, boolean bl) {
        if (bl && buttonModel != null && buttonModel != this.selection) {
            ButtonModel buttonModel2 = this.selection;
            this.selection = buttonModel;
            if (buttonModel2 != null) {
                buttonModel2.setSelected(false);
            }
            buttonModel.setSelected(true);
        }
    }

    public boolean isSelected(ButtonModel buttonModel) {
        return buttonModel == this.selection;
    }

    public int getButtonCount() {
        if (this.buttons == null) {
            return 0;
        }
        return this.buttons.size();
    }
}

