/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

public class AudioFormat {
    protected Encoding encoding;
    protected float sampleRate;
    protected int sampleSizeInBits;
    protected int channels;
    protected int frameSize;
    protected float frameRate;
    protected boolean bigEndian;

    public AudioFormat(Encoding encoding, float f, int n, int n2, int n3, float f2, boolean bl) {
        this.encoding = encoding;
        this.sampleRate = f;
        this.sampleSizeInBits = n;
        this.channels = n2;
        this.frameSize = n3;
        this.frameRate = f2;
        this.bigEndian = bl;
    }

    public AudioFormat(float f, int n, int n2, boolean bl, boolean bl2) {
        this(bl ? Encoding.PCM_SIGNED : Encoding.PCM_UNSIGNED, f, n, n2, n2 == -1 || n == -1 ? -1 : (n + 7) / 8 * n2, f, bl2);
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public boolean matches(AudioFormat audioFormat) {
        return !(audioFormat.getEncoding() != this.getEncoding() || audioFormat.getSampleRate() != -1.0f && audioFormat.getSampleRate() != this.getSampleRate() || audioFormat.getSampleSizeInBits() != this.getSampleSizeInBits() || audioFormat.getChannels() != this.getChannels() || audioFormat.getFrameSize() != this.getFrameSize() || audioFormat.getFrameRate() != -1.0f && audioFormat.getFrameRate() != this.getFrameRate() || audioFormat.getSampleSizeInBits() > 8 && audioFormat.isBigEndian() != this.isBigEndian());
    }

    public String toString() {
        return this.getEncoding() + ", " + this.sampleRate + " Hz, " + this.sampleSizeInBits + " bit, " + (this.channels == 2 ? "stereo, " : "mono, ") + (this.sampleSizeInBits > 8 ? (this.bigEndian ? "big-endian, " : "little-endian, ") : "") + "audio data";
    }

    public static class Encoding {
        public static final Encoding PCM_SIGNED = new Encoding("PCM_SIGNED");
        public static final Encoding PCM_UNSIGNED = new Encoding("PCM_UNSIGNED");
        public static final Encoding ULAW = new Encoding("ULAW");
        public static final Encoding ALAW = new Encoding("ALAW");
        private String name;

        protected Encoding(String string) {
            this.name = string;
        }

        public final boolean equals(Object object) {
            return super.equals(object);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }
}

