/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;

abstract class SunCodec
extends FormatConversionProvider {
    private static SunCodec[] codecs;
    AudioFormat.Encoding[] inputEncodings;
    AudioFormat.Encoding[] outputEncodings;
    private static final String[] codecClassNames;

    protected SunCodec(AudioFormat.Encoding[] encodingArray, AudioFormat.Encoding[] encodingArray2) {
        this.inputEncodings = encodingArray;
        this.outputEncodings = encodingArray2;
    }

    public AudioFormat.Encoding[] getSourceEncodings() {
        AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[this.inputEncodings.length];
        System.arraycopy(this.inputEncodings, 0, encodingArray, 0, this.inputEncodings.length);
        return encodingArray;
    }

    public AudioFormat.Encoding[] getTargetEncodings() {
        AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[this.outputEncodings.length];
        System.arraycopy(this.outputEncodings, 0, encodingArray, 0, this.outputEncodings.length);
        return encodingArray;
    }

    public abstract AudioFormat.Encoding[] getTargetEncodings(AudioFormat var1);

    public abstract AudioFormat[] getTargetFormats(AudioFormat.Encoding var1, AudioFormat var2);

    public abstract AudioInputStream getAudioInputStream(AudioFormat.Encoding var1, AudioInputStream var2);

    public abstract AudioInputStream getAudioInputStream(AudioFormat var1, AudioInputStream var2);

    static int getNumCodecs() {
        return codecs.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SunCodec getCodec(int n) {
        SunCodec[] sunCodecArray = codecs;
        synchronized (codecs) {
            try {
                if (codecs[n] == null) {
                    Class<?> clazz = Class.forName(codecClassNames[n]);
                    SunCodec.codecs[n] = (SunCodec)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return codecs[n];
        }
    }

    static {
        codecClassNames = new String[]{"com.sun.media.sound.UlawCodec", "com.sun.media.sound.AlawCodec"};
        codecs = new SunCodec[codecClassNames.length];
    }
}

