/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.FastShortMessage;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;

class SMFParser {
    private static final int MTrk_MAGIC = 1297379947;
    int tracks;
    private InputStream stream;
    private int trackLength = 0;
    private byte[] trackData = null;
    private int pos = 0;

    public SMFParser(InputStream inputStream) {
        this.stream = inputStream;
    }

    public int readUnsigned() throws IOException {
        return this.trackData[this.pos++] & 0xFF;
    }

    private int readInt() throws IOException {
        int n = this.stream.read() << 24;
        int n2 = this.stream.read() << 16;
        int n3 = this.stream.read() << 8;
        int n4 = this.stream.read();
        if (n4 < 0) {
            throw new EOFException();
        }
        return n | n2 | n3 | n4;
    }

    public void read(byte[] byArray) throws IOException {
        System.arraycopy(this.trackData, this.pos, byArray, 0, byArray.length);
        this.pos += byArray.length;
    }

    public long readVarInt() throws IOException {
        long l = 0L;
        int n = 0;
        do {
            n = this.trackData[this.pos++] & 0xFF;
            l = (l << 7) + (long)(n & 0x7F);
        } while ((n & 0x80) != 0);
        return l;
    }

    public void nextTrack() throws IOException, InvalidMidiDataException {
        int n;
        this.trackLength = 0;
        do {
            if (this.stream.skip(this.trackLength) != (long)this.trackLength) {
                throw new EOFException();
            }
            n = this.readInt();
            this.trackLength = this.readInt();
        } while (n != 1297379947);
        this.trackData = new byte[this.trackLength];
        if (this.stream.read(this.trackData) != this.trackLength) {
            throw new EOFException();
        }
        this.pos = 0;
    }

    public boolean trackFinished() {
        return this.pos >= this.trackLength;
    }

    public void readTrack(Track track) throws IOException, InvalidMidiDataException {
        try {
            long l = 0L;
            int n = 0;
            boolean bl = false;
            while (!this.trackFinished() && !bl) {
                MidiMessage midiMessage;
                int n2 = -1;
                int n3 = 0;
                l += this.readVarInt();
                int n4 = this.readUnsigned();
                if (n4 >= 128) {
                    n = n4;
                } else {
                    n2 = n4;
                }
                block1 : switch (n & 0xF0) {
                    case 128: 
                    case 144: 
                    case 160: 
                    case 176: 
                    case 224: {
                        if (n2 == -1) {
                            n2 = this.readUnsigned();
                        }
                        n3 = this.readUnsigned();
                        midiMessage = new FastShortMessage(n | n2 << 8 | n3 << 16);
                        break;
                    }
                    case 192: 
                    case 208: {
                        if (n2 == -1) {
                            n2 = this.readUnsigned();
                        }
                        midiMessage = new FastShortMessage(n | n2 << 8);
                        break;
                    }
                    case 240: {
                        switch (n) {
                            case 240: 
                            case 247: {
                                int n5 = (int)this.readVarInt();
                                byte[] byArray = new byte[n5];
                                this.read(byArray);
                                SysexMessage sysexMessage = new SysexMessage();
                                sysexMessage.setMessage(n, byArray, n5);
                                midiMessage = sysexMessage;
                                break block1;
                            }
                            case 255: {
                                int n6 = this.readUnsigned();
                                int n7 = (int)this.readVarInt();
                                byte[] byArray = new byte[n7];
                                this.read(byArray);
                                MetaMessage metaMessage = new MetaMessage();
                                metaMessage.setMessage(n6, byArray, n7);
                                midiMessage = metaMessage;
                                if (n6 != 47) break block1;
                                bl = true;
                                break block1;
                            }
                            default: {
                                throw new InvalidMidiDataException("Invalid status byte: " + n);
                            }
                        }
                    }
                    default: {
                        throw new InvalidMidiDataException("Invalid status byte: " + n);
                    }
                }
                track.add(new MidiEvent(midiMessage, l));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EOFException();
        }
    }
}

