/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import java.lang.reflect.Method;
import java.util.Hashtable;

class NetscapeSecurity
implements JSSecurity {
    static final String name = "NetscapeSecurity";
    static JSSecurity security;
    private static Method enablePrivilege;
    private static Class privilegeManager;
    private static Object[] readPropArgs;
    private static Object[] readFileArgs;
    private static Object[] writeFileArgs;
    private static Object[] deleteFileArgs;
    private static Object[] threadArgs;
    private static Object[] threadGroupArgs;
    private static Object[] linkArgs;
    private static Object[] connectArgs;
    private static Object[] windowArgs;
    private static Object[] multicastArgs;
    private static Hashtable table;
    private Method[] methodArray = new Method[1];
    private Class[] classArray = new Class[1];
    private Object[][] arguments = new Object[1][0];

    private NetscapeSecurity() {
    }

    public String getName() {
        return name;
    }

    public void requestPermission(Method[] methodArray, Class[] classArray, Object[][] objectArray, int n) throws SecurityException {
        if (enablePrivilege == null) {
            throw new SecurityException("Cannot request permission");
        }
        methodArray[0] = enablePrivilege;
        classArray[0] = privilegeManager;
        Object v = table.get(new Integer(n));
        if (v == null) {
            throw new SecurityException("Unknown request " + n);
        }
        objectArray[0] = (Object[])v;
    }

    public void requestPermission(Method[] methodArray, Class[] classArray, Object[][] objectArray, int n, String string) throws SecurityException {
        this.requestPermission(methodArray, classArray, objectArray, n);
    }

    public void checkRecordPermission() throws SecurityException {
        JSSecurityManager.checkRecord();
    }

    public boolean isLinkPermissionEnabled() {
        return table.get(new Integer(64)) != null;
    }

    public void permissionFailureNotification(int n) {
        table.remove(new Integer(n));
    }

    public void loadLibrary(String string) throws UnsatisfiedLinkError {
        try {
            this.requestPermission(this.methodArray, this.classArray, this.arguments, 64);
            this.methodArray[0].invoke((Object)this.classArray[0], this.arguments[0]);
            System.loadLibrary(string);
        }
        catch (Exception exception) {
            throw new UnsatisfiedLinkError("Unable to get " + string + " privilege  " + exception);
        }
    }

    public String readProperty(String string) throws UnsatisfiedLinkError {
        return System.getProperty(string);
    }

    static {
        readPropArgs = new Object[]{"UniversalPropertyRead"};
        readFileArgs = new Object[]{"UniversalFileRead"};
        writeFileArgs = new Object[]{"UniversalFileWrite"};
        deleteFileArgs = new Object[]{"UniversalFileDelete"};
        threadArgs = new Object[]{"UniversalThreadAccess"};
        threadGroupArgs = new Object[]{"UniversalThreadGroupAccess"};
        linkArgs = new Object[]{"UniversalLinkAccess"};
        connectArgs = new Object[]{"UniversalConnect"};
        windowArgs = new Object[]{"UniversalTopLevelWindow"};
        multicastArgs = new Object[]{"UniversalMulticast"};
        table = new Hashtable();
        security = new NetscapeSecurity();
        try {
            privilegeManager = Class.forName("netscape.security.PrivilegeManager");
            enablePrivilege = privilegeManager.getMethod("enablePrivilege", String.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        table.put(new Integer(1), readPropArgs);
        table.put(new Integer(2), readFileArgs);
        table.put(new Integer(4), writeFileArgs);
        table.put(new Integer(8), deleteFileArgs);
        table.put(new Integer(16), threadArgs);
        table.put(new Integer(32), threadGroupArgs);
        table.put(new Integer(64), linkArgs);
        table.put(new Integer(128), connectArgs);
        table.put(new Integer(256), windowArgs);
        table.put(new Integer(512), multicastArgs);
    }
}

