/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Platform;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;

public abstract class AbstractMidiDeviceProvider
extends MidiDeviceProvider {
    private static boolean enabled;

    protected synchronized void readDeviceInfos() {
        int n;
        Info[] infoArray = this.getInfoCache();
        MidiDevice[] midiDeviceArray = this.getDeviceCache();
        if (!enabled) {
            if (infoArray == null || infoArray.length != 0) {
                this.setInfoCache(new Info[0]);
            }
            if (midiDeviceArray == null || midiDeviceArray.length != 0) {
                this.setDeviceCache(new MidiDevice[0]);
            }
            return;
        }
        int n2 = infoArray == null ? -1 : infoArray.length;
        if (n2 != (n = this.getNumDevices())) {
            int n3;
            Info[] infoArray2 = new Info[n];
            MidiDevice[] midiDeviceArray2 = new MidiDevice[n];
            for (n3 = 0; n3 < n; ++n3) {
                Info info = this.createInfo(n3);
                if (infoArray != null) {
                    for (int i = 0; i < infoArray.length; ++i) {
                        Info info2 = infoArray[i];
                        if (info2 == null || !info2.equalStrings(info)) continue;
                        infoArray2[n3] = info2;
                        info2.setIndex(n3);
                        infoArray[i] = null;
                        midiDeviceArray2[n3] = midiDeviceArray[i];
                        midiDeviceArray[i] = null;
                        break;
                    }
                }
                if (infoArray2[n3] != null) continue;
                infoArray2[n3] = info;
            }
            if (infoArray != null) {
                for (n3 = 0; n3 < infoArray.length; ++n3) {
                    if (infoArray[n3] == null) continue;
                    infoArray[n3].setIndex(-1);
                }
            }
            this.setInfoCache(infoArray2);
            this.setDeviceCache(midiDeviceArray2);
        }
    }

    public MidiDevice.Info[] getDeviceInfo() {
        this.readDeviceInfos();
        Info[] infoArray = this.getInfoCache();
        MidiDevice.Info[] infoArray2 = new MidiDevice.Info[infoArray.length];
        System.arraycopy(infoArray, 0, infoArray2, 0, infoArray.length);
        return infoArray2;
    }

    public MidiDevice getDevice(MidiDevice.Info info) {
        if (info instanceof Info) {
            this.readDeviceInfos();
            MidiDevice[] midiDeviceArray = this.getDeviceCache();
            Info[] infoArray = this.getInfoCache();
            Info info2 = (Info)info;
            int n = info2.getIndex();
            if (n >= 0 && n < midiDeviceArray.length && infoArray[n] == info) {
                if (midiDeviceArray[n] == null) {
                    midiDeviceArray[n] = this.createDevice(info2);
                }
                if (midiDeviceArray[n] != null) {
                    return midiDeviceArray[n];
                }
            }
        }
        throw new IllegalArgumentException("MidiDevice " + info.toString() + " not supported by this provider.");
    }

    protected abstract int getNumDevices();

    protected abstract MidiDevice[] getDeviceCache();

    protected abstract void setDeviceCache(MidiDevice[] var1);

    protected abstract Info[] getInfoCache();

    protected abstract void setInfoCache(Info[] var1);

    protected abstract Info createInfo(int var1);

    protected abstract MidiDevice createDevice(Info var1);

    static {
        Platform.initialize();
        enabled = Platform.isMidiIOEnabled();
    }

    static class Info
    extends MidiDevice.Info {
        private int index;

        Info(String string, String string2, String string3, String string4, int n) {
            super(string, string2, string3, string4);
            this.index = n;
        }

        boolean equalStrings(Info info) {
            return info != null && this.getName().equals(info.getName()) && this.getVendor().equals(info.getVendor()) && this.getDescription().equals(info.getDescription()) && this.getVersion().equals(info.getVersion());
        }

        int getIndex() {
            return this.index;
        }

        void setIndex(int n) {
            this.index = n;
        }
    }
}

