/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class WindowsProgressBarUI
extends BasicProgressBarUI {
    private Rectangle boxRect;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsProgressBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        if (XPStyle.getXP() != null) {
            this.progressBar.setOpaque(false);
            this.progressBar.setBorder(null);
        }
    }

    protected Dimension getPreferredInnerHorizontal() {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            return xPStyle.getDimension("progress.bar.normalsize");
        }
        return super.getPreferredInnerHorizontal();
    }

    protected Dimension getPreferredInnerVertical() {
        if (XPStyle.getXP() != null) {
            Dimension dimension = this.getPreferredInnerHorizontal();
            return new Dimension(dimension.height, dimension.width);
        }
        return super.getPreferredInnerVertical();
    }

    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            boolean bl = this.progressBar.getOrientation() == 1;
            int n = this.progressBar.getWidth();
            int n2 = this.progressBar.getHeight() - 1;
            int n3 = this.getAmountFull(null, n, n2);
            this.paintXPBackground(graphics, bl, n, n2);
            if (this.progressBar.isStringPainted()) {
                graphics.setColor(this.progressBar.getForeground());
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(new BasicStroke(bl ? (n -= 2) : (n2 -= 2), 0, 2));
                if (!bl) {
                    graphics2D.drawLine(2, n2 / 2 + 1, n3 - 2, n2 / 2 + 1);
                    this.paintString(graphics, 0, 0, n, n2, n3, null);
                } else {
                    graphics2D.drawLine(n / 2 + 1, n2 + 1, n / 2 + 1, n2 + 1 - n3 + 2);
                    this.paintString(graphics, 2, 2, n, n2, n3, null);
                }
            } else {
                XPStyle.Skin skin = xPStyle.getSkin(bl ? "progress.chunkvert" : "progress.chunk");
                int n4 = bl ? n - 5 : n2 - 5;
                int n5 = xPStyle.getInt("progress.progresschunksize", 2);
                int n6 = xPStyle.getInt("progress.progressspacesize", 0);
                int n7 = (n3 - 4) / (n5 + n6);
                if (n6 > 0 && n7 * (n5 + n6) + n5 < n3 - 4) {
                    ++n7;
                }
                for (int i = 0; i < n7; ++i) {
                    if (bl) {
                        skin.paintSkin(graphics, 3, n2 - i * (n5 + n6) - n5 - 2, n4, n5, 0);
                        continue;
                    }
                    skin.paintSkin(graphics, 4 + i * (n5 + n6), 2, n5, n4, 0);
                }
            }
        } else {
            super.paintDeterminate(graphics, jComponent);
        }
    }

    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            boolean bl = this.progressBar.getOrientation() == 1;
            int n = this.progressBar.getWidth();
            int n2 = this.progressBar.getHeight() - 1;
            this.paintXPBackground(graphics, bl, n, n2);
            this.boxRect = this.getBox(this.boxRect);
            if (this.boxRect != null) {
                graphics.setColor(this.progressBar.getForeground());
                if (!bl) {
                    graphics.fillRect(this.boxRect.x, this.boxRect.y + 2, this.boxRect.width, this.boxRect.height - 4);
                } else {
                    graphics.fillRect(this.boxRect.x + 2, this.boxRect.y, this.boxRect.width - 3, this.boxRect.height);
                }
                if (this.progressBar.isStringPainted()) {
                    if (!bl) {
                        this.paintString(graphics, -1, -1, n, n2, 0, null);
                    } else {
                        this.paintString(graphics, 1, 1, n, n2, 0, null);
                    }
                }
            }
        } else {
            super.paintIndeterminate(graphics, jComponent);
        }
    }

    private void paintXPBackground(Graphics graphics, boolean bl, int n, int n2) {
        XPStyle xPStyle = XPStyle.getXP();
        String string = bl ? "progress.barvert" : "progress.bar";
        XPStyle.Skin skin = xPStyle.getSkin(string);
        Color color = xPStyle.getColor(string + ".fillcolorhint", null);
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(2, 2, n - 4, n2 - 4);
        }
        skin.paintSkin(graphics, 0, 0, n, n2, 0);
    }
}

