/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsDesktopManager;
import com.sun.java.swing.plaf.windows.WindowsInternalFrameTitlePane;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class WindowsInternalFrameUI
extends BasicInternalFrameUI {
    WindowsInternalFrameTitlePane titlePane;
    XPStyle xp = XPStyle.getXP();

    public void installDefaults() {
        super.installDefaults();
        if (this.xp != null) {
            this.frame.setBorder(new XPBorder());
        } else {
            this.frame.setBorder(UIManager.getBorder("InternalFrame.border"));
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(this.xp == null);
    }

    public void uninstallDefaults() {
        this.frame.setBorder(null);
        super.uninstallDefaults();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsInternalFrameUI((JInternalFrame)jComponent);
    }

    public WindowsInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected DesktopManager createDesktopManager() {
        return new WindowsDesktopManager();
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new WindowsInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    protected void setupMenuOpenKey() {
        super.setupMenuOpenKey();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.frame);
        if (actionMap != null) {
            actionMap.put("showSystemMenu", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WindowsInternalFrameUI.this.titlePane.showSystemMenu();
                }

                public boolean isEnabled() {
                    return WindowsInternalFrameUI.this.isKeyBindingActive();
                }
            });
        }
    }

    protected LayoutManager createLayoutManager() {
        if (XPStyle.getXP() != null) {
            return new BasicInternalFrameUI.InternalFrameLayout(){

                public void layoutContainer(Container container) {
                    Dimension dimension;
                    Insets insets = WindowsInternalFrameUI.this.frame.getInsets();
                    int n = insets.left;
                    int n2 = 0;
                    int n3 = WindowsInternalFrameUI.this.frame.getWidth() - insets.left - insets.right;
                    int n4 = WindowsInternalFrameUI.this.frame.getHeight() - insets.bottom;
                    if (WindowsInternalFrameUI.this.getNorthPane() != null) {
                        dimension = WindowsInternalFrameUI.this.getNorthPane().getPreferredSize();
                        WindowsInternalFrameUI.this.getNorthPane().setBounds(0, 0, WindowsInternalFrameUI.this.frame.getWidth(), dimension.height);
                        n2 += dimension.height;
                        n4 -= dimension.height;
                    }
                    if (WindowsInternalFrameUI.this.getSouthPane() != null) {
                        dimension = WindowsInternalFrameUI.this.getSouthPane().getPreferredSize();
                        WindowsInternalFrameUI.this.getSouthPane().setBounds(n, WindowsInternalFrameUI.this.frame.getHeight() - insets.bottom - dimension.height, n3, dimension.height);
                        n4 -= dimension.height;
                    }
                    if (WindowsInternalFrameUI.this.getWestPane() != null) {
                        dimension = WindowsInternalFrameUI.this.getWestPane().getPreferredSize();
                        WindowsInternalFrameUI.this.getWestPane().setBounds(n, n2, dimension.width, n4);
                        n3 -= dimension.width;
                        n += dimension.width;
                    }
                    if (WindowsInternalFrameUI.this.getEastPane() != null) {
                        dimension = WindowsInternalFrameUI.this.getEastPane().getPreferredSize();
                        WindowsInternalFrameUI.this.getEastPane().setBounds(n3 - dimension.width, n2, dimension.width, n4);
                        n3 -= dimension.width;
                    }
                    if (WindowsInternalFrameUI.this.frame.getRootPane() != null) {
                        WindowsInternalFrameUI.this.frame.getRootPane().setBounds(n, n2, n3, n4);
                    }
                }
            };
        }
        return super.createLayoutManager();
    }

    private class XPBorder
    extends AbstractBorder {
        private XPStyle.Skin leftSkin;
        private XPStyle.Skin rightSkin;
        private XPStyle.Skin bottomSkin;

        private XPBorder() {
            this.leftSkin = WindowsInternalFrameUI.this.xp.getSkin("window.frameleft");
            this.rightSkin = WindowsInternalFrameUI.this.xp.getSkin("window.frameright");
            this.bottomSkin = WindowsInternalFrameUI.this.xp.getSkin("window.framebottom");
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = ((JInternalFrame)component).isSelected();
            int n5 = WindowsInternalFrameUI.this.titlePane != null ? WindowsInternalFrameUI.this.titlePane.getSize().height : 0;
            this.bottomSkin.paintSkin(graphics, 0, n4 - this.bottomSkin.getHeight(), n3, this.bottomSkin.getHeight(), bl ? 0 : 1);
            this.leftSkin.paintSkin(graphics, 0, n5 - 1, this.leftSkin.getWidth(), n4 - n5 - this.bottomSkin.getHeight() + 2, bl ? 0 : 1);
            this.rightSkin.paintSkin(graphics, n3 - this.rightSkin.getWidth(), n5 - 1, this.rightSkin.getWidth(), n4 - n5 - this.bottomSkin.getHeight() + 2, bl ? 0 : 1);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 4;
            insets.left = this.leftSkin.getWidth();
            insets.right = this.rightSkin.getWidth();
            insets.bottom = this.bottomSkin.getHeight();
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

