/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthGraphics;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SliderUI;

class SynthSliderUI
extends SliderUI
implements SynthUI {
    public static final int POSITIVE_SCROLL = 1;
    public static final int NEGATIVE_SCROLL = -1;
    public static final int MIN_SCROLL = -2;
    public static final int MAX_SCROLL = 2;
    protected Insets insetCache = null;
    protected boolean leftToRightCache = true;
    protected Dimension contentDim = null;
    protected Rectangle labelRect = null;
    protected Rectangle tickRect = null;
    protected Rectangle trackRect = null;
    protected Rectangle thumbRect = null;
    protected Rectangle valueRect = null;
    protected boolean paintValue;
    protected int trackBuffer = 0;
    private static final Dimension PREFERRED_HORIZONTAL_SIZE = new Dimension(200, 21);
    private static final Dimension PREFERRED_VERTICAL_SIZE = new Dimension(21, 200);
    private static final Dimension MINIMUM_HORIZONTAL_SIZE = new Dimension(36, 21);
    private static final Dimension MINIMUM_VERTICAL_SIZE = new Dimension(21, 36);
    private transient boolean isDragging;
    protected TrackListener trackListener;
    protected ChangeListener changeListener;
    protected ComponentListener componentListener;
    protected FocusListener focusListener;
    protected ScrollListener scrollListener;
    protected PropertyChangeListener propertyChangeListener;
    private Color shadowColor;
    private Color highlightColor;
    private static int trackHeight;
    private static int trackBorder;
    private static int thumbWidth;
    private static int thumbHeight;
    private SynthStyle style;
    private SynthStyle sliderTrackStyle;
    private SynthStyle sliderThumbStyle;
    private transient boolean thumbActive;
    protected Timer scrollTimer;
    protected JSlider slider;
    private static Rectangle unionRect;

    SynthSliderUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthSliderUI();
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("positiveUnitIncrement", new SharedActionScroller(1, false));
        actionMap.put("positiveBlockIncrement", new SharedActionScroller(1, true));
        actionMap.put("negativeUnitIncrement", new SharedActionScroller(-1, false));
        actionMap.put("negativeBlockIncrement", new SharedActionScroller(-1, true));
        actionMap.put("minScroll", new SharedActionScroller(-2, true));
        actionMap.put("maxScroll", new SharedActionScroller(2, true));
    }

    protected String getPropertyPrefix() {
        return "Slider.";
    }

    public void installUI(JComponent jComponent) {
        this.slider = (JSlider)jComponent;
        this.slider.setEnabled(this.slider.isEnabled());
        this.slider.setOpaque(true);
        this.isDragging = false;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.insetCache = this.slider.getInsets();
        this.leftToRightCache = SynthLookAndFeel.isLeftToRight(this.slider);
        this.contentDim = new Dimension();
        this.labelRect = new Rectangle();
        this.tickRect = new Rectangle();
        this.trackRect = new Rectangle();
        this.thumbRect = new Rectangle();
        this.valueRect = new Rectangle();
        this.calculateGeometry();
    }

    public void uninstallUI(JComponent jComponent) {
    }

    protected void installDefaults() {
        this.fetchStyle(this.slider);
        SynthContext synthContext = this.getContext((JComponent)this.slider, 1);
        this.highlightColor = UIManager.getColor("Slider.highlight");
        this.shadowColor = UIManager.getColor("Slider.shadow");
        synthContext.dispose();
    }

    private void fetchStyle(JSlider jSlider) {
        SynthContext synthContext = this.getContext((JComponent)jSlider, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            thumbWidth = this.style.getInt(synthContext, this.getPropertyPrefix() + "thumbWidth", 30);
            thumbHeight = this.style.getInt(synthContext, this.getPropertyPrefix() + "thumbHeight", 14);
            trackBorder = this.style.getInt(synthContext, this.getPropertyPrefix() + "trackBorder", 1);
            trackHeight = thumbHeight + trackBorder * 2;
            this.paintValue = this.style.getBoolean(synthContext, this.getPropertyPrefix() + "paintValue", true);
        }
        synthContext.dispose();
        synthContext = this.getContext(jSlider, Region.SLIDER_TRACK, 1);
        this.sliderTrackStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
        synthContext = this.getContext(jSlider, Region.SLIDER_THUMB, 1);
        this.sliderThumbStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.slider, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(this.slider, Region.SLIDER_TRACK, 1);
        this.sliderTrackStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.sliderTrackStyle = null;
        synthContext = this.getContext(this.slider, Region.SLIDER_THUMB, 1);
        this.sliderThumbStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.sliderThumbStyle = null;
    }

    protected void installListeners() {
        this.trackListener = this.createTrackListener();
        if (this.trackListener != null) {
            this.slider.addMouseListener(this.trackListener);
            this.slider.addMouseMotionListener(this.trackListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.slider.addFocusListener(this.focusListener);
        }
        if ((this.componentListener = this.createComponentListener()) != null) {
            this.slider.addComponentListener(this.componentListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.slider.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.changeListener = this.createChangeListener()) != null) {
            this.slider.getModel().addChangeListener(this.changeListener);
        }
        if ((this.scrollListener = this.createScrollListener()) != null) {
            this.scrollTimer = new Timer(100, this.scrollListener);
            this.scrollTimer.setInitialDelay(300);
        }
    }

    protected void uninstallListeners() {
        if (this.trackListener != null) {
            this.slider.removeMouseListener(this.trackListener);
            this.slider.removeMouseMotionListener(this.trackListener);
        }
        if (this.focusListener != null) {
            this.slider.removeFocusListener(this.focusListener);
        }
        if (this.componentListener != null) {
            this.slider.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.slider.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.changeListener != null) {
            this.slider.getModel().removeChangeListener(this.changeListener);
        }
        this.scrollTimer = null;
    }

    protected TrackListener createTrackListener() {
        return new TrackListener();
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected ChangeListener createChangeListener() {
        return new ChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.slider, 0, inputMap);
        LazyActionMap.installLazyActionMap(this.slider, SynthSliderUI.class, "Slider.actionMap");
    }

    InputMap getInputMap(int n) {
        if (n == 0) {
            InputMap inputMap;
            SynthContext synthContext = this.getContext((JComponent)this.slider, 1);
            InputMap inputMap2 = (InputMap)this.style.get(synthContext, "Slider.focusInputMap");
            if (this.slider.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)this.style.get(synthContext, "Slider.focusInputMap.RightToLeft")) == null) {
                synthContext.dispose();
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            synthContext.dispose();
            return inputMap;
        }
        return null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.slider, null);
        SwingUtilities.replaceUIInputMap(this.slider, 0, null);
    }

    protected TrackListener createTrackListener(JSlider jSlider) {
        return new TrackListener();
    }

    private void updateThumbState(int n, int n2) {
        this.setThumbActive(this.thumbRect.contains(n, n2));
    }

    private void setThumbActive(boolean bl) {
        if (this.thumbActive != bl) {
            this.thumbActive = bl;
            this.slider.repaint(this.thumbRect);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        Dimension dimension = new Dimension(this.contentDim);
        if (this.slider.getOrientation() == 1) {
            dimension.height = 200;
        } else {
            dimension.width = 200;
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        Dimension dimension = new Dimension(this.contentDim);
        if (this.slider.getOrientation() == 1) {
            dimension.height = this.thumbRect.height + this.insetCache.top + this.insetCache.bottom;
        } else {
            dimension.width = this.thumbRect.width + this.insetCache.left + this.insetCache.right;
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        if (this.slider.getOrientation() == 1) {
            dimension.height = Short.MAX_VALUE;
        } else {
            dimension.width = Short.MAX_VALUE;
        }
        return dimension;
    }

    protected void calculateGeometry() {
        this.layout();
        this.calculateThumbLocation();
    }

    protected void layout() {
        SynthContext synthContext = this.getContext(this.slider);
        SynthGraphics synthGraphics = this.style.getSynthGraphics(synthContext);
        Dimension dimension = this.getThumbSize();
        this.thumbRect.setSize(dimension.width, dimension.height);
        Insets insets = new Insets(0, 0, 0, 0);
        this.style.getInsets(this.getContext((JComponent)this.slider, Region.SLIDER_TRACK), insets);
        if (this.slider.getOrientation() == 0) {
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphics.getMaximumCharHeight(this.slider);
            }
            this.trackRect.height = trackHeight;
            this.tickRect.height = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.height = this.getTickLength();
            }
            this.labelRect.height = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.height = this.getHeightOfTallestLabel();
            }
            this.contentDim.height = this.valueRect.height + this.trackRect.height + insets.top + insets.bottom + this.tickRect.height + this.labelRect.height + 4;
            this.contentDim.width = this.slider.getWidth() - this.insetCache.left - this.insetCache.right;
            int n = this.slider.getHeight() / 2 - this.contentDim.height / 2;
            this.tickRect.x = this.labelRect.x = this.insetCache.left;
            this.trackRect.x = this.labelRect.x;
            this.valueRect.x = this.labelRect.x;
            this.tickRect.width = this.labelRect.width = this.contentDim.width;
            this.trackRect.width = this.labelRect.width;
            this.valueRect.width = this.labelRect.width;
            this.valueRect.y = n;
            this.trackRect.y = (n += this.valueRect.height + 2) + insets.top;
            this.tickRect.y = n += this.trackRect.height + insets.top + insets.bottom;
            this.labelRect.y = n += this.tickRect.height + 2;
            n += this.labelRect.height;
        } else {
            this.trackRect.width = trackHeight;
            this.tickRect.width = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.width = this.getTickLength();
            }
            this.labelRect.width = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.width = this.getWidthOfWidestLabel();
            }
            this.valueRect.y = this.insetCache.top;
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphics.getMaximumCharHeight(this.slider);
            }
            this.contentDim.width = this.trackRect.width + insets.left + insets.right + this.tickRect.width + this.labelRect.width + 2 + this.insetCache.left + this.insetCache.right;
            this.contentDim.height = this.slider.getHeight() - this.insetCache.top - this.insetCache.bottom;
            int n = this.slider.getWidth() / 2 - this.contentDim.width / 2;
            this.valueRect.width = Math.max(synthGraphics.computeStringWidth(synthContext, this.slider.getFont(), this.slider.getToolkit().getFontMetrics(this.slider.getFont()), "" + this.slider.getMaximum()), synthGraphics.computeStringWidth(synthContext, this.slider.getFont(), this.slider.getToolkit().getFontMetrics(this.slider.getFont()), "" + this.slider.getMinimum()));
            if (this.valueRect.width > this.trackRect.width + insets.left + insets.right) {
                int n2 = (this.valueRect.width - (this.trackRect.width + insets.left + insets.right)) / 2;
                this.contentDim.width += n2;
                n += n2;
            }
            this.tickRect.y = this.labelRect.y = this.valueRect.y + this.valueRect.height;
            this.trackRect.y = this.labelRect.y;
            this.tickRect.height = this.labelRect.height = this.contentDim.height - this.valueRect.height;
            this.trackRect.height = this.labelRect.height;
            this.trackRect.x = n + insets.left;
            this.tickRect.x = n += this.trackRect.width + insets.right + insets.left;
            this.labelRect.x = n += this.tickRect.width + 2;
            n += this.labelRect.width;
        }
    }

    protected void calculateThumbSize() {
        Dimension dimension = this.getThumbSize();
        this.thumbRect.setSize(dimension.width, dimension.height);
    }

    protected Color getShadowColor() {
        return this.shadowColor;
    }

    protected Color getHighlightColor() {
        return this.highlightColor;
    }

    protected void calculateThumbLocation() {
        int n;
        if (this.slider.getSnapToTicks()) {
            int n2 = n = this.slider.getValue();
            int n3 = this.slider.getMajorTickSpacing();
            int n4 = this.slider.getMinorTickSpacing();
            int n5 = 0;
            if (n4 > 0) {
                n5 = n4;
            } else if (n3 > 0) {
                n5 = n3;
            }
            if (n5 != 0) {
                if ((n - this.slider.getMinimum()) % n5 != 0) {
                    float f = (float)(n - this.slider.getMinimum()) / (float)n5;
                    int n6 = Math.round(f);
                    n2 = this.slider.getMinimum() + n6 * n5;
                }
                if (n2 != n) {
                    this.slider.setValue(n2);
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            n = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = n - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y + trackBorder;
        } else {
            n = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x + trackBorder;
            this.thumbRect.y = n - this.thumbRect.height / 2;
        }
    }

    protected int getTickLength() {
        return 8;
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height + 2 + this.getTickLength();
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            if (SynthLookAndFeel.isLeftToRight(this.slider)) {
                this.tickRect.x = this.trackRect.x + this.trackRect.width;
                this.tickRect.width = this.getTickLength();
            } else {
                this.tickRect.width = this.getTickLength();
                this.tickRect.x = this.trackRect.x - this.tickRect.width;
            }
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    public void setThumbLocation(int n, int n2) {
        unionRect.setBounds(this.thumbRect);
        this.thumbRect.setLocation(n, n2);
        SwingUtilities.computeUnion(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, unionRect);
        this.slider.repaint(SynthSliderUI.unionRect.x, SynthSliderUI.unionRect.y, SynthSliderUI.unionRect.width, SynthSliderUI.unionRect.height);
        this.slider.repaint(this.valueRect.x, this.valueRect.y, this.valueRect.width, this.valueRect.height);
        this.setThumbActive(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2 = this.slider.getValue();
            int n3 = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (n3 <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                n3 = 1;
            }
            int n4 = n3 * (n > 0 ? 1 : -1);
            this.slider.setValue(n2 + n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2 = this.slider.getValue();
            int n3 = 1 * (n > 0 ? 1 : -1);
            this.slider.setValue(n2 + n3);
        }
    }

    protected void scrollDueToClickInTrack(int n) {
        this.scrollByBlock(n);
    }

    protected int xPositionForValue(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.x + this.thumbRect.width / 2 + trackBorder;
        int n6 = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - trackBorder;
        int n7 = n6 - n5;
        double d = (double)n4 - (double)n3;
        double d2 = (double)n7 / d;
        if (!this.drawInverted()) {
            n2 = n5;
            n2 = (int)((long)n2 + Math.round(d2 * ((double)n - (double)n3)));
        } else {
            n2 = n6;
            n2 = (int)((long)n2 - Math.round(d2 * ((double)n - (double)n3)));
        }
        n2 = Math.max(n5, n2);
        n2 = Math.min(n6, n2);
        return n2;
    }

    protected int yPositionForValue(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.y + this.thumbRect.height / 2 + trackBorder;
        int n6 = this.trackRect.y + this.trackRect.height - this.thumbRect.height / 2 - trackBorder;
        int n7 = n6 - n5;
        double d = (double)n4 - (double)n3;
        double d2 = (double)n7 / d;
        if (!this.drawInverted()) {
            n2 = n5;
            n2 = (int)((long)n2 + Math.round(d2 * ((double)n4 - (double)n)));
        } else {
            n2 = n5;
            n2 = (int)((long)n2 + Math.round(d2 * ((double)n - (double)n3)));
        }
        n2 = Math.max(n5, n2);
        n2 = Math.min(n6, n2);
        return n2;
    }

    public int valueForYPosition(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.y + this.thumbRect.height / 2 + trackBorder;
        int n6 = this.trackRect.y + this.trackRect.height - this.thumbRect.height / 2 - trackBorder;
        int n7 = n6 - n5;
        if (n <= n5) {
            n2 = this.drawInverted() ? n3 : n4;
        } else if (n >= n6) {
            n2 = this.drawInverted() ? n4 : n3;
        } else {
            int n8 = n - n5;
            double d = (double)n4 - (double)n3;
            double d2 = d / (double)n7;
            int n9 = (int)Math.round((double)n8 * d2);
            n2 = this.drawInverted() ? n3 + n9 : n4 - n9;
        }
        return n2;
    }

    public int valueForXPosition(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.x + this.thumbRect.width / 2 + trackBorder;
        int n6 = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - trackBorder;
        int n7 = n6 - n5;
        if (n <= n5) {
            n2 = this.drawInverted() ? n4 : n3;
        } else if (n >= n6) {
            n2 = this.drawInverted() ? n3 : n4;
        } else {
            int n8 = n - n5;
            double d = (double)n4 - (double)n3;
            double d2 = d / (double)n7;
            int n9 = (int)Math.round((double)n8 * d2);
            n2 = this.drawInverted() ? n4 - n9 : n3 + n9;
        }
        return n2;
    }

    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = thumbHeight;
            dimension.height = thumbWidth;
        } else {
            dimension.width = thumbWidth;
            dimension.height = thumbHeight;
        }
        return dimension;
    }

    protected int getWidthOfWidestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int n = 0;
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)dictionary.get(enumeration.nextElement());
                n = Math.max(component.getPreferredSize().width, n);
            }
        }
        return n;
    }

    protected int getHeightOfTallestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int n = 0;
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)dictionary.get(enumeration.nextElement());
                n = Math.max(component.getPreferredSize().height, n);
            }
        }
        return n;
    }

    protected int getWidthOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().width;
        }
        return n;
    }

    protected int getWidthOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().width;
        }
        return n;
    }

    protected int getHeightOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().height;
        }
        return n;
    }

    protected int getHeightOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().height;
        }
        return n;
    }

    protected boolean drawInverted() {
        if (this.slider.getOrientation() == 0) {
            if (SynthLookAndFeel.isLeftToRight(this.slider)) {
                return this.slider.getInverted();
            }
            return !this.slider.getInverted();
        }
        return this.slider.getInverted();
    }

    protected Component getLowestValueLabel() {
        Enumeration enumeration;
        Dictionary dictionary = this.slider.getLabelTable();
        Component component = null;
        if (dictionary != null && (enumeration = dictionary.keys()).hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                int n2 = (Integer)enumeration.nextElement();
                n = Math.min(n2, n);
            }
            component = (Component)dictionary.get(new Integer(n));
        }
        return component;
    }

    protected Component getHighestValueLabel() {
        Enumeration enumeration;
        Dictionary dictionary = this.slider.getLabelTable();
        Component component = null;
        if (dictionary != null && (enumeration = dictionary.keys()).hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                int n2 = (Integer)enumeration.nextElement();
                n = Math.max(n2, n);
            }
            component = (Component)dictionary.get(new Integer(n));
        }
        return component;
    }

    protected void recalculateIfInsetsChanged() {
        Insets insets = this.style.getInsets(this.getContext(this.slider), null);
        if (!insets.equals(this.insetCache)) {
            this.insetCache = insets;
            this.calculateGeometry();
        }
    }

    protected void recalculateIfOrientationChanged() {
        boolean bl = SynthLookAndFeel.isLeftToRight(this.slider);
        if (bl != this.leftToRightCache) {
            this.leftToRightCache = bl;
            this.calculateGeometry();
        }
    }

    public Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    public SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n) {
        Class clazz;
        SynthStyle synthStyle = null;
        Class clazz2 = clazz = SynthContext.class;
        if (region == Region.SLIDER_TRACK) {
            synthStyle = this.sliderTrackStyle;
        } else if (region == Region.SLIDER_THUMB) {
            synthStyle = this.sliderThumbStyle;
        }
        return SynthContext.getContext(clazz, jComponent, region, synthStyle, n);
    }

    public int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        if (region == Region.SLIDER_THUMB && this.thumbActive && jComponent.isEnabled()) {
            return 2;
        }
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(SynthContext synthContext, Graphics graphics) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle rectangle = graphics.getClipBounds();
        this.valueRect.x = this.thumbRect.x + this.thumbRect.width / 2 - graphics.getFontMetrics().stringWidth("" + this.slider.getValue()) / 2;
        synthContext.getStyle().getSynthGraphics(synthContext).paintText(synthContext, graphics, "" + this.slider.getValue(), this.valueRect.x, this.valueRect.y, -1);
        SynthContext synthContext2 = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
        this.paintTrack(synthContext2, graphics, this.trackRect);
        synthContext2.dispose();
        synthContext2 = this.getContext((JComponent)this.slider, Region.SLIDER_THUMB);
        this.paintThumb(synthContext2, graphics, this.thumbRect);
        synthContext2.dispose();
        if (this.slider.getPaintTicks() && rectangle.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
    }

    public void paintThumb(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
    }

    public void paintTrack(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
    }

    public void paintLabels(Graphics graphics) {
        Rectangle rectangle = this.labelRect;
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            int n = this.slider.getMinimum();
            int n2 = this.slider.getMaximum();
            while (enumeration.hasMoreElements()) {
                Integer n3 = (Integer)enumeration.nextElement();
                int n4 = n3;
                if (n4 < n || n4 > n2) continue;
                Component component = (Component)dictionary.get(n3);
                if (this.slider.getOrientation() == 0) {
                    graphics.translate(0, rectangle.y);
                    this.paintHorizontalLabel(graphics, n4, component);
                    graphics.translate(0, -rectangle.y);
                    continue;
                }
                int n5 = 0;
                if (!SynthLookAndFeel.isLeftToRight(this.slider)) {
                    n5 = rectangle.width - component.getPreferredSize().width;
                }
                graphics.translate(rectangle.x + n5, 0);
                this.paintVerticalLabel(graphics, n4, component);
                graphics.translate(-rectangle.x - n5, 0);
            }
        }
    }

    protected void paintHorizontalLabel(Graphics graphics, int n, Component component) {
        int n2 = this.xPositionForValue(n);
        int n3 = n2 - component.getPreferredSize().width / 2;
        graphics.translate(n3, 0);
        component.paint(graphics);
        graphics.translate(-n3, 0);
    }

    protected void paintVerticalLabel(Graphics graphics, int n, Component component) {
        int n2 = this.yPositionForValue(n);
        int n3 = n2 - component.getPreferredSize().height / 2;
        graphics.translate(0, n3);
        component.paint(graphics);
        graphics.translate(0, -n3);
    }

    public void paintTicks(Graphics graphics) {
        Rectangle rectangle = this.tickRect;
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.setColor(this.slider.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        int n3 = this.slider.getMajorTickSpacing();
        int n4 = this.slider.getMinorTickSpacing();
        if (this.slider.getOrientation() == 0) {
            int n5;
            graphics.translate(0, rectangle.y);
            int n6 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                for (n5 = this.slider.getMinimum(); n5 <= this.slider.getMaximum(); n5 += this.slider.getMinorTickSpacing()) {
                    n6 = this.xPositionForValue(n5);
                    this.paintMinorTickForHorizSlider(graphics, rectangle, n6);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                for (n5 = this.slider.getMinimum(); n5 <= this.slider.getMaximum(); n5 += this.slider.getMajorTickSpacing()) {
                    n6 = this.xPositionForValue(n5);
                    this.paintMajorTickForHorizSlider(graphics, rectangle, n6);
                }
            }
            graphics.translate(0, -rectangle.y);
        } else {
            graphics.translate(rectangle.x, 0);
            int n7 = this.slider.getMinimum();
            int n8 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                int n9 = 0;
                if (!SynthLookAndFeel.isLeftToRight(this.slider)) {
                    n9 = rectangle.width - rectangle.width / 2;
                    graphics.translate(n9, 0);
                }
                while (n7 <= this.slider.getMaximum()) {
                    n8 = this.yPositionForValue(n7);
                    this.paintMinorTickForVertSlider(graphics, rectangle, n8);
                    n7 += this.slider.getMinorTickSpacing();
                }
                if (!SynthLookAndFeel.isLeftToRight(this.slider)) {
                    graphics.translate(-n9, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n7 = this.slider.getMinimum();
                if (!SynthLookAndFeel.isLeftToRight(this.slider)) {
                    graphics.translate(2, 0);
                }
                while (n7 <= this.slider.getMaximum()) {
                    n8 = this.yPositionForValue(n7);
                    this.paintMajorTickForVertSlider(graphics, rectangle, n8);
                    n7 += this.slider.getMajorTickSpacing();
                }
                if (!SynthLookAndFeel.isLeftToRight(this.slider)) {
                    graphics.translate(-2, 0);
                }
            }
            graphics.translate(-rectangle.x, 0);
        }
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(n, 0, n, rectangle.height / 2 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(n, 0, n, rectangle.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(0, n, rectangle.width / 2 - 1, n);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(0, n, rectangle.width - 2, n);
    }

    static {
        unionRect = new Rectangle();
    }

    static class SharedActionScroller
    extends AbstractAction {
        int dir;
        boolean block;

        public SharedActionScroller(int n, boolean bl) {
            this.dir = n;
            this.block = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSlider jSlider = (JSlider)actionEvent.getSource();
            if (this.dir == -1 || this.dir == 1) {
                int n = this.dir;
                SynthSliderUI synthSliderUI = (SynthSliderUI)jSlider.getUI();
                if (jSlider.getInverted()) {
                    int n2 = n = this.dir == -1 ? 1 : -1;
                }
                if (this.block) {
                    synthSliderUI.scrollByBlock(n);
                } else {
                    synthSliderUI.scrollByUnit(n);
                }
            } else if (jSlider.getInverted()) {
                if (this.dir == -2) {
                    jSlider.setValue(jSlider.getMaximum());
                } else if (this.dir == 2) {
                    jSlider.setValue(jSlider.getMinimum());
                }
            } else if (this.dir == -2) {
                jSlider.setValue(jSlider.getMinimum());
            } else if (this.dir == 2) {
                jSlider.setValue(jSlider.getMaximum());
            }
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            SynthSliderUI.this.slider.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            SynthSliderUI.this.slider.repaint();
        }
    }

    class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            SynthSliderUI.this.calculateGeometry();
            SynthSliderUI.this.slider.repaint();
        }
    }

    class ScrollListener
    implements ActionListener {
        int direction = 1;
        boolean useBlockIncrement;

        public ScrollListener() {
            this.direction = 1;
            this.useBlockIncrement = true;
        }

        public ScrollListener(int n, boolean bl) {
            this.direction = n;
            this.useBlockIncrement = bl;
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public void setScrollByBlock(boolean bl) {
            this.useBlockIncrement = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.useBlockIncrement) {
                SynthSliderUI.this.scrollByBlock(this.direction);
            } else {
                SynthSliderUI.this.scrollByUnit(this.direction);
            }
            if (!SynthSliderUI.this.trackListener.shouldScroll(this.direction)) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }
    }

    protected class TrackListener
    extends MouseInputAdapter {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        protected TrackListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = 0;
            if (!SynthSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (!SynthSliderUI.this.isDragging) {
                return;
            }
            SynthSliderUI.this.slider.setValueIsAdjusting(true);
            switch (SynthSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2 = SynthSliderUI.this.thumbRect.height / 2;
                    int n3 = mouseEvent.getY() - this.offset;
                    int n4 = SynthSliderUI.this.trackRect.y;
                    int n5 = SynthSliderUI.this.trackRect.y + SynthSliderUI.this.trackRect.height - n2 - trackBorder;
                    int n6 = SynthSliderUI.this.yPositionForValue(SynthSliderUI.this.slider.getMaximum() - SynthSliderUI.this.slider.getExtent());
                    if (SynthSliderUI.this.drawInverted()) {
                        n5 = n6;
                    } else {
                        n4 = n6;
                    }
                    n3 = Math.max(n3, n4 - n2);
                    n3 = Math.min(n3, n5 - n2);
                    SynthSliderUI.this.setThumbLocation(SynthSliderUI.this.thumbRect.x, n3);
                    n = n3 + n2;
                    SynthSliderUI.this.slider.setValue(SynthSliderUI.this.valueForYPosition(n));
                    break;
                }
                case 0: {
                    int n7 = SynthSliderUI.this.thumbRect.width / 2;
                    int n8 = mouseEvent.getX() - this.offset;
                    int n9 = SynthSliderUI.this.trackRect.x + n7 + trackBorder;
                    int n10 = SynthSliderUI.this.trackRect.x + SynthSliderUI.this.trackRect.width - n7 - trackBorder;
                    int n11 = SynthSliderUI.this.xPositionForValue(SynthSliderUI.this.slider.getMaximum() - SynthSliderUI.this.slider.getExtent());
                    if (SynthSliderUI.this.drawInverted()) {
                        n9 = n11;
                    } else {
                        n10 = n11;
                    }
                    n8 = Math.max(n8, n9 - n7);
                    n8 = Math.min(n8, n10 - n7);
                    SynthSliderUI.this.setThumbLocation(n8, SynthSliderUI.this.thumbRect.y);
                    n = n8 + n7;
                    SynthSliderUI.this.slider.setValue(SynthSliderUI.this.valueForXPosition(n));
                    break;
                }
                default: {
                    return;
                }
            }
            if (SynthSliderUI.this.slider.getValueIsAdjusting()) {
                SynthSliderUI.this.setThumbActive(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SynthSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.offset = 0;
            SynthSliderUI.this.scrollTimer.stop();
            if (SynthSliderUI.this.slider.getSnapToTicks()) {
                SynthSliderUI.this.isDragging = false;
                SynthSliderUI.this.slider.setValueIsAdjusting(false);
            } else {
                SynthSliderUI.this.slider.setValueIsAdjusting(false);
                SynthSliderUI.this.isDragging = false;
            }
            SynthSliderUI.this.updateThumbState(mouseEvent.getX(), mouseEvent.getY());
            SynthSliderUI.this.slider.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            SynthSliderUI.this.updateThumbState(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SynthSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (SynthSliderUI.this.slider.isRequestFocusEnabled()) {
                SynthSliderUI.this.slider.requestFocus();
            }
            if (SynthSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                switch (SynthSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - SynthSliderUI.this.thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - SynthSliderUI.this.thumbRect.x;
                    }
                }
                SynthSliderUI.this.isDragging = true;
                return;
            }
            SynthSliderUI.this.isDragging = false;
            SynthSliderUI.this.slider.setValueIsAdjusting(true);
            Dimension dimension = SynthSliderUI.this.slider.getSize();
            int n = 1;
            switch (SynthSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2;
                    if (SynthSliderUI.this.thumbRect.isEmpty()) {
                        n2 = dimension.height / 2;
                        if (!SynthSliderUI.this.drawInverted()) {
                            n = this.currentMouseY < n2 ? 1 : -1;
                            break;
                        }
                        n = this.currentMouseY < n2 ? -1 : 1;
                        break;
                    }
                    n2 = SynthSliderUI.this.thumbRect.y;
                    if (!SynthSliderUI.this.drawInverted()) {
                        n = this.currentMouseY < n2 ? 1 : -1;
                        break;
                    }
                    n = this.currentMouseY < n2 ? -1 : 1;
                    break;
                }
                case 0: {
                    int n2;
                    if (SynthSliderUI.this.thumbRect.isEmpty()) {
                        n2 = dimension.width / 2;
                        if (!SynthSliderUI.this.drawInverted()) {
                            n = this.currentMouseX < n2 ? -1 : 1;
                            break;
                        }
                        n = this.currentMouseX < n2 ? 1 : -1;
                        break;
                    }
                    n2 = SynthSliderUI.this.thumbRect.x;
                    n = !SynthSliderUI.this.drawInverted() ? (this.currentMouseX < n2 ? -1 : 1) : (this.currentMouseX < n2 ? 1 : -1);
                }
            }
            SynthSliderUI.this.scrollDueToClickInTrack(n);
            Rectangle rectangle = SynthSliderUI.this.thumbRect;
            if (!rectangle.contains(this.currentMouseX, this.currentMouseY) && this.shouldScroll(n)) {
                SynthSliderUI.this.scrollTimer.stop();
                SynthSliderUI.this.scrollListener.setDirection(n);
                SynthSliderUI.this.scrollTimer.start();
            }
        }

        public boolean shouldScroll(int n) {
            Rectangle rectangle = SynthSliderUI.this.thumbRect;
            if (SynthSliderUI.this.slider.getOrientation() == 1 ? ((SynthSliderUI.this.drawInverted() ? n < 0 : n > 0) ? rectangle.y + rectangle.height <= this.currentMouseY : rectangle.y >= this.currentMouseY) : ((SynthSliderUI.this.drawInverted() ? n < 0 : n > 0) ? rectangle.x + rectangle.width >= this.currentMouseX : rectangle.x <= this.currentMouseX)) {
                return false;
            }
            if (n > 0 && SynthSliderUI.this.slider.getValue() + SynthSliderUI.this.slider.getExtent() >= SynthSliderUI.this.slider.getMaximum()) {
                return false;
            }
            return n >= 0 || SynthSliderUI.this.slider.getValue() > SynthSliderUI.this.slider.getMinimum();
        }
    }

    class ChangeHandler
    implements ChangeListener {
        ChangeHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!SynthSliderUI.this.isDragging) {
                SynthSliderUI.this.calculateThumbLocation();
                SynthSliderUI.this.slider.repaint();
            }
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("orientation") || string.equals("inverted") || string.equals("labelTable") || string.equals("majorTickSpacing") || string.equals("minorTickSpacing") || string.equals("paintTicks") || string.equals("paintTrack") || string.equals("paintLabels")) {
                SynthSliderUI.this.calculateGeometry();
                SynthSliderUI.this.slider.repaint();
            } else if (string.equals("componentOrientation")) {
                SynthSliderUI.this.calculateGeometry();
                SynthSliderUI.this.slider.repaint();
                InputMap inputMap = SynthSliderUI.this.getInputMap(0);
                SwingUtilities.replaceUIInputMap(SynthSliderUI.this.slider, 0, inputMap);
            } else if (string.equals("model")) {
                ((BoundedRangeModel)propertyChangeEvent.getOldValue()).removeChangeListener(SynthSliderUI.this.changeListener);
                ((BoundedRangeModel)propertyChangeEvent.getNewValue()).addChangeListener(SynthSliderUI.this.changeListener);
                SynthSliderUI.this.calculateThumbLocation();
                SynthSliderUI.this.slider.repaint();
            }
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthSliderUI.this.fetchStyle((JSlider)propertyChangeEvent.getSource());
            }
        }
    }
}

