/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.Metacity;
import com.sun.java.swing.plaf.gtk.SynthContext;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

class MetacityCrux
extends Metacity {
    private static final int IconTitleSpacing = 2;
    private static final int CenterTitlePieceWidth = 48;
    private static final int ButtonWidth = 16;
    private static final Metacity.FrameGeometry normalFrameGeometry = new NormalFrameGeometry();
    private HashMap images = new HashMap();

    protected MetacityCrux(String string) {
        super(string, normalFrameGeometry);
    }

    private void active_button(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.getImage("active-button"), 0, 0, n, n2, null);
    }

    private void active_button_pressed(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.getImage("active-button-pressed"), 0, 0, n, n2, null);
    }

    private void active_button_prelight(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.getImage("active-button-prelight"), 0, 0, n, n2, null);
    }

    private void inactive_button(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.getImage("inactive-button"), 0, 0, n, n2, null);
    }

    private void inactive_button_pressed(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.getImage("inactive-button-pressed"), 0, 0, n, n2, null);
    }

    private void inactive_button_prelight(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.getImage("inactive-button-prelight"), 0, 0, n, n2, null);
    }

    void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JInternalFrame jInternalFrame;
        this.context = synthContext;
        JButton jButton = (JButton)synthContext.getComponent();
        String string = jButton.getName();
        int n5 = synthContext.getComponentState();
        JComponent jComponent = (JComponent)jButton.getParent();
        Container container = jComponent.getParent();
        if (container instanceof JInternalFrame) {
            jInternalFrame = (JInternalFrame)container;
        } else if (container instanceof JInternalFrame.JDesktopIcon) {
            jInternalFrame = ((JInternalFrame.JDesktopIcon)container).getInternalFrame();
        } else {
            return;
        }
        boolean bl = jInternalFrame.isSelected();
        this.setFrameGeometry(jComponent, normalFrameGeometry);
        if (!bl) {
            if (string.equals("InternalFrameTitlePane.menuButton")) {
                if ((n5 & 4) != 0) {
                    graphics.drawImage(this.getImage("inactive-menu-button-pressed"), n, n2, n3, n4, null);
                } else if ((n5 & 2) != 0) {
                    graphics.drawImage(this.getImage("inactive-menu-button-prelight"), n, n2, n3, n4, null);
                } else {
                    graphics.drawImage(this.getImage("inactive-menu-button"), n, n2, n3, n4, null);
                }
            } else if (string.equals("InternalFrameTitlePane.iconifyButton")) {
                if ((n5 & 4) != 0) {
                    this.inactive_button_pressed(graphics, n3, n4);
                    graphics.drawImage(this.getImage("inactive-minimize-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
                } else if ((n5 & 2) != 0) {
                    this.inactive_button_prelight(graphics, n3, n4);
                    graphics.drawImage(this.getImage("inactive-minimize-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
                } else {
                    this.inactive_button(graphics, n3, n4);
                    graphics.drawImage(this.getImage("inactive-minimize-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
                }
            } else if (string.equals("InternalFrameTitlePane.maximizeButton")) {
                if ((n5 & 4) != 0) {
                    this.inactive_button_pressed(graphics, n3, n4);
                    graphics.drawImage(this.getImage("inactive-maximize-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
                } else if ((n5 & 2) != 0) {
                    this.inactive_button_prelight(graphics, n3, n4);
                    graphics.drawImage(this.getImage("inactive-maximize-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
                } else {
                    this.inactive_button(graphics, n3, n4);
                    graphics.drawImage(this.getImage("inactive-maximize-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
                }
            } else if (string.equals("InternalFrameTitlePane.closeButton")) {
                if ((n5 & 4) != 0) {
                    this.inactive_button_pressed(graphics, n3, n4);
                    graphics.drawImage(this.getImage("inactive-close-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
                } else if ((n5 & 2) != 0) {
                    this.inactive_button_prelight(graphics, n3, n4);
                    graphics.drawImage(this.getImage("inactive-close-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
                } else {
                    this.inactive_button(graphics, n3, n4);
                    graphics.drawImage(this.getImage("inactive-close-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
                }
            }
        } else if (string.equals("InternalFrameTitlePane.menuButton")) {
            if ((n5 & 4) != 0) {
                graphics.drawImage(this.getImage("active-menu-button-pressed", this.getColor(512, GTKColorType.BACKGROUND)), n, n2, n3, n4, null);
            } else if ((n5 & 2) != 0) {
                graphics.drawImage(this.getImage("active-menu-button-prelight", this.getColor(512, GTKColorType.BACKGROUND)), n, n2, n3, n4, null);
            } else {
                graphics.drawImage(this.getImage("active-menu-button", this.getColor(512, GTKColorType.BACKGROUND)), n, n2, n3, n4, null);
            }
        } else if (string.equals("InternalFrameTitlePane.iconifyButton")) {
            if ((n5 & 4) != 0) {
                this.active_button_pressed(graphics, n3, n4);
                graphics.drawImage(this.getImage("active-minimize-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
            } else if ((n5 & 2) != 0) {
                this.active_button_prelight(graphics, n3, n4);
                graphics.drawImage(this.getImage("active-minimize-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
            } else {
                this.active_button(graphics, n3, n4);
                graphics.drawImage(this.getImage("active-minimize-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
            }
        } else if (string.equals("InternalFrameTitlePane.maximizeButton")) {
            if ((n5 & 4) != 0) {
                this.active_button_pressed(graphics, n3, n4);
                graphics.drawImage(this.getImage("active-maximize-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
            } else if ((n5 & 2) != 0) {
                this.active_button_prelight(graphics, n3, n4);
                graphics.drawImage(this.getImage("active-maximize-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
            } else {
                this.active_button(graphics, n3, n4);
                graphics.drawImage(this.getImage("active-maximize-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
            }
        } else if (string.equals("InternalFrameTitlePane.closeButton")) {
            if ((n5 & 4) != 0) {
                this.active_button_pressed(graphics, n3, n4);
                graphics.drawImage(this.getImage("active-close-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
            } else if ((n5 & 2) != 0) {
                this.active_button_prelight(graphics, n3, n4);
                graphics.drawImage(this.getImage("active-close-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
            } else {
                this.active_button(graphics, n3, n4);
                graphics.drawImage(this.getImage("active-close-button"), n + 2, n2 + 2, n3 - 4, n4 - 4, null);
            }
        }
    }

    private void paintTitleBar(Graphics graphics, int n, int n2, boolean bl, JInternalFrame jInternalFrame, JComponent jComponent) {
        Image image = this.getImage("left-top-border", bl);
        Image image2 = this.getImage("top-center-left", bl);
        Image image3 = this.getImage("top-center-right", bl);
        Image image4 = this.getImage("right-top-border", bl);
        Image image5 = this.getImage("top-center-mid-left", bl);
        Image image6 = this.getImage("top-center-mid-right", bl);
        Image image7 = this.getImage("top-center-mid", bl);
        Metacity.FrameGeometry frameGeometry = this.getFrameGeometry();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = this.calculateTitleWidth(jInternalFrame, jComponent, fontMetrics);
        if (!bl) {
            Image image8 = image;
            int n4 = 0;
            int n5 = 0;
            int n6 = image8.getWidth(null);
            int n7 = n2;
            graphics.drawImage(image8, n4, n5, n6, n7, null);
            image8 = image4;
            n4 = n - image8.getWidth(null);
            n5 = 0;
            n6 = image8.getWidth(null);
            n7 = n2;
            graphics.drawImage(image8, n4, n5, n6, n7, null);
            image8 = image2;
            n4 = 4;
            n5 = 0;
            n6 = Math.min(frameGeometry.left_width + 16 + 2 + n3, n - frameGeometry.right_width - 48 - 48 * n2 / 22 - 3);
            n7 = n2;
            graphics.drawImage(image8, n4, n5, n6, n7, null);
            image8 = image7;
            if (image7 == null) {
                image8 = image5;
            }
            n4 = Math.min(frameGeometry.left_width + 16 + 2 + n3, n - image8.getWidth(null) * n2 / 22 - frameGeometry.right_width - 48) + 1;
            n5 = 0;
            n6 = image8.getWidth(null) * n2 / 22;
            n7 = n2;
            graphics.drawImage(image8, n4, n5, n6, n7, null);
            if (image7 == null) {
                image8 = image6;
                graphics.drawImage(image8, n4, n5, n6, n7, null);
            }
            image8 = image3;
            n4 = Math.min(frameGeometry.left_width + 16 + 2 + n3 + 48 * n2 / 22, n - 48 - frameGeometry.right_width) + 1;
            n5 = 0;
            n6 = Math.max(n - n3 - frameGeometry.left_width - 16 - 2 - 48 * n2 / 22 - frameGeometry.right_width, 48);
            n7 = n2;
            graphics.drawImage(image8, n4, n5, n6, n7, null);
        } else {
            Image image9 = this.getImage("active-left-top-border", this.getColor(512, GTKColorType.BACKGROUND));
            int n8 = 0;
            int n9 = 0;
            int n10 = image9.getWidth(null);
            int n11 = n2;
            graphics.drawImage(image9, n8, n9, n10, n11, null);
            image9 = image4;
            n8 = n - image9.getWidth(null);
            n9 = 0;
            n10 = image9.getWidth(null);
            n11 = n2;
            graphics.drawImage(image9, n8, n9, n10, n11, null);
            image9 = this.getImage("active-top-center-left", this.getColor(512, GTKColorType.BACKGROUND));
            n8 = 4;
            n9 = 0;
            n10 = Math.min(frameGeometry.left_width + 16 + 2 + n3, n - frameGeometry.right_width - 48 - 48 * n2 / 22 - 3);
            n11 = n2;
            graphics.drawImage(image9, n8, n9, n10, n11, null);
            image9 = this.getImage("active-top-center-mid-left", this.getColor(512, GTKColorType.BACKGROUND));
            n8 = Math.min(frameGeometry.left_width + 16 + 2 + n3, n - image9.getWidth(null) * n2 / 22 - frameGeometry.right_width - 48) + 1;
            n9 = 0;
            n10 = image9.getWidth(null) * n2 / 22;
            n11 = n2;
            graphics.drawImage(image9, n8, n9, n10, n11, null);
            image9 = image6;
            n8 = Math.min(frameGeometry.left_width + 16 + 2 + n3, n - image9.getWidth(null) * n2 / 22 - frameGeometry.right_width - 48) + 1;
            n9 = 0;
            n10 = image9.getWidth(null) * n2 / 22;
            n11 = n2;
            graphics.drawImage(image9, n8, n9, n10, n11, null);
            image9 = image3;
            n8 = Math.min(frameGeometry.left_width + 16 + 2 + n3 + 48 * n2 / 22, n - 48 - frameGeometry.right_width) + 1;
            n9 = 0;
            n10 = Math.max(n - n3 - frameGeometry.left_width - 16 - 2 - 48 * n2 / 22 - frameGeometry.right_width, 48);
            n11 = n2;
            graphics.drawImage(image9, n8, n9, n10, n11, null);
        }
        Color color = !bl ? Color.white : Color.white;
        String string = jInternalFrame.getTitle();
        if (string != null) {
            int n12;
            int n13 = (n2 + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
            if (jInternalFrame.getComponentOrientation().isLeftToRight()) {
                string = this.getTitle(string, fontMetrics, n3);
                n12 = frameGeometry.left_width + 16 + 2;
            } else {
                n12 = n - frameGeometry.right_width - 16 - 2 - SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            graphics.setColor(color);
            graphics.drawString(string, n12, n13);
        }
    }

    private int calculateTitleWidth(JInternalFrame jInternalFrame, JComponent jComponent, FontMetrics fontMetrics) {
        Metacity.FrameGeometry frameGeometry = this.getFrameGeometry();
        String string = jInternalFrame.getTitle();
        if (string != null) {
            JComponent jComponent2 = null;
            if (jInternalFrame.isIconifiable()) {
                jComponent2 = MetacityCrux.findChild(jComponent, "InternalFrameTitlePane.iconifyButton");
            }
            if (jComponent2 == null && jInternalFrame.isMaximizable()) {
                jComponent2 = MetacityCrux.findChild(jComponent, "InternalFrameTitlePane.maximizeButton");
            }
            if (jComponent2 == null && jInternalFrame.isClosable()) {
                jComponent2 = MetacityCrux.findChild(jComponent, "InternalFrameTitlePane.closeButton");
            }
            int n = jComponent2 != null ? jComponent2.getX() : jComponent.getWidth() - frameGeometry.right_titlebar_edge;
            return Math.min(SwingUtilities.computeStringWidth(fontMetrics, string), n - (frameGeometry.left_width + 16 + 2) - 3);
        }
        return 0;
    }

    private String getTitle(String string, FontMetrics fontMetrics, int n) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
        String string2 = "...";
        if (n2 > n) {
            int n3;
            int n4 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            for (n3 = 0; n3 < string.length() && (n4 += fontMetrics.charWidth(string.charAt(n3))) <= n; ++n3) {
            }
            string = string.substring(0, n3) + string2;
        }
        return string;
    }

    void paintFrameBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        this.context = synthContext;
        JComponent jComponent = synthContext.getComponent();
        JInternalFrame jInternalFrame = null;
        if (jComponent instanceof JInternalFrame) {
            jInternalFrame = (JInternalFrame)jComponent;
        } else if (jComponent instanceof JInternalFrame.JDesktopIcon) {
            jInternalFrame = ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame();
        } else {
            return;
        }
        JComponent jComponent2 = MetacityCrux.findChild(jInternalFrame, "InternalFrame.northPane");
        boolean bl = jInternalFrame.isSelected();
        this.setFrameGeometry(jComponent2, normalFrameGeometry);
        Image image = this.getImage("left-border", bl);
        Image image2 = this.getImage("right-border", bl);
        Image image3 = this.getImage("bottom-left-corner", bl);
        Image image4 = this.getImage("bottom-left-border", bl);
        Image image5 = this.getImage("bottom-right-border", bl);
        Image image6 = this.getImage("bottom-right-corner", bl);
        Image image7 = this.getImage("bottom-mid-border", bl);
        Image image8 = this.getImage("bottom-mid-left-border", bl);
        Image image9 = this.getImage("bottom-mid-right-border", bl);
        Font font = graphics.getFont();
        graphics.setFont(jComponent2.getFont());
        graphics.translate(n, n2);
        this.paintTitleBar(graphics, n3, jComponent2.getHeight(), bl, jInternalFrame, jComponent2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n6 = this.calculateTitleWidth(jInternalFrame, jComponent2, fontMetrics);
        int n7 = n5 = jComponent2 != null ? jComponent2.getPreferredSize().height : 16;
        if (image == null) {
            graphics.setColor(bl ? Color.black : Color.gray);
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
        } else if (!bl) {
            Image image10 = image;
            int n8 = 0;
            int n9 = 0;
            int n10 = image10.getWidth(null);
            int n11 = n4;
            n9 = n5;
            n11 = n4 - n5 - image3.getHeight(null);
            graphics.drawImage(image10, n8, n9, n10, n11, null);
            image10 = image2;
            n8 = 0;
            n9 = 0;
            n10 = image10.getWidth(null);
            n11 = n4;
            n8 = n3 - image2.getWidth(null);
            n9 = n5;
            n11 = n4 - n5 - image6.getHeight(null);
            graphics.drawImage(image10, n8, n9, n10, n11, null);
            image10 = image3;
            n8 = 0;
            n9 = n4 - image10.getHeight(null);
            n10 = image10.getWidth(null);
            n11 = image10.getHeight(null);
            graphics.drawImage(image10, n8, n9, n10, n11, null);
            image10 = image4;
            n8 = 5;
            n9 = n4 - image10.getHeight(null);
            n10 = Math.min(n6 + n4 / 2 - 4, n3 - image10.getWidth(null) - 26);
            n11 = image10.getHeight(null);
            graphics.drawImage(image10, n8, n9, n10, n11, null);
            image10 = image7;
            if (image7 == null) {
                image10 = image8;
            }
            n8 = Math.min(n6 + n4 / 2, n3 - image10.getWidth(null) - 6) + 1;
            n9 = n4 - image10.getHeight(null);
            n10 = image10.getWidth(null);
            n11 = image10.getHeight(null);
            graphics.drawImage(image10, n8, n9, n10, n11, null);
            if (image7 == null) {
                image10 = image9;
                graphics.drawImage(image10, n8, n9, n10, n11, null);
            }
            image10 = image5;
            n8 = n6 + n4 / 2 + 32 + 1;
            n9 = n4 - image10.getHeight(null);
            n10 = Math.max(n3 - n6 - n4 / 2 - 32 - 7, 0);
            n11 = image10.getHeight(null);
            graphics.drawImage(image10, n8, n9, n10, n11, null);
            image10 = image6;
            n8 = n3 - image10.getWidth(null);
            n9 = n4 - image10.getHeight(null);
            n10 = image10.getWidth(null);
            n11 = image10.getHeight(null);
            graphics.drawImage(image10, n8, n9, n10, n11, null);
        } else {
            Image image11 = this.getImage("active-left-border", this.getColor(512, GTKColorType.BACKGROUND));
            int n12 = 0;
            int n13 = 0;
            int n14 = image11.getWidth(null);
            int n15 = n4;
            n13 = n5;
            n15 = n4 - n5 - image3.getHeight(null);
            graphics.drawImage(image11, n12, n13, n14, n15, null);
            image11 = image2;
            n12 = 0;
            n13 = 0;
            n14 = image11.getWidth(null);
            n15 = n4;
            n12 = n3 - image2.getWidth(null);
            n13 = n5;
            n15 = n4 - n5 - image6.getHeight(null);
            graphics.drawImage(image11, n12, n13, n14, n15, null);
            image11 = this.getImage("active-bottom-left-corner", this.getColor(512, GTKColorType.BACKGROUND));
            n12 = 0;
            n13 = n4 - image11.getHeight(null);
            n14 = image11.getWidth(null);
            n15 = image11.getHeight(null);
            graphics.drawImage(image11, n12, n13, n14, n15, null);
            image11 = this.getImage("active-bottom-left-border", this.getColor(512, GTKColorType.BACKGROUND));
            n12 = 5;
            n13 = n4 - image11.getHeight(null);
            n14 = Math.min(n6 + n4 / 2 - 4, n3 - image11.getWidth(null) - 26);
            n15 = image11.getHeight(null);
            graphics.drawImage(image11, n12, n13, n14, n15, null);
            image11 = this.getImage("active-bottom-mid-left-border", this.getColor(512, GTKColorType.BACKGROUND));
            n12 = Math.min(n6 + n4 / 2, n3 - image11.getWidth(null) - 6) + 1;
            n13 = n4 - image11.getHeight(null);
            n14 = image11.getWidth(null);
            n15 = image11.getHeight(null);
            graphics.drawImage(image11, n12, n13, n14, n15, null);
            image11 = image9;
            n12 = Math.min(n6 + n4 / 2, n3 - image11.getWidth(null) - 6) + 1;
            n13 = n4 - image11.getHeight(null);
            n14 = image11.getWidth(null);
            n15 = image11.getHeight(null);
            graphics.drawImage(image11, n12, n13, n14, n15, null);
            image11 = image5;
            n12 = n6 + n4 / 2 + 32 + 1;
            n13 = n4 - image11.getHeight(null);
            n14 = Math.max(n3 - n6 - n4 / 2 - 32 - 7, 0);
            n15 = image11.getHeight(null);
            graphics.drawImage(image11, n12, n13, n14, n15, null);
            image11 = image6;
            n12 = n3 - image11.getWidth(null);
            n13 = n4 - image11.getHeight(null);
            n14 = image11.getWidth(null);
            n15 = image11.getHeight(null);
            graphics.drawImage(image11, n12, n13, n14, n15, null);
        }
        graphics.translate(-n, -n2);
        graphics.setFont(font);
    }

    Insets getBorderInsets(SynthContext synthContext, Insets insets) {
        Metacity.FrameGeometry frameGeometry = this.getFrameGeometry();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = frameGeometry.title_border.top;
        insets.bottom = frameGeometry.bottom_height;
        insets.left = frameGeometry.left_width;
        insets.right = frameGeometry.right_width;
        return insets;
    }

    private Image getImage(String string, Color color) {
        Image image = (Image)this.images.get(string + "-" + color.getRGB());
        if (image == null && (image = this.colorizeImage(this.getImage(string), color)) != null) {
            this.images.put(string + "-" + color.getRGB(), image);
        }
        return image;
    }

    private Image getImage(String string) {
        Image image = (Image)this.images.get(string);
        if (image == null) {
            if (this.themeDir != null) {
                final String string2 = this.themeDir + File.separator + string + ".png";
                image = (Image)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new ImageIcon(string2).getImage();
                    }
                });
            } else {
                String string3 = "resources/metacity/" + string + ".png";
                URL uRL = this.getClass().getResource(string3);
                if (uRL != null) {
                    image = new ImageIcon(uRL).getImage();
                }
            }
            if (image == null && string.startsWith("inactive")) {
                image = this.getImage(string.substring(2));
            }
            if (image != null) {
                this.images.put(string, image);
            }
        }
        return image;
    }

    private Image getImage(String string, boolean bl) {
        return this.getImage((bl ? "active" : "inactive") + "-" + string);
    }

    private static class NormalFrameGeometry
    extends Metacity.FrameGeometry {
        NormalFrameGeometry() {
            this.left_width = 5;
            this.right_width = 6;
            this.bottom_height = 6;
            this.left_titlebar_edge = 5;
            this.right_titlebar_edge = 6;
            this.aspect_ratio = 1.0f;
            this.title_vertical_pad = 0;
            this.title_border = new Insets(3, 0, 3, 0);
            this.button_border = new Insets(3, 0, 3, 0);
        }
    }
}

