/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import sun.misc.HexDumpEncoder;
import sun.security.util.Debug;

public class PKCS8Key
implements PrivateKey {
    private static final long serialVersionUID = -3836890099307167124L;
    protected AlgorithmId algid;
    protected byte[] key;
    protected byte[] encodedKey;
    public static final BigInteger version = BigInteger.ZERO;

    public PKCS8Key() {
    }

    private PKCS8Key(AlgorithmId algorithmId, byte[] byArray) throws InvalidKeyException {
        this.algid = algorithmId;
        this.key = byArray;
        this.encode();
    }

    public static PKCS8Key parse(DerValue derValue) throws IOException {
        PrivateKey privateKey = PKCS8Key.parseKey(derValue);
        if (privateKey instanceof PKCS8Key) {
            return (PKCS8Key)privateKey;
        }
        throw new IOException("Provider did not return PKCS8Key");
    }

    public static PrivateKey parseKey(DerValue derValue) throws IOException {
        PrivateKey privateKey;
        if (derValue.getTag() != 48) {
            throw new IOException("corrupt private key");
        }
        BigInteger bigInteger = derValue.getData().getBigInteger();
        if (!version.equals(bigInteger)) {
            throw new IOException("version mismatch: (supported: " + Debug.toHexString(version) + ", parsed: " + Debug.toHexString(bigInteger));
        }
        AlgorithmId algorithmId = AlgorithmId.parse((DerValue)derValue.getData().getDerValue());
        try {
            privateKey = PKCS8Key.buildPKCS8Key(algorithmId, derValue.getData().getOctetString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("corrupt private key");
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("excess private key");
        }
        return privateKey;
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        this.encode();
    }

    static PrivateKey buildPKCS8Key(AlgorithmId algorithmId, byte[] byArray) throws IOException, InvalidKeyException {
        DerOutputStream derOutputStream = new DerOutputStream();
        PKCS8Key.encode(derOutputStream, algorithmId, byArray);
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(derOutputStream.toByteArray());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithmId.getName());
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        PKCS8Key pKCS8Key = new PKCS8Key();
        pKCS8Key.algid = algorithmId;
        pKCS8Key.key = byArray;
        return pKCS8Key;
    }

    public String getAlgorithm() {
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public final void encode(DerOutputStream derOutputStream) throws IOException {
        PKCS8Key.encode(derOutputStream, this.algid, this.key);
    }

    public synchronized byte[] getEncoded() {
        byte[] byArray = null;
        try {
            byArray = this.encode();
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return byArray;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] encode() throws InvalidKeyException {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.encodedKey = derOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("IOException : " + iOException.getMessage());
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        return "algorithm = " + this.algid.toString() + ", unparsed keybits = \n" + hexDumpEncoder.encodeBuffer(this.key);
    }

    public void decode(InputStream inputStream) throws InvalidKeyException {
        try {
            DerValue derValue = new DerValue(inputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            BigInteger bigInteger = derValue.getData().getBigInteger();
            if (!bigInteger.equals(version)) {
                throw new IOException("version mismatch: (supported: " + Debug.toHexString(version) + ", parsed: " + Debug.toHexString(bigInteger));
            }
            this.algid = AlgorithmId.parse((DerValue)derValue.getData().getDerValue());
            this.key = derValue.getData().getOctetString();
            this.parseKeyBits();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException("excess key data");
            }
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("IOException : " + iOException.getMessage());
        }
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(byArray));
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getEncoded());
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.decode(objectInputStream);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            throw new IOException("deserialized key is invalid: " + invalidKeyException.getMessage());
        }
    }

    static void encode(DerOutputStream derOutputStream, AlgorithmId algorithmId, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(version);
        algorithmId.encode(derOutputStream2);
        derOutputStream2.putOctetString(byArray);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            byte[] byArray;
            byte[] byArray2 = this.encodedKey != null ? this.encodedKey : this.getEncoded();
            if (byArray2.length != (byArray = ((Key)object).getEncoded()).length) {
                return false;
            }
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] == byArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        byte[] byArray = this.getEncoded();
        for (int i = 1; i < byArray.length; ++i) {
            n += byArray[i] * i;
        }
        return n;
    }
}

