/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import sun.security.pkcs.ParsingException;

public class ContentInfo {
    private static int[] data = new int[]{1, 2, 840, 113549, 1, 7, 1};
    private static final int[] OLD_SDATA = new int[]{1, 2, 840, 1113549, 1, 7, 2};
    private static final int[] OLD_DATA = new int[]{1, 2, 840, 1113549, 1, 7, 1};
    public static ObjectIdentifier DATA_OID;
    public static ObjectIdentifier OLD_SIGNED_DATA_OID;
    public static ObjectIdentifier OLD_DATA_OID;
    ObjectIdentifier contentType;
    DerValue content;

    public ContentInfo(ObjectIdentifier objectIdentifier, DerValue derValue) {
        this.contentType = objectIdentifier;
        this.content = derValue;
    }

    public ContentInfo(byte[] byArray) {
        DerValue derValue = new DerValue(4, byArray);
        this.contentType = DATA_OID;
        this.content = derValue;
    }

    public ContentInfo(DerInputStream derInputStream) throws IOException, ParsingException {
        this(derInputStream, false);
    }

    public ContentInfo(DerInputStream derInputStream, boolean bl) throws IOException, ParsingException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        DerValue derValue = derValueArray[0];
        DerInputStream derInputStream2 = new DerInputStream(derValue.toByteArray());
        this.contentType = derInputStream2.getOID();
        if (bl) {
            this.content = derValueArray[1];
        } else if (derValueArray.length > 1) {
            DerValue derValue2 = derValueArray[1];
            DerInputStream derInputStream3 = new DerInputStream(derValue2.toByteArray());
            DerValue[] derValueArray2 = derInputStream3.getSet(1, true);
            this.content = derValueArray2[0];
        }
    }

    public DerValue getContent() {
        return this.content;
    }

    public ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public byte[] getData() throws IOException {
        if (this.contentType.equals(DATA_OID) || this.contentType.equals(OLD_DATA_OID)) {
            if (this.content == null) {
                return null;
            }
            return this.content.getOctetString();
        }
        throw new IOException("content type is not DATA: " + this.contentType);
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.contentType);
        if (this.content != null) {
            DerValue derValue = null;
            DerOutputStream derOutputStream3 = new DerOutputStream();
            this.content.encode(derOutputStream3);
            derValue = new DerValue(-96, derOutputStream3.toByteArray());
            derOutputStream2.putDerValue(derValue);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public byte[] getContentBytes() throws IOException {
        if (this.content == null) {
            return null;
        }
        DerInputStream derInputStream = new DerInputStream(this.content.toByteArray());
        return derInputStream.getOctetString();
    }

    public String toString() {
        return "Content Info Sequence\n\tContent type: " + this.contentType + "\n" + "\tContent: " + this.content;
    }

    static {
        try {
            DATA_OID = new ObjectIdentifier(data);
            OLD_SIGNED_DATA_OID = new ObjectIdentifier(OLD_SDATA);
            OLD_DATA_OID = new ObjectIdentifier(OLD_DATA);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

