/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.prefs;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.ui.general.GeneralUtilities;
import com.sun.javaws.ui.player.Player;
import com.sun.javaws.ui.prefs.PrefsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class AdvancedPanel
extends PrefsPanel.PropertyPanel
implements ActionListener {
    private JCheckBox _consoleCB;
    private JCheckBox _logFileCB;
    private JButton _logFileChooserButton;
    private JTextField _baseDirTF;
    private JLabel _currentSizeLabel;
    private JSlider _sizeTF;
    private JButton _clearButton;
    private JTextField _logFileTF;

    protected void createPropertyControls() {
        Insets insets = new Insets(0, 2, 5, 2);
        this.setBorder(new TitledBorder(LineBorder.createGrayLineBorder(), Resources.getString("controlpanel.advanced.title"), 1, 2));
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._consoleCB = new JCheckBox(Resources.getString("controlpanel.advanced.consoleCB"));
        this._consoleCB.setMnemonic(Resources.getVKCode("controlpanel.advanced.consoleMnemonic"));
        this._consoleCB.getAccessibleContext().setAccessibleDescription(Resources.getString("controlpanel.advanced.consoleCB.desc"));
        jPanel.add((Component)this._consoleCB, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this._logFileCB = new JCheckBox(Resources.getString("controlpanel.advanced.logOutputCB"));
        this._logFileCB.setMnemonic(Resources.getVKCode("controlpanel.advanced.logOutputMnemonic"));
        this._logFileCB.getAccessibleContext().setAccessibleDescription(Resources.getString("controlpanel.advanced.logOutputCB.desc"));
        this._logFileCB.addActionListener(this);
        jPanel.add((Component)this._logFileCB, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this._logFileChooserButton = new JButton(Resources.getString("controlpanel.advanced.chooseLogButton"));
        this._logFileChooserButton.setMnemonic(Resources.getVKCode("controlpanel.advanced.chooseLogMnemonic"));
        this._logFileChooserButton.getAccessibleContext().setAccessibleDescription(Resources.getString("controlpanel.advanced.chooseLogButtonDescr"));
        this._logFileChooserButton.setEnabled(false);
        this._logFileChooserButton.setRequestFocusEnabled(false);
        this._logFileChooserButton.addActionListener(this);
        jPanel.add((Component)this._logFileChooserButton, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        JLabel jLabel = new JLabel(Resources.getString("controlpanel.advanced.logFileLabel"));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this._logFileTF = new JTextField("NONE");
        this._logFileTF.setEnabled(false);
        jPanel.add((Component)this._logFileTF, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        jLabel.setDisplayedMnemonic(Resources.getVKCode("controlpanel.advanced.logFileMnemonic"));
        jLabel.setLabelFor(this._logFileTF);
        this._logFileTF.getAccessibleContext().setAccessibleDescription(Resources.getString("controlpanel.advanced.logFileTF.desc"));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel2 = new JLabel(Resources.getString("controlpanel.advanced.baseDirLabel"));
        jPanel2.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this._baseDirTF = new JTextField();
        this._baseDirTF.setEditable(true);
        this._baseDirTF.getAccessibleContext().setAccessibleDescription(Resources.getString("controlpanel.advanced.basedDirTF.desc"));
        jPanel2.add((Component)this._baseDirTF, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        jLabel2.setLabelFor(this._baseDirTF);
        jLabel2.setDisplayedMnemonic(Resources.getVKCode("controlpanel.advanced.baseDirMnemonic"));
        JLabel jLabel3 = new JLabel(Resources.getString("controlpanel.advanced.currentSizeLabel"));
        jPanel2.add((Component)jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this._currentSizeLabel = new JLabel();
        jPanel2.add((Component)this._currentSizeLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this._clearButton = new JButton(Resources.getString("controlpanel.advanced.clearCacheButton"));
        this._clearButton.setRequestFocusEnabled(false);
        this._clearButton.setMnemonic(Resources.getVKCode("controlpanel.advanced.clearCacheMnemonic"));
        this._clearButton.addActionListener(this);
        jPanel2.add((Component)this._clearButton, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        jPanel.setBorder(new TitledBorder(LineBorder.createGrayLineBorder(), Resources.getString("controlpanel.advanced.output"), 1, 2));
        jPanel2.setBorder(new TitledBorder(LineBorder.createGrayLineBorder(), Resources.getString("controlpanel.advanced.cache"), 1, 2));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        this.revert();
    }

    private boolean isCacheDirValid(String string) {
        Object object;
        File file = new File(string = string + File.separator);
        if (!file.exists()) {
            file.mkdirs();
        } else {
            object = file.listFiles();
            if (object == null) {
                return false;
            }
            boolean bl = false;
            for (int i = 0; i < ((File[])object).length; ++i) {
                if (!object[i].getName().equals("lastAccessed")) continue;
                bl = true;
            }
            if (((File[])object).length == 0) {
                bl = true;
            }
            if (!bl) {
                return false;
            }
        }
        if (file.canRead() && file.canWrite()) {
            object = null;
            try {
                object = File.createTempFile("javaws", null, file);
                ((File)object).delete();
            }
            catch (IOException iOException) {
                Debug.ignoredException(iOException);
                return false;
            }
            return true;
        }
        return false;
    }

    public void apply() {
        ConfigProperties configProperties = this.getConfigProperties();
        String string = this._baseDirTF.getText();
        if (this.isCacheDirValid(string)) {
            configProperties.put("deployment.javaws.cache.dir", string);
        } else {
            GeneralUtilities.showMessageDialog(this, Resources.getString("cacheOption.invalidDir", string), Resources.getString("cacheOption.invalidDir.title"), 0);
        }
        configProperties.put("deployment.javaws.showConsole", String.valueOf(this._consoleCB.isSelected()));
        configProperties.put("deployment.javaws.logFileName", this._logFileTF.getText());
        configProperties.put("deployment.javaws.logToFile", String.valueOf(this._logFileCB.isSelected()));
    }

    public void revert() {
        ConfigProperties configProperties = this.getConfigProperties();
        String string = configProperties.get("deployment.javaws.showConsole");
        String string2 = configProperties.get("deployment.javaws.logToFile");
        this._consoleCB.setSelected(string != null ? Boolean.valueOf(string) : true);
        this._logFileCB.setSelected(string2 != null ? Boolean.valueOf(string2) : true);
        this._logFileTF.setText(configProperties.get("deployment.javaws.logFileName"));
        this._baseDirTF.setText(configProperties.get("deployment.javaws.cache.dir"));
        long l = 0L;
        try {
            l = InstallCache.getDiskCache().getCacheSize();
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        this._currentSizeLabel.setText(String.valueOf(l / 1024L));
        this._clearButton.getAccessibleContext().setAccessibleDescription(Resources.getString("controlpanel.advanced.clearCacheButtonDescr") + "  " + this._currentSizeLabel.getText());
        this._clearButton.setEnabled(l > 0L);
        if (this._logFileCB.isSelected()) {
            this._logFileTF.setEnabled(true);
            this._logFileTF.setEditable(true);
            this._logFileChooserButton.setEnabled(true);
        } else {
            this._logFileTF.setEnabled(false);
            this._logFileTF.setEditable(false);
            this._logFileChooserButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._clearButton) {
            this.doClearButtonActions(actionEvent);
            this._clearButton.requestFocus();
        } else if (object == this._logFileChooserButton) {
            this.doLogFileChooserActions(actionEvent);
            this._logFileChooserButton.requestFocus();
        } else if (object == this._logFileCB) {
            this.doLogToFileCB(actionEvent);
        }
    }

    private void doClearButtonActions(ActionEvent actionEvent) {
        String string = Resources.getString("controlpanel.advanced.clearCache1");
        String string2 = Resources.getString("controlpanel.advanced.clearCache2");
        Object[] objectArray = new Object[]{string, string2};
        if (GeneralUtilities.showOptionDialog(this, objectArray, Resources.getString("controlpanel.advanced.clearCacheTitle"), 0, 3) == 0) {
            Remover remover = new Remover();
            new Thread(remover).start();
        }
    }

    private void doLogFileChooserActions(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this._logFileChooserButton);
        if (n == 0) {
            ConfigProperties configProperties = this.getConfigProperties();
            File file = jFileChooser.getSelectedFile();
            this._logFileTF.setText(file.getAbsolutePath());
            configProperties.put("deployment.javaws.logFileName", file.getAbsolutePath());
        }
    }

    private void doLogToFileCB(ActionEvent actionEvent) {
        if (this._logFileCB.isSelected()) {
            this._logFileTF.setEnabled(true);
            this._logFileTF.setEditable(true);
            this._logFileChooserButton.setEnabled(true);
        } else {
            this._logFileTF.setEnabled(false);
            this._logFileTF.setEditable(false);
            this._logFileChooserButton.setEnabled(false);
        }
    }

    private class Remover
    implements Runnable {
        public void run() {
            InstallCache.getCache().remove();
            Player.getPlayer().resetCacheEntryManager();
            AdvancedPanel.this.revert();
        }
    }
}

