/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.security.CertificateStore;
import com.sun.javaws.security.DeniedCertificateStore;
import com.sun.javaws.security.HttpsRootCACertStore;
import com.sun.javaws.security.JavawsHttpsCertStore;
import com.sun.javaws.security.RootCACertificateStore;
import com.sun.javaws.security.SessionCertificateStore;
import com.sun.javaws.security.TrustDeciderDialog;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class X509JavawsTrustManager
implements X509TrustManager {
    private X509TrustManager trustManager = null;
    private static CertificateStore rootStore = null;
    private static CertificateStore permanentStore = null;
    private static CertificateStore httpsRootStore = null;
    private static CertificateStore sessionStore = null;
    private static CertificateStore deniedStore = null;

    public static void reset() {
        rootStore = new RootCACertificateStore();
        permanentStore = new JavawsHttpsCertStore();
        httpsRootStore = new HttpsRootCACertStore();
        sessionStore = new SessionCertificateStore();
        deniedStore = new DeniedCertificateStore();
    }

    public X509JavawsTrustManager() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("IbmX509");
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        this.trustManager = (X509TrustManager)trustManagerArray[0];
    }

    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 1;
        try {
            rootStore.load();
            httpsRootStore.load();
            permanentStore.load();
            sessionStore.load();
            deniedStore.load();
            if (deniedStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            try {
                this.trustManager.checkClientTrusted(x509CertificateArray, string);
                return;
            }
            catch (CertificateException certificateException) {
                if (sessionStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (permanentStore.contains(x509CertificateArray[0])) {
                    return;
                }
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    if (!rootStore.verify(x509CertificateArray[i]) && !httpsRootStore.verify(x509CertificateArray[i])) {
                        bl = true;
                    }
                    try {
                        x509CertificateArray[i].checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        bl2 = true;
                        continue;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        bl2 = true;
                    }
                }
                TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(x509CertificateArray, 0, x509CertificateArray.length, bl, bl2);
                trustDeciderDialog.setHttpsDialog(true);
                n = trustDeciderDialog.DoModal();
                if (n == 0) {
                    sessionStore.add(x509CertificateArray[0]);
                    sessionStore.save();
                } else if (n == 2) {
                    permanentStore.add(x509CertificateArray[0]);
                    permanentStore.save();
                } else {
                    deniedStore.add(x509CertificateArray[0]);
                    deniedStore.save();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n != 0 && n != 2) {
            throw new CertificateException("Java Web Start couldn't trust Client");
        }
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 1;
        try {
            rootStore.load();
            httpsRootStore.load();
            permanentStore.load();
            sessionStore.load();
            deniedStore.load();
            if (deniedStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            try {
                this.trustManager.checkServerTrusted(x509CertificateArray, string);
                return;
            }
            catch (CertificateException certificateException) {
                if (sessionStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (permanentStore.contains(x509CertificateArray[0])) {
                    return;
                }
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    if (!rootStore.verify(x509CertificateArray[i]) && !httpsRootStore.verify(x509CertificateArray[i])) {
                        bl = true;
                    }
                    try {
                        x509CertificateArray[i].checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        bl2 = true;
                        continue;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        bl2 = true;
                    }
                }
                TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(x509CertificateArray, 0, x509CertificateArray.length, bl, bl2);
                trustDeciderDialog.setHttpsDialog(true);
                n = trustDeciderDialog.DoModal();
                if (n == 0) {
                    sessionStore.add(x509CertificateArray[0]);
                    sessionStore.save();
                } else if (n == 2) {
                    permanentStore.add(x509CertificateArray[0]);
                    permanentStore.save();
                } else {
                    deniedStore.add(x509CertificateArray[0]);
                    deniedStore.save();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n != 0 && n != 2) {
            throw new CertificateException("Java Web Start couldn't trust Server");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    static {
        X509JavawsTrustManager.reset();
    }
}

