/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.xml.XMLAttribute;
import com.sun.javaws.xml.XMLAttributeBuilder;
import com.sun.javaws.xml.XMLNode;
import com.sun.javaws.xml.XMLNodeBuilder;
import com.sun.javaws.xml.XMLable;
import java.net.URL;

public class InformationDesc
implements XMLable {
    private String[] _localeList;
    private String _title;
    private String _vendor;
    private URL _home;
    private String[] _descriptions;
    private IconDesc[] _icons;
    private boolean _supportOfflineOperation;
    public static final int DESC_DEFAULT = 0;
    public static final int DESC_SHORT = 1;
    public static final int DESC_ONELINE = 2;
    public static final int DESC_TOOLTIP = 3;
    public static final int NOF_DESC = 4;
    public static final int ICON_SIZE_SMALL = 0;
    public static final int ICON_SIZE_MEDIUM = 1;
    public static final int ICON_SIZE_LARGE = 2;

    public InformationDesc(String string, String string2, URL uRL, String[] stringArray, IconDesc[] iconDescArray, boolean bl, String[] stringArray2) {
        this._title = string;
        this._vendor = string2;
        this._home = uRL;
        if (stringArray == null) {
            stringArray = new String[4];
        }
        this._descriptions = stringArray;
        this._icons = iconDescArray;
        this._supportOfflineOperation = bl;
        this._localeList = stringArray2;
    }

    public String getTitle() {
        return this._title;
    }

    public String getVendor() {
        return this._vendor;
    }

    public URL getHome() {
        return this._home;
    }

    public boolean supportsOfflineOperation() {
        return this._supportOfflineOperation;
    }

    public IconDesc[] getIcons() {
        return this._icons;
    }

    public String[] getLocaleList() {
        return this._localeList;
    }

    public String getDescription(int n) {
        String string = this._descriptions[n];
        if (string == null) {
            string = this._descriptions[0];
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public IconDesc getIconLocation(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 0: {
                n4 = 16;
                n3 = 16;
                break;
            }
            case 1: {
                n4 = 32;
                n3 = 32;
                break;
            }
            case 2: {
                n4 = 64;
                n3 = 64;
            }
        }
        IconDesc iconDesc = null;
        long l = 0L;
        for (int i = 0; i < this._icons.length; ++i) {
            IconDesc iconDesc2 = this._icons[i];
            if (iconDesc2.getKind() != n2) continue;
            if (iconDesc2.getHeight() == n3 && iconDesc2.getWidth() == n4) {
                return iconDesc2;
            }
            if (iconDesc2.getHeight() == 0 && iconDesc2.getWidth() == 0) {
                if (iconDesc != null) continue;
                iconDesc = iconDesc2;
                continue;
            }
            long l2 = Math.abs(iconDesc2.getHeight() * iconDesc2.getWidth() - n3 * n4);
            if (l != 0L && l2 >= l) continue;
            l = l2;
            iconDesc = iconDesc2;
        }
        return iconDesc;
    }

    public XMLNode asXML() {
        XMLAttributeBuilder xMLAttributeBuilder = new XMLAttributeBuilder();
        XMLNodeBuilder xMLNodeBuilder = new XMLNodeBuilder("information", xMLAttributeBuilder.getAttributeList());
        xMLNodeBuilder.add("title", this._title);
        xMLNodeBuilder.add("vendor", this._vendor);
        xMLNodeBuilder.add(new XMLNode("homepage", new XMLAttribute("href", this._home != null ? this._home.toString() : null), null, null));
        xMLNodeBuilder.add(this.getDescriptionNode(0, ""));
        xMLNodeBuilder.add(this.getDescriptionNode(1, "short"));
        xMLNodeBuilder.add(this.getDescriptionNode(2, "one-line"));
        xMLNodeBuilder.add(this.getDescriptionNode(3, "tooltip"));
        if (this._icons != null) {
            for (int i = 0; i < this._icons.length; ++i) {
                xMLNodeBuilder.add(this._icons[i]);
            }
        }
        if (this._supportOfflineOperation) {
            xMLNodeBuilder.add(new XMLNode("offline-allowed", null));
        }
        return xMLNodeBuilder.getNode();
    }

    private XMLNode getDescriptionNode(int n, String string) {
        String string2 = this._descriptions[n];
        if (string2 == null) {
            return null;
        }
        XMLAttributeBuilder xMLAttributeBuilder = new XMLAttributeBuilder();
        xMLAttributeBuilder.add("kind", string);
        return new XMLNode("description", xMLAttributeBuilder.getAttributeList(), new XMLNode(string2), null);
    }
}

