/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertException;
import com.ibm.security.x509.CertParseError;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X500Signer;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Certificate;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;

public class X509Cert
implements Certificate,
Serializable {
    static final long serialVersionUID = -52595524744692374L;
    protected transient AlgorithmId algid;
    private transient byte[] rawCert;
    private transient byte[] signature;
    private transient byte[] signedCert;
    private transient X500Name subject;
    private transient PublicKey pubkey;
    private transient Date notafter;
    private transient Date notbefore;
    private transient int version;
    private transient BigInteger serialnum;
    private transient X500Name issuer;
    private transient AlgorithmId issuerSigAlg;
    private transient boolean parsed = false;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X509Cert";

    public X509Cert() {
        if (debug != null) {
            debug.entry(16384L, className, "X509Cert");
            debug.exit(16384L, className, "X509Cert");
        }
    }

    public X509Cert(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509Cert", (Object)byArray);
        }
        DerValue derValue = new DerValue(byArray);
        this.parse(derValue);
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "X509Cert", "garbage at end");
            }
            throw new CertParseError("garbage at end");
        }
        this.signedCert = byArray;
        if (debug != null) {
            debug.exit(16384L, className, "X509Cert");
        }
    }

    public X509Cert(byte[] byArray, int n, int n2) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{byArray, new Integer(n), new Integer(n2)};
            debug.entry(16384L, (Object)className, "X509Cert", objectArray);
        }
        objectArray = new DerValue(byArray, n, n2);
        this.parse((DerValue)objectArray);
        if (objectArray.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "X509Cert", "garbage at end");
            }
            throw new CertParseError("garbage at end");
        }
        this.signedCert = new byte[n2];
        System.arraycopy(byArray, n, this.signedCert, 0, n2);
        if (debug != null) {
            debug.exit(16384L, className, "X509Cert");
        }
    }

    public X509Cert(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509Cert", derValue);
        }
        this.parse(derValue);
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "X509Cert", "garbage at end");
            }
            throw new CertParseError("garbage at end");
        }
        this.signedCert = derValue.toByteArray();
        if (debug != null) {
            debug.exit(16384L, className, "X509Cert");
        }
    }

    public X509Cert(X500Name x500Name, X509Key x509Key, Date date, Date date2) throws CertException {
        if (debug != null) {
            Object[] objectArray = new Object[]{x500Name, x509Key, date, date2};
            debug.entry(16384L, (Object)className, "X509Cert", objectArray);
        }
        this.subject = x500Name;
        if (!(x509Key instanceof PublicKey)) {
            if (debug != null) {
                debug.text(16384L, className, "X509Cert", "Doesn't implement PublicKey interface");
            }
            throw new CertException(9, "Doesn't implement PublicKey interface");
        }
        this.pubkey = x509Key;
        this.notbefore = date;
        this.notafter = date2;
        this.version = 0;
        if (debug != null) {
            debug.exit(16384L, className, "X509Cert");
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
        }
        DerValue derValue = new DerValue(inputStream);
        this.parse(derValue);
        this.signedCert = derValue.toByteArray();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        outputStream.write(this.getSignedCert());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        boolean bl = false;
        if (object instanceof X509Cert) {
            bl = this.equals((X509Cert)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(bl));
        }
        return bl;
    }

    public boolean equals(X509Cert x509Cert) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", x509Cert);
        }
        boolean bl = true;
        if (this == x509Cert) {
            bl = true;
        } else if (this.signedCert == null || x509Cert.signedCert == null) {
            bl = false;
        } else if (this.signedCert.length != x509Cert.signedCert.length) {
            bl = false;
        } else {
            for (int i = 0; i < this.signedCert.length; ++i) {
                if (this.signedCert[i] == x509Cert.signedCert[i]) continue;
                bl = false;
                break;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", bl);
        }
        return bl;
    }

    public String getFormat() {
        return "X.509";
    }

    public Principal getGuarantor() {
        return this.getIssuerName();
    }

    public Principal getPrincipal() {
        return this.getSubjectName();
    }

    public void verify(PublicKey publicKey) throws CertException {
        Date date;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verify", publicKey);
        }
        if ((date = new Date()).before(this.notbefore)) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Certificate is not yet valid");
            }
            throw new CertException(3);
        }
        if (date.after(this.notafter)) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Certificate has expired");
            }
            throw new CertException(4);
        }
        if (this.signedCert == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "?? certificate is not signed yet ??");
            }
            throw new CertException(1, "?? certificate is not signed yet ??");
        }
        String string = null;
        try {
            Signature signature = null;
            string = this.issuerSigAlg.getName();
            signature = Signature.getInstance(string);
            signature.initVerify(publicKey);
            signature.update(this.rawCert, 0, this.rawCert.length);
            if (!signature.verify(this.signature)) {
                if (debug != null) {
                    debug.text(16384L, className, "verify", "Signature ... by <" + this.issuer + "> for <" + this.subject + ">");
                }
                throw new CertException(1, "Signature ... by <" + this.issuer + "> for <" + this.subject + ">");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Unsupported signature algorithm (" + string + ")");
            }
            throw new CertException(1, "Unsupported signature algorithm (" + string + ")");
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Algorithm (" + string + ") rejected public key");
            }
            throw new CertException(9, "Algorithm (" + string + ") rejected public key");
        }
        catch (SignatureException signatureException) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature by <" + this.issuer + "> for <" + this.subject + ">");
            }
            throw new CertException(1, "Signature by <" + this.issuer + "> for <" + this.subject + ">");
        }
        if (debug != null) {
            debug.exit(16384L, className, "verify");
        }
    }

    public byte[] encodeAndSign(BigInteger bigInteger, X500Signer x500Signer) throws IOException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "encodeAndSign", bigInteger, x500Signer);
        }
        this.rawCert = null;
        this.version = 0;
        this.serialnum = bigInteger;
        this.issuer = x500Signer.getSigner();
        this.issuerSigAlg = x500Signer.getAlgorithmId();
        if (this.subject == null || this.pubkey == null || this.notbefore == null || this.notafter == null) {
            if (debug != null) {
                debug.text(16384L, className, "encodeAndSign", "not enough cert parameters");
            }
            throw new IOException("not enough cert parameters");
        }
        this.rawCert = this.DERencode();
        this.signedCert = this.sign(x500Signer, this.rawCert);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encodeAndSign", this.signedCert);
        }
        return this.signedCert;
    }

    public X500Signer getSigner(AlgorithmId algorithmId, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, className, "setSigner", algorithmId, privateKey);
        }
        if (!(privateKey instanceof Key)) {
            if (debug != null) {
                debug.text(16384L, className, "setSigner", "private key not a key!");
            }
            throw new InvalidKeyException("private key not a key!");
        }
        Serializable serializable = privateKey;
        String string = serializable.getAlgorithm();
        Signature signature = Signature.getInstance(algorithmId.getName());
        if (!this.pubkey.getAlgorithm().equals(string)) {
            if (debug != null) {
                debug.text(16384L, className, "setSigner", "Private key algorithm " + string + " incompatible with certificate " + this.pubkey.getAlgorithm());
            }
            throw new InvalidKeyException("Private key algorithm " + string + " incompatible with certificate " + this.pubkey.getAlgorithm());
        }
        signature.initSign(privateKey);
        serializable = new X500Signer(signature, this.subject);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "setSigner", serializable);
        }
        return serializable;
    }

    public Signature getVerifier(String string) throws NoSuchAlgorithmException, InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getVerifier", string);
        }
        Signature signature = Signature.getInstance(string);
        signature.initVerify(this.pubkey);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getVerifier", signature);
        }
        return signature;
    }

    public byte[] getSignedCert() {
        return (byte[])this.signedCert.clone();
    }

    public BigInteger getSerialNumber() {
        return this.serialnum;
    }

    public X500Name getSubjectName() {
        return this.subject;
    }

    public X500Name getIssuerName() {
        return this.issuer;
    }

    public AlgorithmId getIssuerAlgorithmId() {
        return this.issuerSigAlg;
    }

    public Date getNotBefore() {
        return new Date(this.notbefore.getTime());
    }

    public Date getNotAfter() {
        return new Date(this.notafter.getTime());
    }

    public PublicKey getPublicKey() {
        return this.pubkey;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
        }
        int n = 0;
        for (int i = 0; i < this.signedCert.length; ++i) {
            n += this.signedCert[i] * i;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hashCode", n);
        }
        return n;
    }

    public String toString() {
        if (this.subject == null || this.pubkey == null || this.notbefore == null || this.notafter == null || this.issuer == null || this.issuerSigAlg == null || this.serialnum == null) {
            throw new NullPointerException("X.509 cert is incomplete");
        }
        String string = "  X.509v" + (this.version + 1) + " certificate,\n";
        string = string + "  Subject is " + this.subject + "\n";
        string = string + "  Key:  " + this.pubkey;
        string = string + "  Validity <" + this.notbefore + "> until <" + this.notafter + ">\n";
        string = string + "  Issuer is " + this.issuer + "\n";
        string = string + "  Issuer signature used " + this.issuerSigAlg.toString() + "\n";
        string = string + "  Serial number = " + this.serialnum + "\n";
        return "[\n" + string + "]";
    }

    public String toString(boolean bl) {
        return this.toString();
    }

    private void parse(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "parse", derValue);
        }
        if (this.parsed) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "Certificate already parsed");
            }
            throw new IOException("Certificate already parsed");
        }
        DerValue[] derValueArray = new DerValue[]{derValue.getData().getDerValue(), derValue.getData().getDerValue(), derValue.getData().getDerValue()};
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "signed overrun, bytes = " + derValue.getData().available());
            }
            throw new CertParseError("signed overrun, bytes = " + derValue.getData().available());
        }
        if (derValueArray[0].getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "signed fields invalid");
            }
            throw new CertParseError("signed fields invalid");
        }
        this.rawCert = derValueArray[0].toByteArray();
        this.issuerSigAlg = AlgorithmId.parse(derValueArray[1]);
        this.signature = derValueArray[2].getBitString();
        if (derValueArray[1].getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "algid field overrun");
            }
            throw new CertParseError("algid field overrun");
        }
        if (derValueArray[2].getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "signed fields overrun");
            }
            throw new CertParseError("signed fields overrun");
        }
        DerInputStream derInputStream = derValueArray[0].getData();
        this.version = 0;
        DerValue derValue2 = derInputStream.getDerValue();
        if (derValue2.isConstructed() && derValue2.isContextSpecific()) {
            this.version = derValue2.getData().getInteger().intValue();
            if (derValue2.getData().available() != 0) {
                if (debug != null) {
                    debug.text(16384L, className, "parse", "X.509 version, bad format");
                }
                throw new IOException("X.509 version, bad format");
            }
            derValue2 = derInputStream.getDerValue();
        }
        this.serialnum = derValue2.getInteger();
        derValue2 = derInputStream.getDerValue();
        AlgorithmId algorithmId = AlgorithmId.parse(derValue2);
        if (!algorithmId.equals(this.issuerSigAlg)) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "CA Algorithm mismatch!");
            }
            throw new CertParseError("CA Algorithm mismatch!");
        }
        this.algid = algorithmId;
        this.issuer = new X500Name(derInputStream);
        derValue2 = derInputStream.getDerValue();
        if (derValue2.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "corrupt validity field");
            }
            throw new CertParseError("corrupt validity field");
        }
        this.notbefore = derValue2.getData().getUTCTime();
        this.notafter = derValue2.getData().getUTCTime();
        if (derValue2.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "excess validity data");
            }
            throw new CertParseError("excess validity data");
        }
        this.subject = new X500Name(derInputStream);
        derValue2 = derInputStream.getDerValue();
        this.pubkey = X509Key.parse(derValue2);
        if (derInputStream.available() != 0) {
            // empty if block
        }
        this.parsed = true;
        if (debug != null) {
            debug.exit(16384L, className, "parse");
        }
    }

    private byte[] DERencode() throws IOException {
        if (debug != null) {
            debug.exit(16384L, className, "DERencode");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encode(derOutputStream);
        byte[] byArray = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DERencode", byArray);
        }
        return byArray;
    }

    private void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.serialnum);
        this.issuerSigAlg.encode(derOutputStream2);
        this.issuer.encode(derOutputStream2);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.putUTCTime(this.notbefore);
        derOutputStream3.putUTCTime(this.notafter);
        derOutputStream2.write((byte)48, derOutputStream3);
        this.subject.encode(derOutputStream2);
        derOutputStream2.write(this.pubkey.getEncoded());
        derOutputStream.write((byte)48, derOutputStream2);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    private byte[] sign(X500Signer x500Signer, byte[] byArray) throws IOException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "sign", x500Signer, byArray);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(byArray);
        x500Signer.getAlgorithmId().encode(derOutputStream2);
        x500Signer.update(byArray, 0, byArray.length);
        this.signature = x500Signer.sign();
        derOutputStream2.putBitString(this.signature);
        derOutputStream.write((byte)48, derOutputStream2);
        byte[] byArray2 = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "sign", byArray2);
        }
        return byArray2;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.encode(objectOutputStream);
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.decode(objectInputStream);
    }
}

