/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.KeyUsageExtension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;

public final class NetscapeCertTypeExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.NetscapeCertType";
    public static final String NAME = "NetscapeCertType";
    public static final String SSL_CLIENT = "ssl_client";
    public static final String SSL_SERVER = "ssl_server";
    public static final String S_MIME = "s_mime";
    public static final String OBJECT_SIGNING = "object_signing";
    public static final String SSL_CA = "ssl_ca";
    public static final String S_MIME_CA = "s_mime_ca";
    public static final String OBJECT_SIGNING_CA = "object_signing_ca";
    private static final int[] CertType_data = new int[]{2, 16, 840, 1, 113730, 1, 1};
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.NetscapeCertTypeExtension";
    public static ObjectIdentifier NetscapeCertType_Id;
    private boolean[] bitString;
    private static MapEntry[] mMapData;
    private static final Vector mAttributeNames;

    private static int getPosition(String string) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "getPosition", string);
        }
        for (int i = 0; i < mMapData.length; ++i) {
            if (!string.equalsIgnoreCase(NetscapeCertTypeExtension.mMapData[i].mName)) continue;
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getPosition", NetscapeCertTypeExtension.mMapData[i].mPosition);
            }
            return NetscapeCertTypeExtension.mMapData[i].mPosition;
        }
        if (debug != null) {
            debug.text(8192L, className, "getPosition", "Attribute name [" + string + "] not recognized by CertAttrSet:NetscapeCertType.");
        }
        throw new IOException("Attribute name [" + string + "] not recognized by CertAttrSet:NetscapeCertType.");
    }

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putNamedBitString(new BitArray(this.bitString));
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis");
        }
    }

    private boolean isSet(int n) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "isSet", new Integer(n));
            debug.exit(8192L, (Object)className, "isSet", this.bitString[n]);
        }
        return this.bitString[n];
    }

    private void set(int n, boolean bl) {
        if (debug != null) {
            debug.entry(8192L, className, "set", new Integer(n), new Boolean(bl));
        }
        if (n >= this.bitString.length) {
            boolean[] blArray = new boolean[n + 1];
            System.arraycopy(this.bitString, 0, blArray, 0, this.bitString.length);
            this.bitString = blArray;
        }
        this.bitString[n] = bl;
        if (debug != null) {
            debug.exit(8192L, className, "set");
        }
    }

    public NetscapeCertTypeExtension(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "NetscapeCertTypeExtension", (Object)byArray);
        }
        this.bitString = new BitArray(byArray.length * 8, byArray).toBooleanArray();
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "NetscapeCertTypeExtension");
        }
    }

    public NetscapeCertTypeExtension(boolean[] blArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "NetscapeCertTypeExtension", (Object)blArray);
        }
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.bitString = blArray != null ? (boolean[])blArray.clone() : blArray;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "NetscapeCertTypeExtension");
        }
    }

    public NetscapeCertTypeExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "NetscapeCertTypeExtension", bl, object);
        }
        this.extensionId = NetscapeCertType_Id;
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = Array.getByte(object, i);
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        this.bitString = derValue.getUnalignedBitString().toBooleanArray();
        if (debug != null) {
            debug.exit(16384L, className, "NetscapeCertTypeExtension");
        }
    }

    public NetscapeCertTypeExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "NetscapeCertTypeExtension");
        }
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.bitString = new boolean[0];
        if (debug != null) {
            debug.exit(16384L, className, "NetscapeCertTypeExtension");
        }
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (!(object instanceof Boolean)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type Boolean.");
            }
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean bl = (Boolean)object;
        this.set(NetscapeCertTypeExtension.getPosition(string), bl);
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
            debug.exit(16384L, (Object)className, "get", new Boolean(this.isSet(NetscapeCertTypeExtension.getPosition(string))));
        }
        return new Boolean(this.isSet(NetscapeCertTypeExtension.getPosition(string)));
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        this.set(NetscapeCertTypeExtension.getPosition(string), false);
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public String toString() {
        String string;
        block11: {
            if (debug != null) {
                debug.entry(16384L, className, "toString");
            }
            string = super.toString() + "NetscapeCertType [\n";
            try {
                if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CLIENT))) {
                    string = string + "   SSL client\n";
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_SERVER))) {
                    string = string + "   SSL server\n";
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME))) {
                    string = string + "   S/MIME\n";
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING))) {
                    string = string + "   Object Signing\n";
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CA))) {
                    string = string + "   SSL CA\n";
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME_CA))) {
                    string = string + "   S/MIME CA\n";
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING_CA))) {
                    string = string + "   Object Signing CA";
                }
            }
            catch (Exception exception) {
                if (debug == null) break block11;
                debug.exception(16384L, className, "toString", exception);
            }
        }
        string = string + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.exit(16384L, (Object)className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = NetscapeCertType_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
            debug.exit(16384L, (Object)className, "getElements", mAttributeNames.elements());
        }
        return mAttributeNames.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public boolean[] getKeyUsageMappedBits() {
        KeyUsageExtension keyUsageExtension;
        block7: {
            if (debug != null) {
                debug.entry(16384L, className, "getKeyUsageMappedBits");
            }
            keyUsageExtension = new KeyUsageExtension();
            Boolean bl = new Boolean(true);
            try {
                if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CLIENT)) || this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME)) || this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING))) {
                    keyUsageExtension.set("digital_signature", bl);
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_SERVER))) {
                    keyUsageExtension.set("key_encipherment", bl);
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CA)) || this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME_CA)) || this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING_CA))) {
                    keyUsageExtension.set("key_certsign", bl);
                }
            }
            catch (IOException iOException) {
                if (debug == null) break block7;
                debug.exception(16384L, className, "getKeyUsageMappedBits", iOException);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getKeyUsageMappedBits", keyUsageExtension.getBits());
        }
        return keyUsageExtension.getBits();
    }

    static {
        try {
            NetscapeCertType_Id = new ObjectIdentifier(CertType_data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        mMapData = new MapEntry[]{new MapEntry(SSL_CLIENT, 0), new MapEntry(SSL_SERVER, 1), new MapEntry(S_MIME, 2), new MapEntry(OBJECT_SIGNING, 3), new MapEntry(SSL_CA, 5), new MapEntry(S_MIME_CA, 6), new MapEntry(OBJECT_SIGNING_CA, 7)};
        mAttributeNames = new Vector();
        for (int i = 0; i < mMapData.length; ++i) {
            mAttributeNames.addElement(NetscapeCertTypeExtension.mMapData[i].mName);
        }
    }

    private static class MapEntry {
        String mName;
        int mPosition;

        MapEntry(String string, int n) {
            this.mName = string;
            this.mPosition = n;
        }
    }
}

