/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralNameInterface;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class IPAddressName
implements GeneralNameInterface {
    private byte[] address;
    private boolean isIPv4;
    private String name;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.IPAddressName";
    private static final int MASKSIZE = 16;
    private static final int IN6ADDRSZ = 16;
    private static final int INT16SZ = 2;
    private static final int INADDRSZ = 4;

    public IPAddressName(DerValue derValue) throws IOException {
        this(derValue.getOctetString());
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IPAddressName", derValue);
            debug.exit(16384L, className, "IPAddressName");
        }
    }

    public IPAddressName(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IPAddressName", (Object)byArray);
        }
        if (byArray != null) {
            if (byArray.length == 4 || byArray.length == 8) {
                this.isIPv4 = true;
            } else if (byArray.length == 16 || byArray.length == 32) {
                this.isIPv4 = false;
            } else {
                throw new IOException("Invalid IPAddressName");
            }
            this.address = (byte[])byArray.clone();
        } else {
            this.address = byArray;
        }
        if (debug != null) {
            debug.exit(16384L, className, "IPAddressName");
        }
    }

    public IPAddressName(String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException("IPAddressName cannot be null");
        }
        if (string.charAt(string.length() - 1) == '/') {
            throw new IOException("Invalid IPAddress " + string);
        }
        if (string.indexOf(":") >= 0) {
            this.parseIPv6(string);
            this.isIPv4 = false;
        } else if (string.indexOf(".") >= 0) {
            int n = string.indexOf(47);
            if (n == -1) {
                this.address = IPAddressName.ipv4_getByteArray(string);
                if (this.address == null) {
                    throw new IOException("Invalid IPAddress" + string);
                }
            } else {
                this.address = new byte[8];
                byte[] byArray = IPAddressName.ipv4_getByteArray(string.substring(n + 1));
                byte[] byArray2 = IPAddressName.ipv4_getByteArray(string.substring(0, n));
                if (byArray == null || byArray2 == null) {
                    throw new IOException("Invalid IPAddress" + string);
                }
                System.arraycopy(byArray2, 0, this.address, 0, 4);
                System.arraycopy(byArray, 0, this.address, 4, 4);
                this.isIPv4 = true;
            }
        } else {
            throw new IOException("Invalid IPAddressName " + string);
        }
    }

    private void parseIPv6(String string) throws IOException {
        Object object;
        int n = string.indexOf(47);
        if (n >= 0) {
            this.address = new byte[32];
            object = IPAddressName.ipv6_getByteArray(string.substring(0, n));
            if (object == null) {
                throw new IOException("Invalid IPAddress" + string);
            }
            System.arraycopy(object, 0, this.address, 0, 16);
        } else {
            this.address = IPAddressName.ipv6_getByteArray(string);
            if (this.address == null) {
                throw new IOException("Invalid IPAddress" + string);
            }
        }
        if (n >= 0) {
            object = string.substring(n + 1);
            int n2 = Integer.parseInt((String)object);
            if (n2 > 128) {
                throw new IOException("Prefix may not be longer than 128");
            }
            BitArray bitArray = new BitArray(128);
            for (int i = 0; i < n2; ++i) {
                bitArray.set(i, true);
            }
            byte[] byArray = bitArray.toByteArray();
            for (int i = 0; i < 16; ++i) {
                this.address[16 + i] = byArray[i];
            }
        }
    }

    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 7);
        }
        return 7;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        if (this.address != null) {
            derOutputStream.putOctetString(this.address);
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        try {
            return "IPAddress: " + this.getName();
        }
        catch (IOException iOException) {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            return "IPAddress: " + hexDumpEncoder.encodeBuffer(this.address);
        }
    }

    public byte[] getBytes() {
        if (this.address != null) {
            return (byte[])this.address.clone();
        }
        return null;
    }

    public String getName() throws IOException {
        String string = "";
        if (this.address != null) {
            if (this.isIPv4) {
                string = string + (this.address[0] & 0xFF) + "." + (this.address[1] & 0xFF) + "." + (this.address[2] & 0xFF) + "." + (this.address[3] & 0xFF);
                if (this.address.length == 8) {
                    string = string + "/" + (this.address[4] & 0xFF) + "." + (this.address[5] & 0xFF) + "." + (this.address[6] & 0xFF) + "." + (this.address[7] & 0xFF);
                }
            } else {
                int n;
                String string2 = "";
                int n2 = this.address.length;
                for (int i = 0; i < 8; ++i) {
                    n = ((this.address[i * 2] & 0xFF) << 8) + (this.address[i * 2 + 1] & 0xFF);
                    String string3 = Integer.toHexString(n);
                    if (string3.length() > 4) {
                        string3 = string3.substring(string3.length() - 4, string3.length());
                    }
                    string2 = i == 7 ? (n2 == 16 ? "" : "/") : ":";
                    string = string + string3 + string2;
                }
                if (n2 == 32) {
                    int n3;
                    byte[] byArray = new byte[16];
                    for (n = 16; n < 32; ++n) {
                        byArray[n - 16] = this.address[n];
                    }
                    BitArray bitArray = new BitArray(128, byArray);
                    for (n3 = 0; n3 < 128 && bitArray.get(n3); ++n3) {
                    }
                    string = string + n3;
                    while (n3 < 128) {
                        if (bitArray.get(n3)) {
                            throw new IOException("Invalid IPv6 subdomain - set bit " + n3 + " not contiguous");
                        }
                        ++n3;
                    }
                }
            }
        }
        return string;
    }

    static byte[] ipv6_getByteArray(String string) {
        int n;
        byte[] byArray = null;
        try {
            byArray = string.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "ipv6_getByteArray", unsupportedEncodingException);
            }
            byArray = string.getBytes();
        }
        byte[] byArray2 = new byte[16];
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        if (byArray[n3] == 58 && byArray[++n3] != 58) {
            return null;
        }
        boolean bl = false;
        int n5 = 0;
        while (n3 < byArray.length) {
            byte by;
            if ((n = Character.digit((char)(by = byArray[n3++]), 16)) != -1) {
                n5 <<= 4;
                if ((n5 |= n) > 65535) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (by == 58) {
                if (!bl) {
                    if (n2 != -1) {
                        return null;
                    }
                    n2 = n4;
                    continue;
                }
                if (n3 == byArray.length) {
                    return null;
                }
                if (n4 + 2 > 16) {
                    return null;
                }
                byArray2[n4++] = (byte)(n5 >> 8 & 0xFF);
                byArray2[n4++] = (byte)(n5 & 0xFF);
                bl = false;
                n5 = 0;
                continue;
            }
            if (by == 46 && n4 + 4 <= 16) {
                byte[] byArray3 = IPAddressName.ipv4_getByteArray(string.substring(n3));
                for (int i = 0; i < 4; ++i) {
                    byArray2[n4++] = byArray3[i];
                }
                bl = false;
                break;
            }
            return null;
        }
        if (bl) {
            if (n4 + 2 > 16) {
                return null;
            }
            byArray2[n4++] = (byte)(n5 >> 8 & 0xFF);
            byArray2[n4++] = (byte)(n5 & 0xFF);
        }
        if (n2 != -1) {
            n = n4 - n2;
            if (n4 == 16) {
                return null;
            }
            for (n3 = 1; n3 <= n; ++n3) {
                byArray2[16 - n3] = byArray2[n2 + n - n3];
                byArray2[n2 + n - n3] = 0;
            }
            n4 = 16;
        }
        if (n4 != 16) {
            return null;
        }
        return byArray2;
    }

    static byte[] ipv4_getByteArray(String string) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "ipv4_getByteArray", unsupportedEncodingException);
            }
            byArray2 = string.getBytes();
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray2.length) {
            byte by;
            if (Character.isDigit((char)(by = byArray2[n2++]))) {
                byArray[n3] = (byte)(byArray[n3] * 10 + (Character.digit((char)by, 10) & 0xFF));
                if (byArray[n3] > 255) {
                    return null;
                }
                if (bl) continue;
                if (++n > 4) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (by == 46 && bl) {
                if (n == 4) {
                    return null;
                }
                byArray[++n3] = 0;
                bl = false;
                continue;
            }
            return null;
        }
        if (n < 4) {
            return null;
        }
        return byArray;
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n;
        if (this.address == null) {
            return 2;
        }
        if (generalNameInterface == null) {
            n = -1;
        } else if (generalNameInterface.getType() != 7) {
            n = -1;
        } else if (((IPAddressName)generalNameInterface).equals(this)) {
            n = 0;
        } else {
            byte[] byArray = ((IPAddressName)generalNameInterface).getBytes();
            if (byArray.length == 4 && this.address.length == 4) {
                n = 3;
            } else if (byArray.length == 8 && this.address.length == 8 || byArray.length == 32 && this.address.length == 32) {
                boolean bl = true;
                boolean bl2 = true;
                boolean bl3 = false;
                boolean bl4 = false;
                int n2 = this.address.length / 2;
                for (int i = 0; i < n2; ++i) {
                    if ((byte)(this.address[i] & this.address[i + n2]) != this.address[i]) {
                        bl3 = true;
                    }
                    if ((byte)(byArray[i] & byArray[i + n2]) != byArray[i]) {
                        bl4 = true;
                    }
                    if ((byte)(this.address[i + n2] & byArray[i + n2]) != this.address[i + n2] || (byte)(this.address[i] & this.address[i + n2]) != (byte)(byArray[i] & this.address[i + n2])) {
                        bl = false;
                    }
                    if ((byte)(byArray[i + n2] & this.address[i + n2]) == byArray[i + n2] && (byte)(byArray[i] & byArray[i + n2]) == (byte)(this.address[i] & byArray[i + n2])) continue;
                    bl2 = false;
                }
                n = bl3 || bl4 ? (bl3 && bl4 ? 0 : (bl3 ? 2 : 1)) : (bl ? 1 : (bl2 ? 2 : 3));
            } else if (byArray.length == 8 || byArray.length == 32) {
                int n3;
                int n4 = byArray.length / 2;
                for (n3 = 0; n3 < n4 && (this.address[n3] & byArray[n3 + n4]) == byArray[n3]; ++n3) {
                }
                n = n3 == n4 ? 2 : 3;
            } else if (this.address.length == 8 || this.address.length == 32) {
                int n5;
                int n6 = this.address.length / 2;
                for (n5 = 0; n5 < n6 && (byArray[n5] & this.address[n5 + n6]) == this.address[n5]; ++n5) {
                }
                n = n5 == n6 ? 1 : 3;
            } else {
                n = 3;
            }
        }
        return n;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not defined for IPAddressName");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IPAddressName)) {
            return false;
        }
        byte[] byArray = ((IPAddressName)object).getBytes();
        if (byArray == null) {
            return this.address == null;
        }
        if (this.address == null) {
            return false;
        }
        if (byArray.length != this.address.length) {
            return false;
        }
        if (this.address.length == 8 || this.address.length == 32) {
            int n;
            int n2 = this.address.length / 2;
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = new byte[n2];
            for (n = 0; n < n2; ++n) {
                byArray2[n] = (byte)(this.address[n] & this.address[n + n2]);
                byArray3[n] = (byte)(byArray[n] & byArray[n + n2]);
                if (byArray2[n] == byArray3[n]) continue;
                return false;
            }
            for (n = n2; n < this.address.length; ++n) {
                if (this.address[n] == byArray[n]) continue;
                return false;
            }
            return true;
        }
        return Arrays.equals(byArray, this.address);
    }

    public int hashCode() {
        int n = 0;
        if (this.address != null) {
            for (int i = 0; i < this.address.length; ++i) {
                n += this.address[i] * i;
            }
        }
        return n;
    }
}

