/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

class UTFUtils {
    UTFUtils() {
    }

    static StringBuffer fromUTF(byte[] byArray) {
        byte by;
        int n = 0;
        int n2 = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        block6: while (n3 < n2 && ((by = byArray[n3++]) != 0 || n3 != n2)) {
            switch (by & 0xF0) {
                case 192: 
                case 208: {
                    n = (by & 0x1F) << 6;
                    if (n3 < n2) break;
                    throw new IllegalArgumentException();
                }
                case 224: {
                    n = (by & 0xF) << 12;
                    if (n3 >= n2 - 1) {
                        throw new IllegalArgumentException();
                    }
                    if (((by = byArray[n3++]) & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    if ((n += (by & 0x3F) << 6) <= 55295 || n >= 49152) break;
                    throw new IllegalArgumentException();
                }
                case 0: 
                case 16: 
                case 32: 
                case 48: 
                case 64: 
                case 80: 
                case 96: 
                case 112: {
                    stringBuffer.append((char)by);
                    continue block6;
                }
                case 240: {
                    n = (by & 0xF) << 18;
                    if (n3 >= n2 - 2) {
                        throw new IllegalArgumentException();
                    }
                    if (((by = byArray[n3++]) & 0xC0) == 128) {
                        n += (by & 0x3F) << 12;
                    }
                    if (((by = byArray[n3++]) & 0xC0) == 128) {
                        n += (by & 0x3F) << 6;
                    }
                    if (((by = byArray[n3++]) & 0xC0) == 128) {
                        UTFUtils.toUTF16(n + (by & 0x3F), stringBuffer);
                        continue block6;
                    }
                    throw new IllegalArgumentException();
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (((by = byArray[n3++]) & 0xC0) == 128) {
                stringBuffer.append((char)(n + (by & 0x3F)));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return stringBuffer;
    }

    static StringBuffer fromUniv(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        if ((n2 & 3) != 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n2; i += 4) {
            if (byArray[i] != 0) {
                throw new IllegalArgumentException();
            }
            n = (byArray[i + 1] << 16) + (byArray[i + 2] << 8);
            if ((n += byArray[i + 3]) > 65535) {
                UTFUtils.toUTF16(n, stringBuffer);
                continue;
            }
            if (n < 55296 || n > 57343) {
                stringBuffer.append((char)n);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return stringBuffer;
    }

    private static int fromUTF16(char c, char c2) {
        if (c < '\ud800' || c > '\udbff' || c2 < '\udc00' || c2 > '\udfff') {
            return 0;
        }
        int n = (c & 0x3FF) << 10;
        return n + 65536 + (c2 & 0x3FF);
    }

    private static void toUTF16(int n, StringBuffer stringBuffer) {
        int n2 = n - 65536;
        if (n2 > 1048575 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        stringBuffer.append((char)((n2 >> 10) + 55296));
        stringBuffer.append((char)((n2 & 0x3FF) + 56320));
    }

    static byte[] toUTF(String string) {
        char c;
        int n;
        int n2 = n = string.length();
        while (--n2 >= 0) {
            c = string.charAt(n2);
            if ((c & 0xFF80) == 0) continue;
            if ((c & 0xF800) == 0) {
                ++n;
                continue;
            }
            n += c > '\ud7ff' && c < '\uc000' ? 1 : 2;
        }
        int n3 = n;
        byte[] byArray = new byte[n];
        n2 = 0;
        n = 0;
        while (n2 < n3) {
            c = string.charAt(n);
            if ((c & 0xFF80) == 0) {
                byArray[n2++] = (byte)c;
            } else {
                if ((c & 0xF800) != 0) {
                    if (c > '\ud7ff' && c < '\uc000') {
                        int n4 = UTFUtils.fromUTF16(c, string.charAt(++n));
                        byArray[n2++] = (byte)(0xF0 | n4 >> 18);
                        byArray[n2++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                    } else {
                        byArray[n2++] = (byte)(0xE0 | c >> 12);
                        byArray[n2++] = (byte)(0x80 | c >> 6 & 0x3F);
                    }
                } else {
                    byArray[n2++] = (byte)(0xC0 | c >> 6);
                }
                byArray[n2++] = (byte)(0x80 | c & 0x3F);
            }
            ++n;
        }
        return byArray;
    }

    static byte[] toUniv(String string) {
        char c;
        int n;
        int n2 = n = string.length();
        while (--n2 >= 0) {
            c = string.charAt(n2);
            if (c <= '\ud7ff' || c >= '\udc00') continue;
            --n;
        }
        int n3 = n * 4;
        byte[] byArray = new byte[n3];
        n2 = 0;
        n = 0;
        while (n2 < n3) {
            c = string.charAt(n);
            if ((c & 0xFF80) == 0) {
                byArray[n2++] = (byte)c;
            } else {
                if ((c & 0xF800) != 0) {
                    if (c > '\ud7ff' && c < '\uc000') {
                        int n4 = UTFUtils.fromUTF16(c, string.charAt(++n));
                        byArray[n2++] = (byte)(0xF0 | n4 >> 18);
                        byArray[n2++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                    } else {
                        byArray[n2++] = (byte)(0xE0 | c >> 12);
                        byArray[n2++] = (byte)(0x80 | c >> 6 & 0x3F);
                    }
                } else {
                    byArray[n2++] = (byte)(0xC0 | c >> 6);
                }
                byArray[n2++] = (byte)(0x80 | c & 0x3F);
            }
            ++n;
        }
        return byArray;
    }
}

