/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.smime.jmail.PKCS7MimeDataSource;
import com.ibm.security.smime.jmail.PKCS7NewMimeDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class SMIMEMimeMultipart
extends MimeMultipart {
    private ContentInfo contentInfo;
    private String provider = null;
    private boolean oldTypes = true;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.SMIMEMimeMultipart";

    public SMIMEMimeMultipart() {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMimeMultipart");
            debug.exit(16384L, className, "SMIMEMimeMultipart");
        }
        this.contentInfo = null;
    }

    public SMIMEMimeMultipart(DataSource dataSource) throws MessagingException {
        super(dataSource);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEMimeMultipart", dataSource);
        }
        if (dataSource instanceof PKCS7MimeDataSource) {
            PKCS7MimeDataSource pKCS7MimeDataSource = (PKCS7MimeDataSource)dataSource;
            this.contentInfo = pKCS7MimeDataSource.getContentInfo();
            this.oldTypes = true;
        } else if (dataSource instanceof PKCS7NewMimeDataSource) {
            PKCS7NewMimeDataSource pKCS7NewMimeDataSource = (PKCS7NewMimeDataSource)dataSource;
            this.contentInfo = pKCS7NewMimeDataSource.getContentInfo();
            this.oldTypes = false;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "SMIMEMimeMultipart", "DataSource must be an instance of PKCS7MimeDataSource.  Instead ds is an instance of " + dataSource.getClass().getName());
            }
            throw new IllegalArgumentException("DataSource must be an instance of PKCS7MimeDataSource.  Instead ds is an instance of " + dataSource.getClass().getName());
        }
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMultipart");
        }
    }

    public SMIMEMimeMultipart(DataSource dataSource, String string) throws MessagingException {
        super(dataSource);
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMimeMultipart", dataSource, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        if (dataSource instanceof PKCS7MimeDataSource) {
            PKCS7MimeDataSource pKCS7MimeDataSource = (PKCS7MimeDataSource)dataSource;
            this.contentInfo = pKCS7MimeDataSource.getContentInfo();
            this.oldTypes = true;
        } else if (dataSource instanceof PKCS7NewMimeDataSource) {
            PKCS7NewMimeDataSource pKCS7NewMimeDataSource = (PKCS7NewMimeDataSource)dataSource;
            this.contentInfo = pKCS7NewMimeDataSource.getContentInfo();
            this.oldTypes = false;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "SMIMEMimeMultipart", "DataSource must be an instance of PKCS7MimeDataSource.  Instead ds is an instance of " + dataSource.getClass().getName());
            }
            throw new IllegalArgumentException("DataSource must be an instance of PKCS7MimeDataSource.  Instead ds is an instance of " + dataSource.getClass().getName());
        }
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMultipart");
        }
    }

    public SMIMEMimeMultipart(String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEMimeMultipart", string);
            debug.exit(16384L, className, "SMIMEMimeMultipart");
        }
        this.contentInfo = null;
    }

    public SMIMEMimeMultipart(String string, String string2) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMimeMultipart", string, string2);
        }
        if (string2 != null) {
            this.provider = new String(string2);
        }
        this.contentInfo = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMultipart");
        }
    }

    public void setProvider(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setProvider", string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        if (debug != null) {
            debug.exit(16384L, className, "setProvider");
        }
    }

    public void setSMIMEContentType(boolean bl) {
        this.oldTypes = bl;
    }

    public boolean getSMIMEContentType() {
        return this.oldTypes;
    }

    public void signSignatureOnly(Object object, Certificate certificate, PrivateKey privateKey, String string) throws PKCSException, IOException, NoSuchAlgorithmException, MessagingException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{object, certificate, privateKey, string};
            debug.entry(16384L, (Object)className, "signSignatureOnly", objectArray);
        }
        if (this.contentInfo != null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "ContentInfo must not be specified.");
            }
            throw new PKCSException("ContentInfo must not be specified.");
        }
        if (object == null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "Message must be specified.");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "digestSignatureAlgorithm must be specified.");
            }
            throw new IllegalArgumentException("digestSignatureAlgorithm must be specified.");
        }
        objectArray = new MimeBodyPart();
        if (object instanceof String) {
            objectArray.setContent(object, "text/plain");
        } else if (object instanceof Multipart) {
            objectArray.setContent((Multipart)object);
        } else {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "message must be an instance of String or Multipart.  Instead message is an instance of " + object.getClass().getName());
            }
            throw new IllegalArgumentException("message must be an instance of String or Multipart.  Instead message is an instance of " + object.getClass().getName());
        }
        this.addBodyPart((BodyPart)objectArray);
        this.updateHeaders();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        objectArray.writeTo((OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        Data data = new Data(this.provider);
        data.setData(byArray);
        ContentInfo contentInfo = new ContentInfo(data, this.provider);
        boolean bl = false;
        SignedData signedData = new SignedData(certificate, contentInfo, string, privateKey, bl, this.provider);
        signedData.removeContent();
        ContentInfo contentInfo2 = new ContentInfo(signedData, this.provider);
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        String string2 = null;
        string2 = this.oldTypes ? "application/x-pkcs7-signature; name=\"" : "application/pkcs7-signature; name=\"";
        string2 = string2 + "smime.p7s\"";
        String string3 = "attachment; filename=\"smime.p7s\"";
        String string4 = "S/MIME Cryptographic Signature";
        mimeBodyPart.setContent((Object)contentInfo2, string2);
        mimeBodyPart.setDisposition(string3);
        mimeBodyPart.setDescription(string4);
        this.addBodyPart((BodyPart)mimeBodyPart);
        String string5 = PKCS7.getDigestAlgorithm(string);
        String string6 = this.getmicalg(string5);
        String string7 = null;
        string7 = this.oldTypes ? "signed; protocol=\"application/x-pkcs7-signature\"; micalg=" + string6 : "signed; protocol=\"application/pkcs7-signature\"; micalg=" + string6;
        this.setSubType(string7);
        this.updateHeaders();
        if (debug != null) {
            debug.exit(16384L, className, "signSignatureOnly");
        }
    }

    private String getmicalg(String string) {
        String string2 = string;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "getmicalg", string);
        }
        if (string2.equalsIgnoreCase("md5")) {
            string2 = "md5";
        } else if (string2.equalsIgnoreCase("sha") || string2.equalsIgnoreCase("sha1") || string2.equalsIgnoreCase("sha-1")) {
            string2 = "sha1";
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getmicalg", string2);
        }
        return string2;
    }

    public String toString() {
        String string = "SMIMEMimeMultipart:  ";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        string = this.contentInfo != null ? string + this.contentInfo.toString() : string + "Does not contain a ContentInfo object.";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }
}

