/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.smime.jmail.PKCS10NewMimeDataSource;
import com.ibm.security.smime.jmail.SMIMEMimeMessage;
import com.ibm.security.smime.jmail.SMIMEUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePartDataSource;

public class PKCS10NewMimeHandler
implements DataContentHandler {
    private static String PKCS10NEWMIMEDATASOURCE_CLASSNAME = "com.ibm.security.smime.jmail.PKCS10NewMimeDataSource";
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.PKCS10NewMimeHandler";

    public PKCS10NewMimeHandler() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS10NewMimeHandler");
            debug.exit(16384L, className, "PKCS10NewMimeHandler");
        }
    }

    public PKCS10NewMimeHandler(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS10NewMimeHandler", string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS10NewMimeHandler");
        }
    }

    public Object getContent(DataSource dataSource) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getContent", dataSource);
        }
        if (dataSource instanceof PKCS10NewMimeDataSource) {
            PKCS10NewMimeDataSource pKCS10NewMimeDataSource = (PKCS10NewMimeDataSource)dataSource;
            CertificationRequest certificationRequest = pKCS10NewMimeDataSource.getCertificationRequest();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent_1", certificationRequest);
            }
            return certificationRequest;
        }
        if (dataSource instanceof MimePartDataSource) {
            MimePartDataSource mimePartDataSource = (MimePartDataSource)dataSource;
            MessageContext messageContext = mimePartDataSource.getMessageContext();
            Session session = messageContext.getSession();
            Message message = messageContext.getMessage();
            if (message instanceof SMIMEMimeMessage) {
                SMIMEMimeMessage sMIMEMimeMessage = (SMIMEMimeMessage)messageContext.getMessage();
                byte[] byArray = SMIMEUtils.getMessageBodyRemoveTrailer(sMIMEMimeMessage.getContentBytes());
                PKCS10NewMimeDataSource pKCS10NewMimeDataSource = new PKCS10NewMimeDataSource(byArray, true, this.provider);
                CertificationRequest certificationRequest = pKCS10NewMimeDataSource.getCertificationRequest();
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getContent_2", certificationRequest);
                }
                return certificationRequest;
            }
            if (message instanceof MimeMessage) {
                try {
                    MimeMessage mimeMessage = (MimeMessage)message;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    mimeMessage.writeTo((OutputStream)byteArrayOutputStream);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    SMIMEMimeMessage sMIMEMimeMessage = new SMIMEMimeMessage(session, (InputStream)byteArrayInputStream, this.provider);
                    CertificationRequest certificationRequest = sMIMEMimeMessage.getCertificationRequest();
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "getContent_3", certificationRequest);
                    }
                    return certificationRequest;
                }
                catch (MessagingException messagingException) {
                    if (debug != null) {
                        debug.exception(16384L, className, "getContent", messagingException);
                    }
                    throw new IOException(messagingException.toString());
                }
            }
        }
        if (debug != null) {
            debug.text(16384L, className, "getContent", "Only PKCS10NewMimeDataSource supported.  DataSource class was " + dataSource.getClass().getName());
        }
        throw new IOException("Only PKCS10NewMimeDataSource supported.  DataSource class was " + dataSource.getClass().getName());
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray;
        block4: {
            if (debug != null) {
                debug.entry(16384L, className, "getTransferDataFlavors");
            }
            dataFlavorArray = new DataFlavor[2];
            try {
                dataFlavorArray[0] = new ActivationDataFlavor(Class.forName("java.lang.String"), "application/pkcs10", "PKCS10 MIME");
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                debug.exception(16384L, className, "getTransferDataFlavors", exception);
            }
        }
        dataFlavorArray[1] = new DataFlavor("application/pkcs10", "PKCS10 MIME");
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getTransferDataFlavors", dataFlavorArray);
        }
        return dataFlavorArray;
    }

    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws UnsupportedFlavorException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getTransferData", dataFlavor, dataSource);
        }
        if (dataFlavor == null) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", "DataFlavor is null");
            }
            throw new IOException("DataFlavor is null");
        }
        if (dataSource == null) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", "DataSource is null");
            }
            throw new IOException("DataSource is null");
        }
        if (!dataFlavor.getMimeType().equals("application/pkcs10")) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", dataFlavor.getMimeType() + " not supported by PKCS10NewMimeHandler.");
            }
            throw new IOException(dataFlavor.getMimeType() + " not supported by PKCS10NewMimeHandler.");
        }
        if (!dataFlavor.getRepresentationClass().getName().equals(PKCS10NEWMIMEDATASOURCE_CLASSNAME)) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", dataFlavor.getRepresentationClass().getName() + " not supported by PKCS10NewMimeHandler.");
            }
            throw new IOException(dataFlavor.getRepresentationClass().getName() + " not supported by PKCS10NewMimeHandler.");
        }
        try {
            CertificationRequest certificationRequest = null;
            if (dataSource instanceof PKCS10NewMimeDataSource) {
                certificationRequest = ((PKCS10NewMimeDataSource)dataSource).getCertificationRequest();
            } else {
                ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)dataSource.getInputStream();
                int n = byteArrayInputStream.available();
                byte[] byArray = new byte[n];
                int n2 = byteArrayInputStream.read(byArray, 0, n);
                certificationRequest = new CertificationRequest(byArray, this.provider);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getTransferData_1", certificationRequest);
            }
            return certificationRequest;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getTransferData", exception);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getTransferData_2", null);
            }
            return null;
        }
    }

    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{object, string, outputStream};
            debug.entry(16384L, (Object)className, "writeTo", objectArray);
        }
        if (object instanceof CertificationRequest) {
            objectArray = (Object[])object;
            objectArray.encode(outputStream);
            if (debug != null) {
                debug.exit(16384L, className, "writeTo");
            }
            return;
        }
        if (debug != null) {
            debug.text(16384L, className, "writeTo", "obj must be of type CertificationRequest.  Instead obj is of class " + object.getClass().getName());
        }
        throw new IOException("obj must be of type CertificationRequest.  Instead obj is of class " + object.getClass().getName());
    }

    public String toString() {
        String string = "PKCS10NewMimeHandler";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }
}

