/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs7.ContentInfo;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public final class SMIMEMessage
implements Cloneable {
    private byte[] header;
    private Hashtable htable;
    private byte[] body;
    private byte[] message;
    private byte[] contentInfoBytes;
    private byte[] certRequestBytes;
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.SMIMEMessage";
    private static String crlf = "\r\n";
    private static byte[] crlfbytes = null;
    private static String BASE64 = "base64";

    public SMIMEMessage(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEMessage", (Object)byArray);
        }
        this.parse(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMessage");
        }
    }

    public SMIMEMessage(byte[] byArray, String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMessage", byArray, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.parse(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMessage");
        }
    }

    public SMIMEMessage(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEMessage", inputStream);
        }
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        inputStream.close();
        this.parse(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMessage");
        }
    }

    public SMIMEMessage(InputStream inputStream, String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMessage", inputStream, string);
        }
        byte[] byArray = new byte[inputStream.available()];
        if (string != null) {
            this.provider = new String(string);
        }
        inputStream.read(byArray);
        inputStream.close();
        this.parse(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMessage");
        }
    }

    public SMIMEMessage(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEMessage", string);
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        this.parse(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMessage");
        }
    }

    public SMIMEMessage(String string, String string2) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMessage", string, string2);
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        if (string2 != null) {
            this.provider = new String(string2);
        }
        fileInputStream.read(byArray);
        fileInputStream.close();
        this.parse(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMessage");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            SMIMEMessage sMIMEMessage = new SMIMEMessage(this.getBytes(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", sMIMEMessage);
            }
            return sMIMEMessage;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    private void setHeader(String string) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setHeader", string);
        }
        try {
            this.setHeader(string.getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(8192L, className, "setHeader", unsupportedEncodingException);
            }
            this.setHeader(string.getBytes());
        }
        if (debug != null) {
            debug.exit(8192L, className, "setHeader");
        }
    }

    private void setHeader(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setHeader", (Object)byArray);
        }
        this.parseHeader(byArray);
        if (debug != null) {
            debug.exit(8192L, className, "setHeader");
        }
    }

    private void setBody(String string) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setBody", string);
        }
        try {
            this.setBody(string.getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(8192L, className, "setBody", unsupportedEncodingException);
            }
            this.setBody(string.getBytes());
        }
        if (debug != null) {
            debug.exit(8192L, className, "setBody");
        }
    }

    private void setBody(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setBody", (Object)byArray);
        }
        this.parseBody(byArray);
        if (debug != null) {
            debug.exit(8192L, className, "setBody");
        }
    }

    private void setMessage(String string) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setMessage", string);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(8192L, className, "setMessage", "message not specified.");
            }
            throw new IOException("message not specified.");
        }
        try {
            this.parse(string.getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(8192L, className, "setMessage", unsupportedEncodingException);
            }
            this.parse(string.getBytes());
        }
        if (debug != null) {
            debug.exit(8192L, className, "setMessage");
        }
    }

    private void setMessage(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setMessage", (Object)byArray);
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(8192L, className, "setMessage", "message not specified.");
            }
            throw new IOException("message not specified.");
        }
        this.parse(byArray);
        if (debug != null) {
            debug.exit(8192L, className, "setMessage");
        }
    }

    public byte[] getBytes() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getBytes");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.header);
        byteArrayOutputStream.write(this.body);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getBytes", byArray);
        }
        return byArray;
    }

    public byte[] getHeader() {
        if (debug != null) {
            debug.entry(16384L, className, "getHeader");
        }
        if (this.header == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getHeader_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getHeader_2", (byte[])this.header.clone());
        }
        return (byte[])this.header.clone();
    }

    public Hashtable getHeaderHashTable() {
        if (debug != null) {
            debug.entry(16384L, className, "getHeaderHashTable");
            debug.exit(16384L, (Object)className, "getHeaderHashTable", this.htable);
        }
        return this.htable;
    }

    public byte[] getBody() {
        if (debug != null) {
            debug.entry(16384L, className, "getBody");
        }
        if (this.body == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getBody_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getBody_2", this.body.clone());
        }
        return (byte[])this.body.clone();
    }

    private void parse(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parse", (Object)byArray);
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "message not specified.");
            }
            throw new IOException("message not specified.");
        }
        this.parseHeader(byArray);
        if (debug != null) {
            debug.exit(8192L, className, "parse");
        }
    }

    private void parseHeader(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parseHeader", (Object)byArray);
        }
        if (byArray == null) {
            this.header = null;
            if (debug != null) {
                debug.exit(8192L, className, "parseHeader_1");
            }
            return;
        }
        this.htable = new Hashtable();
        String string = null;
        try {
            string = new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(8192L, className, "parseHeader", unsupportedEncodingException);
            }
            string = new String(byArray);
        }
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        String string2 = null;
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string3 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.equals("")) {
                bl = true;
                break;
            }
            try {
                byteArrayOutputStream.write(string2.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (debug != null) {
                    debug.exception(8192L, className, "parseHeader", unsupportedEncodingException);
                }
                byteArrayOutputStream.write(string2.getBytes());
            }
            byteArrayOutputStream.write(crlfbytes);
            if (string2.charAt(0) == '\t') {
                if (string3 != null) {
                    String string4 = (String)this.htable.get(string3);
                    string4 = string4 + crlf + string2;
                    this.htable.put(string3, string4);
                    continue;
                }
                if (debug != null) {
                    debug.text(8192L, className, "parseHeader", "Header line extends an invalid S/MIME tag.");
                }
                throw new IOException("Header line extends an invalid S/MIME tag.");
            }
            int n = string2.indexOf(":");
            if (n <= -1) continue;
            String string5 = string2.substring(0, n);
            String string6 = string2.substring(n + 1, string2.length());
            this.htable.put(string5, string6);
            string3 = string5;
        }
        this.header = byteArrayOutputStream.toByteArray();
        if (bl) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((string2 = bufferedReader.readLine()) != null) {
                try {
                    byteArrayOutputStream.write(string2.getBytes("8859_1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (debug != null) {
                        debug.exception(8192L, className, "parseHeader", unsupportedEncodingException);
                    }
                    byteArrayOutputStream.write(string2.getBytes());
                }
                byteArrayOutputStream.write(crlfbytes);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            this.parseBody(byArray2);
        }
        if (debug != null) {
            debug.exit(8192L, className, "parseHeader_2");
        }
    }

    private void parseBody(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parseBody", (Object)byArray);
        }
        this.body = byArray;
        this.parseMessage(byArray);
        if (debug != null) {
            debug.exit(8192L, className, "parseBody");
        }
    }

    private void setBodyBytes(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setBodyBytes", (Object)byArray);
        }
        String string = this.getContentTransferEncoding();
        this.setBodyBytes(byArray, string);
    }

    private void setBodyBytes(byte[] byArray, String string) throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "setBodyBytes", byArray, string);
        }
        this.contentInfoBytes = null;
        this.certRequestBytes = null;
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "setBodyBytes_1");
            }
            return;
        }
        if (string == null || !string.equalsIgnoreCase(BASE64)) {
            if (debug != null) {
                debug.exit(8192L, className, "setBodyBytes_2");
            }
            return;
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray2 = null;
        try {
            byArray2 = bASE64Decoder.decodeBuffer(new String(byArray, "8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(8192L, className, "setBodyBytes", unsupportedEncodingException);
            }
            byArray2 = bASE64Decoder.decodeBuffer(new String(byArray));
        }
        try {
            ContentInfo contentInfo = new ContentInfo(byArray2, this.provider);
            this.contentInfoBytes = byArray;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "setBodyBytes", exception);
            }
            try {
                CertificationRequest certificationRequest = new CertificationRequest(byArray2, this.provider);
                this.certRequestBytes = byArray;
            }
            catch (Exception exception2) {
                if (debug != null) {
                    debug.exception(8192L, className, "setBodyBytes", exception2);
                }
                throw new IOException("Body byte array is not a ContentInfo or CertificationRequest object.");
            }
        }
        if (debug != null) {
            debug.exit(8192L, className, "setBodyBytes_3");
        }
    }

    private void parseMessage(byte[] byArray) throws IOException {
        byte[] byArray2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parseMessage", (Object)byArray);
        }
        this.message = null;
        this.contentInfoBytes = null;
        this.certRequestBytes = null;
        if (byArray == null) {
            if (debug != null) {
                debug.exit(8192L, className, "parseMessage_1");
            }
            return;
        }
        String string = null;
        try {
            string = new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(8192L, className, "parseMessage", unsupportedEncodingException);
            }
            string = new String(byArray);
        }
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        String string2 = this.getBoundary();
        if (string2 == null) {
            this.parseBodyBytes(bufferedReader, string2);
            if (debug != null) {
                debug.exit(8192L, className, "parseMessage_2");
            }
            return;
        }
        String string3 = "--" + string2;
        String string4 = string3 + "--";
        String string5 = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        while ((string5 = bufferedReader.readLine()) != null) {
            if (string5.equals(string3) && bl) {
                bl = false;
                bl2 = true;
                continue;
            }
            if (string5.equals(string3)) {
                bl5 = true;
                break;
            }
            if (string5.equals("") && !bl2) continue;
            if (bl2) {
                try {
                    byteArrayOutputStream.write(string5.getBytes("8859_1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (debug != null) {
                        debug.exception(8192L, className, "parseMessage", unsupportedEncodingException);
                    }
                    byteArrayOutputStream.write(string5.getBytes());
                }
                byteArrayOutputStream.write(crlfbytes);
                continue;
            }
            if (string5.equals(".")) break;
            try {
                byteArrayOutputStream2.write(string5.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (debug != null) {
                    debug.exception(8192L, className, "parseMessage", unsupportedEncodingException);
                }
                byteArrayOutputStream2.write(string5.getBytes());
            }
            byteArrayOutputStream2.write(crlfbytes);
        }
        if ((byArray2 = byteArrayOutputStream.toByteArray()) == null || byArray2.length == 0) {
            this.message = null;
            if (string2 != null && ((byArray2 = byteArrayOutputStream2.toByteArray()) != null || byArray2.length > 0)) {
                this.setBodyBytes(byArray2);
            }
            if (debug != null) {
                debug.exit(8192L, className, "parseMessage_3");
            }
            return;
        }
        byte[] byArray3 = new byte[byArray2.length - 2];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        this.message = byArray3;
        if (bl5) {
            this.parseBodyBytes(bufferedReader, string4);
        }
        if (debug != null) {
            debug.exit(8192L, className, "parseMessage_4");
        }
    }

    private void parseBodyBytes(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (debug != null) {
            debug.entry(8192L, className, "parseBodyBytes", bufferedReader, string);
        }
        while ((string2 = bufferedReader.readLine()) != null && !(string != null ? string2.equals(string) : string2.equals("") || string2.equals("."))) {
            try {
                byteArrayOutputStream.write(string2.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (debug != null) {
                    debug.exception(8192L, className, "parseBodyBytes", unsupportedEncodingException);
                }
                byteArrayOutputStream.write(string2.getBytes());
            }
            byteArrayOutputStream.write(crlfbytes);
        }
        if (string != null) {
            SMIMEMessage sMIMEMessage = new SMIMEMessage(byteArrayOutputStream.toByteArray(), this.provider);
            String string3 = sMIMEMessage.getContentTransferEncoding();
            this.setBodyBytes(sMIMEMessage.getContentInfoBytes(), string3);
        } else {
            this.setBodyBytes(byteArrayOutputStream.toByteArray());
        }
        if (debug != null) {
            debug.exit(8192L, className, "parseBodyBytes");
        }
    }

    private String getBoundary() {
        String string;
        String string2 = "boundary=";
        String string3 = null;
        if (debug != null) {
            debug.entry(8192L, className, "getBoundary");
        }
        if ((string = (String)this.htable.get("Content-Type")) == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getBoundary_1", string3);
            }
            return string3;
        }
        int n = string.indexOf(string2);
        if (n > -1) {
            string3 = "";
            String string4 = string.substring(n + string2.length(), string.length());
            int n2 = string4.length();
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                char c = string4.charAt(i);
                if (c == '\"') {
                    for (int j = 1; j < n2; ++j) {
                        char c2 = string4.charAt(j);
                        if (c2 == '\"' || c2 == ';') {
                            bl = true;
                            break;
                        }
                        string3 = string3 + c2;
                    }
                    bl = true;
                }
                if (bl || c == ' ' || c == ';') break;
                string3 = string3 + c;
            }
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getBoundary_2", string3);
        }
        return string3;
    }

    private String getContentTransferEncoding() {
        String string;
        if (debug != null) {
            debug.entry(8192L, className, "getContentTransferEncoding");
        }
        if ((string = (String)this.htable.get("Content-Transfer-Encoding")) != null) {
            string = string.trim();
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getContentTransferEncoding", string);
        }
        return string;
    }

    public byte[] getMessage() {
        if (debug != null) {
            debug.entry(16384L, className, "getMessage");
        }
        if (this.message == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMessage_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getMessage_2", (byte[])this.message.clone());
        }
        return (byte[])this.message.clone();
    }

    public byte[] getContentInfoBytes() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfoBytes");
        }
        if (this.contentInfoBytes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfoBytes_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfoBytes_2", (byte[])this.contentInfoBytes.clone());
        }
        return (byte[])this.contentInfoBytes.clone();
    }

    public ContentInfo getContentInfo() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfo");
        }
        if (this.contentInfoBytes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfo_1", null);
            }
            return null;
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray = null;
        try {
            byArray = bASE64Decoder.decodeBuffer(new String(this.contentInfoBytes, "8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "getContentInfo", unsupportedEncodingException);
            }
            byArray = bASE64Decoder.decodeBuffer(new String(this.contentInfoBytes));
        }
        ContentInfo contentInfo = new ContentInfo(byArray, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfo_2", contentInfo);
        }
        return contentInfo;
    }

    public byte[] getCertificationRequestBytes() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequestBytes");
        }
        if (this.certRequestBytes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequestBytes_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificationRequestBytes_2", (byte[])this.certRequestBytes.clone());
        }
        return (byte[])this.certRequestBytes.clone();
    }

    public CertificationRequest getCertificationRequest() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequest");
        }
        if (this.certRequestBytes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequest_1", null);
            }
            return null;
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray = null;
        try {
            byArray = bASE64Decoder.decodeBuffer(new String(this.certRequestBytes, "8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "getCertificationRequest", unsupportedEncodingException);
            }
            byArray = bASE64Decoder.decodeBuffer(new String(this.certRequestBytes));
        }
        CertificationRequest certificationRequest = new CertificationRequest(byArray, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificationRequest_2", certificationRequest);
        }
        return certificationRequest;
    }

    public String toString() {
        String string = "SMIMEMessage:\r\n";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.header == null) {
            string = string + "\tNo header information\r\n";
        } else {
            try {
                string = string + new String(this.header, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (debug != null) {
                    debug.exception(16384L, className, "toString", unsupportedEncodingException);
                }
                string = string + new String(this.header);
            }
        }
        string = string + "\r\n";
        if (this.body == null) {
            string = string + "\tNo body information\r\n";
        } else {
            try {
                string = string + new String(this.body, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (debug != null) {
                    debug.exception(16384L, className, "toString", unsupportedEncodingException);
                }
                string = string + new String(this.body);
            }
        }
        string = string + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    static {
        try {
            crlfbytes = crlf.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            crlfbytes = crlf.getBytes();
        }
    }
}

