/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs9.PKCS9;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.UnresolvedAttribute;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class PKCSAttribute
extends PKCSDerObject
implements DerEncoder,
Cloneable {
    private ObjectIdentifier attributeId;
    private Object attributeValue;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcsutil.PKCSAttribute";

    public PKCSAttribute(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttribute", (Object)byArray);
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttribute", byArray, string);
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(ObjectIdentifier objectIdentifier, Object object) throws IOException {
        this(objectIdentifier, object, null);
        if (debug != null) {
            Object[] objectArray = new Object[]{objectIdentifier, object};
            debug.entry(16384L, (Object)className, "PKCSAttribute", objectArray);
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(ObjectIdentifier objectIdentifier, Object object, String string) throws IOException {
        super(string);
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{objectIdentifier, object};
            debug.entry(16384L, (Object)className, "PKCSAttribute", objectArray);
        }
        if ((objectArray = PKCS9.getName(objectIdentifier)) != null) {
            PKCS9DerObject pKCS9DerObject = PKCS9.getPKCS9Attribute(objectIdentifier, object);
            if (pKCS9DerObject == null) {
                if (debug != null) {
                    debug.text(16384L, className, "PKCSAttribute", "Class " + object.getClass().getName() + " does not match the class required for Object Identifier " + objectIdentifier);
                }
                throw new IllegalArgumentException("Class " + object.getClass().getName() + " does not match the class required for Object Identifier " + objectIdentifier);
            }
        } else {
            if (!(object instanceof byte[])) {
                if (debug != null) {
                    debug.text(16384L, className, "PKCSAttribute", "Non-standard Attribute value must be a byte array");
                }
                throw new IOException("Non-standard Attribute value must be a byte array");
            }
            DerValue derValue = new DerValue((byte[])object);
            if (derValue.getTag() != 49) {
                if (debug != null) {
                    debug.text(16384L, className, "PKCSAttribute", "Non-standard Attribute value must be a SET OF DER value");
                }
                throw new IOException("Non-standard Attribute value must be a SET OF DER value");
            }
        }
        this.attributeId = objectIdentifier;
        this.attributeValue = object;
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(PKCS9DerObject pKCS9DerObject) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttribute", pKCS9DerObject);
        }
        this.attributeId = pKCS9DerObject.getObjectIdentifier();
        this.attributeValue = pKCS9DerObject.getValue();
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(PKCS9DerObject pKCS9DerObject, String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttribute", pKCS9DerObject, string);
        }
        this.attributeId = pKCS9DerObject.getObjectIdentifier();
        this.attributeValue = pKCS9DerObject.getValue();
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(UnresolvedAttribute unresolvedAttribute) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttribute", unresolvedAttribute);
        }
        this.attributeId = unresolvedAttribute.getObjectIdentifier();
        this.attributeValue = unresolvedAttribute.getValue();
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(UnresolvedAttribute unresolvedAttribute, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttribute", unresolvedAttribute, string);
        }
        this.attributeId = unresolvedAttribute.getObjectIdentifier();
        this.attributeValue = unresolvedAttribute.getValue();
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "PKCSAttribute", objectArray);
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public PKCSAttribute(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "PKCSAttribute", objectArray);
            debug.exit(16384L, className, "PKCSAttribute");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
                debug.exit(16384L, (Object)className, "clone", new PKCSAttribute(this.attributeId, this.attributeValue, this.provider));
            }
            return new PKCSAttribute(this.attributeId, this.attributeValue, this.provider);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof PKCSAttribute) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", this.equals((PKCSAttribute)object));
            }
            return this.equals((PKCSAttribute)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", false);
        }
        return false;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.derEncode(outputStream);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        String string;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", outputStream);
        }
        if ((string = PKCS9.getName(this.attributeId)) != null) {
            PKCS9DerObject pKCS9DerObject = PKCS9.getPKCS9Attribute(this.attributeId, this.attributeValue);
            pKCS9DerObject.encode(outputStream);
        } else {
            UnresolvedAttribute unresolvedAttribute = new UnresolvedAttribute(this.attributeId, this.attributeValue, this.provider);
            unresolvedAttribute.encode(outputStream);
        }
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    public ObjectIdentifier getAttributeId() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeId");
            debug.exit(16384L, (Object)className, "getAttributeId", this.attributeId);
        }
        return this.attributeId;
    }

    public Object getAttributeValue() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeValue");
        }
        PKCSAttribute pKCSAttribute = new PKCSAttribute(this.attributeId, this.attributeValue, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAttributeValue", pKCSAttribute.attributeValue);
        }
        return pKCSAttribute.attributeValue;
    }

    public String toString() {
        String string;
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string2 = "Object Identifier: ";
        string2 = string2 + this.attributeId.toString();
        String string3 = PKCS9.getName(this.attributeId);
        if (string3 != null) {
            string2 = string2 + " (" + string3 + ")";
        }
        string2 = string2 + "\r\n";
        string2 = string2 + "Value:\r\n";
        if (this.attributeValue instanceof byte[]) {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            string = hexDumpEncoder.encodeBuffer((byte[])this.attributeValue);
        } else if (this.attributeValue instanceof String[]) {
            String[] stringArray = (String[])this.attributeValue;
            string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i] + " ";
            }
        } else {
            string = this.attributeValue.toString();
        }
        string2 = string2 + string;
        string2 = string2 + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string2);
        }
        return string2;
    }

    public PKCS9DerObject getPKCS9DerObject() {
        if (debug != null) {
            debug.entry(16384L, className, "getPKCS9DerObject");
            debug.exit(16384L, (Object)className, "getPKCS9DerObject", PKCS9.getPKCS9Attribute(this.attributeId, this.attributeValue));
        }
        return PKCS9.getPKCS9Attribute(this.attributeId, this.attributeValue);
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PKCS Attribute encoding error");
            }
            throw new IOException("PKCS Attribute encoding error");
        }
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derInputStream.available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Excess data parsing PKCS Attribute");
            }
            throw new IOException("Excess data parsing PKCS Attribute");
        }
        if (derValueArray.length != 2) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PKCS Attribute doesn't have two components");
            }
            throw new IOException("PKCS Attribute doesn't have two components");
        }
        ObjectIdentifier objectIdentifier = derValueArray[0].getOID();
        String string = PKCS9.getName(objectIdentifier);
        if (string != null) {
            PKCS9DerObject pKCS9DerObject = PKCS9.getPKCS9Attribute(derValue.toByteArray());
            this.attributeValue = pKCS9DerObject.getValue();
        } else {
            UnresolvedAttribute unresolvedAttribute = new UnresolvedAttribute(derValue.toByteArray());
            this.attributeValue = unresolvedAttribute.getValue();
        }
        this.attributeId = objectIdentifier;
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(PKCSAttribute pKCSAttribute) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", pKCSAttribute);
        }
        if (pKCSAttribute == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            pKCSAttribute.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", exception);
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

