/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.SignerInfo;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class Countersignature
extends PKCS9DerObject
implements Cloneable {
    private SignerInfo[] signers;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.CounterSignature";

    public Countersignature(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CounterSignature", (Object)byArray);
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Countersignature(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "CounterSignature", byArray, string);
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Countersignature(SignerInfo signerInfo) {
        SignerInfo[] signerInfoArray = new SignerInfo[]{signerInfo};
        this.signers = signerInfoArray;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CounterSignature", signerInfo);
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Countersignature(SignerInfo signerInfo, String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "CounterSignature", signerInfo, string);
            debug.exit(16384L, className, "CounterSignature");
        }
        SignerInfo[] signerInfoArray = new SignerInfo[]{signerInfo};
        this.signers = signerInfoArray;
    }

    public Countersignature(SignerInfo[] signerInfoArray) {
        this.signers = signerInfoArray;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CounterSignature", signerInfoArray);
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Countersignature(SignerInfo[] signerInfoArray, String string) {
        super(string);
        this.signers = signerInfoArray;
        if (debug != null) {
            debug.entry(16384L, className, "CounterSignature", signerInfoArray, string);
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Countersignature(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "CounterSignature", string, new Boolean(bl));
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Countersignature(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "CounterSignature", objectArray);
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            Countersignature countersignature = new Countersignature(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", countersignature);
            }
            return countersignature;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof Countersignature) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", this.equals((Countersignature)object));
            }
            return this.equals((Countersignature)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.COUNTERSIGNATURE_OID);
        }
        return PKCSOID.COUNTERSIGNATURE_OID;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.signers == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "SignerInfo objects not specified.");
            }
            throw new IOException("SignerInfo objects not specified.");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.getObjectIdentifier());
        DerEncoder[] derEncoderArray = new DerOutputStream[this.signers.length];
        for (int i = 0; i < this.signers.length; ++i) {
            derEncoderArray[i] = new DerOutputStream();
            this.signers[i].encode((OutputStream)((Object)derEncoderArray[i]));
        }
        derOutputStream.putOrderedSetOf((byte)49, derEncoderArray);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream.toByteArray());
        outputStream.write(derOutputStream3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public SignerInfo[] getSignerInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignerInfos");
            debug.exit(16384L, (Object)className, "getSignerInfos", this.signers.clone());
        }
        return (SignerInfo[])this.signers.clone();
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getSignerInfos());
        }
        return this.getSignerInfos();
    }

    public boolean isTagValid(byte by) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(by));
        }
        if (by == 48) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getValue", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue", new Boolean(false));
        }
        return false;
    }

    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(false));
        }
        return false;
    }

    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "Countersignature");
        }
        return "Countersignature";
    }

    public String toString() {
        String string = "PKCS9 Countersignature:\r\n";
        if (this.signers == null || this.signers.length == 0) {
            string = string + "\tNo SignerInfo values set.\r\n";
        } else {
            for (int i = 0; i < this.signers.length; ++i) {
                string = string + "SignerInfo[" + i + "]:\r\n";
                string = string + this.signers[i].toString();
            }
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        super.decode(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        DerValue[] derValueArray = null;
        if (derValue.getTag() == 48) {
            DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray2 = derInputStream.getSequence(2);
            derValueArray = new DerInputStream(derValueArray2[1].toByteArray()).getSet(1);
        } else {
            derValueArray = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        this.signers = new SignerInfo[derValueArray.length];
        for (int i = 0; i < derValueArray.length; ++i) {
            this.signers[i] = new SignerInfo(derValueArray[i].toByteArray(), this.provider);
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(Countersignature countersignature) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", countersignature);
        }
        if (countersignature == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            countersignature.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

