/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class ShroudedKeyBag
extends PKCSDerObject
implements Bag,
Cloneable {
    private ObjectIdentifier oid = PKCSOID.SHROUDEDKEYBAG_OID;
    private EncryptedPrivateKeyInfo value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.ShroudedKeyBag";

    public ShroudedKeyBag(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ShroudedKeyBag", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "ShroudedKeyBag");
        }
    }

    public ShroudedKeyBag(byte[] byArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "ShroudedKeyBag", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "ShroudedKeyBag");
        }
    }

    public ShroudedKeyBag(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ShroudedKeyBag", encryptedPrivateKeyInfo);
            debug.exit(16384L, className, "ShroudedKeyBag");
        }
        this.value = encryptedPrivateKeyInfo;
    }

    public ShroudedKeyBag(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "ShroudedKeyBag", encryptedPrivateKeyInfo, string);
            debug.exit(16384L, className, "ShroudedKeyBag");
        }
        this.value = encryptedPrivateKeyInfo;
    }

    public ShroudedKeyBag(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "ShroudedKeyBag", string, new Boolean(bl));
            debug.exit(16384L, className, "ShroudedKeyBag");
        }
    }

    public ShroudedKeyBag(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "ShroudedKeyBag", objectArray);
            debug.exit(16384L, className, "ShroudedKeyBag");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.value.encode(outputStream);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.SHROUDEDKEYBAG_OID);
        }
        return PKCSOID.SHROUDEDKEYBAG_OID;
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.value.clone());
        }
        return this.value.clone();
    }

    public byte[] getEncodedValue() {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedValue");
        }
        try {
            this.value.encode(derOutputStream);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "getEncodedValue", iOException);
                debug.exit(16384L, (Object)className, "getEncodedValue_1", null);
            }
            return null;
        }
        byte[] byArray = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncodedValue_2", byArray);
        }
        return byArray;
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "ShroudedKeyBag");
        }
        return "ShroudedKeyBag";
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof ShroudedKeyBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((ShroudedKeyBag)object));
            }
            return this.equals((ShroudedKeyBag)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            ShroudedKeyBag shroudedKeyBag = new ShroudedKeyBag(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", shroudedKeyBag);
            }
            return shroudedKeyBag;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "ShroudedKeyBag:";
        string = string + "\r\nobject identifier: " + this.oid;
        string = string + "\r\nencrypted private key info:\r\n";
        string = string + this.value.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        this.value = new EncryptedPrivateKeyInfo(derValue.toByteArray(), this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decode", this.value);
        }
    }

    private boolean equals(ShroudedKeyBag shroudedKeyBag) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", shroudedKeyBag);
        }
        if (shroudedKeyBag == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            shroudedKeyBag.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", exception);
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

