/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import com.ibm.crypto.pkcs11.provider.PKCS11RSAPrivateKey;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Date;

final class RSAPKCS11PrivateKey
extends PrivateKeyInfo
implements PKCS11RSAPrivateKey,
Serializable {
    private PKCS11Object object = null;
    private PKCS11Session session = null;
    private PKCS11Session[] allSessions = null;
    private String label = null;
    private Integer keyType = PKCS11Object.RSA;
    private byte[] ID = null;
    private byte[] subject = null;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private BigInteger version = BigInteger.ZERO;
    private BigInteger modulus = null;
    private BigInteger publicExponent = null;
    private BigInteger privateExponent = null;
    private BigInteger prime1 = null;
    private BigInteger prime2 = null;
    private BigInteger exponent1 = null;
    private BigInteger exponent2 = null;
    private BigInteger coefficient = null;
    private int slotID;

    public RSAPKCS11PrivateKey(int n, PKCS11Object pKCS11Object, PKCS11Session pKCS11Session, PKCS11Session[] pKCS11SessionArray, String string, byte[] byArray, byte[] byArray2, Boolean bl, Boolean bl2) throws InvalidKeyException {
        this.slotID = n;
        this.object = pKCS11Object;
        this.session = pKCS11Session;
        this.allSessions = pKCS11SessionArray;
        if (string != null) {
            this.label = string;
        }
        if (byArray != null) {
            this.ID = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.ID, 0, byArray.length);
        }
        if (byArray2 != null) {
            this.subject = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.subject, 0, byArray2.length);
        }
        if (bl != null) {
            this.isDecrypt = new Boolean(bl);
        }
        if (bl2 != null) {
            this.isSign = new Boolean(bl2);
        }
    }

    public RSAPKCS11PrivateKey(int n, PKCS11Object pKCS11Object, PKCS11Session pKCS11Session, PKCS11Session[] pKCS11SessionArray, String string, byte[] byArray, byte[] byArray2, Boolean bl, Boolean bl2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this(n, pKCS11Object, pKCS11Session, pKCS11SessionArray, string, byArray, byArray2, bl, bl2);
        if (bigInteger != null) {
            this.modulus = new BigInteger(bigInteger.toByteArray());
        }
        if (bigInteger2 != null) {
            this.publicExponent = new BigInteger(bigInteger2.toByteArray());
        }
        if (bigInteger3 != null) {
            this.privateExponent = new BigInteger(bigInteger3.toByteArray());
        }
        if (bigInteger4 != null) {
            this.prime1 = new BigInteger(bigInteger4.toByteArray());
        }
        if (bigInteger5 != null) {
            this.prime2 = new BigInteger(bigInteger5.toByteArray());
        }
        if (bigInteger6 != null) {
            this.exponent1 = new BigInteger(bigInteger6.toByteArray());
        }
        if (bigInteger7 != null) {
            this.exponent2 = new BigInteger(bigInteger7.toByteArray());
        }
        if (bigInteger8 != null) {
            this.coefficient = new BigInteger(bigInteger8.toByteArray());
        }
        this.algid = new AlgIdRSA();
        if (this.modulus != null && this.privateExponent != null && this.publicExponent != null && this.prime1 != null && this.prime2 != null && this.exponent1 != null && this.exponent2 != null && this.coefficient != null) {
            try {
                DerValue[] derValueArray = new DerValue[]{new DerValue(2, this.version.toByteArray()), new DerValue(2, this.modulus.toByteArray()), new DerValue(2, this.publicExponent.toByteArray()), new DerValue(2, this.privateExponent.toByteArray()), new DerValue(2, this.prime1.toByteArray()), new DerValue(2, this.prime2.toByteArray()), new DerValue(2, this.exponent1.toByteArray()), new DerValue(2, this.exponent2.toByteArray()), new DerValue(2, this.coefficient.toByteArray())};
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putSequence(derValueArray);
                this.key = derOutputStream.toByteArray();
                this.encode();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("could not DER encode: " + iOException.getMessage());
            }
        }
    }

    public RSAPKCS11PrivateKey(PKCS11Object pKCS11Object, PKCS11Session pKCS11Session, PKCS11Session[] pKCS11SessionArray, byte[] byArray) throws InvalidKeyException {
        this.object = pKCS11Object;
        this.session = pKCS11Session;
        this.allSessions = pKCS11SessionArray;
        if (byArray == null) {
            throw new InvalidKeyException("ID must be specified");
        }
        this.ID = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.ID, 0, byArray.length);
        this.label = null;
        this.subject = null;
        this.isDecrypt = null;
        this.isSign = null;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public Boolean getAlwaysSensitive() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Integer getAuthPinFlags() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public BigInteger getCoefficient() {
        return this.coefficient;
    }

    public Boolean getDecrypt() {
        return this.isDecrypt;
    }

    public Boolean getDerive() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Date getEndDate() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public BigInteger getExponent1() {
        return this.exponent1;
    }

    public BigInteger getExponent2() {
        return this.exponent2;
    }

    public Boolean getExtractable() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getID() {
        if (this.ID == null) {
            return null;
        }
        return (byte[])this.ID.clone();
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getLocal() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Boolean getModifiable() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public Boolean getNeverExtractable() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public PKCS11Session[] getOpenSessions() {
        return this.allSessions;
    }

    public BigInteger getPrime1() {
        return this.prime1;
    }

    public BigInteger getPrime2() {
        return this.prime2;
    }

    public Boolean getPrivate() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public Boolean getSecondaryAuth() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Boolean getSensitive() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public PKCS11Session getSession() {
        return this.session;
    }

    public Boolean getSign() {
        return this.isSign;
    }

    public Boolean getSignRecover() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public int getSlotID() {
        return this.slotID;
    }

    public Date getStartDate() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public byte[] getSubject() {
        if (this.subject == null) {
            return null;
        }
        return (byte[])this.subject.clone();
    }

    public Boolean getToken() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Boolean getUnwrap() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        return pKCS11Object.getAttributeValue(n);
    }

    protected void parseKeyBits() throws IOException {
        if (this.object != null) {
            if (((Boolean)this.getValue(this.object, 259)).equals(Boolean.TRUE)) {
                throw new IOException("This key cannot be revealed");
            }
            if (((Boolean)this.getValue(this.object, 354)).equals(Boolean.TRUE)) {
                throw new IOException("This key cannot be extracted");
            }
        }
        try {
            DerValue derValue = new DerValue(this.key);
            this.modulus = derValue.getData().getInteger();
            this.privateExponent = derValue.getData().getInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException("Invalid RSAPrivateKey encoding, data overrun");
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public String toString() {
        String string = "IBMPKCS11";
        String string2 = String.valueOf(string) + " RSA Private Key: ";
        if (this.object != null) {
            string2 = String.valueOf(string2) + this.object.toString();
        }
        if (this.label != null) {
            string2 = String.valueOf(string2) + "\n label: " + this.label;
        }
        if (this.ID != null) {
            string2 = String.valueOf(string2) + "\n ID: " + new String(this.ID);
        }
        if (this.subject != null) {
            string2 = String.valueOf(string2) + "\n subject: " + new String(this.subject);
        }
        if (this.isDecrypt != null) {
            string2 = String.valueOf(string2) + "\n decrypt: " + this.isDecrypt;
        }
        if (this.isSign != null) {
            string2 = String.valueOf(string2) + "\n sign: " + this.isSign;
        }
        if (this.modulus != null) {
            string2 = String.valueOf(string2) + "\n modulus: " + this.modulus.toString();
        }
        if (this.publicExponent != null) {
            string2 = String.valueOf(string2) + "\n public exponent: " + this.publicExponent.toString();
        }
        if (this.privateExponent != null) {
            string2 = String.valueOf(string2) + "\n private exponent: " + this.privateExponent.toString();
        }
        if (this.prime1 != null) {
            string2 = String.valueOf(string2) + "\n prime1: " + this.prime1.toString();
        }
        if (this.prime2 != null) {
            string2 = String.valueOf(string2) + "\n prime2: " + this.prime2.toString();
        }
        if (this.exponent1 != null) {
            string2 = String.valueOf(string2) + "\n exponent1: " + this.exponent1.toString();
        }
        if (this.exponent2 != null) {
            string2 = String.valueOf(string2) + "\n exponent2: " + this.exponent2.toString();
        }
        if (this.coefficient != null) {
            string2 = String.valueOf(string2) + "\n coefficient: " + this.coefficient.toString();
        }
        return string2;
    }
}

